/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspacesweb.model.WorkSpacesWebRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBrowserSettingsRequest
extends WorkSpacesWebRequest
implements ToCopyableBuilder<Builder, UpdateBrowserSettingsRequest> {
    private static final SdkField<String> BROWSER_SETTINGS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("browserSettingsArn").getter(UpdateBrowserSettingsRequest.getter(UpdateBrowserSettingsRequest::browserSettingsArn)).setter(UpdateBrowserSettingsRequest.setter(Builder::browserSettingsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("browserSettingsArn").build()}).build();
    private static final SdkField<String> BROWSER_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("browserPolicy").getter(UpdateBrowserSettingsRequest.getter(UpdateBrowserSettingsRequest::browserPolicy)).setter(UpdateBrowserSettingsRequest.setter(Builder::browserPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserPolicy").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateBrowserSettingsRequest.getter(UpdateBrowserSettingsRequest::clientToken)).setter(UpdateBrowserSettingsRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROWSER_SETTINGS_ARN_FIELD, BROWSER_POLICY_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateBrowserSettingsRequest.memberNameToFieldInitializer();
    private final String browserSettingsArn;
    private final String browserPolicy;
    private final String clientToken;

    private UpdateBrowserSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.browserSettingsArn = builder.browserSettingsArn;
        this.browserPolicy = builder.browserPolicy;
        this.clientToken = builder.clientToken;
    }

    public final String browserSettingsArn() {
        return this.browserSettingsArn;
    }

    public final String browserPolicy() {
        return this.browserPolicy;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.browserSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.browserPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBrowserSettingsRequest)) {
            return false;
        }
        UpdateBrowserSettingsRequest other = (UpdateBrowserSettingsRequest)((Object)obj);
        return Objects.equals(this.browserSettingsArn(), other.browserSettingsArn()) && Objects.equals(this.browserPolicy(), other.browserPolicy()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateBrowserSettingsRequest").add("BrowserSettingsArn", (Object)this.browserSettingsArn()).add("BrowserPolicy", (Object)(this.browserPolicy() == null ? null : "*** Sensitive Data Redacted ***")).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "browserSettingsArn": {
                return Optional.ofNullable(clazz.cast(this.browserSettingsArn()));
            }
            case "browserPolicy": {
                return Optional.ofNullable(clazz.cast(this.browserPolicy()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("browserSettingsArn", BROWSER_SETTINGS_ARN_FIELD);
        map.put("browserPolicy", BROWSER_POLICY_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateBrowserSettingsRequest, T> g) {
        return obj -> g.apply((UpdateBrowserSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesWebRequest.BuilderImpl
    implements Builder {
        private String browserSettingsArn;
        private String browserPolicy;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBrowserSettingsRequest model) {
            super(model);
            this.browserSettingsArn(model.browserSettingsArn);
            this.browserPolicy(model.browserPolicy);
            this.clientToken(model.clientToken);
        }

        public final String getBrowserSettingsArn() {
            return this.browserSettingsArn;
        }

        public final void setBrowserSettingsArn(String browserSettingsArn) {
            this.browserSettingsArn = browserSettingsArn;
        }

        @Override
        public final Builder browserSettingsArn(String browserSettingsArn) {
            this.browserSettingsArn = browserSettingsArn;
            return this;
        }

        public final String getBrowserPolicy() {
            return this.browserPolicy;
        }

        public final void setBrowserPolicy(String browserPolicy) {
            this.browserPolicy = browserPolicy;
        }

        @Override
        public final Builder browserPolicy(String browserPolicy) {
            this.browserPolicy = browserPolicy;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBrowserSettingsRequest build() {
            return new UpdateBrowserSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkSpacesWebRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBrowserSettingsRequest> {
        public Builder browserSettingsArn(String var1);

        public Builder browserPolicy(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

