/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Certificate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Certificate> {
    private static final SdkField<String> THUMBPRINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thumbprint").getter(Certificate.getter(Certificate::thumbprint)).setter(Certificate.setter(Builder::thumbprint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbprint").build()}).build();
    private static final SdkField<String> SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subject").getter(Certificate.getter(Certificate::subject)).setter(Certificate.setter(Builder::subject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subject").build()}).build();
    private static final SdkField<String> ISSUER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("issuer").getter(Certificate.getter(Certificate::issuer)).setter(Certificate.setter(Builder::issuer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuer").build()}).build();
    private static final SdkField<Instant> NOT_VALID_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("notValidBefore").getter(Certificate.getter(Certificate::notValidBefore)).setter(Certificate.setter(Builder::notValidBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notValidBefore").build()}).build();
    private static final SdkField<Instant> NOT_VALID_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("notValidAfter").getter(Certificate.getter(Certificate::notValidAfter)).setter(Certificate.setter(Builder::notValidAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notValidAfter").build()}).build();
    private static final SdkField<SdkBytes> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("body").getter(Certificate.getter(Certificate::body)).setter(Certificate.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THUMBPRINT_FIELD, SUBJECT_FIELD, ISSUER_FIELD, NOT_VALID_BEFORE_FIELD, NOT_VALID_AFTER_FIELD, BODY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Certificate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String thumbprint;
    private final String subject;
    private final String issuer;
    private final Instant notValidBefore;
    private final Instant notValidAfter;
    private final SdkBytes body;

    private Certificate(BuilderImpl builder) {
        this.thumbprint = builder.thumbprint;
        this.subject = builder.subject;
        this.issuer = builder.issuer;
        this.notValidBefore = builder.notValidBefore;
        this.notValidAfter = builder.notValidAfter;
        this.body = builder.body;
    }

    public final String thumbprint() {
        return this.thumbprint;
    }

    public final String subject() {
        return this.subject;
    }

    public final String issuer() {
        return this.issuer;
    }

    public final Instant notValidBefore() {
        return this.notValidBefore;
    }

    public final Instant notValidAfter() {
        return this.notValidAfter;
    }

    public final SdkBytes body() {
        return this.body;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.thumbprint());
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.issuer());
        hashCode = 31 * hashCode + Objects.hashCode(this.notValidBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.notValidAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Certificate)) {
            return false;
        }
        Certificate other = (Certificate)obj;
        return Objects.equals(this.thumbprint(), other.thumbprint()) && Objects.equals(this.subject(), other.subject()) && Objects.equals(this.issuer(), other.issuer()) && Objects.equals(this.notValidBefore(), other.notValidBefore()) && Objects.equals(this.notValidAfter(), other.notValidAfter()) && Objects.equals(this.body(), other.body());
    }

    public final String toString() {
        return ToString.builder((String)"Certificate").add("Thumbprint", (Object)this.thumbprint()).add("Subject", (Object)this.subject()).add("Issuer", (Object)this.issuer()).add("NotValidBefore", (Object)this.notValidBefore()).add("NotValidAfter", (Object)this.notValidAfter()).add("Body", (Object)this.body()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thumbprint": {
                return Optional.ofNullable(clazz.cast(this.thumbprint()));
            }
            case "subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
            case "issuer": {
                return Optional.ofNullable(clazz.cast(this.issuer()));
            }
            case "notValidBefore": {
                return Optional.ofNullable(clazz.cast(this.notValidBefore()));
            }
            case "notValidAfter": {
                return Optional.ofNullable(clazz.cast(this.notValidAfter()));
            }
            case "body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("thumbprint", THUMBPRINT_FIELD);
        map.put("subject", SUBJECT_FIELD);
        map.put("issuer", ISSUER_FIELD);
        map.put("notValidBefore", NOT_VALID_BEFORE_FIELD);
        map.put("notValidAfter", NOT_VALID_AFTER_FIELD);
        map.put("body", BODY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Certificate, T> g) {
        return obj -> g.apply((Certificate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String thumbprint;
        private String subject;
        private String issuer;
        private Instant notValidBefore;
        private Instant notValidAfter;
        private SdkBytes body;

        private BuilderImpl() {
        }

        private BuilderImpl(Certificate model) {
            this.thumbprint(model.thumbprint);
            this.subject(model.subject);
            this.issuer(model.issuer);
            this.notValidBefore(model.notValidBefore);
            this.notValidAfter(model.notValidAfter);
            this.body(model.body);
        }

        public final String getThumbprint() {
            return this.thumbprint;
        }

        public final void setThumbprint(String thumbprint) {
            this.thumbprint = thumbprint;
        }

        @Override
        public final Builder thumbprint(String thumbprint) {
            this.thumbprint = thumbprint;
            return this;
        }

        public final String getSubject() {
            return this.subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final String getIssuer() {
            return this.issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final Instant getNotValidBefore() {
            return this.notValidBefore;
        }

        public final void setNotValidBefore(Instant notValidBefore) {
            this.notValidBefore = notValidBefore;
        }

        @Override
        public final Builder notValidBefore(Instant notValidBefore) {
            this.notValidBefore = notValidBefore;
            return this;
        }

        public final Instant getNotValidAfter() {
            return this.notValidAfter;
        }

        public final void setNotValidAfter(Instant notValidAfter) {
            this.notValidAfter = notValidAfter;
        }

        @Override
        public final Builder notValidAfter(Instant notValidAfter) {
            this.notValidAfter = notValidAfter;
            return this;
        }

        public final ByteBuffer getBody() {
            return this.body == null ? null : this.body.asByteBuffer();
        }

        public final void setBody(ByteBuffer body) {
            this.body(body == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)body));
        }

        @Override
        public final Builder body(SdkBytes body) {
            this.body = body;
            return this;
        }

        public Certificate build() {
            return new Certificate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Certificate> {
        public Builder thumbprint(String var1);

        public Builder subject(String var1);

        public Builder issuer(String var1);

        public Builder notValidBefore(Instant var1);

        public Builder notValidAfter(Instant var1);

        public Builder body(SdkBytes var1);
    }
}

