/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspacesweb.model.NetworkSettingsListCopier;
import software.amazon.awssdk.services.workspacesweb.model.NetworkSettingsSummary;
import software.amazon.awssdk.services.workspacesweb.model.WorkSpacesWebResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNetworkSettingsResponse
extends WorkSpacesWebResponse
implements ToCopyableBuilder<Builder, ListNetworkSettingsResponse> {
    private static final SdkField<List<NetworkSettingsSummary>> NETWORK_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("networkSettings").getter(ListNetworkSettingsResponse.getter(ListNetworkSettingsResponse::networkSettings)).setter(ListNetworkSettingsResponse.setter(Builder::networkSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NetworkSettingsSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListNetworkSettingsResponse.getter(ListNetworkSettingsResponse::nextToken)).setter(ListNetworkSettingsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_SETTINGS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListNetworkSettingsResponse.memberNameToFieldInitializer();
    private final List<NetworkSettingsSummary> networkSettings;
    private final String nextToken;

    private ListNetworkSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.networkSettings = builder.networkSettings;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasNetworkSettings() {
        return this.networkSettings != null && !(this.networkSettings instanceof SdkAutoConstructList);
    }

    public final List<NetworkSettingsSummary> networkSettings() {
        return this.networkSettings;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkSettings() ? this.networkSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNetworkSettingsResponse)) {
            return false;
        }
        ListNetworkSettingsResponse other = (ListNetworkSettingsResponse)((Object)obj);
        return this.hasNetworkSettings() == other.hasNetworkSettings() && Objects.equals(this.networkSettings(), other.networkSettings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListNetworkSettingsResponse").add("NetworkSettings", this.hasNetworkSettings() ? this.networkSettings() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "networkSettings": {
                return Optional.ofNullable(clazz.cast(this.networkSettings()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("networkSettings", NETWORK_SETTINGS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListNetworkSettingsResponse, T> g) {
        return obj -> g.apply((ListNetworkSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesWebResponse.BuilderImpl
    implements Builder {
        private List<NetworkSettingsSummary> networkSettings = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNetworkSettingsResponse model) {
            super(model);
            this.networkSettings(model.networkSettings);
            this.nextToken(model.nextToken);
        }

        public final List<NetworkSettingsSummary.Builder> getNetworkSettings() {
            List<NetworkSettingsSummary.Builder> result = NetworkSettingsListCopier.copyToBuilder(this.networkSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkSettings(Collection<NetworkSettingsSummary.BuilderImpl> networkSettings) {
            this.networkSettings = NetworkSettingsListCopier.copyFromBuilder(networkSettings);
        }

        @Override
        public final Builder networkSettings(Collection<NetworkSettingsSummary> networkSettings) {
            this.networkSettings = NetworkSettingsListCopier.copy(networkSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkSettings(NetworkSettingsSummary ... networkSettings) {
            this.networkSettings(Arrays.asList(networkSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkSettings(Consumer<NetworkSettingsSummary.Builder> ... networkSettings) {
            this.networkSettings(Stream.of(networkSettings).map(c -> (NetworkSettingsSummary)((NetworkSettingsSummary.Builder)NetworkSettingsSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListNetworkSettingsResponse build() {
            return new ListNetworkSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkSpacesWebResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNetworkSettingsResponse> {
        public Builder networkSettings(Collection<NetworkSettingsSummary> var1);

        public Builder networkSettings(NetworkSettingsSummary ... var1);

        public Builder networkSettings(Consumer<NetworkSettingsSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

