/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspacesweb.model.TrustStoreSummary;
import software.amazon.awssdk.services.workspacesweb.model.TrustStoreSummaryListCopier;
import software.amazon.awssdk.services.workspacesweb.model.WorkSpacesWebResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTrustStoresResponse
extends WorkSpacesWebResponse
implements ToCopyableBuilder<Builder, ListTrustStoresResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTrustStoresResponse.getter(ListTrustStoresResponse::nextToken)).setter(ListTrustStoresResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<TrustStoreSummary>> TRUST_STORES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("trustStores").getter(ListTrustStoresResponse.getter(ListTrustStoresResponse::trustStores)).setter(ListTrustStoresResponse.setter(Builder::trustStores)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trustStores").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrustStoreSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, TRUST_STORES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTrustStoresResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<TrustStoreSummary> trustStores;

    private ListTrustStoresResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.trustStores = builder.trustStores;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasTrustStores() {
        return this.trustStores != null && !(this.trustStores instanceof SdkAutoConstructList);
    }

    public final List<TrustStoreSummary> trustStores() {
        return this.trustStores;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrustStores() ? this.trustStores() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrustStoresResponse)) {
            return false;
        }
        ListTrustStoresResponse other = (ListTrustStoresResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasTrustStores() == other.hasTrustStores() && Objects.equals(this.trustStores(), other.trustStores());
    }

    public final String toString() {
        return ToString.builder((String)"ListTrustStoresResponse").add("NextToken", (Object)this.nextToken()).add("TrustStores", this.hasTrustStores() ? this.trustStores() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "trustStores": {
                return Optional.ofNullable(clazz.cast(this.trustStores()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("trustStores", TRUST_STORES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTrustStoresResponse, T> g) {
        return obj -> g.apply((ListTrustStoresResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesWebResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<TrustStoreSummary> trustStores = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrustStoresResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.trustStores(model.trustStores);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TrustStoreSummary.Builder> getTrustStores() {
            List<TrustStoreSummary.Builder> result = TrustStoreSummaryListCopier.copyToBuilder(this.trustStores);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrustStores(Collection<TrustStoreSummary.BuilderImpl> trustStores) {
            this.trustStores = TrustStoreSummaryListCopier.copyFromBuilder(trustStores);
        }

        @Override
        public final Builder trustStores(Collection<TrustStoreSummary> trustStores) {
            this.trustStores = TrustStoreSummaryListCopier.copy(trustStores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trustStores(TrustStoreSummary ... trustStores) {
            this.trustStores(Arrays.asList(trustStores));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trustStores(Consumer<TrustStoreSummary.Builder> ... trustStores) {
            this.trustStores(Stream.of(trustStores).map(c -> (TrustStoreSummary)((TrustStoreSummary.Builder)TrustStoreSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListTrustStoresResponse build() {
            return new ListTrustStoresResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkSpacesWebResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTrustStoresResponse> {
        public Builder nextToken(String var1);

        public Builder trustStores(Collection<TrustStoreSummary> var1);

        public Builder trustStores(TrustStoreSummary ... var1);

        public Builder trustStores(Consumer<TrustStoreSummary.Builder> ... var1);
    }
}

