/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpAccessSettingsSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpAccessSettingsSummary> {
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(IpAccessSettingsSummary.getter(IpAccessSettingsSummary::creationDate)).setter(IpAccessSettingsSummary.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(IpAccessSettingsSummary.getter(IpAccessSettingsSummary::description)).setter(IpAccessSettingsSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(IpAccessSettingsSummary.getter(IpAccessSettingsSummary::displayName)).setter(IpAccessSettingsSummary.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> IP_ACCESS_SETTINGS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ipAccessSettingsArn").getter(IpAccessSettingsSummary.getter(IpAccessSettingsSummary::ipAccessSettingsArn)).setter(IpAccessSettingsSummary.setter(Builder::ipAccessSettingsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAccessSettingsArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_DATE_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, IP_ACCESS_SETTINGS_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IpAccessSettingsSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant creationDate;
    private final String description;
    private final String displayName;
    private final String ipAccessSettingsArn;

    private IpAccessSettingsSummary(BuilderImpl builder) {
        this.creationDate = builder.creationDate;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.ipAccessSettingsArn = builder.ipAccessSettingsArn;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final String description() {
        return this.description;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String ipAccessSettingsArn() {
        return this.ipAccessSettingsArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAccessSettingsArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpAccessSettingsSummary)) {
            return false;
        }
        IpAccessSettingsSummary other = (IpAccessSettingsSummary)obj;
        return Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.ipAccessSettingsArn(), other.ipAccessSettingsArn());
    }

    public final String toString() {
        return ToString.builder((String)"IpAccessSettingsSummary").add("CreationDate", (Object)this.creationDate()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DisplayName", (Object)(this.displayName() == null ? null : "*** Sensitive Data Redacted ***")).add("IpAccessSettingsArn", (Object)this.ipAccessSettingsArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "ipAccessSettingsArn": {
                return Optional.ofNullable(clazz.cast(this.ipAccessSettingsArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("creationDate", CREATION_DATE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("ipAccessSettingsArn", IP_ACCESS_SETTINGS_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IpAccessSettingsSummary, T> g) {
        return obj -> g.apply((IpAccessSettingsSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant creationDate;
        private String description;
        private String displayName;
        private String ipAccessSettingsArn;

        private BuilderImpl() {
        }

        private BuilderImpl(IpAccessSettingsSummary model) {
            this.creationDate(model.creationDate);
            this.description(model.description);
            this.displayName(model.displayName);
            this.ipAccessSettingsArn(model.ipAccessSettingsArn);
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getIpAccessSettingsArn() {
            return this.ipAccessSettingsArn;
        }

        public final void setIpAccessSettingsArn(String ipAccessSettingsArn) {
            this.ipAccessSettingsArn = ipAccessSettingsArn;
        }

        @Override
        public final Builder ipAccessSettingsArn(String ipAccessSettingsArn) {
            this.ipAccessSettingsArn = ipAccessSettingsArn;
            return this;
        }

        public IpAccessSettingsSummary build() {
            return new IpAccessSettingsSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpAccessSettingsSummary> {
        public Builder creationDate(Instant var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder ipAccessSettingsArn(String var1);
    }
}

