/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.workspacesweb.model.IdentityProviderDetailsCopier;
import software.amazon.awssdk.services.workspacesweb.model.IdentityProviderType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IdentityProvider
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IdentityProvider> {
    private static final SdkField<String> IDENTITY_PROVIDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identityProviderArn").getter(IdentityProvider.getter(IdentityProvider::identityProviderArn)).setter(IdentityProvider.setter(Builder::identityProviderArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderArn").build()}).build();
    private static final SdkField<Map<String, String>> IDENTITY_PROVIDER_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("identityProviderDetails").getter(IdentityProvider.getter(IdentityProvider::identityProviderDetails)).setter(IdentityProvider.setter(Builder::identityProviderDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderDetails").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> IDENTITY_PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identityProviderName").getter(IdentityProvider.getter(IdentityProvider::identityProviderName)).setter(IdentityProvider.setter(Builder::identityProviderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderName").build()}).build();
    private static final SdkField<String> IDENTITY_PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identityProviderType").getter(IdentityProvider.getter(IdentityProvider::identityProviderTypeAsString)).setter(IdentityProvider.setter(Builder::identityProviderType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_PROVIDER_ARN_FIELD, IDENTITY_PROVIDER_DETAILS_FIELD, IDENTITY_PROVIDER_NAME_FIELD, IDENTITY_PROVIDER_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IdentityProvider.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String identityProviderArn;
    private final Map<String, String> identityProviderDetails;
    private final String identityProviderName;
    private final String identityProviderType;

    private IdentityProvider(BuilderImpl builder) {
        this.identityProviderArn = builder.identityProviderArn;
        this.identityProviderDetails = builder.identityProviderDetails;
        this.identityProviderName = builder.identityProviderName;
        this.identityProviderType = builder.identityProviderType;
    }

    public final String identityProviderArn() {
        return this.identityProviderArn;
    }

    public final boolean hasIdentityProviderDetails() {
        return this.identityProviderDetails != null && !(this.identityProviderDetails instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> identityProviderDetails() {
        return this.identityProviderDetails;
    }

    public final String identityProviderName() {
        return this.identityProviderName;
    }

    public final IdentityProviderType identityProviderType() {
        return IdentityProviderType.fromValue(this.identityProviderType);
    }

    public final String identityProviderTypeAsString() {
        return this.identityProviderType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentityProviderDetails() ? this.identityProviderDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityProvider)) {
            return false;
        }
        IdentityProvider other = (IdentityProvider)obj;
        return Objects.equals(this.identityProviderArn(), other.identityProviderArn()) && this.hasIdentityProviderDetails() == other.hasIdentityProviderDetails() && Objects.equals(this.identityProviderDetails(), other.identityProviderDetails()) && Objects.equals(this.identityProviderName(), other.identityProviderName()) && Objects.equals(this.identityProviderTypeAsString(), other.identityProviderTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"IdentityProvider").add("IdentityProviderArn", (Object)this.identityProviderArn()).add("IdentityProviderDetails", (Object)(this.identityProviderDetails() == null ? null : "*** Sensitive Data Redacted ***")).add("IdentityProviderName", (Object)(this.identityProviderName() == null ? null : "*** Sensitive Data Redacted ***")).add("IdentityProviderType", (Object)this.identityProviderTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "identityProviderArn": {
                return Optional.ofNullable(clazz.cast(this.identityProviderArn()));
            }
            case "identityProviderDetails": {
                return Optional.ofNullable(clazz.cast(this.identityProviderDetails()));
            }
            case "identityProviderName": {
                return Optional.ofNullable(clazz.cast(this.identityProviderName()));
            }
            case "identityProviderType": {
                return Optional.ofNullable(clazz.cast(this.identityProviderTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("identityProviderArn", IDENTITY_PROVIDER_ARN_FIELD);
        map.put("identityProviderDetails", IDENTITY_PROVIDER_DETAILS_FIELD);
        map.put("identityProviderName", IDENTITY_PROVIDER_NAME_FIELD);
        map.put("identityProviderType", IDENTITY_PROVIDER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdentityProvider, T> g) {
        return obj -> g.apply((IdentityProvider)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String identityProviderArn;
        private Map<String, String> identityProviderDetails = DefaultSdkAutoConstructMap.getInstance();
        private String identityProviderName;
        private String identityProviderType;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityProvider model) {
            this.identityProviderArn(model.identityProviderArn);
            this.identityProviderDetails(model.identityProviderDetails);
            this.identityProviderName(model.identityProviderName);
            this.identityProviderType(model.identityProviderType);
        }

        public final String getIdentityProviderArn() {
            return this.identityProviderArn;
        }

        public final void setIdentityProviderArn(String identityProviderArn) {
            this.identityProviderArn = identityProviderArn;
        }

        @Override
        public final Builder identityProviderArn(String identityProviderArn) {
            this.identityProviderArn = identityProviderArn;
            return this;
        }

        public final Map<String, String> getIdentityProviderDetails() {
            if (this.identityProviderDetails instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.identityProviderDetails;
        }

        public final void setIdentityProviderDetails(Map<String, String> identityProviderDetails) {
            this.identityProviderDetails = IdentityProviderDetailsCopier.copy(identityProviderDetails);
        }

        @Override
        public final Builder identityProviderDetails(Map<String, String> identityProviderDetails) {
            this.identityProviderDetails = IdentityProviderDetailsCopier.copy(identityProviderDetails);
            return this;
        }

        public final String getIdentityProviderName() {
            return this.identityProviderName;
        }

        public final void setIdentityProviderName(String identityProviderName) {
            this.identityProviderName = identityProviderName;
        }

        @Override
        public final Builder identityProviderName(String identityProviderName) {
            this.identityProviderName = identityProviderName;
            return this;
        }

        public final String getIdentityProviderType() {
            return this.identityProviderType;
        }

        public final void setIdentityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
        }

        @Override
        public final Builder identityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
            return this;
        }

        @Override
        public final Builder identityProviderType(IdentityProviderType identityProviderType) {
            this.identityProviderType(identityProviderType == null ? null : identityProviderType.toString());
            return this;
        }

        public IdentityProvider build() {
            return new IdentityProvider(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IdentityProvider> {
        public Builder identityProviderArn(String var1);

        public Builder identityProviderDetails(Map<String, String> var1);

        public Builder identityProviderName(String var1);

        public Builder identityProviderType(String var1);

        public Builder identityProviderType(IdentityProviderType var1);
    }
}

