/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.workspacesweb.model.EncryptionContextMapCopier;
import software.amazon.awssdk.services.workspacesweb.model.Tag;
import software.amazon.awssdk.services.workspacesweb.model.TagListCopier;
import software.amazon.awssdk.services.workspacesweb.model.WorkSpacesWebRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBrowserSettingsRequest
extends WorkSpacesWebRequest
implements ToCopyableBuilder<Builder, CreateBrowserSettingsRequest> {
    private static final SdkField<Map<String, String>> ADDITIONAL_ENCRYPTION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("additionalEncryptionContext").getter(CreateBrowserSettingsRequest.getter(CreateBrowserSettingsRequest::additionalEncryptionContext)).setter(CreateBrowserSettingsRequest.setter(Builder::additionalEncryptionContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalEncryptionContext").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> BROWSER_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("browserPolicy").getter(CreateBrowserSettingsRequest.getter(CreateBrowserSettingsRequest::browserPolicy)).setter(CreateBrowserSettingsRequest.setter(Builder::browserPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserPolicy").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateBrowserSettingsRequest.getter(CreateBrowserSettingsRequest::clientToken)).setter(CreateBrowserSettingsRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> CUSTOMER_MANAGED_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerManagedKey").getter(CreateBrowserSettingsRequest.getter(CreateBrowserSettingsRequest::customerManagedKey)).setter(CreateBrowserSettingsRequest.setter(Builder::customerManagedKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerManagedKey").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateBrowserSettingsRequest.getter(CreateBrowserSettingsRequest::tags)).setter(CreateBrowserSettingsRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_ENCRYPTION_CONTEXT_FIELD, BROWSER_POLICY_FIELD, CLIENT_TOKEN_FIELD, CUSTOMER_MANAGED_KEY_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateBrowserSettingsRequest.memberNameToFieldInitializer();
    private final Map<String, String> additionalEncryptionContext;
    private final String browserPolicy;
    private final String clientToken;
    private final String customerManagedKey;
    private final List<Tag> tags;

    private CreateBrowserSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.additionalEncryptionContext = builder.additionalEncryptionContext;
        this.browserPolicy = builder.browserPolicy;
        this.clientToken = builder.clientToken;
        this.customerManagedKey = builder.customerManagedKey;
        this.tags = builder.tags;
    }

    public final boolean hasAdditionalEncryptionContext() {
        return this.additionalEncryptionContext != null && !(this.additionalEncryptionContext instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> additionalEncryptionContext() {
        return this.additionalEncryptionContext;
    }

    public final String browserPolicy() {
        return this.browserPolicy;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String customerManagedKey() {
        return this.customerManagedKey;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalEncryptionContext() ? this.additionalEncryptionContext() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.browserPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerManagedKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBrowserSettingsRequest)) {
            return false;
        }
        CreateBrowserSettingsRequest other = (CreateBrowserSettingsRequest)((Object)obj);
        return this.hasAdditionalEncryptionContext() == other.hasAdditionalEncryptionContext() && Objects.equals(this.additionalEncryptionContext(), other.additionalEncryptionContext()) && Objects.equals(this.browserPolicy(), other.browserPolicy()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.customerManagedKey(), other.customerManagedKey()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBrowserSettingsRequest").add("AdditionalEncryptionContext", this.hasAdditionalEncryptionContext() ? this.additionalEncryptionContext() : null).add("BrowserPolicy", (Object)(this.browserPolicy() == null ? null : "*** Sensitive Data Redacted ***")).add("ClientToken", (Object)this.clientToken()).add("CustomerManagedKey", (Object)this.customerManagedKey()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "additionalEncryptionContext": {
                return Optional.ofNullable(clazz.cast(this.additionalEncryptionContext()));
            }
            case "browserPolicy": {
                return Optional.ofNullable(clazz.cast(this.browserPolicy()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "customerManagedKey": {
                return Optional.ofNullable(clazz.cast(this.customerManagedKey()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("additionalEncryptionContext", ADDITIONAL_ENCRYPTION_CONTEXT_FIELD);
        map.put("browserPolicy", BROWSER_POLICY_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("customerManagedKey", CUSTOMER_MANAGED_KEY_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateBrowserSettingsRequest, T> g) {
        return obj -> g.apply((CreateBrowserSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesWebRequest.BuilderImpl
    implements Builder {
        private Map<String, String> additionalEncryptionContext = DefaultSdkAutoConstructMap.getInstance();
        private String browserPolicy;
        private String clientToken;
        private String customerManagedKey;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBrowserSettingsRequest model) {
            super(model);
            this.additionalEncryptionContext(model.additionalEncryptionContext);
            this.browserPolicy(model.browserPolicy);
            this.clientToken(model.clientToken);
            this.customerManagedKey(model.customerManagedKey);
            this.tags(model.tags);
        }

        public final Map<String, String> getAdditionalEncryptionContext() {
            if (this.additionalEncryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalEncryptionContext;
        }

        public final void setAdditionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
        }

        @Override
        public final Builder additionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
            return this;
        }

        public final String getBrowserPolicy() {
            return this.browserPolicy;
        }

        public final void setBrowserPolicy(String browserPolicy) {
            this.browserPolicy = browserPolicy;
        }

        @Override
        public final Builder browserPolicy(String browserPolicy) {
            this.browserPolicy = browserPolicy;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getCustomerManagedKey() {
            return this.customerManagedKey;
        }

        public final void setCustomerManagedKey(String customerManagedKey) {
            this.customerManagedKey = customerManagedKey;
        }

        @Override
        public final Builder customerManagedKey(String customerManagedKey) {
            this.customerManagedKey = customerManagedKey;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBrowserSettingsRequest build() {
            return new CreateBrowserSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkSpacesWebRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBrowserSettingsRequest> {
        public Builder additionalEncryptionContext(Map<String, String> var1);

        public Builder browserPolicy(String var1);

        public Builder clientToken(String var1);

        public Builder customerManagedKey(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

