/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspacesweb.model.InlineRedactionConfiguration;
import software.amazon.awssdk.services.workspacesweb.model.WorkSpacesWebRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDataProtectionSettingsRequest
extends WorkSpacesWebRequest
implements ToCopyableBuilder<Builder, UpdateDataProtectionSettingsRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateDataProtectionSettingsRequest.getter(UpdateDataProtectionSettingsRequest::clientToken)).setter(UpdateDataProtectionSettingsRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DATA_PROTECTION_SETTINGS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataProtectionSettingsArn").getter(UpdateDataProtectionSettingsRequest.getter(UpdateDataProtectionSettingsRequest::dataProtectionSettingsArn)).setter(UpdateDataProtectionSettingsRequest.setter(Builder::dataProtectionSettingsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("dataProtectionSettingsArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateDataProtectionSettingsRequest.getter(UpdateDataProtectionSettingsRequest::description)).setter(UpdateDataProtectionSettingsRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(UpdateDataProtectionSettingsRequest.getter(UpdateDataProtectionSettingsRequest::displayName)).setter(UpdateDataProtectionSettingsRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<InlineRedactionConfiguration> INLINE_REDACTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inlineRedactionConfiguration").getter(UpdateDataProtectionSettingsRequest.getter(UpdateDataProtectionSettingsRequest::inlineRedactionConfiguration)).setter(UpdateDataProtectionSettingsRequest.setter(Builder::inlineRedactionConfiguration)).constructor(InlineRedactionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inlineRedactionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DATA_PROTECTION_SETTINGS_ARN_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, INLINE_REDACTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateDataProtectionSettingsRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String dataProtectionSettingsArn;
    private final String description;
    private final String displayName;
    private final InlineRedactionConfiguration inlineRedactionConfiguration;

    private UpdateDataProtectionSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.dataProtectionSettingsArn = builder.dataProtectionSettingsArn;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.inlineRedactionConfiguration = builder.inlineRedactionConfiguration;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String dataProtectionSettingsArn() {
        return this.dataProtectionSettingsArn;
    }

    public final String description() {
        return this.description;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final InlineRedactionConfiguration inlineRedactionConfiguration() {
        return this.inlineRedactionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataProtectionSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.inlineRedactionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataProtectionSettingsRequest)) {
            return false;
        }
        UpdateDataProtectionSettingsRequest other = (UpdateDataProtectionSettingsRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.dataProtectionSettingsArn(), other.dataProtectionSettingsArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.inlineRedactionConfiguration(), other.inlineRedactionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDataProtectionSettingsRequest").add("ClientToken", (Object)this.clientToken()).add("DataProtectionSettingsArn", (Object)this.dataProtectionSettingsArn()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DisplayName", (Object)(this.displayName() == null ? null : "*** Sensitive Data Redacted ***")).add("InlineRedactionConfiguration", (Object)this.inlineRedactionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "dataProtectionSettingsArn": {
                return Optional.ofNullable(clazz.cast(this.dataProtectionSettingsArn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "inlineRedactionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.inlineRedactionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("dataProtectionSettingsArn", DATA_PROTECTION_SETTINGS_ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("inlineRedactionConfiguration", INLINE_REDACTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataProtectionSettingsRequest, T> g) {
        return obj -> g.apply((UpdateDataProtectionSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesWebRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String dataProtectionSettingsArn;
        private String description;
        private String displayName;
        private InlineRedactionConfiguration inlineRedactionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataProtectionSettingsRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.dataProtectionSettingsArn(model.dataProtectionSettingsArn);
            this.description(model.description);
            this.displayName(model.displayName);
            this.inlineRedactionConfiguration(model.inlineRedactionConfiguration);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDataProtectionSettingsArn() {
            return this.dataProtectionSettingsArn;
        }

        public final void setDataProtectionSettingsArn(String dataProtectionSettingsArn) {
            this.dataProtectionSettingsArn = dataProtectionSettingsArn;
        }

        @Override
        public final Builder dataProtectionSettingsArn(String dataProtectionSettingsArn) {
            this.dataProtectionSettingsArn = dataProtectionSettingsArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final InlineRedactionConfiguration.Builder getInlineRedactionConfiguration() {
            return this.inlineRedactionConfiguration != null ? this.inlineRedactionConfiguration.toBuilder() : null;
        }

        public final void setInlineRedactionConfiguration(InlineRedactionConfiguration.BuilderImpl inlineRedactionConfiguration) {
            this.inlineRedactionConfiguration = inlineRedactionConfiguration != null ? inlineRedactionConfiguration.build() : null;
        }

        @Override
        public final Builder inlineRedactionConfiguration(InlineRedactionConfiguration inlineRedactionConfiguration) {
            this.inlineRedactionConfiguration = inlineRedactionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataProtectionSettingsRequest build() {
            return new UpdateDataProtectionSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkSpacesWebRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDataProtectionSettingsRequest> {
        public Builder clientToken(String var1);

        public Builder dataProtectionSettingsArn(String var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder inlineRedactionConfiguration(InlineRedactionConfiguration var1);

        default public Builder inlineRedactionConfiguration(Consumer<InlineRedactionConfiguration.Builder> inlineRedactionConfiguration) {
            return this.inlineRedactionConfiguration((InlineRedactionConfiguration)((InlineRedactionConfiguration.Builder)InlineRedactionConfiguration.builder().applyMutation(inlineRedactionConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

