/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.workspacesweb.model.ArnListCopier;
import software.amazon.awssdk.services.workspacesweb.model.EncryptionContextMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BrowserSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BrowserSettings> {
    private static final SdkField<Map<String, String>> ADDITIONAL_ENCRYPTION_CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("additionalEncryptionContext").getter(BrowserSettings.getter(BrowserSettings::additionalEncryptionContext)).setter(BrowserSettings.setter(Builder::additionalEncryptionContext)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalEncryptionContext").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ASSOCIATED_PORTAL_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("associatedPortalArns").getter(BrowserSettings.getter(BrowserSettings::associatedPortalArns)).setter(BrowserSettings.setter(Builder::associatedPortalArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedPortalArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> BROWSER_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("browserPolicy").getter(BrowserSettings.getter(BrowserSettings::browserPolicy)).setter(BrowserSettings.setter(Builder::browserPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserPolicy").build()}).build();
    private static final SdkField<String> BROWSER_SETTINGS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("browserSettingsArn").getter(BrowserSettings.getter(BrowserSettings::browserSettingsArn)).setter(BrowserSettings.setter(Builder::browserSettingsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserSettingsArn").build()}).build();
    private static final SdkField<String> CUSTOMER_MANAGED_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customerManagedKey").getter(BrowserSettings.getter(BrowserSettings::customerManagedKey)).setter(BrowserSettings.setter(Builder::customerManagedKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerManagedKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_ENCRYPTION_CONTEXT_FIELD, ASSOCIATED_PORTAL_ARNS_FIELD, BROWSER_POLICY_FIELD, BROWSER_SETTINGS_ARN_FIELD, CUSTOMER_MANAGED_KEY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("additionalEncryptionContext", ADDITIONAL_ENCRYPTION_CONTEXT_FIELD);
            this.put("associatedPortalArns", ASSOCIATED_PORTAL_ARNS_FIELD);
            this.put("browserPolicy", BROWSER_POLICY_FIELD);
            this.put("browserSettingsArn", BROWSER_SETTINGS_ARN_FIELD);
            this.put("customerManagedKey", CUSTOMER_MANAGED_KEY_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Map<String, String> additionalEncryptionContext;
    private final List<String> associatedPortalArns;
    private final String browserPolicy;
    private final String browserSettingsArn;
    private final String customerManagedKey;

    private BrowserSettings(BuilderImpl builder) {
        this.additionalEncryptionContext = builder.additionalEncryptionContext;
        this.associatedPortalArns = builder.associatedPortalArns;
        this.browserPolicy = builder.browserPolicy;
        this.browserSettingsArn = builder.browserSettingsArn;
        this.customerManagedKey = builder.customerManagedKey;
    }

    public final boolean hasAdditionalEncryptionContext() {
        return this.additionalEncryptionContext != null && !(this.additionalEncryptionContext instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> additionalEncryptionContext() {
        return this.additionalEncryptionContext;
    }

    public final boolean hasAssociatedPortalArns() {
        return this.associatedPortalArns != null && !(this.associatedPortalArns instanceof SdkAutoConstructList);
    }

    public final List<String> associatedPortalArns() {
        return this.associatedPortalArns;
    }

    public final String browserPolicy() {
        return this.browserPolicy;
    }

    public final String browserSettingsArn() {
        return this.browserSettingsArn;
    }

    public final String customerManagedKey() {
        return this.customerManagedKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalEncryptionContext() ? this.additionalEncryptionContext() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedPortalArns() ? this.associatedPortalArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.browserPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.browserSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerManagedKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrowserSettings)) {
            return false;
        }
        BrowserSettings other = (BrowserSettings)obj;
        return this.hasAdditionalEncryptionContext() == other.hasAdditionalEncryptionContext() && Objects.equals(this.additionalEncryptionContext(), other.additionalEncryptionContext()) && this.hasAssociatedPortalArns() == other.hasAssociatedPortalArns() && Objects.equals(this.associatedPortalArns(), other.associatedPortalArns()) && Objects.equals(this.browserPolicy(), other.browserPolicy()) && Objects.equals(this.browserSettingsArn(), other.browserSettingsArn()) && Objects.equals(this.customerManagedKey(), other.customerManagedKey());
    }

    public final String toString() {
        return ToString.builder((String)"BrowserSettings").add("AdditionalEncryptionContext", this.hasAdditionalEncryptionContext() ? this.additionalEncryptionContext() : null).add("AssociatedPortalArns", this.hasAssociatedPortalArns() ? this.associatedPortalArns() : null).add("BrowserPolicy", (Object)(this.browserPolicy() == null ? null : "*** Sensitive Data Redacted ***")).add("BrowserSettingsArn", (Object)this.browserSettingsArn()).add("CustomerManagedKey", (Object)this.customerManagedKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "additionalEncryptionContext": {
                return Optional.ofNullable(clazz.cast(this.additionalEncryptionContext()));
            }
            case "associatedPortalArns": {
                return Optional.ofNullable(clazz.cast(this.associatedPortalArns()));
            }
            case "browserPolicy": {
                return Optional.ofNullable(clazz.cast(this.browserPolicy()));
            }
            case "browserSettingsArn": {
                return Optional.ofNullable(clazz.cast(this.browserSettingsArn()));
            }
            case "customerManagedKey": {
                return Optional.ofNullable(clazz.cast(this.customerManagedKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BrowserSettings, T> g) {
        return obj -> g.apply((BrowserSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> additionalEncryptionContext = DefaultSdkAutoConstructMap.getInstance();
        private List<String> associatedPortalArns = DefaultSdkAutoConstructList.getInstance();
        private String browserPolicy;
        private String browserSettingsArn;
        private String customerManagedKey;

        private BuilderImpl() {
        }

        private BuilderImpl(BrowserSettings model) {
            this.additionalEncryptionContext(model.additionalEncryptionContext);
            this.associatedPortalArns(model.associatedPortalArns);
            this.browserPolicy(model.browserPolicy);
            this.browserSettingsArn(model.browserSettingsArn);
            this.customerManagedKey(model.customerManagedKey);
        }

        public final Map<String, String> getAdditionalEncryptionContext() {
            if (this.additionalEncryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalEncryptionContext;
        }

        public final void setAdditionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
        }

        @Override
        public final Builder additionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
            return this;
        }

        public final Collection<String> getAssociatedPortalArns() {
            if (this.associatedPortalArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedPortalArns;
        }

        public final void setAssociatedPortalArns(Collection<String> associatedPortalArns) {
            this.associatedPortalArns = ArnListCopier.copy(associatedPortalArns);
        }

        @Override
        public final Builder associatedPortalArns(Collection<String> associatedPortalArns) {
            this.associatedPortalArns = ArnListCopier.copy(associatedPortalArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedPortalArns(String ... associatedPortalArns) {
            this.associatedPortalArns(Arrays.asList(associatedPortalArns));
            return this;
        }

        public final String getBrowserPolicy() {
            return this.browserPolicy;
        }

        public final void setBrowserPolicy(String browserPolicy) {
            this.browserPolicy = browserPolicy;
        }

        @Override
        public final Builder browserPolicy(String browserPolicy) {
            this.browserPolicy = browserPolicy;
            return this;
        }

        public final String getBrowserSettingsArn() {
            return this.browserSettingsArn;
        }

        public final void setBrowserSettingsArn(String browserSettingsArn) {
            this.browserSettingsArn = browserSettingsArn;
        }

        @Override
        public final Builder browserSettingsArn(String browserSettingsArn) {
            this.browserSettingsArn = browserSettingsArn;
            return this;
        }

        public final String getCustomerManagedKey() {
            return this.customerManagedKey;
        }

        public final void setCustomerManagedKey(String customerManagedKey) {
            this.customerManagedKey = customerManagedKey;
        }

        @Override
        public final Builder customerManagedKey(String customerManagedKey) {
            this.customerManagedKey = customerManagedKey;
            return this;
        }

        public BrowserSettings build() {
            return new BrowserSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BrowserSettings> {
        public Builder additionalEncryptionContext(Map<String, String> var1);

        public Builder associatedPortalArns(Collection<String> var1);

        public Builder associatedPortalArns(String ... var1);

        public Builder browserPolicy(String var1);

        public Builder browserSettingsArn(String var1);

        public Builder customerManagedKey(String var1);
    }
}

