/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspacesweb.model.IpAddressListCopier;
import software.amazon.awssdk.services.workspacesweb.model.SessionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Session
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Session> {
    private static final SdkField<List<String>> CLIENT_IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("clientIpAddresses").getter(Session.getter(Session::clientIpAddresses)).setter(Session.setter(Builder::clientIpAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientIpAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(Session.getter(Session::endTime)).setter(Session.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> PORTAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portalArn").getter(Session.getter(Session::portalArn)).setter(Session.setter(Builder::portalArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalArn").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(Session.getter(Session::sessionId)).setter(Session.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(Session.getter(Session::startTime)).setter(Session.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(Session.getter(Session::statusAsString)).setter(Session.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("username").getter(Session.getter(Session::username)).setter(Session.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_IP_ADDRESSES_FIELD, END_TIME_FIELD, PORTAL_ARN_FIELD, SESSION_ID_FIELD, START_TIME_FIELD, STATUS_FIELD, USERNAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> clientIpAddresses;
    private final Instant endTime;
    private final String portalArn;
    private final String sessionId;
    private final Instant startTime;
    private final String status;
    private final String username;

    private Session(BuilderImpl builder) {
        this.clientIpAddresses = builder.clientIpAddresses;
        this.endTime = builder.endTime;
        this.portalArn = builder.portalArn;
        this.sessionId = builder.sessionId;
        this.startTime = builder.startTime;
        this.status = builder.status;
        this.username = builder.username;
    }

    public final boolean hasClientIpAddresses() {
        return this.clientIpAddresses != null && !(this.clientIpAddresses instanceof SdkAutoConstructList);
    }

    public final List<String> clientIpAddresses() {
        return this.clientIpAddresses;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final String portalArn() {
        return this.portalArn;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final SessionStatus status() {
        return SessionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String username() {
        return this.username;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClientIpAddresses() ? this.clientIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Session)) {
            return false;
        }
        Session other = (Session)obj;
        return this.hasClientIpAddresses() == other.hasClientIpAddresses() && Objects.equals(this.clientIpAddresses(), other.clientIpAddresses()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.portalArn(), other.portalArn()) && Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.username(), other.username());
    }

    public final String toString() {
        return ToString.builder((String)"Session").add("ClientIpAddresses", (Object)(this.clientIpAddresses() == null ? null : "*** Sensitive Data Redacted ***")).add("EndTime", (Object)this.endTime()).add("PortalArn", (Object)this.portalArn()).add("SessionId", (Object)this.sessionId()).add("StartTime", (Object)this.startTime()).add("Status", (Object)this.statusAsString()).add("Username", (Object)(this.username() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientIpAddresses": {
                return Optional.ofNullable(clazz.cast(this.clientIpAddresses()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "portalArn": {
                return Optional.ofNullable(clazz.cast(this.portalArn()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Session, T> g) {
        return obj -> g.apply((Session)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> clientIpAddresses = DefaultSdkAutoConstructList.getInstance();
        private Instant endTime;
        private String portalArn;
        private String sessionId;
        private Instant startTime;
        private String status;
        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(Session model) {
            this.clientIpAddresses(model.clientIpAddresses);
            this.endTime(model.endTime);
            this.portalArn(model.portalArn);
            this.sessionId(model.sessionId);
            this.startTime(model.startTime);
            this.status(model.status);
            this.username(model.username);
        }

        public final Collection<String> getClientIpAddresses() {
            if (this.clientIpAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return this.clientIpAddresses;
        }

        public final void setClientIpAddresses(Collection<String> clientIpAddresses) {
            this.clientIpAddresses = IpAddressListCopier.copy(clientIpAddresses);
        }

        @Override
        public final Builder clientIpAddresses(Collection<String> clientIpAddresses) {
            this.clientIpAddresses = IpAddressListCopier.copy(clientIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientIpAddresses(String ... clientIpAddresses) {
            this.clientIpAddresses(Arrays.asList(clientIpAddresses));
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getPortalArn() {
            return this.portalArn;
        }

        public final void setPortalArn(String portalArn) {
            this.portalArn = portalArn;
        }

        @Override
        public final Builder portalArn(String portalArn) {
            this.portalArn = portalArn;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public Session build() {
            return new Session(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Session> {
        public Builder clientIpAddresses(Collection<String> var1);

        public Builder clientIpAddresses(String ... var1);

        public Builder endTime(Instant var1);

        public Builder portalArn(String var1);

        public Builder sessionId(String var1);

        public Builder startTime(Instant var1);

        public Builder status(String var1);

        public Builder status(SessionStatus var1);

        public Builder username(String var1);
    }
}

