/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspacesweb.model.ArnListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserAccessLoggingSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserAccessLoggingSettings> {
    private static final SdkField<List<String>> ASSOCIATED_PORTAL_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("associatedPortalArns").getter(UserAccessLoggingSettings.getter(UserAccessLoggingSettings::associatedPortalArns)).setter(UserAccessLoggingSettings.setter(Builder::associatedPortalArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedPortalArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> KINESIS_STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kinesisStreamArn").getter(UserAccessLoggingSettings.getter(UserAccessLoggingSettings::kinesisStreamArn)).setter(UserAccessLoggingSettings.setter(Builder::kinesisStreamArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kinesisStreamArn").build()}).build();
    private static final SdkField<String> USER_ACCESS_LOGGING_SETTINGS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userAccessLoggingSettingsArn").getter(UserAccessLoggingSettings.getter(UserAccessLoggingSettings::userAccessLoggingSettingsArn)).setter(UserAccessLoggingSettings.setter(Builder::userAccessLoggingSettingsArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAccessLoggingSettingsArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_PORTAL_ARNS_FIELD, KINESIS_STREAM_ARN_FIELD, USER_ACCESS_LOGGING_SETTINGS_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> associatedPortalArns;
    private final String kinesisStreamArn;
    private final String userAccessLoggingSettingsArn;

    private UserAccessLoggingSettings(BuilderImpl builder) {
        this.associatedPortalArns = builder.associatedPortalArns;
        this.kinesisStreamArn = builder.kinesisStreamArn;
        this.userAccessLoggingSettingsArn = builder.userAccessLoggingSettingsArn;
    }

    public final boolean hasAssociatedPortalArns() {
        return this.associatedPortalArns != null && !(this.associatedPortalArns instanceof SdkAutoConstructList);
    }

    public final List<String> associatedPortalArns() {
        return this.associatedPortalArns;
    }

    public final String kinesisStreamArn() {
        return this.kinesisStreamArn;
    }

    public final String userAccessLoggingSettingsArn() {
        return this.userAccessLoggingSettingsArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedPortalArns() ? this.associatedPortalArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisStreamArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.userAccessLoggingSettingsArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserAccessLoggingSettings)) {
            return false;
        }
        UserAccessLoggingSettings other = (UserAccessLoggingSettings)obj;
        return this.hasAssociatedPortalArns() == other.hasAssociatedPortalArns() && Objects.equals(this.associatedPortalArns(), other.associatedPortalArns()) && Objects.equals(this.kinesisStreamArn(), other.kinesisStreamArn()) && Objects.equals(this.userAccessLoggingSettingsArn(), other.userAccessLoggingSettingsArn());
    }

    public final String toString() {
        return ToString.builder((String)"UserAccessLoggingSettings").add("AssociatedPortalArns", this.hasAssociatedPortalArns() ? this.associatedPortalArns() : null).add("KinesisStreamArn", (Object)this.kinesisStreamArn()).add("UserAccessLoggingSettingsArn", (Object)this.userAccessLoggingSettingsArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "associatedPortalArns": {
                return Optional.ofNullable(clazz.cast(this.associatedPortalArns()));
            }
            case "kinesisStreamArn": {
                return Optional.ofNullable(clazz.cast(this.kinesisStreamArn()));
            }
            case "userAccessLoggingSettingsArn": {
                return Optional.ofNullable(clazz.cast(this.userAccessLoggingSettingsArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserAccessLoggingSettings, T> g) {
        return obj -> g.apply((UserAccessLoggingSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> associatedPortalArns = DefaultSdkAutoConstructList.getInstance();
        private String kinesisStreamArn;
        private String userAccessLoggingSettingsArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UserAccessLoggingSettings model) {
            this.associatedPortalArns(model.associatedPortalArns);
            this.kinesisStreamArn(model.kinesisStreamArn);
            this.userAccessLoggingSettingsArn(model.userAccessLoggingSettingsArn);
        }

        public final Collection<String> getAssociatedPortalArns() {
            if (this.associatedPortalArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedPortalArns;
        }

        public final void setAssociatedPortalArns(Collection<String> associatedPortalArns) {
            this.associatedPortalArns = ArnListCopier.copy(associatedPortalArns);
        }

        @Override
        public final Builder associatedPortalArns(Collection<String> associatedPortalArns) {
            this.associatedPortalArns = ArnListCopier.copy(associatedPortalArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedPortalArns(String ... associatedPortalArns) {
            this.associatedPortalArns(Arrays.asList(associatedPortalArns));
            return this;
        }

        public final String getKinesisStreamArn() {
            return this.kinesisStreamArn;
        }

        public final void setKinesisStreamArn(String kinesisStreamArn) {
            this.kinesisStreamArn = kinesisStreamArn;
        }

        @Override
        public final Builder kinesisStreamArn(String kinesisStreamArn) {
            this.kinesisStreamArn = kinesisStreamArn;
            return this;
        }

        public final String getUserAccessLoggingSettingsArn() {
            return this.userAccessLoggingSettingsArn;
        }

        public final void setUserAccessLoggingSettingsArn(String userAccessLoggingSettingsArn) {
            this.userAccessLoggingSettingsArn = userAccessLoggingSettingsArn;
        }

        @Override
        public final Builder userAccessLoggingSettingsArn(String userAccessLoggingSettingsArn) {
            this.userAccessLoggingSettingsArn = userAccessLoggingSettingsArn;
            return this;
        }

        public UserAccessLoggingSettings build() {
            return new UserAccessLoggingSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserAccessLoggingSettings> {
        public Builder associatedPortalArns(Collection<String> var1);

        public Builder associatedPortalArns(String ... var1);

        public Builder kinesisStreamArn(String var1);

        public Builder userAccessLoggingSettingsArn(String var1);
    }
}

