/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspacesweb.WorkSpacesWebClient;
import software.amazon.awssdk.services.workspacesweb.internal.UserAgentUtils;
import software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsResponse;

public class ListBrowserSettingsIterable
implements SdkIterable<ListBrowserSettingsResponse> {
    private final WorkSpacesWebClient client;
    private final ListBrowserSettingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBrowserSettingsIterable(WorkSpacesWebClient client, ListBrowserSettingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBrowserSettingsResponseFetcher();
    }

    public Iterator<ListBrowserSettingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListBrowserSettingsResponseFetcher
    implements SyncPageFetcher<ListBrowserSettingsResponse> {
        private ListBrowserSettingsResponseFetcher() {
        }

        public boolean hasNextPage(ListBrowserSettingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBrowserSettingsResponse nextPage(ListBrowserSettingsResponse previousPage) {
            if (previousPage == null) {
                return ListBrowserSettingsIterable.this.client.listBrowserSettings(ListBrowserSettingsIterable.this.firstRequest);
            }
            return ListBrowserSettingsIterable.this.client.listBrowserSettings((ListBrowserSettingsRequest)((Object)ListBrowserSettingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

