/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.workspacesweb.model.IdentityProviderDetailsCopier;
import software.amazon.awssdk.services.workspacesweb.model.IdentityProviderType;
import software.amazon.awssdk.services.workspacesweb.model.WorkSpacesWebRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIdentityProviderRequest
extends WorkSpacesWebRequest
implements ToCopyableBuilder<Builder, CreateIdentityProviderRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateIdentityProviderRequest.getter(CreateIdentityProviderRequest::clientToken)).setter(CreateIdentityProviderRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> IDENTITY_PROVIDER_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("identityProviderDetails").getter(CreateIdentityProviderRequest.getter(CreateIdentityProviderRequest::identityProviderDetails)).setter(CreateIdentityProviderRequest.setter(Builder::identityProviderDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderDetails").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> IDENTITY_PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identityProviderName").getter(CreateIdentityProviderRequest.getter(CreateIdentityProviderRequest::identityProviderName)).setter(CreateIdentityProviderRequest.setter(Builder::identityProviderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderName").build()}).build();
    private static final SdkField<String> IDENTITY_PROVIDER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identityProviderType").getter(CreateIdentityProviderRequest.getter(CreateIdentityProviderRequest::identityProviderTypeAsString)).setter(CreateIdentityProviderRequest.setter(Builder::identityProviderType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderType").build()}).build();
    private static final SdkField<String> PORTAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portalArn").getter(CreateIdentityProviderRequest.getter(CreateIdentityProviderRequest::portalArn)).setter(CreateIdentityProviderRequest.setter(Builder::portalArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, IDENTITY_PROVIDER_DETAILS_FIELD, IDENTITY_PROVIDER_NAME_FIELD, IDENTITY_PROVIDER_TYPE_FIELD, PORTAL_ARN_FIELD));
    private final String clientToken;
    private final Map<String, String> identityProviderDetails;
    private final String identityProviderName;
    private final String identityProviderType;
    private final String portalArn;

    private CreateIdentityProviderRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.identityProviderDetails = builder.identityProviderDetails;
        this.identityProviderName = builder.identityProviderName;
        this.identityProviderType = builder.identityProviderType;
        this.portalArn = builder.portalArn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasIdentityProviderDetails() {
        return this.identityProviderDetails != null && !(this.identityProviderDetails instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> identityProviderDetails() {
        return this.identityProviderDetails;
    }

    public final String identityProviderName() {
        return this.identityProviderName;
    }

    public final IdentityProviderType identityProviderType() {
        return IdentityProviderType.fromValue(this.identityProviderType);
    }

    public final String identityProviderTypeAsString() {
        return this.identityProviderType;
    }

    public final String portalArn() {
        return this.portalArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentityProviderDetails() ? this.identityProviderDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIdentityProviderRequest)) {
            return false;
        }
        CreateIdentityProviderRequest other = (CreateIdentityProviderRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && this.hasIdentityProviderDetails() == other.hasIdentityProviderDetails() && Objects.equals(this.identityProviderDetails(), other.identityProviderDetails()) && Objects.equals(this.identityProviderName(), other.identityProviderName()) && Objects.equals(this.identityProviderTypeAsString(), other.identityProviderTypeAsString()) && Objects.equals(this.portalArn(), other.portalArn());
    }

    public final String toString() {
        return ToString.builder((String)"CreateIdentityProviderRequest").add("ClientToken", (Object)this.clientToken()).add("IdentityProviderDetails", (Object)(this.identityProviderDetails() == null ? null : "*** Sensitive Data Redacted ***")).add("IdentityProviderName", (Object)(this.identityProviderName() == null ? null : "*** Sensitive Data Redacted ***")).add("IdentityProviderType", (Object)this.identityProviderTypeAsString()).add("PortalArn", (Object)this.portalArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "identityProviderDetails": {
                return Optional.ofNullable(clazz.cast(this.identityProviderDetails()));
            }
            case "identityProviderName": {
                return Optional.ofNullable(clazz.cast(this.identityProviderName()));
            }
            case "identityProviderType": {
                return Optional.ofNullable(clazz.cast(this.identityProviderTypeAsString()));
            }
            case "portalArn": {
                return Optional.ofNullable(clazz.cast(this.portalArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateIdentityProviderRequest, T> g) {
        return obj -> g.apply((CreateIdentityProviderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesWebRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private Map<String, String> identityProviderDetails = DefaultSdkAutoConstructMap.getInstance();
        private String identityProviderName;
        private String identityProviderType;
        private String portalArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIdentityProviderRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.identityProviderDetails(model.identityProviderDetails);
            this.identityProviderName(model.identityProviderName);
            this.identityProviderType(model.identityProviderType);
            this.portalArn(model.portalArn);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getIdentityProviderDetails() {
            if (this.identityProviderDetails instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.identityProviderDetails;
        }

        public final void setIdentityProviderDetails(Map<String, String> identityProviderDetails) {
            this.identityProviderDetails = IdentityProviderDetailsCopier.copy(identityProviderDetails);
        }

        @Override
        public final Builder identityProviderDetails(Map<String, String> identityProviderDetails) {
            this.identityProviderDetails = IdentityProviderDetailsCopier.copy(identityProviderDetails);
            return this;
        }

        public final String getIdentityProviderName() {
            return this.identityProviderName;
        }

        public final void setIdentityProviderName(String identityProviderName) {
            this.identityProviderName = identityProviderName;
        }

        @Override
        public final Builder identityProviderName(String identityProviderName) {
            this.identityProviderName = identityProviderName;
            return this;
        }

        public final String getIdentityProviderType() {
            return this.identityProviderType;
        }

        public final void setIdentityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
        }

        @Override
        public final Builder identityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
            return this;
        }

        @Override
        public final Builder identityProviderType(IdentityProviderType identityProviderType) {
            this.identityProviderType(identityProviderType == null ? null : identityProviderType.toString());
            return this;
        }

        public final String getPortalArn() {
            return this.portalArn;
        }

        public final void setPortalArn(String portalArn) {
            this.portalArn = portalArn;
        }

        @Override
        public final Builder portalArn(String portalArn) {
            this.portalArn = portalArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIdentityProviderRequest build() {
            return new CreateIdentityProviderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesWebRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIdentityProviderRequest> {
        public Builder clientToken(String var1);

        public Builder identityProviderDetails(Map<String, String> var1);

        public Builder identityProviderName(String var1);

        public Builder identityProviderType(String var1);

        public Builder identityProviderType(IdentityProviderType var1);

        public Builder portalArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

