/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListUserSettingsResponse extends WorkSpacesWebResponse implements
        ToCopyableBuilder<ListUserSettingsResponse.Builder, ListUserSettingsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListUserSettingsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<UserSettingsSummary>> USER_SETTINGS_FIELD = SdkField
            .<List<UserSettingsSummary>> builder(MarshallingType.LIST)
            .memberName("userSettings")
            .getter(getter(ListUserSettingsResponse::userSettings))
            .setter(setter(Builder::userSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserSettingsSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserSettingsSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            USER_SETTINGS_FIELD));

    private final String nextToken;

    private final List<UserSettingsSummary> userSettings;

    private ListUserSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.userSettings = builder.userSettings;
    }

    /**
     * <p>
     * The pagination token used to retrieve the next page of results for this operation.
     * </p>
     * 
     * @return The pagination token used to retrieve the next page of results for this operation.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserSettings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserSettings() {
        return userSettings != null && !(userSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The user settings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserSettings} method.
     * </p>
     * 
     * @return The user settings.
     */
    public final List<UserSettingsSummary> userSettings() {
        return userSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserSettings() ? userSettings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUserSettingsResponse)) {
            return false;
        }
        ListUserSettingsResponse other = (ListUserSettingsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasUserSettings() == other.hasUserSettings()
                && Objects.equals(userSettings(), other.userSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListUserSettingsResponse").add("NextToken", nextToken())
                .add("UserSettings", hasUserSettings() ? userSettings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "userSettings":
            return Optional.ofNullable(clazz.cast(userSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListUserSettingsResponse, T> g) {
        return obj -> g.apply((ListUserSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesWebResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListUserSettingsResponse> {
        /**
         * <p>
         * The pagination token used to retrieve the next page of results for this operation.
         * </p>
         * 
         * @param nextToken
         *        The pagination token used to retrieve the next page of results for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The user settings.
         * </p>
         * 
         * @param userSettings
         *        The user settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userSettings(Collection<UserSettingsSummary> userSettings);

        /**
         * <p>
         * The user settings.
         * </p>
         * 
         * @param userSettings
         *        The user settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userSettings(UserSettingsSummary... userSettings);

        /**
         * <p>
         * The user settings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspacesweb.model.UserSettingsSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.workspacesweb.model.UserSettingsSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspacesweb.model.UserSettingsSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #userSettings(List<UserSettingsSummary>)}.
         * 
         * @param userSettings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspacesweb.model.UserSettingsSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userSettings(java.util.Collection<UserSettingsSummary>)
         */
        Builder userSettings(Consumer<UserSettingsSummary.Builder>... userSettings);
    }

    static final class BuilderImpl extends WorkSpacesWebResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<UserSettingsSummary> userSettings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListUserSettingsResponse model) {
            super(model);
            nextToken(model.nextToken);
            userSettings(model.userSettings);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<UserSettingsSummary.Builder> getUserSettings() {
            List<UserSettingsSummary.Builder> result = UserSettingsListCopier.copyToBuilder(this.userSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserSettings(Collection<UserSettingsSummary.BuilderImpl> userSettings) {
            this.userSettings = UserSettingsListCopier.copyFromBuilder(userSettings);
        }

        @Override
        public final Builder userSettings(Collection<UserSettingsSummary> userSettings) {
            this.userSettings = UserSettingsListCopier.copy(userSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userSettings(UserSettingsSummary... userSettings) {
            userSettings(Arrays.asList(userSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userSettings(Consumer<UserSettingsSummary.Builder>... userSettings) {
            userSettings(Stream.of(userSettings).map(c -> UserSettingsSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListUserSettingsResponse build() {
            return new ListUserSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
