/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspacesweb.WorkSpacesWebClient;
import software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsResponse;

public class ListUserSettingsIterable
implements SdkIterable<ListUserSettingsResponse> {
    private final WorkSpacesWebClient client;
    private final ListUserSettingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListUserSettingsIterable(WorkSpacesWebClient client, ListUserSettingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListUserSettingsResponseFetcher();
    }

    public Iterator<ListUserSettingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListUserSettingsResponseFetcher
    implements SyncPageFetcher<ListUserSettingsResponse> {
        private ListUserSettingsResponseFetcher() {
        }

        public boolean hasNextPage(ListUserSettingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListUserSettingsResponse nextPage(ListUserSettingsResponse previousPage) {
            if (previousPage == null) {
                return ListUserSettingsIterable.this.client.listUserSettings(ListUserSettingsIterable.this.firstRequest);
            }
            return ListUserSettingsIterable.this.client.listUserSettings((ListUserSettingsRequest)((Object)ListUserSettingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

