/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspacesweb.model.WorkSpacesWebResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePortalResponse
extends WorkSpacesWebResponse
implements ToCopyableBuilder<Builder, CreatePortalResponse> {
    private static final SdkField<String> PORTAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portalArn").getter(CreatePortalResponse.getter(CreatePortalResponse::portalArn)).setter(CreatePortalResponse.setter(Builder::portalArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalArn").build()}).build();
    private static final SdkField<String> PORTAL_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("portalEndpoint").getter(CreatePortalResponse.getter(CreatePortalResponse::portalEndpoint)).setter(CreatePortalResponse.setter(Builder::portalEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalEndpoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTAL_ARN_FIELD, PORTAL_ENDPOINT_FIELD));
    private final String portalArn;
    private final String portalEndpoint;

    private CreatePortalResponse(BuilderImpl builder) {
        super(builder);
        this.portalArn = builder.portalArn;
        this.portalEndpoint = builder.portalEndpoint;
    }

    public final String portalArn() {
        return this.portalArn;
    }

    public final String portalEndpoint() {
        return this.portalEndpoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.portalArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.portalEndpoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePortalResponse)) {
            return false;
        }
        CreatePortalResponse other = (CreatePortalResponse)((Object)obj);
        return Objects.equals(this.portalArn(), other.portalArn()) && Objects.equals(this.portalEndpoint(), other.portalEndpoint());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePortalResponse").add("PortalArn", (Object)this.portalArn()).add("PortalEndpoint", (Object)this.portalEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "portalArn": {
                return Optional.ofNullable(clazz.cast(this.portalArn()));
            }
            case "portalEndpoint": {
                return Optional.ofNullable(clazz.cast(this.portalEndpoint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePortalResponse, T> g) {
        return obj -> g.apply((CreatePortalResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesWebResponse.BuilderImpl
    implements Builder {
        private String portalArn;
        private String portalEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePortalResponse model) {
            super(model);
            this.portalArn(model.portalArn);
            this.portalEndpoint(model.portalEndpoint);
        }

        public final String getPortalArn() {
            return this.portalArn;
        }

        public final void setPortalArn(String portalArn) {
            this.portalArn = portalArn;
        }

        @Override
        @Transient
        public final Builder portalArn(String portalArn) {
            this.portalArn = portalArn;
            return this;
        }

        public final String getPortalEndpoint() {
            return this.portalEndpoint;
        }

        public final void setPortalEndpoint(String portalEndpoint) {
            this.portalEndpoint = portalEndpoint;
        }

        @Override
        @Transient
        public final Builder portalEndpoint(String portalEndpoint) {
            this.portalEndpoint = portalEndpoint;
            return this;
        }

        @Override
        public CreatePortalResponse build() {
            return new CreatePortalResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesWebResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePortalResponse> {
        public Builder portalArn(String var1);

        public Builder portalEndpoint(String var1);
    }
}

