/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspacesweb.model.PortalListCopier;
import software.amazon.awssdk.services.workspacesweb.model.PortalSummary;
import software.amazon.awssdk.services.workspacesweb.model.WorkSpacesWebResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPortalsResponse
extends WorkSpacesWebResponse
implements ToCopyableBuilder<Builder, ListPortalsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPortalsResponse.getter(ListPortalsResponse::nextToken)).setter(ListPortalsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<PortalSummary>> PORTALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("portals").getter(ListPortalsResponse.getter(ListPortalsResponse::portals)).setter(ListPortalsResponse.setter(Builder::portals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PortalSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PORTALS_FIELD));
    private final String nextToken;
    private final List<PortalSummary> portals;

    private ListPortalsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.portals = builder.portals;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasPortals() {
        return this.portals != null && !(this.portals instanceof SdkAutoConstructList);
    }

    public final List<PortalSummary> portals() {
        return this.portals;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPortals() ? this.portals() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPortalsResponse)) {
            return false;
        }
        ListPortalsResponse other = (ListPortalsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasPortals() == other.hasPortals() && Objects.equals(this.portals(), other.portals());
    }

    public final String toString() {
        return ToString.builder((String)"ListPortalsResponse").add("NextToken", (Object)this.nextToken()).add("Portals", this.hasPortals() ? this.portals() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "portals": {
                return Optional.ofNullable(clazz.cast(this.portals()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPortalsResponse, T> g) {
        return obj -> g.apply((ListPortalsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesWebResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<PortalSummary> portals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPortalsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.portals(model.portals);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<PortalSummary.Builder> getPortals() {
            List<PortalSummary.Builder> result = PortalListCopier.copyToBuilder(this.portals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPortals(Collection<PortalSummary.BuilderImpl> portals) {
            this.portals = PortalListCopier.copyFromBuilder(portals);
        }

        @Override
        @Transient
        public final Builder portals(Collection<PortalSummary> portals) {
            this.portals = PortalListCopier.copy(portals);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder portals(PortalSummary ... portals) {
            this.portals(Arrays.asList(portals));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder portals(Consumer<PortalSummary.Builder> ... portals) {
            this.portals(Stream.of(portals).map(c -> (PortalSummary)((PortalSummary.Builder)PortalSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPortalsResponse build() {
            return new ListPortalsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesWebResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPortalsResponse> {
        public Builder nextToken(String var1);

        public Builder portals(Collection<PortalSummary> var1);

        public Builder portals(PortalSummary ... var1);

        public Builder portals(Consumer<PortalSummary.Builder> ... var1);
    }
}

