/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspacesweb.model.EnabledType;
import software.amazon.awssdk.services.workspacesweb.model.Tag;
import software.amazon.awssdk.services.workspacesweb.model.TagListCopier;
import software.amazon.awssdk.services.workspacesweb.model.WorkSpacesWebRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateUserSettingsRequest
extends WorkSpacesWebRequest
implements ToCopyableBuilder<Builder, CreateUserSettingsRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateUserSettingsRequest.getter(CreateUserSettingsRequest::clientToken)).setter(CreateUserSettingsRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> COPY_ALLOWED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("copyAllowed").getter(CreateUserSettingsRequest.getter(CreateUserSettingsRequest::copyAllowedAsString)).setter(CreateUserSettingsRequest.setter(Builder::copyAllowed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyAllowed").build()}).build();
    private static final SdkField<String> DOWNLOAD_ALLOWED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("downloadAllowed").getter(CreateUserSettingsRequest.getter(CreateUserSettingsRequest::downloadAllowedAsString)).setter(CreateUserSettingsRequest.setter(Builder::downloadAllowed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("downloadAllowed").build()}).build();
    private static final SdkField<String> PASTE_ALLOWED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pasteAllowed").getter(CreateUserSettingsRequest.getter(CreateUserSettingsRequest::pasteAllowedAsString)).setter(CreateUserSettingsRequest.setter(Builder::pasteAllowed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pasteAllowed").build()}).build();
    private static final SdkField<String> PRINT_ALLOWED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("printAllowed").getter(CreateUserSettingsRequest.getter(CreateUserSettingsRequest::printAllowedAsString)).setter(CreateUserSettingsRequest.setter(Builder::printAllowed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("printAllowed").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateUserSettingsRequest.getter(CreateUserSettingsRequest::tags)).setter(CreateUserSettingsRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> UPLOAD_ALLOWED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uploadAllowed").getter(CreateUserSettingsRequest.getter(CreateUserSettingsRequest::uploadAllowedAsString)).setter(CreateUserSettingsRequest.setter(Builder::uploadAllowed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadAllowed").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, COPY_ALLOWED_FIELD, DOWNLOAD_ALLOWED_FIELD, PASTE_ALLOWED_FIELD, PRINT_ALLOWED_FIELD, TAGS_FIELD, UPLOAD_ALLOWED_FIELD));
    private final String clientToken;
    private final String copyAllowed;
    private final String downloadAllowed;
    private final String pasteAllowed;
    private final String printAllowed;
    private final List<Tag> tags;
    private final String uploadAllowed;

    private CreateUserSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.copyAllowed = builder.copyAllowed;
        this.downloadAllowed = builder.downloadAllowed;
        this.pasteAllowed = builder.pasteAllowed;
        this.printAllowed = builder.printAllowed;
        this.tags = builder.tags;
        this.uploadAllowed = builder.uploadAllowed;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final EnabledType copyAllowed() {
        return EnabledType.fromValue(this.copyAllowed);
    }

    public final String copyAllowedAsString() {
        return this.copyAllowed;
    }

    public final EnabledType downloadAllowed() {
        return EnabledType.fromValue(this.downloadAllowed);
    }

    public final String downloadAllowedAsString() {
        return this.downloadAllowed;
    }

    public final EnabledType pasteAllowed() {
        return EnabledType.fromValue(this.pasteAllowed);
    }

    public final String pasteAllowedAsString() {
        return this.pasteAllowed;
    }

    public final EnabledType printAllowed() {
        return EnabledType.fromValue(this.printAllowed);
    }

    public final String printAllowedAsString() {
        return this.printAllowed;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final EnabledType uploadAllowed() {
        return EnabledType.fromValue(this.uploadAllowed);
    }

    public final String uploadAllowedAsString() {
        return this.uploadAllowed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyAllowedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.downloadAllowedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pasteAllowedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.printAllowedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadAllowedAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserSettingsRequest)) {
            return false;
        }
        CreateUserSettingsRequest other = (CreateUserSettingsRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.copyAllowedAsString(), other.copyAllowedAsString()) && Objects.equals(this.downloadAllowedAsString(), other.downloadAllowedAsString()) && Objects.equals(this.pasteAllowedAsString(), other.pasteAllowedAsString()) && Objects.equals(this.printAllowedAsString(), other.printAllowedAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.uploadAllowedAsString(), other.uploadAllowedAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateUserSettingsRequest").add("ClientToken", (Object)this.clientToken()).add("CopyAllowed", (Object)this.copyAllowedAsString()).add("DownloadAllowed", (Object)this.downloadAllowedAsString()).add("PasteAllowed", (Object)this.pasteAllowedAsString()).add("PrintAllowed", (Object)this.printAllowedAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("UploadAllowed", (Object)this.uploadAllowedAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "copyAllowed": {
                return Optional.ofNullable(clazz.cast(this.copyAllowedAsString()));
            }
            case "downloadAllowed": {
                return Optional.ofNullable(clazz.cast(this.downloadAllowedAsString()));
            }
            case "pasteAllowed": {
                return Optional.ofNullable(clazz.cast(this.pasteAllowedAsString()));
            }
            case "printAllowed": {
                return Optional.ofNullable(clazz.cast(this.printAllowedAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "uploadAllowed": {
                return Optional.ofNullable(clazz.cast(this.uploadAllowedAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUserSettingsRequest, T> g) {
        return obj -> g.apply((CreateUserSettingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesWebRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String copyAllowed;
        private String downloadAllowed;
        private String pasteAllowed;
        private String printAllowed;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String uploadAllowed;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserSettingsRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.copyAllowed(model.copyAllowed);
            this.downloadAllowed(model.downloadAllowed);
            this.pasteAllowed(model.pasteAllowed);
            this.printAllowed(model.printAllowed);
            this.tags(model.tags);
            this.uploadAllowed(model.uploadAllowed);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getCopyAllowed() {
            return this.copyAllowed;
        }

        public final void setCopyAllowed(String copyAllowed) {
            this.copyAllowed = copyAllowed;
        }

        @Override
        @Transient
        public final Builder copyAllowed(String copyAllowed) {
            this.copyAllowed = copyAllowed;
            return this;
        }

        @Override
        @Transient
        public final Builder copyAllowed(EnabledType copyAllowed) {
            this.copyAllowed(copyAllowed == null ? null : copyAllowed.toString());
            return this;
        }

        public final String getDownloadAllowed() {
            return this.downloadAllowed;
        }

        public final void setDownloadAllowed(String downloadAllowed) {
            this.downloadAllowed = downloadAllowed;
        }

        @Override
        @Transient
        public final Builder downloadAllowed(String downloadAllowed) {
            this.downloadAllowed = downloadAllowed;
            return this;
        }

        @Override
        @Transient
        public final Builder downloadAllowed(EnabledType downloadAllowed) {
            this.downloadAllowed(downloadAllowed == null ? null : downloadAllowed.toString());
            return this;
        }

        public final String getPasteAllowed() {
            return this.pasteAllowed;
        }

        public final void setPasteAllowed(String pasteAllowed) {
            this.pasteAllowed = pasteAllowed;
        }

        @Override
        @Transient
        public final Builder pasteAllowed(String pasteAllowed) {
            this.pasteAllowed = pasteAllowed;
            return this;
        }

        @Override
        @Transient
        public final Builder pasteAllowed(EnabledType pasteAllowed) {
            this.pasteAllowed(pasteAllowed == null ? null : pasteAllowed.toString());
            return this;
        }

        public final String getPrintAllowed() {
            return this.printAllowed;
        }

        public final void setPrintAllowed(String printAllowed) {
            this.printAllowed = printAllowed;
        }

        @Override
        @Transient
        public final Builder printAllowed(String printAllowed) {
            this.printAllowed = printAllowed;
            return this;
        }

        @Override
        @Transient
        public final Builder printAllowed(EnabledType printAllowed) {
            this.printAllowed(printAllowed == null ? null : printAllowed.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUploadAllowed() {
            return this.uploadAllowed;
        }

        public final void setUploadAllowed(String uploadAllowed) {
            this.uploadAllowed = uploadAllowed;
        }

        @Override
        @Transient
        public final Builder uploadAllowed(String uploadAllowed) {
            this.uploadAllowed = uploadAllowed;
            return this;
        }

        @Override
        @Transient
        public final Builder uploadAllowed(EnabledType uploadAllowed) {
            this.uploadAllowed(uploadAllowed == null ? null : uploadAllowed.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUserSettingsRequest build() {
            return new CreateUserSettingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesWebRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateUserSettingsRequest> {
        public Builder clientToken(String var1);

        public Builder copyAllowed(String var1);

        public Builder copyAllowed(EnabledType var1);

        public Builder downloadAllowed(String var1);

        public Builder downloadAllowed(EnabledType var1);

        public Builder pasteAllowed(String var1);

        public Builder pasteAllowed(EnabledType var1);

        public Builder printAllowed(String var1);

        public Builder printAllowed(EnabledType var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder uploadAllowed(String var1);

        public Builder uploadAllowed(EnabledType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

