/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CertificateSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CertificateSummary> {
    private static final SdkField<String> ISSUER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("issuer").getter(CertificateSummary.getter(CertificateSummary::issuer)).setter(CertificateSummary.setter(Builder::issuer)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuer").build()}).build();
    private static final SdkField<Instant> NOT_VALID_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("notValidAfter").getter(CertificateSummary.getter(CertificateSummary::notValidAfter)).setter(CertificateSummary.setter(Builder::notValidAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notValidAfter").build()}).build();
    private static final SdkField<Instant> NOT_VALID_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("notValidBefore").getter(CertificateSummary.getter(CertificateSummary::notValidBefore)).setter(CertificateSummary.setter(Builder::notValidBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notValidBefore").build()}).build();
    private static final SdkField<String> SUBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subject").getter(CertificateSummary.getter(CertificateSummary::subject)).setter(CertificateSummary.setter(Builder::subject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subject").build()}).build();
    private static final SdkField<String> THUMBPRINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("thumbprint").getter(CertificateSummary.getter(CertificateSummary::thumbprint)).setter(CertificateSummary.setter(Builder::thumbprint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbprint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISSUER_FIELD, NOT_VALID_AFTER_FIELD, NOT_VALID_BEFORE_FIELD, SUBJECT_FIELD, THUMBPRINT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String issuer;
    private final Instant notValidAfter;
    private final Instant notValidBefore;
    private final String subject;
    private final String thumbprint;

    private CertificateSummary(BuilderImpl builder) {
        this.issuer = builder.issuer;
        this.notValidAfter = builder.notValidAfter;
        this.notValidBefore = builder.notValidBefore;
        this.subject = builder.subject;
        this.thumbprint = builder.thumbprint;
    }

    public final String issuer() {
        return this.issuer;
    }

    public final Instant notValidAfter() {
        return this.notValidAfter;
    }

    public final Instant notValidBefore() {
        return this.notValidBefore;
    }

    public final String subject() {
        return this.subject;
    }

    public final String thumbprint() {
        return this.thumbprint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.issuer());
        hashCode = 31 * hashCode + Objects.hashCode(this.notValidAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.notValidBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.subject());
        hashCode = 31 * hashCode + Objects.hashCode(this.thumbprint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateSummary)) {
            return false;
        }
        CertificateSummary other = (CertificateSummary)obj;
        return Objects.equals(this.issuer(), other.issuer()) && Objects.equals(this.notValidAfter(), other.notValidAfter()) && Objects.equals(this.notValidBefore(), other.notValidBefore()) && Objects.equals(this.subject(), other.subject()) && Objects.equals(this.thumbprint(), other.thumbprint());
    }

    public final String toString() {
        return ToString.builder((String)"CertificateSummary").add("Issuer", (Object)this.issuer()).add("NotValidAfter", (Object)this.notValidAfter()).add("NotValidBefore", (Object)this.notValidBefore()).add("Subject", (Object)this.subject()).add("Thumbprint", (Object)this.thumbprint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "issuer": {
                return Optional.ofNullable(clazz.cast(this.issuer()));
            }
            case "notValidAfter": {
                return Optional.ofNullable(clazz.cast(this.notValidAfter()));
            }
            case "notValidBefore": {
                return Optional.ofNullable(clazz.cast(this.notValidBefore()));
            }
            case "subject": {
                return Optional.ofNullable(clazz.cast(this.subject()));
            }
            case "thumbprint": {
                return Optional.ofNullable(clazz.cast(this.thumbprint()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CertificateSummary, T> g) {
        return obj -> g.apply((CertificateSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String issuer;
        private Instant notValidAfter;
        private Instant notValidBefore;
        private String subject;
        private String thumbprint;

        private BuilderImpl() {
        }

        private BuilderImpl(CertificateSummary model) {
            this.issuer(model.issuer);
            this.notValidAfter(model.notValidAfter);
            this.notValidBefore(model.notValidBefore);
            this.subject(model.subject);
            this.thumbprint(model.thumbprint);
        }

        public final String getIssuer() {
            return this.issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        @Transient
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final Instant getNotValidAfter() {
            return this.notValidAfter;
        }

        public final void setNotValidAfter(Instant notValidAfter) {
            this.notValidAfter = notValidAfter;
        }

        @Override
        @Transient
        public final Builder notValidAfter(Instant notValidAfter) {
            this.notValidAfter = notValidAfter;
            return this;
        }

        public final Instant getNotValidBefore() {
            return this.notValidBefore;
        }

        public final void setNotValidBefore(Instant notValidBefore) {
            this.notValidBefore = notValidBefore;
        }

        @Override
        @Transient
        public final Builder notValidBefore(Instant notValidBefore) {
            this.notValidBefore = notValidBefore;
            return this;
        }

        public final String getSubject() {
            return this.subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        @Transient
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final String getThumbprint() {
            return this.thumbprint;
        }

        public final void setThumbprint(String thumbprint) {
            this.thumbprint = thumbprint;
        }

        @Override
        @Transient
        public final Builder thumbprint(String thumbprint) {
            this.thumbprint = thumbprint;
            return this;
        }

        public CertificateSummary build() {
            return new CertificateSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CertificateSummary> {
        public Builder issuer(String var1);

        public Builder notValidAfter(Instant var1);

        public Builder notValidBefore(Instant var1);

        public Builder subject(String var1);

        public Builder thumbprint(String var1);
    }
}

