/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesinstances.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures private DNS name settings for WorkSpace Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrivateDnsNameOptionsRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<PrivateDnsNameOptionsRequest.Builder, PrivateDnsNameOptionsRequest> {
    private static final SdkField<String> HOSTNAME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HostnameType").getter(getter(PrivateDnsNameOptionsRequest::hostnameTypeAsString))
            .setter(setter(Builder::hostnameType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostnameType").build()).build();

    private static final SdkField<Boolean> ENABLE_RESOURCE_NAME_DNS_A_RECORD_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableResourceNameDnsARecord")
            .getter(getter(PrivateDnsNameOptionsRequest::enableResourceNameDnsARecord))
            .setter(setter(Builder::enableResourceNameDnsARecord))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableResourceNameDnsARecord")
                    .build()).build();

    private static final SdkField<Boolean> ENABLE_RESOURCE_NAME_DNS_AAAA_RECORD_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableResourceNameDnsAAAARecord")
            .getter(getter(PrivateDnsNameOptionsRequest::enableResourceNameDnsAAAARecord))
            .setter(setter(Builder::enableResourceNameDnsAAAARecord))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableResourceNameDnsAAAARecord")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTNAME_TYPE_FIELD,
            ENABLE_RESOURCE_NAME_DNS_A_RECORD_FIELD, ENABLE_RESOURCE_NAME_DNS_AAAA_RECORD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String hostnameType;

    private final Boolean enableResourceNameDnsARecord;

    private final Boolean enableResourceNameDnsAAAARecord;

    private PrivateDnsNameOptionsRequest(BuilderImpl builder) {
        this.hostnameType = builder.hostnameType;
        this.enableResourceNameDnsARecord = builder.enableResourceNameDnsARecord;
        this.enableResourceNameDnsAAAARecord = builder.enableResourceNameDnsAAAARecord;
    }

    /**
     * <p>
     * Specifies the type of hostname configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hostnameType} will
     * return {@link HostnameTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hostnameTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of hostname configuration.
     * @see HostnameTypeEnum
     */
    public final HostnameTypeEnum hostnameType() {
        return HostnameTypeEnum.fromValue(hostnameType);
    }

    /**
     * <p>
     * Specifies the type of hostname configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hostnameType} will
     * return {@link HostnameTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hostnameTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of hostname configuration.
     * @see HostnameTypeEnum
     */
    public final String hostnameTypeAsString() {
        return hostnameType;
    }

    /**
     * <p>
     * Enables DNS A record for resource name resolution.
     * </p>
     * 
     * @return Enables DNS A record for resource name resolution.
     */
    public final Boolean enableResourceNameDnsARecord() {
        return enableResourceNameDnsARecord;
    }

    /**
     * <p>
     * Enables DNS AAAA record for resource name resolution.
     * </p>
     * 
     * @return Enables DNS AAAA record for resource name resolution.
     */
    public final Boolean enableResourceNameDnsAAAARecord() {
        return enableResourceNameDnsAAAARecord;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostnameTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enableResourceNameDnsARecord());
        hashCode = 31 * hashCode + Objects.hashCode(enableResourceNameDnsAAAARecord());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrivateDnsNameOptionsRequest)) {
            return false;
        }
        PrivateDnsNameOptionsRequest other = (PrivateDnsNameOptionsRequest) obj;
        return Objects.equals(hostnameTypeAsString(), other.hostnameTypeAsString())
                && Objects.equals(enableResourceNameDnsARecord(), other.enableResourceNameDnsARecord())
                && Objects.equals(enableResourceNameDnsAAAARecord(), other.enableResourceNameDnsAAAARecord());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrivateDnsNameOptionsRequest").add("HostnameType", hostnameTypeAsString())
                .add("EnableResourceNameDnsARecord", enableResourceNameDnsARecord())
                .add("EnableResourceNameDnsAAAARecord", enableResourceNameDnsAAAARecord()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HostnameType":
            return Optional.ofNullable(clazz.cast(hostnameTypeAsString()));
        case "EnableResourceNameDnsARecord":
            return Optional.ofNullable(clazz.cast(enableResourceNameDnsARecord()));
        case "EnableResourceNameDnsAAAARecord":
            return Optional.ofNullable(clazz.cast(enableResourceNameDnsAAAARecord()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HostnameType", HOSTNAME_TYPE_FIELD);
        map.put("EnableResourceNameDnsARecord", ENABLE_RESOURCE_NAME_DNS_A_RECORD_FIELD);
        map.put("EnableResourceNameDnsAAAARecord", ENABLE_RESOURCE_NAME_DNS_AAAA_RECORD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PrivateDnsNameOptionsRequest, T> g) {
        return obj -> g.apply((PrivateDnsNameOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrivateDnsNameOptionsRequest> {
        /**
         * <p>
         * Specifies the type of hostname configuration.
         * </p>
         * 
         * @param hostnameType
         *        Specifies the type of hostname configuration.
         * @see HostnameTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostnameTypeEnum
         */
        Builder hostnameType(String hostnameType);

        /**
         * <p>
         * Specifies the type of hostname configuration.
         * </p>
         * 
         * @param hostnameType
         *        Specifies the type of hostname configuration.
         * @see HostnameTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HostnameTypeEnum
         */
        Builder hostnameType(HostnameTypeEnum hostnameType);

        /**
         * <p>
         * Enables DNS A record for resource name resolution.
         * </p>
         * 
         * @param enableResourceNameDnsARecord
         *        Enables DNS A record for resource name resolution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableResourceNameDnsARecord(Boolean enableResourceNameDnsARecord);

        /**
         * <p>
         * Enables DNS AAAA record for resource name resolution.
         * </p>
         * 
         * @param enableResourceNameDnsAAAARecord
         *        Enables DNS AAAA record for resource name resolution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableResourceNameDnsAAAARecord(Boolean enableResourceNameDnsAAAARecord);
    }

    static final class BuilderImpl implements Builder {
        private String hostnameType;

        private Boolean enableResourceNameDnsARecord;

        private Boolean enableResourceNameDnsAAAARecord;

        private BuilderImpl() {
        }

        private BuilderImpl(PrivateDnsNameOptionsRequest model) {
            hostnameType(model.hostnameType);
            enableResourceNameDnsARecord(model.enableResourceNameDnsARecord);
            enableResourceNameDnsAAAARecord(model.enableResourceNameDnsAAAARecord);
        }

        public final String getHostnameType() {
            return hostnameType;
        }

        public final void setHostnameType(String hostnameType) {
            this.hostnameType = hostnameType;
        }

        @Override
        public final Builder hostnameType(String hostnameType) {
            this.hostnameType = hostnameType;
            return this;
        }

        @Override
        public final Builder hostnameType(HostnameTypeEnum hostnameType) {
            this.hostnameType(hostnameType == null ? null : hostnameType.toString());
            return this;
        }

        public final Boolean getEnableResourceNameDnsARecord() {
            return enableResourceNameDnsARecord;
        }

        public final void setEnableResourceNameDnsARecord(Boolean enableResourceNameDnsARecord) {
            this.enableResourceNameDnsARecord = enableResourceNameDnsARecord;
        }

        @Override
        public final Builder enableResourceNameDnsARecord(Boolean enableResourceNameDnsARecord) {
            this.enableResourceNameDnsARecord = enableResourceNameDnsARecord;
            return this;
        }

        public final Boolean getEnableResourceNameDnsAAAARecord() {
            return enableResourceNameDnsAAAARecord;
        }

        public final void setEnableResourceNameDnsAAAARecord(Boolean enableResourceNameDnsAAAARecord) {
            this.enableResourceNameDnsAAAARecord = enableResourceNameDnsAAAARecord;
        }

        @Override
        public final Builder enableResourceNameDnsAAAARecord(Boolean enableResourceNameDnsAAAARecord) {
            this.enableResourceNameDnsAAAARecord = enableResourceNameDnsAAAARecord;
            return this;
        }

        @Override
        public PrivateDnsNameOptionsRequest build() {
            return new PrivateDnsNameOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
