/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesinstances.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class EC2InstanceErrorsCopier {
    static List<EC2InstanceError> copy(Collection<? extends EC2InstanceError> ec2InstanceErrorsParam) {
        List<EC2InstanceError> list;
        if (ec2InstanceErrorsParam == null || ec2InstanceErrorsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<EC2InstanceError> modifiableList = new ArrayList<>(ec2InstanceErrorsParam.size());
            ec2InstanceErrorsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<EC2InstanceError> copyFromBuilder(Collection<? extends EC2InstanceError.Builder> ec2InstanceErrorsParam) {
        List<EC2InstanceError> list;
        if (ec2InstanceErrorsParam == null || ec2InstanceErrorsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<EC2InstanceError> modifiableList = new ArrayList<>(ec2InstanceErrorsParam.size());
            ec2InstanceErrorsParam.forEach(entry -> {
                EC2InstanceError member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<EC2InstanceError.Builder> copyToBuilder(Collection<? extends EC2InstanceError> ec2InstanceErrorsParam) {
        List<EC2InstanceError.Builder> list;
        if (ec2InstanceErrorsParam == null || ec2InstanceErrorsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<EC2InstanceError.Builder> modifiableList = new ArrayList<>(ec2InstanceErrorsParam.size());
            ec2InstanceErrorsParam.forEach(entry -> {
                EC2InstanceError.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
