/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesinstances.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspacesinstances.model.WorkspacesInstancesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateVolumeRequest
extends WorkspacesInstancesRequest
implements ToCopyableBuilder<Builder, AssociateVolumeRequest> {
    private static final SdkField<String> WORKSPACE_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkspaceInstanceId").getter(AssociateVolumeRequest.getter(AssociateVolumeRequest::workspaceInstanceId)).setter(AssociateVolumeRequest.setter(Builder::workspaceInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceInstanceId").build()}).build();
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeId").getter(AssociateVolumeRequest.getter(AssociateVolumeRequest::volumeId)).setter(AssociateVolumeRequest.setter(Builder::volumeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").build()}).build();
    private static final SdkField<String> DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Device").getter(AssociateVolumeRequest.getter(AssociateVolumeRequest::device)).setter(AssociateVolumeRequest.setter(Builder::device)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Device").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKSPACE_INSTANCE_ID_FIELD, VOLUME_ID_FIELD, DEVICE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssociateVolumeRequest.memberNameToFieldInitializer();
    private final String workspaceInstanceId;
    private final String volumeId;
    private final String device;

    private AssociateVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.workspaceInstanceId = builder.workspaceInstanceId;
        this.volumeId = builder.volumeId;
        this.device = builder.device;
    }

    public final String workspaceInstanceId() {
        return this.workspaceInstanceId;
    }

    public final String volumeId() {
        return this.volumeId;
    }

    public final String device() {
        return this.device;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.device());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateVolumeRequest)) {
            return false;
        }
        AssociateVolumeRequest other = (AssociateVolumeRequest)((Object)obj);
        return Objects.equals(this.workspaceInstanceId(), other.workspaceInstanceId()) && Objects.equals(this.volumeId(), other.volumeId()) && Objects.equals(this.device(), other.device());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateVolumeRequest").add("WorkspaceInstanceId", (Object)this.workspaceInstanceId()).add("VolumeId", (Object)this.volumeId()).add("Device", (Object)this.device()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WorkspaceInstanceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceInstanceId()));
            }
            case "VolumeId": {
                return Optional.ofNullable(clazz.cast(this.volumeId()));
            }
            case "Device": {
                return Optional.ofNullable(clazz.cast(this.device()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("WorkspaceInstanceId", WORKSPACE_INSTANCE_ID_FIELD);
        map.put("VolumeId", VOLUME_ID_FIELD);
        map.put("Device", DEVICE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateVolumeRequest, T> g) {
        return obj -> g.apply((AssociateVolumeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkspacesInstancesRequest.BuilderImpl
    implements Builder {
        private String workspaceInstanceId;
        private String volumeId;
        private String device;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateVolumeRequest model) {
            super(model);
            this.workspaceInstanceId(model.workspaceInstanceId);
            this.volumeId(model.volumeId);
            this.device(model.device);
        }

        public final String getWorkspaceInstanceId() {
            return this.workspaceInstanceId;
        }

        public final void setWorkspaceInstanceId(String workspaceInstanceId) {
            this.workspaceInstanceId = workspaceInstanceId;
        }

        @Override
        public final Builder workspaceInstanceId(String workspaceInstanceId) {
            this.workspaceInstanceId = workspaceInstanceId;
            return this;
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final String getDevice() {
            return this.device;
        }

        public final void setDevice(String device) {
            this.device = device;
        }

        @Override
        public final Builder device(String device) {
            this.device = device;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateVolumeRequest build() {
            return new AssociateVolumeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkspacesInstancesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateVolumeRequest> {
        public Builder workspaceInstanceId(String var1);

        public Builder volumeId(String var1);

        public Builder device(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

