/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesinstances.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines configuration for spot instance deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SpotMarketOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<SpotMarketOptions.Builder, SpotMarketOptions> {
    private static final SdkField<Integer> BLOCK_DURATION_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BlockDurationMinutes").getter(getter(SpotMarketOptions::blockDurationMinutes))
            .setter(setter(Builder::blockDurationMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDurationMinutes").build())
            .build();

    private static final SdkField<String> INSTANCE_INTERRUPTION_BEHAVIOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceInterruptionBehavior")
            .getter(getter(SpotMarketOptions::instanceInterruptionBehaviorAsString))
            .setter(setter(Builder::instanceInterruptionBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInterruptionBehavior")
                    .build()).build();

    private static final SdkField<String> MAX_PRICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxPrice").getter(getter(SpotMarketOptions::maxPrice)).setter(setter(Builder::maxPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPrice").build()).build();

    private static final SdkField<String> SPOT_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SpotInstanceType").getter(getter(SpotMarketOptions::spotInstanceTypeAsString))
            .setter(setter(Builder::spotInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotInstanceType").build()).build();

    private static final SdkField<Instant> VALID_UNTIL_UTC_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ValidUntilUtc").getter(getter(SpotMarketOptions::validUntilUtc)).setter(setter(Builder::validUntilUtc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidUntilUtc").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_DURATION_MINUTES_FIELD,
            INSTANCE_INTERRUPTION_BEHAVIOR_FIELD, MAX_PRICE_FIELD, SPOT_INSTANCE_TYPE_FIELD, VALID_UNTIL_UTC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer blockDurationMinutes;

    private final String instanceInterruptionBehavior;

    private final String maxPrice;

    private final String spotInstanceType;

    private final Instant validUntilUtc;

    private SpotMarketOptions(BuilderImpl builder) {
        this.blockDurationMinutes = builder.blockDurationMinutes;
        this.instanceInterruptionBehavior = builder.instanceInterruptionBehavior;
        this.maxPrice = builder.maxPrice;
        this.spotInstanceType = builder.spotInstanceType;
        this.validUntilUtc = builder.validUntilUtc;
    }

    /**
     * <p>
     * Duration of spot instance block reservation.
     * </p>
     * 
     * @return Duration of spot instance block reservation.
     */
    public final Integer blockDurationMinutes() {
        return blockDurationMinutes;
    }

    /**
     * <p>
     * Specifies behavior when spot instance is interrupted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceInterruptionBehavior} will return {@link InstanceInterruptionBehaviorEnum#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #instanceInterruptionBehaviorAsString}.
     * </p>
     * 
     * @return Specifies behavior when spot instance is interrupted.
     * @see InstanceInterruptionBehaviorEnum
     */
    public final InstanceInterruptionBehaviorEnum instanceInterruptionBehavior() {
        return InstanceInterruptionBehaviorEnum.fromValue(instanceInterruptionBehavior);
    }

    /**
     * <p>
     * Specifies behavior when spot instance is interrupted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #instanceInterruptionBehavior} will return {@link InstanceInterruptionBehaviorEnum#UNKNOWN_TO_SDK_VERSION}
     * . The raw value returned by the service is available from {@link #instanceInterruptionBehaviorAsString}.
     * </p>
     * 
     * @return Specifies behavior when spot instance is interrupted.
     * @see InstanceInterruptionBehaviorEnum
     */
    public final String instanceInterruptionBehaviorAsString() {
        return instanceInterruptionBehavior;
    }

    /**
     * <p>
     * Maximum hourly price for spot instance.
     * </p>
     * 
     * @return Maximum hourly price for spot instance.
     */
    public final String maxPrice() {
        return maxPrice;
    }

    /**
     * <p>
     * Defines the type of spot instance request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #spotInstanceType}
     * will return {@link SpotInstanceTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #spotInstanceTypeAsString}.
     * </p>
     * 
     * @return Defines the type of spot instance request.
     * @see SpotInstanceTypeEnum
     */
    public final SpotInstanceTypeEnum spotInstanceType() {
        return SpotInstanceTypeEnum.fromValue(spotInstanceType);
    }

    /**
     * <p>
     * Defines the type of spot instance request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #spotInstanceType}
     * will return {@link SpotInstanceTypeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #spotInstanceTypeAsString}.
     * </p>
     * 
     * @return Defines the type of spot instance request.
     * @see SpotInstanceTypeEnum
     */
    public final String spotInstanceTypeAsString() {
        return spotInstanceType;
    }

    /**
     * <p>
     * Timestamp until which spot instance request is valid.
     * </p>
     * 
     * @return Timestamp until which spot instance request is valid.
     */
    public final Instant validUntilUtc() {
        return validUntilUtc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blockDurationMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(instanceInterruptionBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxPrice());
        hashCode = 31 * hashCode + Objects.hashCode(spotInstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(validUntilUtc());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotMarketOptions)) {
            return false;
        }
        SpotMarketOptions other = (SpotMarketOptions) obj;
        return Objects.equals(blockDurationMinutes(), other.blockDurationMinutes())
                && Objects.equals(instanceInterruptionBehaviorAsString(), other.instanceInterruptionBehaviorAsString())
                && Objects.equals(maxPrice(), other.maxPrice())
                && Objects.equals(spotInstanceTypeAsString(), other.spotInstanceTypeAsString())
                && Objects.equals(validUntilUtc(), other.validUntilUtc());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SpotMarketOptions").add("BlockDurationMinutes", blockDurationMinutes())
                .add("InstanceInterruptionBehavior", instanceInterruptionBehaviorAsString()).add("MaxPrice", maxPrice())
                .add("SpotInstanceType", spotInstanceTypeAsString()).add("ValidUntilUtc", validUntilUtc()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlockDurationMinutes":
            return Optional.ofNullable(clazz.cast(blockDurationMinutes()));
        case "InstanceInterruptionBehavior":
            return Optional.ofNullable(clazz.cast(instanceInterruptionBehaviorAsString()));
        case "MaxPrice":
            return Optional.ofNullable(clazz.cast(maxPrice()));
        case "SpotInstanceType":
            return Optional.ofNullable(clazz.cast(spotInstanceTypeAsString()));
        case "ValidUntilUtc":
            return Optional.ofNullable(clazz.cast(validUntilUtc()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BlockDurationMinutes", BLOCK_DURATION_MINUTES_FIELD);
        map.put("InstanceInterruptionBehavior", INSTANCE_INTERRUPTION_BEHAVIOR_FIELD);
        map.put("MaxPrice", MAX_PRICE_FIELD);
        map.put("SpotInstanceType", SPOT_INSTANCE_TYPE_FIELD);
        map.put("ValidUntilUtc", VALID_UNTIL_UTC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SpotMarketOptions, T> g) {
        return obj -> g.apply((SpotMarketOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SpotMarketOptions> {
        /**
         * <p>
         * Duration of spot instance block reservation.
         * </p>
         * 
         * @param blockDurationMinutes
         *        Duration of spot instance block reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDurationMinutes(Integer blockDurationMinutes);

        /**
         * <p>
         * Specifies behavior when spot instance is interrupted.
         * </p>
         * 
         * @param instanceInterruptionBehavior
         *        Specifies behavior when spot instance is interrupted.
         * @see InstanceInterruptionBehaviorEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceInterruptionBehaviorEnum
         */
        Builder instanceInterruptionBehavior(String instanceInterruptionBehavior);

        /**
         * <p>
         * Specifies behavior when spot instance is interrupted.
         * </p>
         * 
         * @param instanceInterruptionBehavior
         *        Specifies behavior when spot instance is interrupted.
         * @see InstanceInterruptionBehaviorEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceInterruptionBehaviorEnum
         */
        Builder instanceInterruptionBehavior(InstanceInterruptionBehaviorEnum instanceInterruptionBehavior);

        /**
         * <p>
         * Maximum hourly price for spot instance.
         * </p>
         * 
         * @param maxPrice
         *        Maximum hourly price for spot instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxPrice(String maxPrice);

        /**
         * <p>
         * Defines the type of spot instance request.
         * </p>
         * 
         * @param spotInstanceType
         *        Defines the type of spot instance request.
         * @see SpotInstanceTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpotInstanceTypeEnum
         */
        Builder spotInstanceType(String spotInstanceType);

        /**
         * <p>
         * Defines the type of spot instance request.
         * </p>
         * 
         * @param spotInstanceType
         *        Defines the type of spot instance request.
         * @see SpotInstanceTypeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SpotInstanceTypeEnum
         */
        Builder spotInstanceType(SpotInstanceTypeEnum spotInstanceType);

        /**
         * <p>
         * Timestamp until which spot instance request is valid.
         * </p>
         * 
         * @param validUntilUtc
         *        Timestamp until which spot instance request is valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validUntilUtc(Instant validUntilUtc);
    }

    static final class BuilderImpl implements Builder {
        private Integer blockDurationMinutes;

        private String instanceInterruptionBehavior;

        private String maxPrice;

        private String spotInstanceType;

        private Instant validUntilUtc;

        private BuilderImpl() {
        }

        private BuilderImpl(SpotMarketOptions model) {
            blockDurationMinutes(model.blockDurationMinutes);
            instanceInterruptionBehavior(model.instanceInterruptionBehavior);
            maxPrice(model.maxPrice);
            spotInstanceType(model.spotInstanceType);
            validUntilUtc(model.validUntilUtc);
        }

        public final Integer getBlockDurationMinutes() {
            return blockDurationMinutes;
        }

        public final void setBlockDurationMinutes(Integer blockDurationMinutes) {
            this.blockDurationMinutes = blockDurationMinutes;
        }

        @Override
        public final Builder blockDurationMinutes(Integer blockDurationMinutes) {
            this.blockDurationMinutes = blockDurationMinutes;
            return this;
        }

        public final String getInstanceInterruptionBehavior() {
            return instanceInterruptionBehavior;
        }

        public final void setInstanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
        }

        @Override
        public final Builder instanceInterruptionBehavior(String instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior = instanceInterruptionBehavior;
            return this;
        }

        @Override
        public final Builder instanceInterruptionBehavior(InstanceInterruptionBehaviorEnum instanceInterruptionBehavior) {
            this.instanceInterruptionBehavior(instanceInterruptionBehavior == null ? null : instanceInterruptionBehavior
                    .toString());
            return this;
        }

        public final String getMaxPrice() {
            return maxPrice;
        }

        public final void setMaxPrice(String maxPrice) {
            this.maxPrice = maxPrice;
        }

        @Override
        public final Builder maxPrice(String maxPrice) {
            this.maxPrice = maxPrice;
            return this;
        }

        public final String getSpotInstanceType() {
            return spotInstanceType;
        }

        public final void setSpotInstanceType(String spotInstanceType) {
            this.spotInstanceType = spotInstanceType;
        }

        @Override
        public final Builder spotInstanceType(String spotInstanceType) {
            this.spotInstanceType = spotInstanceType;
            return this;
        }

        @Override
        public final Builder spotInstanceType(SpotInstanceTypeEnum spotInstanceType) {
            this.spotInstanceType(spotInstanceType == null ? null : spotInstanceType.toString());
            return this;
        }

        public final Instant getValidUntilUtc() {
            return validUntilUtc;
        }

        public final void setValidUntilUtc(Instant validUntilUtc) {
            this.validUntilUtc = validUntilUtc;
        }

        @Override
        public final Builder validUntilUtc(Instant validUntilUtc) {
            this.validUntilUtc = validUntilUtc;
            return this;
        }

        @Override
        public SpotMarketOptions build() {
            return new SpotMarketOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
