/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesinstances.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines device mapping for WorkSpace Instance storage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BlockDeviceMappingRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<BlockDeviceMappingRequest.Builder, BlockDeviceMappingRequest> {
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceName").getter(getter(BlockDeviceMappingRequest::deviceName)).setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()).build();

    private static final SdkField<EbsBlockDevice> EBS_FIELD = SdkField.<EbsBlockDevice> builder(MarshallingType.SDK_POJO)
            .memberName("Ebs").getter(getter(BlockDeviceMappingRequest::ebs)).setter(setter(Builder::ebs))
            .constructor(EbsBlockDevice::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ebs").build()).build();

    private static final SdkField<String> NO_DEVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NoDevice").getter(getter(BlockDeviceMappingRequest::noDevice)).setter(setter(Builder::noDevice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoDevice").build()).build();

    private static final SdkField<String> VIRTUAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VirtualName").getter(getter(BlockDeviceMappingRequest::virtualName))
            .setter(setter(Builder::virtualName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_NAME_FIELD, EBS_FIELD,
            NO_DEVICE_FIELD, VIRTUAL_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String deviceName;

    private final EbsBlockDevice ebs;

    private final String noDevice;

    private final String virtualName;

    private BlockDeviceMappingRequest(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.ebs = builder.ebs;
        this.noDevice = builder.noDevice;
        this.virtualName = builder.virtualName;
    }

    /**
     * <p>
     * Name of the device for storage mapping.
     * </p>
     * 
     * @return Name of the device for storage mapping.
     */
    public final String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * EBS volume configuration for the device.
     * </p>
     * 
     * @return EBS volume configuration for the device.
     */
    public final EbsBlockDevice ebs() {
        return ebs;
    }

    /**
     * <p>
     * Indicates device should not be mapped.
     * </p>
     * 
     * @return Indicates device should not be mapped.
     */
    public final String noDevice() {
        return noDevice;
    }

    /**
     * <p>
     * Virtual device name for ephemeral storage.
     * </p>
     * 
     * @return Virtual device name for ephemeral storage.
     */
    public final String virtualName() {
        return virtualName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(ebs());
        hashCode = 31 * hashCode + Objects.hashCode(noDevice());
        hashCode = 31 * hashCode + Objects.hashCode(virtualName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockDeviceMappingRequest)) {
            return false;
        }
        BlockDeviceMappingRequest other = (BlockDeviceMappingRequest) obj;
        return Objects.equals(deviceName(), other.deviceName()) && Objects.equals(ebs(), other.ebs())
                && Objects.equals(noDevice(), other.noDevice()) && Objects.equals(virtualName(), other.virtualName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BlockDeviceMappingRequest").add("DeviceName", deviceName()).add("Ebs", ebs())
                .add("NoDevice", noDevice()).add("VirtualName", virtualName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "Ebs":
            return Optional.ofNullable(clazz.cast(ebs()));
        case "NoDevice":
            return Optional.ofNullable(clazz.cast(noDevice()));
        case "VirtualName":
            return Optional.ofNullable(clazz.cast(virtualName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeviceName", DEVICE_NAME_FIELD);
        map.put("Ebs", EBS_FIELD);
        map.put("NoDevice", NO_DEVICE_FIELD);
        map.put("VirtualName", VIRTUAL_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BlockDeviceMappingRequest, T> g) {
        return obj -> g.apply((BlockDeviceMappingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BlockDeviceMappingRequest> {
        /**
         * <p>
         * Name of the device for storage mapping.
         * </p>
         * 
         * @param deviceName
         *        Name of the device for storage mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * EBS volume configuration for the device.
         * </p>
         * 
         * @param ebs
         *        EBS volume configuration for the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebs(EbsBlockDevice ebs);

        /**
         * <p>
         * EBS volume configuration for the device.
         * </p>
         * This is a convenience method that creates an instance of the {@link EbsBlockDevice.Builder} avoiding the need
         * to create one manually via {@link EbsBlockDevice#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EbsBlockDevice.Builder#build()} is called immediately and its
         * result is passed to {@link #ebs(EbsBlockDevice)}.
         * 
         * @param ebs
         *        a consumer that will call methods on {@link EbsBlockDevice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebs(EbsBlockDevice)
         */
        default Builder ebs(Consumer<EbsBlockDevice.Builder> ebs) {
            return ebs(EbsBlockDevice.builder().applyMutation(ebs).build());
        }

        /**
         * <p>
         * Indicates device should not be mapped.
         * </p>
         * 
         * @param noDevice
         *        Indicates device should not be mapped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noDevice(String noDevice);

        /**
         * <p>
         * Virtual device name for ephemeral storage.
         * </p>
         * 
         * @param virtualName
         *        Virtual device name for ephemeral storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualName(String virtualName);
    }

    static final class BuilderImpl implements Builder {
        private String deviceName;

        private EbsBlockDevice ebs;

        private String noDevice;

        private String virtualName;

        private BuilderImpl() {
        }

        private BuilderImpl(BlockDeviceMappingRequest model) {
            deviceName(model.deviceName);
            ebs(model.ebs);
            noDevice(model.noDevice);
            virtualName(model.virtualName);
        }

        public final String getDeviceName() {
            return deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final EbsBlockDevice.Builder getEbs() {
            return ebs != null ? ebs.toBuilder() : null;
        }

        public final void setEbs(EbsBlockDevice.BuilderImpl ebs) {
            this.ebs = ebs != null ? ebs.build() : null;
        }

        @Override
        public final Builder ebs(EbsBlockDevice ebs) {
            this.ebs = ebs;
            return this;
        }

        public final String getNoDevice() {
            return noDevice;
        }

        public final void setNoDevice(String noDevice) {
            this.noDevice = noDevice;
        }

        @Override
        public final Builder noDevice(String noDevice) {
            this.noDevice = noDevice;
            return this;
        }

        public final String getVirtualName() {
            return virtualName;
        }

        public final void setVirtualName(String virtualName) {
            this.virtualName = virtualName;
        }

        @Override
        public final Builder virtualName(String virtualName) {
            this.virtualName = virtualName;
            return this;
        }

        @Override
        public BlockDeviceMappingRequest build() {
            return new BlockDeviceMappingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
