/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesinstances;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.workspacesinstances.model.AccessDeniedException;
import software.amazon.awssdk.services.workspacesinstances.model.AssociateVolumeRequest;
import software.amazon.awssdk.services.workspacesinstances.model.AssociateVolumeResponse;
import software.amazon.awssdk.services.workspacesinstances.model.ConflictException;
import software.amazon.awssdk.services.workspacesinstances.model.CreateVolumeRequest;
import software.amazon.awssdk.services.workspacesinstances.model.CreateVolumeResponse;
import software.amazon.awssdk.services.workspacesinstances.model.CreateWorkspaceInstanceRequest;
import software.amazon.awssdk.services.workspacesinstances.model.CreateWorkspaceInstanceResponse;
import software.amazon.awssdk.services.workspacesinstances.model.DeleteVolumeRequest;
import software.amazon.awssdk.services.workspacesinstances.model.DeleteVolumeResponse;
import software.amazon.awssdk.services.workspacesinstances.model.DeleteWorkspaceInstanceRequest;
import software.amazon.awssdk.services.workspacesinstances.model.DeleteWorkspaceInstanceResponse;
import software.amazon.awssdk.services.workspacesinstances.model.DisassociateVolumeRequest;
import software.amazon.awssdk.services.workspacesinstances.model.DisassociateVolumeResponse;
import software.amazon.awssdk.services.workspacesinstances.model.GetWorkspaceInstanceRequest;
import software.amazon.awssdk.services.workspacesinstances.model.GetWorkspaceInstanceResponse;
import software.amazon.awssdk.services.workspacesinstances.model.InternalServerException;
import software.amazon.awssdk.services.workspacesinstances.model.ListInstanceTypesRequest;
import software.amazon.awssdk.services.workspacesinstances.model.ListInstanceTypesResponse;
import software.amazon.awssdk.services.workspacesinstances.model.ListRegionsRequest;
import software.amazon.awssdk.services.workspacesinstances.model.ListRegionsResponse;
import software.amazon.awssdk.services.workspacesinstances.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.workspacesinstances.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.workspacesinstances.model.ListWorkspaceInstancesRequest;
import software.amazon.awssdk.services.workspacesinstances.model.ListWorkspaceInstancesResponse;
import software.amazon.awssdk.services.workspacesinstances.model.ResourceNotFoundException;
import software.amazon.awssdk.services.workspacesinstances.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.workspacesinstances.model.TagResourceRequest;
import software.amazon.awssdk.services.workspacesinstances.model.TagResourceResponse;
import software.amazon.awssdk.services.workspacesinstances.model.ThrottlingException;
import software.amazon.awssdk.services.workspacesinstances.model.UntagResourceRequest;
import software.amazon.awssdk.services.workspacesinstances.model.UntagResourceResponse;
import software.amazon.awssdk.services.workspacesinstances.model.ValidationException;
import software.amazon.awssdk.services.workspacesinstances.model.WorkspacesInstancesException;
import software.amazon.awssdk.services.workspacesinstances.paginators.ListInstanceTypesIterable;
import software.amazon.awssdk.services.workspacesinstances.paginators.ListRegionsIterable;
import software.amazon.awssdk.services.workspacesinstances.paginators.ListWorkspaceInstancesIterable;

/**
 * Service client for accessing Amazon Workspaces Instances. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Amazon WorkSpaces Instances provides an API framework for managing virtual workspace environments across multiple AWS
 * regions, enabling programmatic creation and configuration of desktop infrastructure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface WorkspacesInstancesClient extends AwsClient {
    String SERVICE_NAME = "workspaces-instances";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "workspaces-instances";

    /**
     * <p>
     * Attaches a volume to a WorkSpace Instance.
     * </p>
     *
     * @param associateVolumeRequest
     *        Specifies volume attachment parameters.
     * @return Result of the AssociateVolume operation returned by the service.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws ResourceNotFoundException
     *         Indicates the requested resource could not be found.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws ConflictException
     *         Signals a conflict with the current state of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.AssociateVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/AssociateVolume"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateVolumeResponse associateVolume(AssociateVolumeRequest associateVolumeRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, ConflictException,
            AwsServiceException, SdkClientException, WorkspacesInstancesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a volume to a WorkSpace Instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateVolumeRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateVolumeRequest#builder()}
     * </p>
     *
     * @param associateVolumeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.AssociateVolumeRequest.Builder} to create
     *        a request. Specifies volume attachment parameters.
     * @return Result of the AssociateVolume operation returned by the service.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws ResourceNotFoundException
     *         Indicates the requested resource could not be found.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws ConflictException
     *         Signals a conflict with the current state of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.AssociateVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/AssociateVolume"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateVolumeResponse associateVolume(Consumer<AssociateVolumeRequest.Builder> associateVolumeRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, ConflictException, AwsServiceException, SdkClientException, WorkspacesInstancesException {
        return associateVolume(AssociateVolumeRequest.builder().applyMutation(associateVolumeRequest).build());
    }

    /**
     * <p>
     * Creates a new volume for WorkSpace Instances.
     * </p>
     *
     * @param createVolumeRequest
     *        Specifies volume creation parameters.
     * @return Result of the CreateVolume operation returned by the service.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws ServiceQuotaExceededException
     *         Indicates that a service quota has been exceeded.
     * @throws ConflictException
     *         Signals a conflict with the current state of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.CreateVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/CreateVolume"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVolumeResponse createVolume(CreateVolumeRequest createVolumeRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, ServiceQuotaExceededException,
            ConflictException, AwsServiceException, SdkClientException, WorkspacesInstancesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new volume for WorkSpace Instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVolumeRequest.Builder} avoiding the need to
     * create one manually via {@link CreateVolumeRequest#builder()}
     * </p>
     *
     * @param createVolumeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.CreateVolumeRequest.Builder} to create a
     *        request. Specifies volume creation parameters.
     * @return Result of the CreateVolume operation returned by the service.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws ServiceQuotaExceededException
     *         Indicates that a service quota has been exceeded.
     * @throws ConflictException
     *         Signals a conflict with the current state of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.CreateVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/CreateVolume"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVolumeResponse createVolume(Consumer<CreateVolumeRequest.Builder> createVolumeRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException,
            ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException,
            WorkspacesInstancesException {
        return createVolume(CreateVolumeRequest.builder().applyMutation(createVolumeRequest).build());
    }

    /**
     * <p>
     * Launches a new WorkSpace Instance with specified configuration parameters, enabling programmatic workspace
     * deployment.
     * </p>
     *
     * @param createWorkspaceInstanceRequest
     *        Defines the configuration parameters for creating a new WorkSpaces Instance.
     * @return Result of the CreateWorkspaceInstance operation returned by the service.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws ServiceQuotaExceededException
     *         Indicates that a service quota has been exceeded.
     * @throws ConflictException
     *         Signals a conflict with the current state of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.CreateWorkspaceInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/CreateWorkspaceInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWorkspaceInstanceResponse createWorkspaceInstance(CreateWorkspaceInstanceRequest createWorkspaceInstanceRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException,
            ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException,
            WorkspacesInstancesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Launches a new WorkSpace Instance with specified configuration parameters, enabling programmatic workspace
     * deployment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkspaceInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link CreateWorkspaceInstanceRequest#builder()}
     * </p>
     *
     * @param createWorkspaceInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.CreateWorkspaceInstanceRequest.Builder}
     *        to create a request. Defines the configuration parameters for creating a new WorkSpaces Instance.
     * @return Result of the CreateWorkspaceInstance operation returned by the service.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws ServiceQuotaExceededException
     *         Indicates that a service quota has been exceeded.
     * @throws ConflictException
     *         Signals a conflict with the current state of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.CreateWorkspaceInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/CreateWorkspaceInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateWorkspaceInstanceResponse createWorkspaceInstance(
            Consumer<CreateWorkspaceInstanceRequest.Builder> createWorkspaceInstanceRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, ServiceQuotaExceededException,
            ConflictException, AwsServiceException, SdkClientException, WorkspacesInstancesException {
        return createWorkspaceInstance(CreateWorkspaceInstanceRequest.builder().applyMutation(createWorkspaceInstanceRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a specified volume.
     * </p>
     *
     * @param deleteVolumeRequest
     *        Specifies the volume to delete.
     * @return Result of the DeleteVolume operation returned by the service.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws ResourceNotFoundException
     *         Indicates the requested resource could not be found.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws ConflictException
     *         Signals a conflict with the current state of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.DeleteVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/DeleteVolume"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVolumeResponse deleteVolume(DeleteVolumeRequest deleteVolumeRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, ConflictException,
            AwsServiceException, SdkClientException, WorkspacesInstancesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified volume.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVolumeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteVolumeRequest#builder()}
     * </p>
     *
     * @param deleteVolumeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.DeleteVolumeRequest.Builder} to create a
     *        request. Specifies the volume to delete.
     * @return Result of the DeleteVolume operation returned by the service.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws ResourceNotFoundException
     *         Indicates the requested resource could not be found.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws ConflictException
     *         Signals a conflict with the current state of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.DeleteVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/DeleteVolume"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVolumeResponse deleteVolume(Consumer<DeleteVolumeRequest.Builder> deleteVolumeRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, ConflictException, AwsServiceException, SdkClientException, WorkspacesInstancesException {
        return deleteVolume(DeleteVolumeRequest.builder().applyMutation(deleteVolumeRequest).build());
    }

    /**
     * <p>
     * Deletes the specified WorkSpace
     * </p>
     *
     * @param deleteWorkspaceInstanceRequest
     *        The WorkSpace to delete
     * @return Result of the DeleteWorkspaceInstance operation returned by the service.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws ResourceNotFoundException
     *         Indicates the requested resource could not be found.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws ConflictException
     *         Signals a conflict with the current state of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.DeleteWorkspaceInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/DeleteWorkspaceInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWorkspaceInstanceResponse deleteWorkspaceInstance(DeleteWorkspaceInstanceRequest deleteWorkspaceInstanceRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, ConflictException, AwsServiceException, SdkClientException, WorkspacesInstancesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified WorkSpace
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkspaceInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteWorkspaceInstanceRequest#builder()}
     * </p>
     *
     * @param deleteWorkspaceInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.DeleteWorkspaceInstanceRequest.Builder}
     *        to create a request. The WorkSpace to delete
     * @return Result of the DeleteWorkspaceInstance operation returned by the service.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws ResourceNotFoundException
     *         Indicates the requested resource could not be found.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws ConflictException
     *         Signals a conflict with the current state of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.DeleteWorkspaceInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/DeleteWorkspaceInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWorkspaceInstanceResponse deleteWorkspaceInstance(
            Consumer<DeleteWorkspaceInstanceRequest.Builder> deleteWorkspaceInstanceRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, ConflictException,
            AwsServiceException, SdkClientException, WorkspacesInstancesException {
        return deleteWorkspaceInstance(DeleteWorkspaceInstanceRequest.builder().applyMutation(deleteWorkspaceInstanceRequest)
                .build());
    }

    /**
     * <p>
     * Detaches a volume from a WorkSpace Instance.
     * </p>
     *
     * @param disassociateVolumeRequest
     *        Specifies volume detachment parameters.
     * @return Result of the DisassociateVolume operation returned by the service.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws ResourceNotFoundException
     *         Indicates the requested resource could not be found.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws ConflictException
     *         Signals a conflict with the current state of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.DisassociateVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/DisassociateVolume"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateVolumeResponse disassociateVolume(DisassociateVolumeRequest disassociateVolumeRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, ConflictException, AwsServiceException, SdkClientException, WorkspacesInstancesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches a volume from a WorkSpace Instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateVolumeRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateVolumeRequest#builder()}
     * </p>
     *
     * @param disassociateVolumeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.DisassociateVolumeRequest.Builder} to
     *        create a request. Specifies volume detachment parameters.
     * @return Result of the DisassociateVolume operation returned by the service.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws ResourceNotFoundException
     *         Indicates the requested resource could not be found.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws ConflictException
     *         Signals a conflict with the current state of the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.DisassociateVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/DisassociateVolume"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateVolumeResponse disassociateVolume(Consumer<DisassociateVolumeRequest.Builder> disassociateVolumeRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, ConflictException, AwsServiceException, SdkClientException, WorkspacesInstancesException {
        return disassociateVolume(DisassociateVolumeRequest.builder().applyMutation(disassociateVolumeRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about a specific WorkSpace Instance.
     * </p>
     *
     * @param getWorkspaceInstanceRequest
     *        Identifies the WorkSpaces Instance to retrieve detailed information for.
     * @return Result of the GetWorkspaceInstance operation returned by the service.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws ResourceNotFoundException
     *         Indicates the requested resource could not be found.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.GetWorkspaceInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/GetWorkspaceInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWorkspaceInstanceResponse getWorkspaceInstance(GetWorkspaceInstanceRequest getWorkspaceInstanceRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, WorkspacesInstancesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information about a specific WorkSpace Instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkspaceInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link GetWorkspaceInstanceRequest#builder()}
     * </p>
     *
     * @param getWorkspaceInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.GetWorkspaceInstanceRequest.Builder} to
     *        create a request. Identifies the WorkSpaces Instance to retrieve detailed information for.
     * @return Result of the GetWorkspaceInstance operation returned by the service.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws ResourceNotFoundException
     *         Indicates the requested resource could not be found.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.GetWorkspaceInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/GetWorkspaceInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWorkspaceInstanceResponse getWorkspaceInstance(
            Consumer<GetWorkspaceInstanceRequest.Builder> getWorkspaceInstanceRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, WorkspacesInstancesException {
        return getWorkspaceInstance(GetWorkspaceInstanceRequest.builder().applyMutation(getWorkspaceInstanceRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of instance types supported by Amazon WorkSpaces Instances, enabling precise workspace
     * infrastructure configuration.
     * </p>
     *
     * @param listInstanceTypesRequest
     *        Defines input parameters for retrieving supported WorkSpaces Instances instance types.
     * @return Result of the ListInstanceTypes operation returned by the service.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.ListInstanceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/ListInstanceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceTypesResponse listInstanceTypes(ListInstanceTypesRequest listInstanceTypesRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, WorkspacesInstancesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of instance types supported by Amazon WorkSpaces Instances, enabling precise workspace
     * infrastructure configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceTypesRequest.Builder} avoiding the need
     * to create one manually via {@link ListInstanceTypesRequest#builder()}
     * </p>
     *
     * @param listInstanceTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.ListInstanceTypesRequest.Builder} to
     *        create a request. Defines input parameters for retrieving supported WorkSpaces Instances instance types.
     * @return Result of the ListInstanceTypes operation returned by the service.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.ListInstanceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/ListInstanceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceTypesResponse listInstanceTypes(Consumer<ListInstanceTypesRequest.Builder> listInstanceTypesRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, WorkspacesInstancesException {
        return listInstanceTypes(ListInstanceTypesRequest.builder().applyMutation(listInstanceTypesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInstanceTypes(software.amazon.awssdk.services.workspacesinstances.model.ListInstanceTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesinstances.paginators.ListInstanceTypesIterable responses = client.listInstanceTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesinstances.paginators.ListInstanceTypesIterable responses = client
     *             .listInstanceTypesPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesinstances.model.ListInstanceTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesinstances.paginators.ListInstanceTypesIterable responses = client.listInstanceTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceTypes(software.amazon.awssdk.services.workspacesinstances.model.ListInstanceTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInstanceTypesRequest
     *        Defines input parameters for retrieving supported WorkSpaces Instances instance types.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.ListInstanceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/ListInstanceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceTypesIterable listInstanceTypesPaginator(ListInstanceTypesRequest listInstanceTypesRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, WorkspacesInstancesException {
        return new ListInstanceTypesIterable(this, listInstanceTypesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInstanceTypes(software.amazon.awssdk.services.workspacesinstances.model.ListInstanceTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesinstances.paginators.ListInstanceTypesIterable responses = client.listInstanceTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesinstances.paginators.ListInstanceTypesIterable responses = client
     *             .listInstanceTypesPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesinstances.model.ListInstanceTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesinstances.paginators.ListInstanceTypesIterable responses = client.listInstanceTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceTypes(software.amazon.awssdk.services.workspacesinstances.model.ListInstanceTypesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceTypesRequest.Builder} avoiding the need
     * to create one manually via {@link ListInstanceTypesRequest#builder()}
     * </p>
     *
     * @param listInstanceTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.ListInstanceTypesRequest.Builder} to
     *        create a request. Defines input parameters for retrieving supported WorkSpaces Instances instance types.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.ListInstanceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/ListInstanceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceTypesIterable listInstanceTypesPaginator(
            Consumer<ListInstanceTypesRequest.Builder> listInstanceTypesRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            WorkspacesInstancesException {
        return listInstanceTypesPaginator(ListInstanceTypesRequest.builder().applyMutation(listInstanceTypesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of AWS regions supported by Amazon WorkSpaces Instances, enabling region discovery for workspace
     * deployments.
     * </p>
     *
     * @param listRegionsRequest
     *        Defines input parameters for retrieving supported WorkSpaces Instances regions.
     * @return Result of the ListRegions operation returned by the service.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.ListRegions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/ListRegions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRegionsResponse listRegions(ListRegionsRequest listRegionsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            WorkspacesInstancesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of AWS regions supported by Amazon WorkSpaces Instances, enabling region discovery for workspace
     * deployments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRegionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRegionsRequest#builder()}
     * </p>
     *
     * @param listRegionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.ListRegionsRequest.Builder} to create a
     *        request. Defines input parameters for retrieving supported WorkSpaces Instances regions.
     * @return Result of the ListRegions operation returned by the service.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.ListRegions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/ListRegions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRegionsResponse listRegions(Consumer<ListRegionsRequest.Builder> listRegionsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            WorkspacesInstancesException {
        return listRegions(ListRegionsRequest.builder().applyMutation(listRegionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRegions(software.amazon.awssdk.services.workspacesinstances.model.ListRegionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesinstances.paginators.ListRegionsIterable responses = client.listRegionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesinstances.paginators.ListRegionsIterable responses = client
     *             .listRegionsPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesinstances.model.ListRegionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesinstances.paginators.ListRegionsIterable responses = client.listRegionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRegions(software.amazon.awssdk.services.workspacesinstances.model.ListRegionsRequest)} operation.</b>
     * </p>
     *
     * @param listRegionsRequest
     *        Defines input parameters for retrieving supported WorkSpaces Instances regions.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.ListRegions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/ListRegions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRegionsIterable listRegionsPaginator(ListRegionsRequest listRegionsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            WorkspacesInstancesException {
        return new ListRegionsIterable(this, listRegionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRegions(software.amazon.awssdk.services.workspacesinstances.model.ListRegionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesinstances.paginators.ListRegionsIterable responses = client.listRegionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesinstances.paginators.ListRegionsIterable responses = client
     *             .listRegionsPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesinstances.model.ListRegionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesinstances.paginators.ListRegionsIterable responses = client.listRegionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRegions(software.amazon.awssdk.services.workspacesinstances.model.ListRegionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRegionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRegionsRequest#builder()}
     * </p>
     *
     * @param listRegionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.ListRegionsRequest.Builder} to create a
     *        request. Defines input parameters for retrieving supported WorkSpaces Instances regions.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.ListRegions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/ListRegions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRegionsIterable listRegionsPaginator(Consumer<ListRegionsRequest.Builder> listRegionsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, WorkspacesInstancesException {
        return listRegionsPaginator(ListRegionsRequest.builder().applyMutation(listRegionsRequest).build());
    }

    /**
     * <p>
     * Retrieves tags for a WorkSpace Instance.
     * </p>
     *
     * @param listTagsForResourceRequest
     *        Specifies the WorkSpace Instance to retrieve tags for.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ResourceNotFoundException
     *         Indicates the requested resource could not be found.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, WorkspacesInstancesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves tags for a WorkSpace Instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.ListTagsForResourceRequest.Builder} to
     *        create a request. Specifies the WorkSpace Instance to retrieve tags for.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ResourceNotFoundException
     *         Indicates the requested resource could not be found.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, WorkspacesInstancesException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves a collection of WorkSpaces Instances based on specified filters.
     * </p>
     *
     * @param listWorkspaceInstancesRequest
     *        Defines filters and pagination parameters for retrieving WorkSpaces Instances.
     * @return Result of the ListWorkspaceInstances operation returned by the service.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.ListWorkspaceInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/ListWorkspaceInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkspaceInstancesResponse listWorkspaceInstances(ListWorkspaceInstancesRequest listWorkspaceInstancesRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, WorkspacesInstancesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a collection of WorkSpaces Instances based on specified filters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkspaceInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorkspaceInstancesRequest#builder()}
     * </p>
     *
     * @param listWorkspaceInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.ListWorkspaceInstancesRequest.Builder} to
     *        create a request. Defines filters and pagination parameters for retrieving WorkSpaces Instances.
     * @return Result of the ListWorkspaceInstances operation returned by the service.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.ListWorkspaceInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/ListWorkspaceInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkspaceInstancesResponse listWorkspaceInstances(
            Consumer<ListWorkspaceInstancesRequest.Builder> listWorkspaceInstancesRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            WorkspacesInstancesException {
        return listWorkspaceInstances(ListWorkspaceInstancesRequest.builder().applyMutation(listWorkspaceInstancesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkspaceInstances(software.amazon.awssdk.services.workspacesinstances.model.ListWorkspaceInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesinstances.paginators.ListWorkspaceInstancesIterable responses = client.listWorkspaceInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesinstances.paginators.ListWorkspaceInstancesIterable responses = client
     *             .listWorkspaceInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesinstances.model.ListWorkspaceInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesinstances.paginators.ListWorkspaceInstancesIterable responses = client.listWorkspaceInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkspaceInstances(software.amazon.awssdk.services.workspacesinstances.model.ListWorkspaceInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorkspaceInstancesRequest
     *        Defines filters and pagination parameters for retrieving WorkSpaces Instances.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.ListWorkspaceInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/ListWorkspaceInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkspaceInstancesIterable listWorkspaceInstancesPaginator(
            ListWorkspaceInstancesRequest listWorkspaceInstancesRequest) throws ValidationException, AccessDeniedException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, WorkspacesInstancesException {
        return new ListWorkspaceInstancesIterable(this, listWorkspaceInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkspaceInstances(software.amazon.awssdk.services.workspacesinstances.model.ListWorkspaceInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesinstances.paginators.ListWorkspaceInstancesIterable responses = client.listWorkspaceInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesinstances.paginators.ListWorkspaceInstancesIterable responses = client
     *             .listWorkspaceInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesinstances.model.ListWorkspaceInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesinstances.paginators.ListWorkspaceInstancesIterable responses = client.listWorkspaceInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkspaceInstances(software.amazon.awssdk.services.workspacesinstances.model.ListWorkspaceInstancesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkspaceInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorkspaceInstancesRequest#builder()}
     * </p>
     *
     * @param listWorkspaceInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.ListWorkspaceInstancesRequest.Builder} to
     *        create a request. Defines filters and pagination parameters for retrieving WorkSpaces Instances.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.ListWorkspaceInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/ListWorkspaceInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkspaceInstancesIterable listWorkspaceInstancesPaginator(
            Consumer<ListWorkspaceInstancesRequest.Builder> listWorkspaceInstancesRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            WorkspacesInstancesException {
        return listWorkspaceInstancesPaginator(ListWorkspaceInstancesRequest.builder()
                .applyMutation(listWorkspaceInstancesRequest).build());
    }

    /**
     * <p>
     * Adds tags to a WorkSpace Instance.
     * </p>
     *
     * @param tagResourceRequest
     *        Specifies tags to add to a WorkSpace Instance.
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ResourceNotFoundException
     *         Indicates the requested resource could not be found.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, WorkspacesInstancesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to a WorkSpace Instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.TagResourceRequest.Builder} to create a
     *        request. Specifies tags to add to a WorkSpace Instance.
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ResourceNotFoundException
     *         Indicates the requested resource could not be found.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, WorkspacesInstancesException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a WorkSpace Instance.
     * </p>
     *
     * @param untagResourceRequest
     *        Specifies tags to remove from a WorkSpace Instance.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ResourceNotFoundException
     *         Indicates the requested resource could not be found.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, WorkspacesInstancesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a WorkSpace Instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.UntagResourceRequest.Builder} to create a
     *        request. Specifies tags to remove from a WorkSpace Instance.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         Indicates invalid input parameters in the request.
     * @throws AccessDeniedException
     *         Indicates insufficient permissions to perform the requested action.
     * @throws ResourceNotFoundException
     *         Indicates the requested resource could not be found.
     * @throws ThrottlingException
     *         Indicates the request rate has exceeded limits.
     * @throws InternalServerException
     *         Indicates an unexpected server-side error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkspacesInstancesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkspacesInstancesClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ValidationException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, WorkspacesInstancesException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * Create a {@link WorkspacesInstancesClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static WorkspacesInstancesClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link WorkspacesInstancesClient}.
     */
    static WorkspacesInstancesClientBuilder builder() {
        return new DefaultWorkspacesInstancesClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default WorkspacesInstancesServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
