/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class WorkspaceConnectionStatusListCopier {
    static List<WorkspaceConnectionStatus> copy(Collection<? extends WorkspaceConnectionStatus> workspaceConnectionStatusListParam) {
        List<WorkspaceConnectionStatus> list;
        if (workspaceConnectionStatusListParam == null || workspaceConnectionStatusListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<WorkspaceConnectionStatus> modifiableList = new ArrayList<>(workspaceConnectionStatusListParam.size());
            workspaceConnectionStatusListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<WorkspaceConnectionStatus> copyFromBuilder(
            Collection<? extends WorkspaceConnectionStatus.Builder> workspaceConnectionStatusListParam) {
        List<WorkspaceConnectionStatus> list;
        if (workspaceConnectionStatusListParam == null || workspaceConnectionStatusListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<WorkspaceConnectionStatus> modifiableList = new ArrayList<>(workspaceConnectionStatusListParam.size());
            workspaceConnectionStatusListParam.forEach(entry -> {
                WorkspaceConnectionStatus member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<WorkspaceConnectionStatus.Builder> copyToBuilder(
            Collection<? extends WorkspaceConnectionStatus> workspaceConnectionStatusListParam) {
        List<WorkspaceConnectionStatus.Builder> list;
        if (workspaceConnectionStatusListParam == null || workspaceConnectionStatusListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<WorkspaceConnectionStatus.Builder> modifiableList = new ArrayList<>(workspaceConnectionStatusListParam.size());
            workspaceConnectionStatusListParam.forEach(entry -> {
                WorkspaceConnectionStatus.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
