/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The device types and operating systems that can be used to access a WorkSpace. For more information, see <a
 * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-network-requirements.html">Amazon
 * WorkSpaces Client Network Requirements</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkspaceAccessProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkspaceAccessProperties.Builder, WorkspaceAccessProperties> {
    private static final SdkField<String> DEVICE_TYPE_WINDOWS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceTypeWindows").getter(getter(WorkspaceAccessProperties::deviceTypeWindowsAsString))
            .setter(setter(Builder::deviceTypeWindows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypeWindows").build()).build();

    private static final SdkField<String> DEVICE_TYPE_OSX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceTypeOsx").getter(getter(WorkspaceAccessProperties::deviceTypeOsxAsString))
            .setter(setter(Builder::deviceTypeOsx))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypeOsx").build()).build();

    private static final SdkField<String> DEVICE_TYPE_WEB_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceTypeWeb").getter(getter(WorkspaceAccessProperties::deviceTypeWebAsString))
            .setter(setter(Builder::deviceTypeWeb))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypeWeb").build()).build();

    private static final SdkField<String> DEVICE_TYPE_IOS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceTypeIos").getter(getter(WorkspaceAccessProperties::deviceTypeIosAsString))
            .setter(setter(Builder::deviceTypeIos))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypeIos").build()).build();

    private static final SdkField<String> DEVICE_TYPE_ANDROID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceTypeAndroid").getter(getter(WorkspaceAccessProperties::deviceTypeAndroidAsString))
            .setter(setter(Builder::deviceTypeAndroid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypeAndroid").build()).build();

    private static final SdkField<String> DEVICE_TYPE_CHROME_OS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceTypeChromeOs").getter(getter(WorkspaceAccessProperties::deviceTypeChromeOsAsString))
            .setter(setter(Builder::deviceTypeChromeOs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypeChromeOs").build())
            .build();

    private static final SdkField<String> DEVICE_TYPE_ZERO_CLIENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceTypeZeroClient").getter(getter(WorkspaceAccessProperties::deviceTypeZeroClientAsString))
            .setter(setter(Builder::deviceTypeZeroClient))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypeZeroClient").build())
            .build();

    private static final SdkField<String> DEVICE_TYPE_LINUX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceTypeLinux").getter(getter(WorkspaceAccessProperties::deviceTypeLinuxAsString))
            .setter(setter(Builder::deviceTypeLinux))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypeLinux").build()).build();

    private static final SdkField<String> DEVICE_TYPE_WORK_SPACES_THIN_CLIENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DeviceTypeWorkSpacesThinClient")
            .getter(getter(WorkspaceAccessProperties::deviceTypeWorkSpacesThinClientAsString))
            .setter(setter(Builder::deviceTypeWorkSpacesThinClient))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceTypeWorkSpacesThinClient")
                    .build()).build();

    private static final SdkField<AccessEndpointConfig> ACCESS_ENDPOINT_CONFIG_FIELD = SdkField
            .<AccessEndpointConfig> builder(MarshallingType.SDK_POJO).memberName("AccessEndpointConfig")
            .getter(getter(WorkspaceAccessProperties::accessEndpointConfig)).setter(setter(Builder::accessEndpointConfig))
            .constructor(AccessEndpointConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessEndpointConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_TYPE_WINDOWS_FIELD,
            DEVICE_TYPE_OSX_FIELD, DEVICE_TYPE_WEB_FIELD, DEVICE_TYPE_IOS_FIELD, DEVICE_TYPE_ANDROID_FIELD,
            DEVICE_TYPE_CHROME_OS_FIELD, DEVICE_TYPE_ZERO_CLIENT_FIELD, DEVICE_TYPE_LINUX_FIELD,
            DEVICE_TYPE_WORK_SPACES_THIN_CLIENT_FIELD, ACCESS_ENDPOINT_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String deviceTypeWindows;

    private final String deviceTypeOsx;

    private final String deviceTypeWeb;

    private final String deviceTypeIos;

    private final String deviceTypeAndroid;

    private final String deviceTypeChromeOs;

    private final String deviceTypeZeroClient;

    private final String deviceTypeLinux;

    private final String deviceTypeWorkSpacesThinClient;

    private final AccessEndpointConfig accessEndpointConfig;

    private WorkspaceAccessProperties(BuilderImpl builder) {
        this.deviceTypeWindows = builder.deviceTypeWindows;
        this.deviceTypeOsx = builder.deviceTypeOsx;
        this.deviceTypeWeb = builder.deviceTypeWeb;
        this.deviceTypeIos = builder.deviceTypeIos;
        this.deviceTypeAndroid = builder.deviceTypeAndroid;
        this.deviceTypeChromeOs = builder.deviceTypeChromeOs;
        this.deviceTypeZeroClient = builder.deviceTypeZeroClient;
        this.deviceTypeLinux = builder.deviceTypeLinux;
        this.deviceTypeWorkSpacesThinClient = builder.deviceTypeWorkSpacesThinClient;
        this.accessEndpointConfig = builder.accessEndpointConfig;
    }

    /**
     * <p>
     * Indicates whether users can use Windows clients to access their WorkSpaces.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceTypeWindows}
     * will return {@link AccessPropertyValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deviceTypeWindowsAsString}.
     * </p>
     * 
     * @return Indicates whether users can use Windows clients to access their WorkSpaces.
     * @see AccessPropertyValue
     */
    public final AccessPropertyValue deviceTypeWindows() {
        return AccessPropertyValue.fromValue(deviceTypeWindows);
    }

    /**
     * <p>
     * Indicates whether users can use Windows clients to access their WorkSpaces.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceTypeWindows}
     * will return {@link AccessPropertyValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deviceTypeWindowsAsString}.
     * </p>
     * 
     * @return Indicates whether users can use Windows clients to access their WorkSpaces.
     * @see AccessPropertyValue
     */
    public final String deviceTypeWindowsAsString() {
        return deviceTypeWindows;
    }

    /**
     * <p>
     * Indicates whether users can use macOS clients to access their WorkSpaces.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceTypeOsx}
     * will return {@link AccessPropertyValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deviceTypeOsxAsString}.
     * </p>
     * 
     * @return Indicates whether users can use macOS clients to access their WorkSpaces.
     * @see AccessPropertyValue
     */
    public final AccessPropertyValue deviceTypeOsx() {
        return AccessPropertyValue.fromValue(deviceTypeOsx);
    }

    /**
     * <p>
     * Indicates whether users can use macOS clients to access their WorkSpaces.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceTypeOsx}
     * will return {@link AccessPropertyValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deviceTypeOsxAsString}.
     * </p>
     * 
     * @return Indicates whether users can use macOS clients to access their WorkSpaces.
     * @see AccessPropertyValue
     */
    public final String deviceTypeOsxAsString() {
        return deviceTypeOsx;
    }

    /**
     * <p>
     * Indicates whether users can access their WorkSpaces through a web browser.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceTypeWeb}
     * will return {@link AccessPropertyValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deviceTypeWebAsString}.
     * </p>
     * 
     * @return Indicates whether users can access their WorkSpaces through a web browser.
     * @see AccessPropertyValue
     */
    public final AccessPropertyValue deviceTypeWeb() {
        return AccessPropertyValue.fromValue(deviceTypeWeb);
    }

    /**
     * <p>
     * Indicates whether users can access their WorkSpaces through a web browser.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceTypeWeb}
     * will return {@link AccessPropertyValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deviceTypeWebAsString}.
     * </p>
     * 
     * @return Indicates whether users can access their WorkSpaces through a web browser.
     * @see AccessPropertyValue
     */
    public final String deviceTypeWebAsString() {
        return deviceTypeWeb;
    }

    /**
     * <p>
     * Indicates whether users can use iOS devices to access their WorkSpaces.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceTypeIos}
     * will return {@link AccessPropertyValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deviceTypeIosAsString}.
     * </p>
     * 
     * @return Indicates whether users can use iOS devices to access their WorkSpaces.
     * @see AccessPropertyValue
     */
    public final AccessPropertyValue deviceTypeIos() {
        return AccessPropertyValue.fromValue(deviceTypeIos);
    }

    /**
     * <p>
     * Indicates whether users can use iOS devices to access their WorkSpaces.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceTypeIos}
     * will return {@link AccessPropertyValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deviceTypeIosAsString}.
     * </p>
     * 
     * @return Indicates whether users can use iOS devices to access their WorkSpaces.
     * @see AccessPropertyValue
     */
    public final String deviceTypeIosAsString() {
        return deviceTypeIos;
    }

    /**
     * <p>
     * Indicates whether users can use Android and Android-compatible Chrome OS devices to access their WorkSpaces.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceTypeAndroid}
     * will return {@link AccessPropertyValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deviceTypeAndroidAsString}.
     * </p>
     * 
     * @return Indicates whether users can use Android and Android-compatible Chrome OS devices to access their
     *         WorkSpaces.
     * @see AccessPropertyValue
     */
    public final AccessPropertyValue deviceTypeAndroid() {
        return AccessPropertyValue.fromValue(deviceTypeAndroid);
    }

    /**
     * <p>
     * Indicates whether users can use Android and Android-compatible Chrome OS devices to access their WorkSpaces.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceTypeAndroid}
     * will return {@link AccessPropertyValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deviceTypeAndroidAsString}.
     * </p>
     * 
     * @return Indicates whether users can use Android and Android-compatible Chrome OS devices to access their
     *         WorkSpaces.
     * @see AccessPropertyValue
     */
    public final String deviceTypeAndroidAsString() {
        return deviceTypeAndroid;
    }

    /**
     * <p>
     * Indicates whether users can use Chromebooks to access their WorkSpaces.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceTypeChromeOs} will return {@link AccessPropertyValue#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #deviceTypeChromeOsAsString}.
     * </p>
     * 
     * @return Indicates whether users can use Chromebooks to access their WorkSpaces.
     * @see AccessPropertyValue
     */
    public final AccessPropertyValue deviceTypeChromeOs() {
        return AccessPropertyValue.fromValue(deviceTypeChromeOs);
    }

    /**
     * <p>
     * Indicates whether users can use Chromebooks to access their WorkSpaces.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceTypeChromeOs} will return {@link AccessPropertyValue#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #deviceTypeChromeOsAsString}.
     * </p>
     * 
     * @return Indicates whether users can use Chromebooks to access their WorkSpaces.
     * @see AccessPropertyValue
     */
    public final String deviceTypeChromeOsAsString() {
        return deviceTypeChromeOs;
    }

    /**
     * <p>
     * Indicates whether users can use zero client devices to access their WorkSpaces.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceTypeZeroClient} will return {@link AccessPropertyValue#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #deviceTypeZeroClientAsString}.
     * </p>
     * 
     * @return Indicates whether users can use zero client devices to access their WorkSpaces.
     * @see AccessPropertyValue
     */
    public final AccessPropertyValue deviceTypeZeroClient() {
        return AccessPropertyValue.fromValue(deviceTypeZeroClient);
    }

    /**
     * <p>
     * Indicates whether users can use zero client devices to access their WorkSpaces.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceTypeZeroClient} will return {@link AccessPropertyValue#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #deviceTypeZeroClientAsString}.
     * </p>
     * 
     * @return Indicates whether users can use zero client devices to access their WorkSpaces.
     * @see AccessPropertyValue
     */
    public final String deviceTypeZeroClientAsString() {
        return deviceTypeZeroClient;
    }

    /**
     * <p>
     * Indicates whether users can use Linux clients to access their WorkSpaces.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceTypeLinux}
     * will return {@link AccessPropertyValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deviceTypeLinuxAsString}.
     * </p>
     * 
     * @return Indicates whether users can use Linux clients to access their WorkSpaces.
     * @see AccessPropertyValue
     */
    public final AccessPropertyValue deviceTypeLinux() {
        return AccessPropertyValue.fromValue(deviceTypeLinux);
    }

    /**
     * <p>
     * Indicates whether users can use Linux clients to access their WorkSpaces.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deviceTypeLinux}
     * will return {@link AccessPropertyValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #deviceTypeLinuxAsString}.
     * </p>
     * 
     * @return Indicates whether users can use Linux clients to access their WorkSpaces.
     * @see AccessPropertyValue
     */
    public final String deviceTypeLinuxAsString() {
        return deviceTypeLinux;
    }

    /**
     * <p>
     * Indicates whether users can access their WorkSpaces through a WorkSpaces Thin Client.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceTypeWorkSpacesThinClient} will return {@link AccessPropertyValue#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deviceTypeWorkSpacesThinClientAsString}.
     * </p>
     * 
     * @return Indicates whether users can access their WorkSpaces through a WorkSpaces Thin Client.
     * @see AccessPropertyValue
     */
    public final AccessPropertyValue deviceTypeWorkSpacesThinClient() {
        return AccessPropertyValue.fromValue(deviceTypeWorkSpacesThinClient);
    }

    /**
     * <p>
     * Indicates whether users can access their WorkSpaces through a WorkSpaces Thin Client.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceTypeWorkSpacesThinClient} will return {@link AccessPropertyValue#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #deviceTypeWorkSpacesThinClientAsString}.
     * </p>
     * 
     * @return Indicates whether users can access their WorkSpaces through a WorkSpaces Thin Client.
     * @see AccessPropertyValue
     */
    public final String deviceTypeWorkSpacesThinClientAsString() {
        return deviceTypeWorkSpacesThinClient;
    }

    /**
     * <p>
     * Specifies the configuration for accessing the WorkSpace.
     * </p>
     * 
     * @return Specifies the configuration for accessing the WorkSpace.
     */
    public final AccessEndpointConfig accessEndpointConfig() {
        return accessEndpointConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceTypeWindowsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceTypeOsxAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceTypeWebAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceTypeIosAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceTypeAndroidAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceTypeChromeOsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceTypeZeroClientAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceTypeLinuxAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceTypeWorkSpacesThinClientAsString());
        hashCode = 31 * hashCode + Objects.hashCode(accessEndpointConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkspaceAccessProperties)) {
            return false;
        }
        WorkspaceAccessProperties other = (WorkspaceAccessProperties) obj;
        return Objects.equals(deviceTypeWindowsAsString(), other.deviceTypeWindowsAsString())
                && Objects.equals(deviceTypeOsxAsString(), other.deviceTypeOsxAsString())
                && Objects.equals(deviceTypeWebAsString(), other.deviceTypeWebAsString())
                && Objects.equals(deviceTypeIosAsString(), other.deviceTypeIosAsString())
                && Objects.equals(deviceTypeAndroidAsString(), other.deviceTypeAndroidAsString())
                && Objects.equals(deviceTypeChromeOsAsString(), other.deviceTypeChromeOsAsString())
                && Objects.equals(deviceTypeZeroClientAsString(), other.deviceTypeZeroClientAsString())
                && Objects.equals(deviceTypeLinuxAsString(), other.deviceTypeLinuxAsString())
                && Objects.equals(deviceTypeWorkSpacesThinClientAsString(), other.deviceTypeWorkSpacesThinClientAsString())
                && Objects.equals(accessEndpointConfig(), other.accessEndpointConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkspaceAccessProperties").add("DeviceTypeWindows", deviceTypeWindowsAsString())
                .add("DeviceTypeOsx", deviceTypeOsxAsString()).add("DeviceTypeWeb", deviceTypeWebAsString())
                .add("DeviceTypeIos", deviceTypeIosAsString()).add("DeviceTypeAndroid", deviceTypeAndroidAsString())
                .add("DeviceTypeChromeOs", deviceTypeChromeOsAsString())
                .add("DeviceTypeZeroClient", deviceTypeZeroClientAsString()).add("DeviceTypeLinux", deviceTypeLinuxAsString())
                .add("DeviceTypeWorkSpacesThinClient", deviceTypeWorkSpacesThinClientAsString())
                .add("AccessEndpointConfig", accessEndpointConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceTypeWindows":
            return Optional.ofNullable(clazz.cast(deviceTypeWindowsAsString()));
        case "DeviceTypeOsx":
            return Optional.ofNullable(clazz.cast(deviceTypeOsxAsString()));
        case "DeviceTypeWeb":
            return Optional.ofNullable(clazz.cast(deviceTypeWebAsString()));
        case "DeviceTypeIos":
            return Optional.ofNullable(clazz.cast(deviceTypeIosAsString()));
        case "DeviceTypeAndroid":
            return Optional.ofNullable(clazz.cast(deviceTypeAndroidAsString()));
        case "DeviceTypeChromeOs":
            return Optional.ofNullable(clazz.cast(deviceTypeChromeOsAsString()));
        case "DeviceTypeZeroClient":
            return Optional.ofNullable(clazz.cast(deviceTypeZeroClientAsString()));
        case "DeviceTypeLinux":
            return Optional.ofNullable(clazz.cast(deviceTypeLinuxAsString()));
        case "DeviceTypeWorkSpacesThinClient":
            return Optional.ofNullable(clazz.cast(deviceTypeWorkSpacesThinClientAsString()));
        case "AccessEndpointConfig":
            return Optional.ofNullable(clazz.cast(accessEndpointConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeviceTypeWindows", DEVICE_TYPE_WINDOWS_FIELD);
        map.put("DeviceTypeOsx", DEVICE_TYPE_OSX_FIELD);
        map.put("DeviceTypeWeb", DEVICE_TYPE_WEB_FIELD);
        map.put("DeviceTypeIos", DEVICE_TYPE_IOS_FIELD);
        map.put("DeviceTypeAndroid", DEVICE_TYPE_ANDROID_FIELD);
        map.put("DeviceTypeChromeOs", DEVICE_TYPE_CHROME_OS_FIELD);
        map.put("DeviceTypeZeroClient", DEVICE_TYPE_ZERO_CLIENT_FIELD);
        map.put("DeviceTypeLinux", DEVICE_TYPE_LINUX_FIELD);
        map.put("DeviceTypeWorkSpacesThinClient", DEVICE_TYPE_WORK_SPACES_THIN_CLIENT_FIELD);
        map.put("AccessEndpointConfig", ACCESS_ENDPOINT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkspaceAccessProperties, T> g) {
        return obj -> g.apply((WorkspaceAccessProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkspaceAccessProperties> {
        /**
         * <p>
         * Indicates whether users can use Windows clients to access their WorkSpaces.
         * </p>
         * 
         * @param deviceTypeWindows
         *        Indicates whether users can use Windows clients to access their WorkSpaces.
         * @see AccessPropertyValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessPropertyValue
         */
        Builder deviceTypeWindows(String deviceTypeWindows);

        /**
         * <p>
         * Indicates whether users can use Windows clients to access their WorkSpaces.
         * </p>
         * 
         * @param deviceTypeWindows
         *        Indicates whether users can use Windows clients to access their WorkSpaces.
         * @see AccessPropertyValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessPropertyValue
         */
        Builder deviceTypeWindows(AccessPropertyValue deviceTypeWindows);

        /**
         * <p>
         * Indicates whether users can use macOS clients to access their WorkSpaces.
         * </p>
         * 
         * @param deviceTypeOsx
         *        Indicates whether users can use macOS clients to access their WorkSpaces.
         * @see AccessPropertyValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessPropertyValue
         */
        Builder deviceTypeOsx(String deviceTypeOsx);

        /**
         * <p>
         * Indicates whether users can use macOS clients to access their WorkSpaces.
         * </p>
         * 
         * @param deviceTypeOsx
         *        Indicates whether users can use macOS clients to access their WorkSpaces.
         * @see AccessPropertyValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessPropertyValue
         */
        Builder deviceTypeOsx(AccessPropertyValue deviceTypeOsx);

        /**
         * <p>
         * Indicates whether users can access their WorkSpaces through a web browser.
         * </p>
         * 
         * @param deviceTypeWeb
         *        Indicates whether users can access their WorkSpaces through a web browser.
         * @see AccessPropertyValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessPropertyValue
         */
        Builder deviceTypeWeb(String deviceTypeWeb);

        /**
         * <p>
         * Indicates whether users can access their WorkSpaces through a web browser.
         * </p>
         * 
         * @param deviceTypeWeb
         *        Indicates whether users can access their WorkSpaces through a web browser.
         * @see AccessPropertyValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessPropertyValue
         */
        Builder deviceTypeWeb(AccessPropertyValue deviceTypeWeb);

        /**
         * <p>
         * Indicates whether users can use iOS devices to access their WorkSpaces.
         * </p>
         * 
         * @param deviceTypeIos
         *        Indicates whether users can use iOS devices to access their WorkSpaces.
         * @see AccessPropertyValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessPropertyValue
         */
        Builder deviceTypeIos(String deviceTypeIos);

        /**
         * <p>
         * Indicates whether users can use iOS devices to access their WorkSpaces.
         * </p>
         * 
         * @param deviceTypeIos
         *        Indicates whether users can use iOS devices to access their WorkSpaces.
         * @see AccessPropertyValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessPropertyValue
         */
        Builder deviceTypeIos(AccessPropertyValue deviceTypeIos);

        /**
         * <p>
         * Indicates whether users can use Android and Android-compatible Chrome OS devices to access their WorkSpaces.
         * </p>
         * 
         * @param deviceTypeAndroid
         *        Indicates whether users can use Android and Android-compatible Chrome OS devices to access their
         *        WorkSpaces.
         * @see AccessPropertyValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessPropertyValue
         */
        Builder deviceTypeAndroid(String deviceTypeAndroid);

        /**
         * <p>
         * Indicates whether users can use Android and Android-compatible Chrome OS devices to access their WorkSpaces.
         * </p>
         * 
         * @param deviceTypeAndroid
         *        Indicates whether users can use Android and Android-compatible Chrome OS devices to access their
         *        WorkSpaces.
         * @see AccessPropertyValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessPropertyValue
         */
        Builder deviceTypeAndroid(AccessPropertyValue deviceTypeAndroid);

        /**
         * <p>
         * Indicates whether users can use Chromebooks to access their WorkSpaces.
         * </p>
         * 
         * @param deviceTypeChromeOs
         *        Indicates whether users can use Chromebooks to access their WorkSpaces.
         * @see AccessPropertyValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessPropertyValue
         */
        Builder deviceTypeChromeOs(String deviceTypeChromeOs);

        /**
         * <p>
         * Indicates whether users can use Chromebooks to access their WorkSpaces.
         * </p>
         * 
         * @param deviceTypeChromeOs
         *        Indicates whether users can use Chromebooks to access their WorkSpaces.
         * @see AccessPropertyValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessPropertyValue
         */
        Builder deviceTypeChromeOs(AccessPropertyValue deviceTypeChromeOs);

        /**
         * <p>
         * Indicates whether users can use zero client devices to access their WorkSpaces.
         * </p>
         * 
         * @param deviceTypeZeroClient
         *        Indicates whether users can use zero client devices to access their WorkSpaces.
         * @see AccessPropertyValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessPropertyValue
         */
        Builder deviceTypeZeroClient(String deviceTypeZeroClient);

        /**
         * <p>
         * Indicates whether users can use zero client devices to access their WorkSpaces.
         * </p>
         * 
         * @param deviceTypeZeroClient
         *        Indicates whether users can use zero client devices to access their WorkSpaces.
         * @see AccessPropertyValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessPropertyValue
         */
        Builder deviceTypeZeroClient(AccessPropertyValue deviceTypeZeroClient);

        /**
         * <p>
         * Indicates whether users can use Linux clients to access their WorkSpaces.
         * </p>
         * 
         * @param deviceTypeLinux
         *        Indicates whether users can use Linux clients to access their WorkSpaces.
         * @see AccessPropertyValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessPropertyValue
         */
        Builder deviceTypeLinux(String deviceTypeLinux);

        /**
         * <p>
         * Indicates whether users can use Linux clients to access their WorkSpaces.
         * </p>
         * 
         * @param deviceTypeLinux
         *        Indicates whether users can use Linux clients to access their WorkSpaces.
         * @see AccessPropertyValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessPropertyValue
         */
        Builder deviceTypeLinux(AccessPropertyValue deviceTypeLinux);

        /**
         * <p>
         * Indicates whether users can access their WorkSpaces through a WorkSpaces Thin Client.
         * </p>
         * 
         * @param deviceTypeWorkSpacesThinClient
         *        Indicates whether users can access their WorkSpaces through a WorkSpaces Thin Client.
         * @see AccessPropertyValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessPropertyValue
         */
        Builder deviceTypeWorkSpacesThinClient(String deviceTypeWorkSpacesThinClient);

        /**
         * <p>
         * Indicates whether users can access their WorkSpaces through a WorkSpaces Thin Client.
         * </p>
         * 
         * @param deviceTypeWorkSpacesThinClient
         *        Indicates whether users can access their WorkSpaces through a WorkSpaces Thin Client.
         * @see AccessPropertyValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessPropertyValue
         */
        Builder deviceTypeWorkSpacesThinClient(AccessPropertyValue deviceTypeWorkSpacesThinClient);

        /**
         * <p>
         * Specifies the configuration for accessing the WorkSpace.
         * </p>
         * 
         * @param accessEndpointConfig
         *        Specifies the configuration for accessing the WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessEndpointConfig(AccessEndpointConfig accessEndpointConfig);

        /**
         * <p>
         * Specifies the configuration for accessing the WorkSpace.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccessEndpointConfig.Builder} avoiding
         * the need to create one manually via {@link AccessEndpointConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccessEndpointConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #accessEndpointConfig(AccessEndpointConfig)}.
         * 
         * @param accessEndpointConfig
         *        a consumer that will call methods on {@link AccessEndpointConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessEndpointConfig(AccessEndpointConfig)
         */
        default Builder accessEndpointConfig(Consumer<AccessEndpointConfig.Builder> accessEndpointConfig) {
            return accessEndpointConfig(AccessEndpointConfig.builder().applyMutation(accessEndpointConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String deviceTypeWindows;

        private String deviceTypeOsx;

        private String deviceTypeWeb;

        private String deviceTypeIos;

        private String deviceTypeAndroid;

        private String deviceTypeChromeOs;

        private String deviceTypeZeroClient;

        private String deviceTypeLinux;

        private String deviceTypeWorkSpacesThinClient;

        private AccessEndpointConfig accessEndpointConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkspaceAccessProperties model) {
            deviceTypeWindows(model.deviceTypeWindows);
            deviceTypeOsx(model.deviceTypeOsx);
            deviceTypeWeb(model.deviceTypeWeb);
            deviceTypeIos(model.deviceTypeIos);
            deviceTypeAndroid(model.deviceTypeAndroid);
            deviceTypeChromeOs(model.deviceTypeChromeOs);
            deviceTypeZeroClient(model.deviceTypeZeroClient);
            deviceTypeLinux(model.deviceTypeLinux);
            deviceTypeWorkSpacesThinClient(model.deviceTypeWorkSpacesThinClient);
            accessEndpointConfig(model.accessEndpointConfig);
        }

        public final String getDeviceTypeWindows() {
            return deviceTypeWindows;
        }

        public final void setDeviceTypeWindows(String deviceTypeWindows) {
            this.deviceTypeWindows = deviceTypeWindows;
        }

        @Override
        public final Builder deviceTypeWindows(String deviceTypeWindows) {
            this.deviceTypeWindows = deviceTypeWindows;
            return this;
        }

        @Override
        public final Builder deviceTypeWindows(AccessPropertyValue deviceTypeWindows) {
            this.deviceTypeWindows(deviceTypeWindows == null ? null : deviceTypeWindows.toString());
            return this;
        }

        public final String getDeviceTypeOsx() {
            return deviceTypeOsx;
        }

        public final void setDeviceTypeOsx(String deviceTypeOsx) {
            this.deviceTypeOsx = deviceTypeOsx;
        }

        @Override
        public final Builder deviceTypeOsx(String deviceTypeOsx) {
            this.deviceTypeOsx = deviceTypeOsx;
            return this;
        }

        @Override
        public final Builder deviceTypeOsx(AccessPropertyValue deviceTypeOsx) {
            this.deviceTypeOsx(deviceTypeOsx == null ? null : deviceTypeOsx.toString());
            return this;
        }

        public final String getDeviceTypeWeb() {
            return deviceTypeWeb;
        }

        public final void setDeviceTypeWeb(String deviceTypeWeb) {
            this.deviceTypeWeb = deviceTypeWeb;
        }

        @Override
        public final Builder deviceTypeWeb(String deviceTypeWeb) {
            this.deviceTypeWeb = deviceTypeWeb;
            return this;
        }

        @Override
        public final Builder deviceTypeWeb(AccessPropertyValue deviceTypeWeb) {
            this.deviceTypeWeb(deviceTypeWeb == null ? null : deviceTypeWeb.toString());
            return this;
        }

        public final String getDeviceTypeIos() {
            return deviceTypeIos;
        }

        public final void setDeviceTypeIos(String deviceTypeIos) {
            this.deviceTypeIos = deviceTypeIos;
        }

        @Override
        public final Builder deviceTypeIos(String deviceTypeIos) {
            this.deviceTypeIos = deviceTypeIos;
            return this;
        }

        @Override
        public final Builder deviceTypeIos(AccessPropertyValue deviceTypeIos) {
            this.deviceTypeIos(deviceTypeIos == null ? null : deviceTypeIos.toString());
            return this;
        }

        public final String getDeviceTypeAndroid() {
            return deviceTypeAndroid;
        }

        public final void setDeviceTypeAndroid(String deviceTypeAndroid) {
            this.deviceTypeAndroid = deviceTypeAndroid;
        }

        @Override
        public final Builder deviceTypeAndroid(String deviceTypeAndroid) {
            this.deviceTypeAndroid = deviceTypeAndroid;
            return this;
        }

        @Override
        public final Builder deviceTypeAndroid(AccessPropertyValue deviceTypeAndroid) {
            this.deviceTypeAndroid(deviceTypeAndroid == null ? null : deviceTypeAndroid.toString());
            return this;
        }

        public final String getDeviceTypeChromeOs() {
            return deviceTypeChromeOs;
        }

        public final void setDeviceTypeChromeOs(String deviceTypeChromeOs) {
            this.deviceTypeChromeOs = deviceTypeChromeOs;
        }

        @Override
        public final Builder deviceTypeChromeOs(String deviceTypeChromeOs) {
            this.deviceTypeChromeOs = deviceTypeChromeOs;
            return this;
        }

        @Override
        public final Builder deviceTypeChromeOs(AccessPropertyValue deviceTypeChromeOs) {
            this.deviceTypeChromeOs(deviceTypeChromeOs == null ? null : deviceTypeChromeOs.toString());
            return this;
        }

        public final String getDeviceTypeZeroClient() {
            return deviceTypeZeroClient;
        }

        public final void setDeviceTypeZeroClient(String deviceTypeZeroClient) {
            this.deviceTypeZeroClient = deviceTypeZeroClient;
        }

        @Override
        public final Builder deviceTypeZeroClient(String deviceTypeZeroClient) {
            this.deviceTypeZeroClient = deviceTypeZeroClient;
            return this;
        }

        @Override
        public final Builder deviceTypeZeroClient(AccessPropertyValue deviceTypeZeroClient) {
            this.deviceTypeZeroClient(deviceTypeZeroClient == null ? null : deviceTypeZeroClient.toString());
            return this;
        }

        public final String getDeviceTypeLinux() {
            return deviceTypeLinux;
        }

        public final void setDeviceTypeLinux(String deviceTypeLinux) {
            this.deviceTypeLinux = deviceTypeLinux;
        }

        @Override
        public final Builder deviceTypeLinux(String deviceTypeLinux) {
            this.deviceTypeLinux = deviceTypeLinux;
            return this;
        }

        @Override
        public final Builder deviceTypeLinux(AccessPropertyValue deviceTypeLinux) {
            this.deviceTypeLinux(deviceTypeLinux == null ? null : deviceTypeLinux.toString());
            return this;
        }

        public final String getDeviceTypeWorkSpacesThinClient() {
            return deviceTypeWorkSpacesThinClient;
        }

        public final void setDeviceTypeWorkSpacesThinClient(String deviceTypeWorkSpacesThinClient) {
            this.deviceTypeWorkSpacesThinClient = deviceTypeWorkSpacesThinClient;
        }

        @Override
        public final Builder deviceTypeWorkSpacesThinClient(String deviceTypeWorkSpacesThinClient) {
            this.deviceTypeWorkSpacesThinClient = deviceTypeWorkSpacesThinClient;
            return this;
        }

        @Override
        public final Builder deviceTypeWorkSpacesThinClient(AccessPropertyValue deviceTypeWorkSpacesThinClient) {
            this.deviceTypeWorkSpacesThinClient(deviceTypeWorkSpacesThinClient == null ? null : deviceTypeWorkSpacesThinClient
                    .toString());
            return this;
        }

        public final AccessEndpointConfig.Builder getAccessEndpointConfig() {
            return accessEndpointConfig != null ? accessEndpointConfig.toBuilder() : null;
        }

        public final void setAccessEndpointConfig(AccessEndpointConfig.BuilderImpl accessEndpointConfig) {
            this.accessEndpointConfig = accessEndpointConfig != null ? accessEndpointConfig.build() : null;
        }

        @Override
        public final Builder accessEndpointConfig(AccessEndpointConfig accessEndpointConfig) {
            this.accessEndpointConfig = accessEndpointConfig;
            return this;
        }

        @Override
        public WorkspaceAccessProperties build() {
            return new WorkspaceAccessProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
