/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the timeout settings for a pool of WorkSpaces.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeoutSettings implements SdkPojo, Serializable, ToCopyableBuilder<TimeoutSettings.Builder, TimeoutSettings> {
    private static final SdkField<Integer> DISCONNECT_TIMEOUT_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DisconnectTimeoutInSeconds")
            .getter(getter(TimeoutSettings::disconnectTimeoutInSeconds))
            .setter(setter(Builder::disconnectTimeoutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisconnectTimeoutInSeconds").build())
            .build();

    private static final SdkField<Integer> IDLE_DISCONNECT_TIMEOUT_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("IdleDisconnectTimeoutInSeconds")
            .getter(getter(TimeoutSettings::idleDisconnectTimeoutInSeconds))
            .setter(setter(Builder::idleDisconnectTimeoutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdleDisconnectTimeoutInSeconds")
                    .build()).build();

    private static final SdkField<Integer> MAX_USER_DURATION_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("MaxUserDurationInSeconds")
            .getter(getter(TimeoutSettings::maxUserDurationInSeconds)).setter(setter(Builder::maxUserDurationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxUserDurationInSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DISCONNECT_TIMEOUT_IN_SECONDS_FIELD, IDLE_DISCONNECT_TIMEOUT_IN_SECONDS_FIELD, MAX_USER_DURATION_IN_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer disconnectTimeoutInSeconds;

    private final Integer idleDisconnectTimeoutInSeconds;

    private final Integer maxUserDurationInSeconds;

    private TimeoutSettings(BuilderImpl builder) {
        this.disconnectTimeoutInSeconds = builder.disconnectTimeoutInSeconds;
        this.idleDisconnectTimeoutInSeconds = builder.idleDisconnectTimeoutInSeconds;
        this.maxUserDurationInSeconds = builder.maxUserDurationInSeconds;
    }

    /**
     * <p>
     * Specifies the amount of time, in seconds, that a streaming session remains active after users disconnect. If
     * users try to reconnect to the streaming session after a disconnection or network interruption within the time
     * set, they are connected to their previous session. Otherwise, they are connected to a new session with a new
     * streaming instance.
     * </p>
     * 
     * @return Specifies the amount of time, in seconds, that a streaming session remains active after users disconnect.
     *         If users try to reconnect to the streaming session after a disconnection or network interruption within
     *         the time set, they are connected to their previous session. Otherwise, they are connected to a new
     *         session with a new streaming instance.
     */
    public final Integer disconnectTimeoutInSeconds() {
        return disconnectTimeoutInSeconds;
    }

    /**
     * <p>
     * The amount of time in seconds a connection will stay active while idle.
     * </p>
     * 
     * @return The amount of time in seconds a connection will stay active while idle.
     */
    public final Integer idleDisconnectTimeoutInSeconds() {
        return idleDisconnectTimeoutInSeconds;
    }

    /**
     * <p>
     * Specifies the maximum amount of time, in seconds, that a streaming session can remain active. If users are still
     * connected to a streaming instance five minutes before this limit is reached, they are prompted to save any open
     * documents before being disconnected. After this time elapses, the instance is terminated and replaced by a new
     * instance.
     * </p>
     * 
     * @return Specifies the maximum amount of time, in seconds, that a streaming session can remain active. If users
     *         are still connected to a streaming instance five minutes before this limit is reached, they are prompted
     *         to save any open documents before being disconnected. After this time elapses, the instance is terminated
     *         and replaced by a new instance.
     */
    public final Integer maxUserDurationInSeconds() {
        return maxUserDurationInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(disconnectTimeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(idleDisconnectTimeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(maxUserDurationInSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeoutSettings)) {
            return false;
        }
        TimeoutSettings other = (TimeoutSettings) obj;
        return Objects.equals(disconnectTimeoutInSeconds(), other.disconnectTimeoutInSeconds())
                && Objects.equals(idleDisconnectTimeoutInSeconds(), other.idleDisconnectTimeoutInSeconds())
                && Objects.equals(maxUserDurationInSeconds(), other.maxUserDurationInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeoutSettings").add("DisconnectTimeoutInSeconds", disconnectTimeoutInSeconds())
                .add("IdleDisconnectTimeoutInSeconds", idleDisconnectTimeoutInSeconds())
                .add("MaxUserDurationInSeconds", maxUserDurationInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DisconnectTimeoutInSeconds":
            return Optional.ofNullable(clazz.cast(disconnectTimeoutInSeconds()));
        case "IdleDisconnectTimeoutInSeconds":
            return Optional.ofNullable(clazz.cast(idleDisconnectTimeoutInSeconds()));
        case "MaxUserDurationInSeconds":
            return Optional.ofNullable(clazz.cast(maxUserDurationInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DisconnectTimeoutInSeconds", DISCONNECT_TIMEOUT_IN_SECONDS_FIELD);
        map.put("IdleDisconnectTimeoutInSeconds", IDLE_DISCONNECT_TIMEOUT_IN_SECONDS_FIELD);
        map.put("MaxUserDurationInSeconds", MAX_USER_DURATION_IN_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimeoutSettings, T> g) {
        return obj -> g.apply((TimeoutSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeoutSettings> {
        /**
         * <p>
         * Specifies the amount of time, in seconds, that a streaming session remains active after users disconnect. If
         * users try to reconnect to the streaming session after a disconnection or network interruption within the time
         * set, they are connected to their previous session. Otherwise, they are connected to a new session with a new
         * streaming instance.
         * </p>
         * 
         * @param disconnectTimeoutInSeconds
         *        Specifies the amount of time, in seconds, that a streaming session remains active after users
         *        disconnect. If users try to reconnect to the streaming session after a disconnection or network
         *        interruption within the time set, they are connected to their previous session. Otherwise, they are
         *        connected to a new session with a new streaming instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds);

        /**
         * <p>
         * The amount of time in seconds a connection will stay active while idle.
         * </p>
         * 
         * @param idleDisconnectTimeoutInSeconds
         *        The amount of time in seconds a connection will stay active while idle.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleDisconnectTimeoutInSeconds(Integer idleDisconnectTimeoutInSeconds);

        /**
         * <p>
         * Specifies the maximum amount of time, in seconds, that a streaming session can remain active. If users are
         * still connected to a streaming instance five minutes before this limit is reached, they are prompted to save
         * any open documents before being disconnected. After this time elapses, the instance is terminated and
         * replaced by a new instance.
         * </p>
         * 
         * @param maxUserDurationInSeconds
         *        Specifies the maximum amount of time, in seconds, that a streaming session can remain active. If users
         *        are still connected to a streaming instance five minutes before this limit is reached, they are
         *        prompted to save any open documents before being disconnected. After this time elapses, the instance
         *        is terminated and replaced by a new instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxUserDurationInSeconds(Integer maxUserDurationInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer disconnectTimeoutInSeconds;

        private Integer idleDisconnectTimeoutInSeconds;

        private Integer maxUserDurationInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeoutSettings model) {
            disconnectTimeoutInSeconds(model.disconnectTimeoutInSeconds);
            idleDisconnectTimeoutInSeconds(model.idleDisconnectTimeoutInSeconds);
            maxUserDurationInSeconds(model.maxUserDurationInSeconds);
        }

        public final Integer getDisconnectTimeoutInSeconds() {
            return disconnectTimeoutInSeconds;
        }

        public final void setDisconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds) {
            this.disconnectTimeoutInSeconds = disconnectTimeoutInSeconds;
        }

        @Override
        public final Builder disconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds) {
            this.disconnectTimeoutInSeconds = disconnectTimeoutInSeconds;
            return this;
        }

        public final Integer getIdleDisconnectTimeoutInSeconds() {
            return idleDisconnectTimeoutInSeconds;
        }

        public final void setIdleDisconnectTimeoutInSeconds(Integer idleDisconnectTimeoutInSeconds) {
            this.idleDisconnectTimeoutInSeconds = idleDisconnectTimeoutInSeconds;
        }

        @Override
        public final Builder idleDisconnectTimeoutInSeconds(Integer idleDisconnectTimeoutInSeconds) {
            this.idleDisconnectTimeoutInSeconds = idleDisconnectTimeoutInSeconds;
            return this;
        }

        public final Integer getMaxUserDurationInSeconds() {
            return maxUserDurationInSeconds;
        }

        public final void setMaxUserDurationInSeconds(Integer maxUserDurationInSeconds) {
            this.maxUserDurationInSeconds = maxUserDurationInSeconds;
        }

        @Override
        public final Builder maxUserDurationInSeconds(Integer maxUserDurationInSeconds) {
            this.maxUserDurationInSeconds = maxUserDurationInSeconds;
            return this;
        }

        @Override
        public TimeoutSettings build() {
            return new TimeoutSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
