/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterWorkspaceDirectoryResponse extends WorkSpacesResponse implements
        ToCopyableBuilder<RegisterWorkspaceDirectoryResponse.Builder, RegisterWorkspaceDirectoryResponse> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(RegisterWorkspaceDirectoryResponse::directoryId))
            .setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(RegisterWorkspaceDirectoryResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String directoryId;

    private final String state;

    private RegisterWorkspaceDirectoryResponse(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.state = builder.state;
    }

    /**
     * <p>
     * The identifier of the directory.
     * </p>
     * 
     * @return The identifier of the directory.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The registration status of the WorkSpace directory.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link WorkspaceDirectoryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The registration status of the WorkSpace directory.
     * @see WorkspaceDirectoryState
     */
    public final WorkspaceDirectoryState state() {
        return WorkspaceDirectoryState.fromValue(state);
    }

    /**
     * <p>
     * The registration status of the WorkSpace directory.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link WorkspaceDirectoryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The registration status of the WorkSpace directory.
     * @see WorkspaceDirectoryState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterWorkspaceDirectoryResponse)) {
            return false;
        }
        RegisterWorkspaceDirectoryResponse other = (RegisterWorkspaceDirectoryResponse) obj;
        return Objects.equals(directoryId(), other.directoryId()) && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterWorkspaceDirectoryResponse").add("DirectoryId", directoryId())
                .add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterWorkspaceDirectoryResponse, T> g) {
        return obj -> g.apply((RegisterWorkspaceDirectoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, RegisterWorkspaceDirectoryResponse> {
        /**
         * <p>
         * The identifier of the directory.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The registration status of the WorkSpace directory.
         * </p>
         * 
         * @param state
         *        The registration status of the WorkSpace directory.
         * @see WorkspaceDirectoryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkspaceDirectoryState
         */
        Builder state(String state);

        /**
         * <p>
         * The registration status of the WorkSpace directory.
         * </p>
         * 
         * @param state
         *        The registration status of the WorkSpace directory.
         * @see WorkspaceDirectoryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkspaceDirectoryState
         */
        Builder state(WorkspaceDirectoryState state);
    }

    static final class BuilderImpl extends WorkSpacesResponse.BuilderImpl implements Builder {
        private String directoryId;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterWorkspaceDirectoryResponse model) {
            super(model);
            directoryId(model.directoryId);
            state(model.state);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(WorkspaceDirectoryState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public RegisterWorkspaceDirectoryResponse build() {
            return new RegisterWorkspaceDirectoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
