/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccountLinksRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<ListAccountLinksRequest.Builder, ListAccountLinksRequest> {
    private static final SdkField<List<String>> LINK_STATUS_FILTER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LinkStatusFilter")
            .getter(getter(ListAccountLinksRequest::linkStatusFilterAsStrings))
            .setter(setter(Builder::linkStatusFilterWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkStatusFilter").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAccountLinksRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListAccountLinksRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINK_STATUS_FILTER_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> linkStatusFilter;

    private final String nextToken;

    private final Integer maxResults;

    private ListAccountLinksRequest(BuilderImpl builder) {
        super(builder);
        this.linkStatusFilter = builder.linkStatusFilter;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * Filters the account based on their link status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLinkStatusFilter} method.
     * </p>
     * 
     * @return Filters the account based on their link status.
     */
    public final List<AccountLinkStatusEnum> linkStatusFilter() {
        return LinkStatusFilterListCopier.copyStringToEnum(linkStatusFilter);
    }

    /**
     * For responses, this returns true if the service returned a value for the LinkStatusFilter property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLinkStatusFilter() {
        return linkStatusFilter != null && !(linkStatusFilter instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the account based on their link status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLinkStatusFilter} method.
     * </p>
     * 
     * @return Filters the account based on their link status.
     */
    public final List<String> linkStatusFilterAsStrings() {
        return linkStatusFilter;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is null when there are no more results to
     * return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is null when there are no more results
     *         to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of accounts to return.
     * </p>
     * 
     * @return The maximum number of accounts to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLinkStatusFilter() ? linkStatusFilterAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountLinksRequest)) {
            return false;
        }
        ListAccountLinksRequest other = (ListAccountLinksRequest) obj;
        return hasLinkStatusFilter() == other.hasLinkStatusFilter()
                && Objects.equals(linkStatusFilterAsStrings(), other.linkStatusFilterAsStrings())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAccountLinksRequest")
                .add("LinkStatusFilter", hasLinkStatusFilter() ? linkStatusFilterAsStrings() : null)
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LinkStatusFilter":
            return Optional.ofNullable(clazz.cast(linkStatusFilterAsStrings()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LinkStatusFilter", LINK_STATUS_FILTER_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAccountLinksRequest, T> g) {
        return obj -> g.apply((ListAccountLinksRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAccountLinksRequest> {
        /**
         * <p>
         * Filters the account based on their link status.
         * </p>
         * 
         * @param linkStatusFilter
         *        Filters the account based on their link status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkStatusFilterWithStrings(Collection<String> linkStatusFilter);

        /**
         * <p>
         * Filters the account based on their link status.
         * </p>
         * 
         * @param linkStatusFilter
         *        Filters the account based on their link status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkStatusFilterWithStrings(String... linkStatusFilter);

        /**
         * <p>
         * Filters the account based on their link status.
         * </p>
         * 
         * @param linkStatusFilter
         *        Filters the account based on their link status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkStatusFilter(Collection<AccountLinkStatusEnum> linkStatusFilter);

        /**
         * <p>
         * Filters the account based on their link status.
         * </p>
         * 
         * @param linkStatusFilter
         *        Filters the account based on their link status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder linkStatusFilter(AccountLinkStatusEnum... linkStatusFilter);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is null when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is null when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of accounts to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of accounts to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private List<String> linkStatusFilter = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccountLinksRequest model) {
            super(model);
            linkStatusFilterWithStrings(model.linkStatusFilter);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Collection<String> getLinkStatusFilter() {
            if (linkStatusFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return linkStatusFilter;
        }

        public final void setLinkStatusFilter(Collection<String> linkStatusFilter) {
            this.linkStatusFilter = LinkStatusFilterListCopier.copy(linkStatusFilter);
        }

        @Override
        public final Builder linkStatusFilterWithStrings(Collection<String> linkStatusFilter) {
            this.linkStatusFilter = LinkStatusFilterListCopier.copy(linkStatusFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkStatusFilterWithStrings(String... linkStatusFilter) {
            linkStatusFilterWithStrings(Arrays.asList(linkStatusFilter));
            return this;
        }

        @Override
        public final Builder linkStatusFilter(Collection<AccountLinkStatusEnum> linkStatusFilter) {
            this.linkStatusFilter = LinkStatusFilterListCopier.copyEnumToString(linkStatusFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder linkStatusFilter(AccountLinkStatusEnum... linkStatusFilter) {
            linkStatusFilter(Arrays.asList(linkStatusFilter));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAccountLinksRequest build() {
            return new ListAccountLinksRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
