/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeApplicationsRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<DescribeApplicationsRequest.Builder, DescribeApplicationsRequest> {
    private static final SdkField<List<String>> APPLICATION_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ApplicationIds")
            .getter(getter(DescribeApplicationsRequest::applicationIds))
            .setter(setter(Builder::applicationIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> COMPUTE_TYPE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ComputeTypeNames")
            .getter(getter(DescribeApplicationsRequest::computeTypeNamesAsStrings))
            .setter(setter(Builder::computeTypeNamesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeTypeNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LICENSE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseType").getter(getter(DescribeApplicationsRequest::licenseTypeAsString))
            .setter(setter(Builder::licenseType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseType").build()).build();

    private static final SdkField<List<String>> OPERATING_SYSTEM_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OperatingSystemNames")
            .getter(getter(DescribeApplicationsRequest::operatingSystemNamesAsStrings))
            .setter(setter(Builder::operatingSystemNamesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystemNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Owner")
            .getter(getter(DescribeApplicationsRequest::owner)).setter(setter(Builder::owner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Owner").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeApplicationsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeApplicationsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_IDS_FIELD,
            COMPUTE_TYPE_NAMES_FIELD, LICENSE_TYPE_FIELD, OPERATING_SYSTEM_NAMES_FIELD, OWNER_FIELD, MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> applicationIds;

    private final List<String> computeTypeNames;

    private final String licenseType;

    private final List<String> operatingSystemNames;

    private final String owner;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeApplicationsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationIds = builder.applicationIds;
        this.computeTypeNames = builder.computeTypeNames;
        this.licenseType = builder.licenseType;
        this.operatingSystemNames = builder.operatingSystemNames;
        this.owner = builder.owner;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApplicationIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasApplicationIds() {
        return applicationIds != null && !(applicationIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers of one or more applications.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApplicationIds} method.
     * </p>
     * 
     * @return The identifiers of one or more applications.
     */
    public final List<String> applicationIds() {
        return applicationIds;
    }

    /**
     * <p>
     * The compute types supported by the applications.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComputeTypeNames} method.
     * </p>
     * 
     * @return The compute types supported by the applications.
     */
    public final List<Compute> computeTypeNames() {
        return ComputeListCopier.copyStringToEnum(computeTypeNames);
    }

    /**
     * For responses, this returns true if the service returned a value for the ComputeTypeNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasComputeTypeNames() {
        return computeTypeNames != null && !(computeTypeNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The compute types supported by the applications.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComputeTypeNames} method.
     * </p>
     * 
     * @return The compute types supported by the applications.
     */
    public final List<String> computeTypeNamesAsStrings() {
        return computeTypeNames;
    }

    /**
     * <p>
     * The license availability for the applications.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseType} will
     * return {@link WorkSpaceApplicationLicenseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #licenseTypeAsString}.
     * </p>
     * 
     * @return The license availability for the applications.
     * @see WorkSpaceApplicationLicenseType
     */
    public final WorkSpaceApplicationLicenseType licenseType() {
        return WorkSpaceApplicationLicenseType.fromValue(licenseType);
    }

    /**
     * <p>
     * The license availability for the applications.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseType} will
     * return {@link WorkSpaceApplicationLicenseType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #licenseTypeAsString}.
     * </p>
     * 
     * @return The license availability for the applications.
     * @see WorkSpaceApplicationLicenseType
     */
    public final String licenseTypeAsString() {
        return licenseType;
    }

    /**
     * <p>
     * The operating systems supported by the applications.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOperatingSystemNames} method.
     * </p>
     * 
     * @return The operating systems supported by the applications.
     */
    public final List<OperatingSystemName> operatingSystemNames() {
        return OperatingSystemNameListCopier.copyStringToEnum(operatingSystemNames);
    }

    /**
     * For responses, this returns true if the service returned a value for the OperatingSystemNames property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOperatingSystemNames() {
        return operatingSystemNames != null && !(operatingSystemNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The operating systems supported by the applications.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOperatingSystemNames} method.
     * </p>
     * 
     * @return The operating systems supported by the applications.
     */
    public final List<String> operatingSystemNamesAsStrings() {
        return operatingSystemNames;
    }

    /**
     * <p>
     * The owner of the applications.
     * </p>
     * 
     * @return The owner of the applications.
     */
    public final String owner() {
        return owner;
    }

    /**
     * <p>
     * The maximum number of applications to return.
     * </p>
     * 
     * @return The maximum number of applications to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to receive
     * the next set of results.
     * </p>
     * 
     * @return If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to
     *         receive the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasApplicationIds() ? applicationIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasComputeTypeNames() ? computeTypeNamesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(licenseTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasOperatingSystemNames() ? operatingSystemNamesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(owner());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationsRequest)) {
            return false;
        }
        DescribeApplicationsRequest other = (DescribeApplicationsRequest) obj;
        return hasApplicationIds() == other.hasApplicationIds() && Objects.equals(applicationIds(), other.applicationIds())
                && hasComputeTypeNames() == other.hasComputeTypeNames()
                && Objects.equals(computeTypeNamesAsStrings(), other.computeTypeNamesAsStrings())
                && Objects.equals(licenseTypeAsString(), other.licenseTypeAsString())
                && hasOperatingSystemNames() == other.hasOperatingSystemNames()
                && Objects.equals(operatingSystemNamesAsStrings(), other.operatingSystemNamesAsStrings())
                && Objects.equals(owner(), other.owner()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeApplicationsRequest")
                .add("ApplicationIds", hasApplicationIds() ? applicationIds() : null)
                .add("ComputeTypeNames", hasComputeTypeNames() ? computeTypeNamesAsStrings() : null)
                .add("LicenseType", licenseTypeAsString())
                .add("OperatingSystemNames", hasOperatingSystemNames() ? operatingSystemNamesAsStrings() : null)
                .add("Owner", owner()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationIds":
            return Optional.ofNullable(clazz.cast(applicationIds()));
        case "ComputeTypeNames":
            return Optional.ofNullable(clazz.cast(computeTypeNamesAsStrings()));
        case "LicenseType":
            return Optional.ofNullable(clazz.cast(licenseTypeAsString()));
        case "OperatingSystemNames":
            return Optional.ofNullable(clazz.cast(operatingSystemNamesAsStrings()));
        case "Owner":
            return Optional.ofNullable(clazz.cast(owner()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApplicationIds", APPLICATION_IDS_FIELD);
        map.put("ComputeTypeNames", COMPUTE_TYPE_NAMES_FIELD);
        map.put("LicenseType", LICENSE_TYPE_FIELD);
        map.put("OperatingSystemNames", OPERATING_SYSTEM_NAMES_FIELD);
        map.put("Owner", OWNER_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicationsRequest, T> g) {
        return obj -> g.apply((DescribeApplicationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeApplicationsRequest> {
        /**
         * <p>
         * The identifiers of one or more applications.
         * </p>
         * 
         * @param applicationIds
         *        The identifiers of one or more applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationIds(Collection<String> applicationIds);

        /**
         * <p>
         * The identifiers of one or more applications.
         * </p>
         * 
         * @param applicationIds
         *        The identifiers of one or more applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationIds(String... applicationIds);

        /**
         * <p>
         * The compute types supported by the applications.
         * </p>
         * 
         * @param computeTypeNames
         *        The compute types supported by the applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeTypeNamesWithStrings(Collection<String> computeTypeNames);

        /**
         * <p>
         * The compute types supported by the applications.
         * </p>
         * 
         * @param computeTypeNames
         *        The compute types supported by the applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeTypeNamesWithStrings(String... computeTypeNames);

        /**
         * <p>
         * The compute types supported by the applications.
         * </p>
         * 
         * @param computeTypeNames
         *        The compute types supported by the applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeTypeNames(Collection<Compute> computeTypeNames);

        /**
         * <p>
         * The compute types supported by the applications.
         * </p>
         * 
         * @param computeTypeNames
         *        The compute types supported by the applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeTypeNames(Compute... computeTypeNames);

        /**
         * <p>
         * The license availability for the applications.
         * </p>
         * 
         * @param licenseType
         *        The license availability for the applications.
         * @see WorkSpaceApplicationLicenseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkSpaceApplicationLicenseType
         */
        Builder licenseType(String licenseType);

        /**
         * <p>
         * The license availability for the applications.
         * </p>
         * 
         * @param licenseType
         *        The license availability for the applications.
         * @see WorkSpaceApplicationLicenseType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkSpaceApplicationLicenseType
         */
        Builder licenseType(WorkSpaceApplicationLicenseType licenseType);

        /**
         * <p>
         * The operating systems supported by the applications.
         * </p>
         * 
         * @param operatingSystemNames
         *        The operating systems supported by the applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingSystemNamesWithStrings(Collection<String> operatingSystemNames);

        /**
         * <p>
         * The operating systems supported by the applications.
         * </p>
         * 
         * @param operatingSystemNames
         *        The operating systems supported by the applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingSystemNamesWithStrings(String... operatingSystemNames);

        /**
         * <p>
         * The operating systems supported by the applications.
         * </p>
         * 
         * @param operatingSystemNames
         *        The operating systems supported by the applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingSystemNames(Collection<OperatingSystemName> operatingSystemNames);

        /**
         * <p>
         * The operating systems supported by the applications.
         * </p>
         * 
         * @param operatingSystemNames
         *        The operating systems supported by the applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operatingSystemNames(OperatingSystemName... operatingSystemNames);

        /**
         * <p>
         * The owner of the applications.
         * </p>
         * 
         * @param owner
         *        The owner of the applications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder owner(String owner);

        /**
         * <p>
         * The maximum number of applications to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of applications to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If you received a <code>NextToken</code> from a previous call that was paginated, provide this token to
         * receive the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If you received a <code>NextToken</code> from a previous call that was paginated, provide this token
         *        to receive the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private List<String> applicationIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> computeTypeNames = DefaultSdkAutoConstructList.getInstance();

        private String licenseType;

        private List<String> operatingSystemNames = DefaultSdkAutoConstructList.getInstance();

        private String owner;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationsRequest model) {
            super(model);
            applicationIds(model.applicationIds);
            computeTypeNamesWithStrings(model.computeTypeNames);
            licenseType(model.licenseType);
            operatingSystemNamesWithStrings(model.operatingSystemNames);
            owner(model.owner);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final Collection<String> getApplicationIds() {
            if (applicationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return applicationIds;
        }

        public final void setApplicationIds(Collection<String> applicationIds) {
            this.applicationIds = WorkSpaceApplicationIdListCopier.copy(applicationIds);
        }

        @Override
        public final Builder applicationIds(Collection<String> applicationIds) {
            this.applicationIds = WorkSpaceApplicationIdListCopier.copy(applicationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationIds(String... applicationIds) {
            applicationIds(Arrays.asList(applicationIds));
            return this;
        }

        public final Collection<String> getComputeTypeNames() {
            if (computeTypeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return computeTypeNames;
        }

        public final void setComputeTypeNames(Collection<String> computeTypeNames) {
            this.computeTypeNames = ComputeListCopier.copy(computeTypeNames);
        }

        @Override
        public final Builder computeTypeNamesWithStrings(Collection<String> computeTypeNames) {
            this.computeTypeNames = ComputeListCopier.copy(computeTypeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeTypeNamesWithStrings(String... computeTypeNames) {
            computeTypeNamesWithStrings(Arrays.asList(computeTypeNames));
            return this;
        }

        @Override
        public final Builder computeTypeNames(Collection<Compute> computeTypeNames) {
            this.computeTypeNames = ComputeListCopier.copyEnumToString(computeTypeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeTypeNames(Compute... computeTypeNames) {
            computeTypeNames(Arrays.asList(computeTypeNames));
            return this;
        }

        public final String getLicenseType() {
            return licenseType;
        }

        public final void setLicenseType(String licenseType) {
            this.licenseType = licenseType;
        }

        @Override
        public final Builder licenseType(String licenseType) {
            this.licenseType = licenseType;
            return this;
        }

        @Override
        public final Builder licenseType(WorkSpaceApplicationLicenseType licenseType) {
            this.licenseType(licenseType == null ? null : licenseType.toString());
            return this;
        }

        public final Collection<String> getOperatingSystemNames() {
            if (operatingSystemNames instanceof SdkAutoConstructList) {
                return null;
            }
            return operatingSystemNames;
        }

        public final void setOperatingSystemNames(Collection<String> operatingSystemNames) {
            this.operatingSystemNames = OperatingSystemNameListCopier.copy(operatingSystemNames);
        }

        @Override
        public final Builder operatingSystemNamesWithStrings(Collection<String> operatingSystemNames) {
            this.operatingSystemNames = OperatingSystemNameListCopier.copy(operatingSystemNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operatingSystemNamesWithStrings(String... operatingSystemNames) {
            operatingSystemNamesWithStrings(Arrays.asList(operatingSystemNames));
            return this;
        }

        @Override
        public final Builder operatingSystemNames(Collection<OperatingSystemName> operatingSystemNames) {
            this.operatingSystemNames = OperatingSystemNameListCopier.copyEnumToString(operatingSystemNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operatingSystemNames(OperatingSystemName... operatingSystemNames) {
            operatingSystemNames(Arrays.asList(operatingSystemNames));
            return this;
        }

        public final String getOwner() {
            return owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeApplicationsRequest build() {
            return new DescribeApplicationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
