/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The default client branding attributes to be imported. These attributes display on the client login screen.
 * </p>
 * <important>
 * <p>
 * Client branding attributes are public facing. Ensure that you do not include sensitive information.
 * </p>
 * </important>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultImportClientBrandingAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultImportClientBrandingAttributes.Builder, DefaultImportClientBrandingAttributes> {
    private static final SdkField<SdkBytes> LOGO_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("Logo").getter(getter(DefaultImportClientBrandingAttributes::logo)).setter(setter(Builder::logo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Logo").build()).build();

    private static final SdkField<String> SUPPORT_EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SupportEmail").getter(getter(DefaultImportClientBrandingAttributes::supportEmail))
            .setter(setter(Builder::supportEmail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportEmail").build()).build();

    private static final SdkField<String> SUPPORT_LINK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SupportLink").getter(getter(DefaultImportClientBrandingAttributes::supportLink))
            .setter(setter(Builder::supportLink))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportLink").build()).build();

    private static final SdkField<String> FORGOT_PASSWORD_LINK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ForgotPasswordLink").getter(getter(DefaultImportClientBrandingAttributes::forgotPasswordLink))
            .setter(setter(Builder::forgotPasswordLink))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ForgotPasswordLink").build())
            .build();

    private static final SdkField<Map<String, String>> LOGIN_MESSAGE_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("LoginMessage")
            .getter(getter(DefaultImportClientBrandingAttributes::loginMessage))
            .setter(setter(Builder::loginMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoginMessage").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGO_FIELD,
            SUPPORT_EMAIL_FIELD, SUPPORT_LINK_FIELD, FORGOT_PASSWORD_LINK_FIELD, LOGIN_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SdkBytes logo;

    private final String supportEmail;

    private final String supportLink;

    private final String forgotPasswordLink;

    private final Map<String, String> loginMessage;

    private DefaultImportClientBrandingAttributes(BuilderImpl builder) {
        this.logo = builder.logo;
        this.supportEmail = builder.supportEmail;
        this.supportLink = builder.supportLink;
        this.forgotPasswordLink = builder.forgotPasswordLink;
        this.loginMessage = builder.loginMessage;
    }

    /**
     * <p>
     * The logo. The only image format accepted is a binary data object that is converted from a <code>.png</code> file.
     * </p>
     * 
     * @return The logo. The only image format accepted is a binary data object that is converted from a
     *         <code>.png</code> file.
     */
    public final SdkBytes logo() {
        return logo;
    }

    /**
     * <p>
     * The support email. The company's customer support email address.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * In each platform type, the <code>SupportEmail</code> and <code>SupportLink</code> parameters are mutually
     * exclusive. You can specify one parameter for each platform type, but not both.
     * </p>
     * </li>
     * <li>
     * <p>
     * The default email is <code>workspaces-feedback@amazon.com</code>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * 
     * @return The support email. The company's customer support email address.</p> <note>
     *         <ul>
     *         <li>
     *         <p>
     *         In each platform type, the <code>SupportEmail</code> and <code>SupportLink</code> parameters are mutually
     *         exclusive. You can specify one parameter for each platform type, but not both.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The default email is <code>workspaces-feedback@amazon.com</code>.
     *         </p>
     *         </li>
     *         </ul>
     */
    public final String supportEmail() {
        return supportEmail;
    }

    /**
     * <p>
     * The support link. The link for the company's customer support page for their WorkSpace.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * In each platform type, the <code>SupportEmail</code> and <code>SupportLink</code> parameters are mutually
     * exclusive. You can specify one parameter for each platform type, but not both.
     * </p>
     * </li>
     * <li>
     * <p>
     * The default support link is <code>workspaces-feedback@amazon.com</code>.
     * </p>
     * </li>
     * </ul>
     * </note>
     * 
     * @return The support link. The link for the company's customer support page for their WorkSpace.</p> <note>
     *         <ul>
     *         <li>
     *         <p>
     *         In each platform type, the <code>SupportEmail</code> and <code>SupportLink</code> parameters are mutually
     *         exclusive. You can specify one parameter for each platform type, but not both.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The default support link is <code>workspaces-feedback@amazon.com</code>.
     *         </p>
     *         </li>
     *         </ul>
     */
    public final String supportLink() {
        return supportLink;
    }

    /**
     * <p>
     * The forgotten password link. This is the web address that users can go to if they forget the password for their
     * WorkSpace.
     * </p>
     * 
     * @return The forgotten password link. This is the web address that users can go to if they forget the password for
     *         their WorkSpace.
     */
    public final String forgotPasswordLink() {
        return forgotPasswordLink;
    }

    /**
     * For responses, this returns true if the service returned a value for the LoginMessage property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLoginMessage() {
        return loginMessage != null && !(loginMessage instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The login message. Specified as a key value pair, in which the key is a locale and the value is the localized
     * message for that locale. The only key supported is <code>en_US</code>. The HTML tags supported include the
     * following:
     * <code>a, b, blockquote, br, cite, code, dd, dl, dt, div, em, i, li, ol, p, pre, q, small, span, strike, strong, sub, sup, u, ul</code>
     * .
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLoginMessage} method.
     * </p>
     * 
     * @return The login message. Specified as a key value pair, in which the key is a locale and the value is the
     *         localized message for that locale. The only key supported is <code>en_US</code>. The HTML tags supported
     *         include the following:
     *         <code>a, b, blockquote, br, cite, code, dd, dl, dt, div, em, i, li, ol, p, pre, q, small, span, strike, strong, sub, sup, u, ul</code>
     *         .
     */
    public final Map<String, String> loginMessage() {
        return loginMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logo());
        hashCode = 31 * hashCode + Objects.hashCode(supportEmail());
        hashCode = 31 * hashCode + Objects.hashCode(supportLink());
        hashCode = 31 * hashCode + Objects.hashCode(forgotPasswordLink());
        hashCode = 31 * hashCode + Objects.hashCode(hasLoginMessage() ? loginMessage() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultImportClientBrandingAttributes)) {
            return false;
        }
        DefaultImportClientBrandingAttributes other = (DefaultImportClientBrandingAttributes) obj;
        return Objects.equals(logo(), other.logo()) && Objects.equals(supportEmail(), other.supportEmail())
                && Objects.equals(supportLink(), other.supportLink())
                && Objects.equals(forgotPasswordLink(), other.forgotPasswordLink())
                && hasLoginMessage() == other.hasLoginMessage() && Objects.equals(loginMessage(), other.loginMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefaultImportClientBrandingAttributes").add("Logo", logo()).add("SupportEmail", supportEmail())
                .add("SupportLink", supportLink()).add("ForgotPasswordLink", forgotPasswordLink())
                .add("LoginMessage", hasLoginMessage() ? loginMessage() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Logo":
            return Optional.ofNullable(clazz.cast(logo()));
        case "SupportEmail":
            return Optional.ofNullable(clazz.cast(supportEmail()));
        case "SupportLink":
            return Optional.ofNullable(clazz.cast(supportLink()));
        case "ForgotPasswordLink":
            return Optional.ofNullable(clazz.cast(forgotPasswordLink()));
        case "LoginMessage":
            return Optional.ofNullable(clazz.cast(loginMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Logo", LOGO_FIELD);
        map.put("SupportEmail", SUPPORT_EMAIL_FIELD);
        map.put("SupportLink", SUPPORT_LINK_FIELD);
        map.put("ForgotPasswordLink", FORGOT_PASSWORD_LINK_FIELD);
        map.put("LoginMessage", LOGIN_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DefaultImportClientBrandingAttributes, T> g) {
        return obj -> g.apply((DefaultImportClientBrandingAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultImportClientBrandingAttributes> {
        /**
         * <p>
         * The logo. The only image format accepted is a binary data object that is converted from a <code>.png</code>
         * file.
         * </p>
         * 
         * @param logo
         *        The logo. The only image format accepted is a binary data object that is converted from a
         *        <code>.png</code> file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logo(SdkBytes logo);

        /**
         * <p>
         * The support email. The company's customer support email address.
         * </p>
         * <note>
         * <ul>
         * <li>
         * <p>
         * In each platform type, the <code>SupportEmail</code> and <code>SupportLink</code> parameters are mutually
         * exclusive. You can specify one parameter for each platform type, but not both.
         * </p>
         * </li>
         * <li>
         * <p>
         * The default email is <code>workspaces-feedback@amazon.com</code>.
         * </p>
         * </li>
         * </ul>
         * </note>
         * 
         * @param supportEmail
         *        The support email. The company's customer support email address.</p> <note>
         *        <ul>
         *        <li>
         *        <p>
         *        In each platform type, the <code>SupportEmail</code> and <code>SupportLink</code> parameters are
         *        mutually exclusive. You can specify one parameter for each platform type, but not both.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The default email is <code>workspaces-feedback@amazon.com</code>.
         *        </p>
         *        </li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportEmail(String supportEmail);

        /**
         * <p>
         * The support link. The link for the company's customer support page for their WorkSpace.
         * </p>
         * <note>
         * <ul>
         * <li>
         * <p>
         * In each platform type, the <code>SupportEmail</code> and <code>SupportLink</code> parameters are mutually
         * exclusive. You can specify one parameter for each platform type, but not both.
         * </p>
         * </li>
         * <li>
         * <p>
         * The default support link is <code>workspaces-feedback@amazon.com</code>.
         * </p>
         * </li>
         * </ul>
         * </note>
         * 
         * @param supportLink
         *        The support link. The link for the company's customer support page for their WorkSpace.</p> <note>
         *        <ul>
         *        <li>
         *        <p>
         *        In each platform type, the <code>SupportEmail</code> and <code>SupportLink</code> parameters are
         *        mutually exclusive. You can specify one parameter for each platform type, but not both.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The default support link is <code>workspaces-feedback@amazon.com</code>.
         *        </p>
         *        </li>
         *        </ul>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportLink(String supportLink);

        /**
         * <p>
         * The forgotten password link. This is the web address that users can go to if they forget the password for
         * their WorkSpace.
         * </p>
         * 
         * @param forgotPasswordLink
         *        The forgotten password link. This is the web address that users can go to if they forget the password
         *        for their WorkSpace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder forgotPasswordLink(String forgotPasswordLink);

        /**
         * <p>
         * The login message. Specified as a key value pair, in which the key is a locale and the value is the localized
         * message for that locale. The only key supported is <code>en_US</code>. The HTML tags supported include the
         * following:
         * <code>a, b, blockquote, br, cite, code, dd, dl, dt, div, em, i, li, ol, p, pre, q, small, span, strike, strong, sub, sup, u, ul</code>
         * .
         * </p>
         * 
         * @param loginMessage
         *        The login message. Specified as a key value pair, in which the key is a locale and the value is the
         *        localized message for that locale. The only key supported is <code>en_US</code>. The HTML tags
         *        supported include the following:
         *        <code>a, b, blockquote, br, cite, code, dd, dl, dt, div, em, i, li, ol, p, pre, q, small, span, strike, strong, sub, sup, u, ul</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loginMessage(Map<String, String> loginMessage);
    }

    static final class BuilderImpl implements Builder {
        private SdkBytes logo;

        private String supportEmail;

        private String supportLink;

        private String forgotPasswordLink;

        private Map<String, String> loginMessage = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultImportClientBrandingAttributes model) {
            logo(model.logo);
            supportEmail(model.supportEmail);
            supportLink(model.supportLink);
            forgotPasswordLink(model.forgotPasswordLink);
            loginMessage(model.loginMessage);
        }

        public final ByteBuffer getLogo() {
            return logo == null ? null : logo.asByteBuffer();
        }

        public final void setLogo(ByteBuffer logo) {
            logo(logo == null ? null : SdkBytes.fromByteBuffer(logo));
        }

        @Override
        public final Builder logo(SdkBytes logo) {
            this.logo = logo;
            return this;
        }

        public final String getSupportEmail() {
            return supportEmail;
        }

        public final void setSupportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
        }

        @Override
        public final Builder supportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
            return this;
        }

        public final String getSupportLink() {
            return supportLink;
        }

        public final void setSupportLink(String supportLink) {
            this.supportLink = supportLink;
        }

        @Override
        public final Builder supportLink(String supportLink) {
            this.supportLink = supportLink;
            return this;
        }

        public final String getForgotPasswordLink() {
            return forgotPasswordLink;
        }

        public final void setForgotPasswordLink(String forgotPasswordLink) {
            this.forgotPasswordLink = forgotPasswordLink;
        }

        @Override
        public final Builder forgotPasswordLink(String forgotPasswordLink) {
            this.forgotPasswordLink = forgotPasswordLink;
            return this;
        }

        public final Map<String, String> getLoginMessage() {
            if (loginMessage instanceof SdkAutoConstructMap) {
                return null;
            }
            return loginMessage;
        }

        public final void setLoginMessage(Map<String, String> loginMessage) {
            this.loginMessage = LoginMessageCopier.copy(loginMessage);
        }

        @Override
        public final Builder loginMessage(Map<String, String> loginMessage) {
            this.loginMessage = LoginMessageCopier.copy(loginMessage);
            return this;
        }

        @Override
        public DefaultImportClientBrandingAttributes build() {
            return new DefaultImportClientBrandingAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
