/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIpGroupRequest extends WorkSpacesRequest implements
        ToCopyableBuilder<CreateIpGroupRequest.Builder, CreateIpGroupRequest> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupName").getter(getter(CreateIpGroupRequest::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<String> GROUP_DESC_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GroupDesc").getter(getter(CreateIpGroupRequest::groupDesc)).setter(setter(Builder::groupDesc))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupDesc").build()).build();

    private static final SdkField<List<IpRuleItem>> USER_RULES_FIELD = SdkField
            .<List<IpRuleItem>> builder(MarshallingType.LIST)
            .memberName("UserRules")
            .getter(getter(CreateIpGroupRequest::userRules))
            .setter(setter(Builder::userRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IpRuleItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpRuleItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateIpGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD,
            GROUP_DESC_FIELD, USER_RULES_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String groupName;

    private final String groupDesc;

    private final List<IpRuleItem> userRules;

    private final List<Tag> tags;

    private CreateIpGroupRequest(BuilderImpl builder) {
        super(builder);
        this.groupName = builder.groupName;
        this.groupDesc = builder.groupDesc;
        this.userRules = builder.userRules;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * 
     * @return The name of the group.
     */
    public final String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The description of the group.
     * </p>
     * 
     * @return The description of the group.
     */
    public final String groupDesc() {
        return groupDesc;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserRules property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUserRules() {
        return userRules != null && !(userRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rules to add to the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserRules} method.
     * </p>
     * 
     * @return The rules to add to the group.
     */
    public final List<IpRuleItem> userRules() {
        return userRules;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags. Each WorkSpaces resource can have a maximum of 50 tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags. Each WorkSpaces resource can have a maximum of 50 tags.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(groupDesc());
        hashCode = 31 * hashCode + Objects.hashCode(hasUserRules() ? userRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIpGroupRequest)) {
            return false;
        }
        CreateIpGroupRequest other = (CreateIpGroupRequest) obj;
        return Objects.equals(groupName(), other.groupName()) && Objects.equals(groupDesc(), other.groupDesc())
                && hasUserRules() == other.hasUserRules() && Objects.equals(userRules(), other.userRules())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIpGroupRequest").add("GroupName", groupName()).add("GroupDesc", groupDesc())
                .add("UserRules", hasUserRules() ? userRules() : null).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "GroupDesc":
            return Optional.ofNullable(clazz.cast(groupDesc()));
        case "UserRules":
            return Optional.ofNullable(clazz.cast(userRules()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("GroupName", GROUP_NAME_FIELD);
        map.put("GroupDesc", GROUP_DESC_FIELD);
        map.put("UserRules", USER_RULES_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIpGroupRequest, T> g) {
        return obj -> g.apply((CreateIpGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateIpGroupRequest> {
        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param groupName
         *        The name of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The description of the group.
         * </p>
         * 
         * @param groupDesc
         *        The description of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupDesc(String groupDesc);

        /**
         * <p>
         * The rules to add to the group.
         * </p>
         * 
         * @param userRules
         *        The rules to add to the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userRules(Collection<IpRuleItem> userRules);

        /**
         * <p>
         * The rules to add to the group.
         * </p>
         * 
         * @param userRules
         *        The rules to add to the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userRules(IpRuleItem... userRules);

        /**
         * <p>
         * The rules to add to the group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspaces.model.IpRuleItem.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.workspaces.model.IpRuleItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspaces.model.IpRuleItem.Builder#build()} is called immediately and
         * its result is passed to {@link #userRules(List<IpRuleItem>)}.
         * 
         * @param userRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspaces.model.IpRuleItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userRules(java.util.Collection<IpRuleItem>)
         */
        Builder userRules(Consumer<IpRuleItem.Builder>... userRules);

        /**
         * <p>
         * The tags. Each WorkSpaces resource can have a maximum of 50 tags.
         * </p>
         * 
         * @param tags
         *        The tags. Each WorkSpaces resource can have a maximum of 50 tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags. Each WorkSpaces resource can have a maximum of 50 tags.
         * </p>
         * 
         * @param tags
         *        The tags. Each WorkSpaces resource can have a maximum of 50 tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags. Each WorkSpaces resource can have a maximum of 50 tags.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspaces.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.workspaces.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspaces.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspaces.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesRequest.BuilderImpl implements Builder {
        private String groupName;

        private String groupDesc;

        private List<IpRuleItem> userRules = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIpGroupRequest model) {
            super(model);
            groupName(model.groupName);
            groupDesc(model.groupDesc);
            userRules(model.userRules);
            tags(model.tags);
        }

        public final String getGroupName() {
            return groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getGroupDesc() {
            return groupDesc;
        }

        public final void setGroupDesc(String groupDesc) {
            this.groupDesc = groupDesc;
        }

        @Override
        public final Builder groupDesc(String groupDesc) {
            this.groupDesc = groupDesc;
            return this;
        }

        public final List<IpRuleItem.Builder> getUserRules() {
            List<IpRuleItem.Builder> result = IpRuleListCopier.copyToBuilder(this.userRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserRules(Collection<IpRuleItem.BuilderImpl> userRules) {
            this.userRules = IpRuleListCopier.copyFromBuilder(userRules);
        }

        @Override
        public final Builder userRules(Collection<IpRuleItem> userRules) {
            this.userRules = IpRuleListCopier.copy(userRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userRules(IpRuleItem... userRules) {
            userRules(Arrays.asList(userRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userRules(Consumer<IpRuleItem.Builder>... userRules) {
            userRules(Stream.of(userRules).map(c -> IpRuleItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIpGroupRequest build() {
            return new CreateIpGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
