/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the capacity status for a pool of WorkSpaces.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityStatus implements SdkPojo, Serializable, ToCopyableBuilder<CapacityStatus.Builder, CapacityStatus> {
    private static final SdkField<Integer> AVAILABLE_USER_SESSIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AvailableUserSessions").getter(getter(CapacityStatus::availableUserSessions))
            .setter(setter(Builder::availableUserSessions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableUserSessions").build())
            .build();

    private static final SdkField<Integer> DESIRED_USER_SESSIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DesiredUserSessions").getter(getter(CapacityStatus::desiredUserSessions))
            .setter(setter(Builder::desiredUserSessions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredUserSessions").build())
            .build();

    private static final SdkField<Integer> ACTUAL_USER_SESSIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ActualUserSessions").getter(getter(CapacityStatus::actualUserSessions))
            .setter(setter(Builder::actualUserSessions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualUserSessions").build())
            .build();

    private static final SdkField<Integer> ACTIVE_USER_SESSIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ActiveUserSessions").getter(getter(CapacityStatus::activeUserSessions))
            .setter(setter(Builder::activeUserSessions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveUserSessions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABLE_USER_SESSIONS_FIELD,
            DESIRED_USER_SESSIONS_FIELD, ACTUAL_USER_SESSIONS_FIELD, ACTIVE_USER_SESSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer availableUserSessions;

    private final Integer desiredUserSessions;

    private final Integer actualUserSessions;

    private final Integer activeUserSessions;

    private CapacityStatus(BuilderImpl builder) {
        this.availableUserSessions = builder.availableUserSessions;
        this.desiredUserSessions = builder.desiredUserSessions;
        this.actualUserSessions = builder.actualUserSessions;
        this.activeUserSessions = builder.activeUserSessions;
    }

    /**
     * <p>
     * The number of user sessions currently available for streaming from your pool.
     * </p>
     * <p>
     * AvailableUserSessions = ActualUserSessions - ActiveUserSessions
     * </p>
     * 
     * @return The number of user sessions currently available for streaming from your pool.</p>
     *         <p>
     *         AvailableUserSessions = ActualUserSessions - ActiveUserSessions
     */
    public final Integer availableUserSessions() {
        return availableUserSessions;
    }

    /**
     * <p>
     * The total number of sessions slots that are either running or pending. This represents the total number of
     * concurrent streaming sessions your pool can support in a steady state.
     * </p>
     * 
     * @return The total number of sessions slots that are either running or pending. This represents the total number
     *         of concurrent streaming sessions your pool can support in a steady state.
     */
    public final Integer desiredUserSessions() {
        return desiredUserSessions;
    }

    /**
     * <p>
     * The total number of user sessions that are available for streaming or are currently streaming in your pool.
     * </p>
     * <p>
     * ActualUserSessions = AvailableUserSessions + ActiveUserSessions
     * </p>
     * 
     * @return The total number of user sessions that are available for streaming or are currently streaming in your
     *         pool.</p>
     *         <p>
     *         ActualUserSessions = AvailableUserSessions + ActiveUserSessions
     */
    public final Integer actualUserSessions() {
        return actualUserSessions;
    }

    /**
     * <p>
     * The number of user sessions currently being used for your pool.
     * </p>
     * 
     * @return The number of user sessions currently being used for your pool.
     */
    public final Integer activeUserSessions() {
        return activeUserSessions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availableUserSessions());
        hashCode = 31 * hashCode + Objects.hashCode(desiredUserSessions());
        hashCode = 31 * hashCode + Objects.hashCode(actualUserSessions());
        hashCode = 31 * hashCode + Objects.hashCode(activeUserSessions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityStatus)) {
            return false;
        }
        CapacityStatus other = (CapacityStatus) obj;
        return Objects.equals(availableUserSessions(), other.availableUserSessions())
                && Objects.equals(desiredUserSessions(), other.desiredUserSessions())
                && Objects.equals(actualUserSessions(), other.actualUserSessions())
                && Objects.equals(activeUserSessions(), other.activeUserSessions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacityStatus").add("AvailableUserSessions", availableUserSessions())
                .add("DesiredUserSessions", desiredUserSessions()).add("ActualUserSessions", actualUserSessions())
                .add("ActiveUserSessions", activeUserSessions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AvailableUserSessions":
            return Optional.ofNullable(clazz.cast(availableUserSessions()));
        case "DesiredUserSessions":
            return Optional.ofNullable(clazz.cast(desiredUserSessions()));
        case "ActualUserSessions":
            return Optional.ofNullable(clazz.cast(actualUserSessions()));
        case "ActiveUserSessions":
            return Optional.ofNullable(clazz.cast(activeUserSessions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AvailableUserSessions", AVAILABLE_USER_SESSIONS_FIELD);
        map.put("DesiredUserSessions", DESIRED_USER_SESSIONS_FIELD);
        map.put("ActualUserSessions", ACTUAL_USER_SESSIONS_FIELD);
        map.put("ActiveUserSessions", ACTIVE_USER_SESSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityStatus, T> g) {
        return obj -> g.apply((CapacityStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityStatus> {
        /**
         * <p>
         * The number of user sessions currently available for streaming from your pool.
         * </p>
         * <p>
         * AvailableUserSessions = ActualUserSessions - ActiveUserSessions
         * </p>
         * 
         * @param availableUserSessions
         *        The number of user sessions currently available for streaming from your pool.</p>
         *        <p>
         *        AvailableUserSessions = ActualUserSessions - ActiveUserSessions
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableUserSessions(Integer availableUserSessions);

        /**
         * <p>
         * The total number of sessions slots that are either running or pending. This represents the total number of
         * concurrent streaming sessions your pool can support in a steady state.
         * </p>
         * 
         * @param desiredUserSessions
         *        The total number of sessions slots that are either running or pending. This represents the total
         *        number of concurrent streaming sessions your pool can support in a steady state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredUserSessions(Integer desiredUserSessions);

        /**
         * <p>
         * The total number of user sessions that are available for streaming or are currently streaming in your pool.
         * </p>
         * <p>
         * ActualUserSessions = AvailableUserSessions + ActiveUserSessions
         * </p>
         * 
         * @param actualUserSessions
         *        The total number of user sessions that are available for streaming or are currently streaming in your
         *        pool.</p>
         *        <p>
         *        ActualUserSessions = AvailableUserSessions + ActiveUserSessions
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualUserSessions(Integer actualUserSessions);

        /**
         * <p>
         * The number of user sessions currently being used for your pool.
         * </p>
         * 
         * @param activeUserSessions
         *        The number of user sessions currently being used for your pool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeUserSessions(Integer activeUserSessions);
    }

    static final class BuilderImpl implements Builder {
        private Integer availableUserSessions;

        private Integer desiredUserSessions;

        private Integer actualUserSessions;

        private Integer activeUserSessions;

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityStatus model) {
            availableUserSessions(model.availableUserSessions);
            desiredUserSessions(model.desiredUserSessions);
            actualUserSessions(model.actualUserSessions);
            activeUserSessions(model.activeUserSessions);
        }

        public final Integer getAvailableUserSessions() {
            return availableUserSessions;
        }

        public final void setAvailableUserSessions(Integer availableUserSessions) {
            this.availableUserSessions = availableUserSessions;
        }

        @Override
        public final Builder availableUserSessions(Integer availableUserSessions) {
            this.availableUserSessions = availableUserSessions;
            return this;
        }

        public final Integer getDesiredUserSessions() {
            return desiredUserSessions;
        }

        public final void setDesiredUserSessions(Integer desiredUserSessions) {
            this.desiredUserSessions = desiredUserSessions;
        }

        @Override
        public final Builder desiredUserSessions(Integer desiredUserSessions) {
            this.desiredUserSessions = desiredUserSessions;
            return this;
        }

        public final Integer getActualUserSessions() {
            return actualUserSessions;
        }

        public final void setActualUserSessions(Integer actualUserSessions) {
            this.actualUserSessions = actualUserSessions;
        }

        @Override
        public final Builder actualUserSessions(Integer actualUserSessions) {
            this.actualUserSessions = actualUserSessions;
            return this;
        }

        public final Integer getActiveUserSessions() {
            return activeUserSessions;
        }

        public final void setActiveUserSessions(Integer activeUserSessions) {
            this.activeUserSessions = activeUserSessions;
        }

        @Override
        public final Builder activeUserSessions(Integer activeUserSessions) {
            this.activeUserSessions = activeUserSessions;
            return this;
        }

        @Override
        public CapacityStatus build() {
            return new CapacityStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
