/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateWorkspaceApplicationResponse extends WorkSpacesResponse implements
        ToCopyableBuilder<AssociateWorkspaceApplicationResponse.Builder, AssociateWorkspaceApplicationResponse> {
    private static final SdkField<WorkspaceResourceAssociation> ASSOCIATION_FIELD = SdkField
            .<WorkspaceResourceAssociation> builder(MarshallingType.SDK_POJO).memberName("Association")
            .getter(getter(AssociateWorkspaceApplicationResponse::association)).setter(setter(Builder::association))
            .constructor(WorkspaceResourceAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Association").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final WorkspaceResourceAssociation association;

    private AssociateWorkspaceApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.association = builder.association;
    }

    /**
     * <p>
     * Information about the association between the specified WorkSpace and the specified application.
     * </p>
     * 
     * @return Information about the association between the specified WorkSpace and the specified application.
     */
    public final WorkspaceResourceAssociation association() {
        return association;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(association());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateWorkspaceApplicationResponse)) {
            return false;
        }
        AssociateWorkspaceApplicationResponse other = (AssociateWorkspaceApplicationResponse) obj;
        return Objects.equals(association(), other.association());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateWorkspaceApplicationResponse").add("Association", association()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Association":
            return Optional.ofNullable(clazz.cast(association()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Association", ASSOCIATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateWorkspaceApplicationResponse, T> g) {
        return obj -> g.apply((AssociateWorkspaceApplicationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkSpacesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateWorkspaceApplicationResponse> {
        /**
         * <p>
         * Information about the association between the specified WorkSpace and the specified application.
         * </p>
         * 
         * @param association
         *        Information about the association between the specified WorkSpace and the specified application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder association(WorkspaceResourceAssociation association);

        /**
         * <p>
         * Information about the association between the specified WorkSpace and the specified application.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkspaceResourceAssociation.Builder}
         * avoiding the need to create one manually via {@link WorkspaceResourceAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkspaceResourceAssociation.Builder#build()} is called
         * immediately and its result is passed to {@link #association(WorkspaceResourceAssociation)}.
         * 
         * @param association
         *        a consumer that will call methods on {@link WorkspaceResourceAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #association(WorkspaceResourceAssociation)
         */
        default Builder association(Consumer<WorkspaceResourceAssociation.Builder> association) {
            return association(WorkspaceResourceAssociation.builder().applyMutation(association).build());
        }
    }

    static final class BuilderImpl extends WorkSpacesResponse.BuilderImpl implements Builder {
        private WorkspaceResourceAssociation association;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateWorkspaceApplicationResponse model) {
            super(model);
            association(model.association);
        }

        public final WorkspaceResourceAssociation.Builder getAssociation() {
            return association != null ? association.toBuilder() : null;
        }

        public final void setAssociation(WorkspaceResourceAssociation.BuilderImpl association) {
            this.association = association != null ? association.build() : null;
        }

        @Override
        public final Builder association(WorkspaceResourceAssociation association) {
            this.association = association;
            return this;
        }

        @Override
        public AssociateWorkspaceApplicationResponse build() {
            return new AssociateWorkspaceApplicationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
