/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspaces;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.workspaces.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.workspaces.internal.WorkSpacesServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.workspaces.model.AcceptAccountLinkInvitationRequest;
import software.amazon.awssdk.services.workspaces.model.AcceptAccountLinkInvitationResponse;
import software.amazon.awssdk.services.workspaces.model.AccessDeniedException;
import software.amazon.awssdk.services.workspaces.model.ApplicationNotSupportedException;
import software.amazon.awssdk.services.workspaces.model.AssociateConnectionAliasRequest;
import software.amazon.awssdk.services.workspaces.model.AssociateConnectionAliasResponse;
import software.amazon.awssdk.services.workspaces.model.AssociateIpGroupsRequest;
import software.amazon.awssdk.services.workspaces.model.AssociateIpGroupsResponse;
import software.amazon.awssdk.services.workspaces.model.AssociateWorkspaceApplicationRequest;
import software.amazon.awssdk.services.workspaces.model.AssociateWorkspaceApplicationResponse;
import software.amazon.awssdk.services.workspaces.model.AuthorizeIpRulesRequest;
import software.amazon.awssdk.services.workspaces.model.AuthorizeIpRulesResponse;
import software.amazon.awssdk.services.workspaces.model.ComputeNotCompatibleException;
import software.amazon.awssdk.services.workspaces.model.ConflictException;
import software.amazon.awssdk.services.workspaces.model.CopyWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.CopyWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.CreateAccountLinkInvitationRequest;
import software.amazon.awssdk.services.workspaces.model.CreateAccountLinkInvitationResponse;
import software.amazon.awssdk.services.workspaces.model.CreateConnectClientAddInRequest;
import software.amazon.awssdk.services.workspaces.model.CreateConnectClientAddInResponse;
import software.amazon.awssdk.services.workspaces.model.CreateConnectionAliasRequest;
import software.amazon.awssdk.services.workspaces.model.CreateConnectionAliasResponse;
import software.amazon.awssdk.services.workspaces.model.CreateIpGroupRequest;
import software.amazon.awssdk.services.workspaces.model.CreateIpGroupResponse;
import software.amazon.awssdk.services.workspaces.model.CreateStandbyWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.CreateStandbyWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.CreateTagsRequest;
import software.amazon.awssdk.services.workspaces.model.CreateTagsResponse;
import software.amazon.awssdk.services.workspaces.model.CreateUpdatedWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.CreateUpdatedWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspaceBundleRequest;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspaceBundleResponse;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspacesPoolRequest;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspacesPoolResponse;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.CreateWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteAccountLinkInvitationRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteAccountLinkInvitationResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteClientBrandingRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteClientBrandingResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteConnectClientAddInRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteConnectClientAddInResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteConnectionAliasRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteConnectionAliasResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteIpGroupRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteIpGroupResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteTagsRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteTagsResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceBundleRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceBundleResponse;
import software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.DeleteWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.DeployWorkspaceApplicationsRequest;
import software.amazon.awssdk.services.workspaces.model.DeployWorkspaceApplicationsResponse;
import software.amazon.awssdk.services.workspaces.model.DeregisterWorkspaceDirectoryRequest;
import software.amazon.awssdk.services.workspaces.model.DeregisterWorkspaceDirectoryResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountModificationsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountModificationsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeAccountResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeApplicationAssociationsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeApplicationsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeApplicationsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeBundleAssociationsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeBundleAssociationsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeClientBrandingRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeClientBrandingResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeClientPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeClientPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeConnectClientAddInsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeConnectClientAddInsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasPermissionsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasPermissionsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeConnectionAliasesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeCustomWorkspaceImageImportRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeCustomWorkspaceImageImportResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeImageAssociationsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeImageAssociationsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeIpGroupsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeIpGroupsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeTagsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeTagsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceAssociationsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceAssociationsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceBundlesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceDirectoriesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagePermissionsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagePermissionsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceImagesResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceSnapshotsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspaceSnapshotsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesConnectionStatusResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesPoolSessionsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesPoolSessionsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesPoolsRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesPoolsResponse;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.DescribeWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.DisassociateConnectionAliasRequest;
import software.amazon.awssdk.services.workspaces.model.DisassociateConnectionAliasResponse;
import software.amazon.awssdk.services.workspaces.model.DisassociateIpGroupsRequest;
import software.amazon.awssdk.services.workspaces.model.DisassociateIpGroupsResponse;
import software.amazon.awssdk.services.workspaces.model.DisassociateWorkspaceApplicationRequest;
import software.amazon.awssdk.services.workspaces.model.DisassociateWorkspaceApplicationResponse;
import software.amazon.awssdk.services.workspaces.model.GetAccountLinkRequest;
import software.amazon.awssdk.services.workspaces.model.GetAccountLinkResponse;
import software.amazon.awssdk.services.workspaces.model.ImportClientBrandingRequest;
import software.amazon.awssdk.services.workspaces.model.ImportClientBrandingResponse;
import software.amazon.awssdk.services.workspaces.model.ImportCustomWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.ImportCustomWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.ImportWorkspaceImageRequest;
import software.amazon.awssdk.services.workspaces.model.ImportWorkspaceImageResponse;
import software.amazon.awssdk.services.workspaces.model.IncompatibleApplicationsException;
import software.amazon.awssdk.services.workspaces.model.InternalServerException;
import software.amazon.awssdk.services.workspaces.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.workspaces.model.InvalidParameterValuesException;
import software.amazon.awssdk.services.workspaces.model.InvalidResourceStateException;
import software.amazon.awssdk.services.workspaces.model.ListAccountLinksRequest;
import software.amazon.awssdk.services.workspaces.model.ListAccountLinksResponse;
import software.amazon.awssdk.services.workspaces.model.ListAvailableManagementCidrRangesRequest;
import software.amazon.awssdk.services.workspaces.model.ListAvailableManagementCidrRangesResponse;
import software.amazon.awssdk.services.workspaces.model.MigrateWorkspaceRequest;
import software.amazon.awssdk.services.workspaces.model.MigrateWorkspaceResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyAccountRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyAccountResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyCertificateBasedAuthPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyCertificateBasedAuthPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyClientPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyClientPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyEndpointEncryptionModeRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyEndpointEncryptionModeResponse;
import software.amazon.awssdk.services.workspaces.model.ModifySamlPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifySamlPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifySelfservicePermissionsRequest;
import software.amazon.awssdk.services.workspaces.model.ModifySelfservicePermissionsResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyStreamingPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyStreamingPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceAccessPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceAccessPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceCreationPropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceCreationPropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspacePropertiesRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspacePropertiesResponse;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceStateRequest;
import software.amazon.awssdk.services.workspaces.model.ModifyWorkspaceStateResponse;
import software.amazon.awssdk.services.workspaces.model.OperatingSystemNotCompatibleException;
import software.amazon.awssdk.services.workspaces.model.OperationInProgressException;
import software.amazon.awssdk.services.workspaces.model.OperationNotSupportedException;
import software.amazon.awssdk.services.workspaces.model.RebootWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.RebootWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.RebuildWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.RebuildWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.RegisterWorkspaceDirectoryRequest;
import software.amazon.awssdk.services.workspaces.model.RegisterWorkspaceDirectoryResponse;
import software.amazon.awssdk.services.workspaces.model.RejectAccountLinkInvitationRequest;
import software.amazon.awssdk.services.workspaces.model.RejectAccountLinkInvitationResponse;
import software.amazon.awssdk.services.workspaces.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.workspaces.model.ResourceAssociatedException;
import software.amazon.awssdk.services.workspaces.model.ResourceCreationFailedException;
import software.amazon.awssdk.services.workspaces.model.ResourceInUseException;
import software.amazon.awssdk.services.workspaces.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.workspaces.model.ResourceNotFoundException;
import software.amazon.awssdk.services.workspaces.model.ResourceUnavailableException;
import software.amazon.awssdk.services.workspaces.model.RestoreWorkspaceRequest;
import software.amazon.awssdk.services.workspaces.model.RestoreWorkspaceResponse;
import software.amazon.awssdk.services.workspaces.model.RevokeIpRulesRequest;
import software.amazon.awssdk.services.workspaces.model.RevokeIpRulesResponse;
import software.amazon.awssdk.services.workspaces.model.StartWorkspacesPoolRequest;
import software.amazon.awssdk.services.workspaces.model.StartWorkspacesPoolResponse;
import software.amazon.awssdk.services.workspaces.model.StartWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.StartWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.StopWorkspacesPoolRequest;
import software.amazon.awssdk.services.workspaces.model.StopWorkspacesPoolResponse;
import software.amazon.awssdk.services.workspaces.model.StopWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.StopWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesPoolRequest;
import software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesPoolResponse;
import software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesPoolSessionRequest;
import software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesPoolSessionResponse;
import software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesRequest;
import software.amazon.awssdk.services.workspaces.model.TerminateWorkspacesResponse;
import software.amazon.awssdk.services.workspaces.model.UnsupportedNetworkConfigurationException;
import software.amazon.awssdk.services.workspaces.model.UnsupportedWorkspaceConfigurationException;
import software.amazon.awssdk.services.workspaces.model.UpdateConnectClientAddInRequest;
import software.amazon.awssdk.services.workspaces.model.UpdateConnectClientAddInResponse;
import software.amazon.awssdk.services.workspaces.model.UpdateConnectionAliasPermissionRequest;
import software.amazon.awssdk.services.workspaces.model.UpdateConnectionAliasPermissionResponse;
import software.amazon.awssdk.services.workspaces.model.UpdateRulesOfIpGroupRequest;
import software.amazon.awssdk.services.workspaces.model.UpdateRulesOfIpGroupResponse;
import software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceBundleRequest;
import software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceBundleResponse;
import software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceImagePermissionRequest;
import software.amazon.awssdk.services.workspaces.model.UpdateWorkspaceImagePermissionResponse;
import software.amazon.awssdk.services.workspaces.model.UpdateWorkspacesPoolRequest;
import software.amazon.awssdk.services.workspaces.model.UpdateWorkspacesPoolResponse;
import software.amazon.awssdk.services.workspaces.model.ValidationException;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesException;
import software.amazon.awssdk.services.workspaces.model.WorkspacesDefaultRoleNotFoundException;
import software.amazon.awssdk.services.workspaces.transform.AcceptAccountLinkInvitationRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.AssociateConnectionAliasRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.AssociateIpGroupsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.AssociateWorkspaceApplicationRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.AuthorizeIpRulesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CopyWorkspaceImageRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateAccountLinkInvitationRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateConnectClientAddInRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateConnectionAliasRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateIpGroupRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateStandbyWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateTagsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateUpdatedWorkspaceImageRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateWorkspaceBundleRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateWorkspaceImageRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateWorkspacesPoolRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.CreateWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeleteAccountLinkInvitationRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeleteClientBrandingRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeleteConnectClientAddInRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeleteConnectionAliasRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeleteIpGroupRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeleteTagsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeleteWorkspaceBundleRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeleteWorkspaceImageRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeployWorkspaceApplicationsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DeregisterWorkspaceDirectoryRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeAccountModificationsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeAccountRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeApplicationAssociationsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeApplicationsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeBundleAssociationsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeClientBrandingRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeClientPropertiesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeConnectClientAddInsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeConnectionAliasPermissionsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeConnectionAliasesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeCustomWorkspaceImageImportRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeImageAssociationsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeIpGroupsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspaceAssociationsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspaceBundlesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspaceDirectoriesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspaceImagePermissionsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspaceImagesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspaceSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspacesConnectionStatusRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspacesPoolSessionsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspacesPoolsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DescribeWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DisassociateConnectionAliasRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DisassociateIpGroupsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.DisassociateWorkspaceApplicationRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.GetAccountLinkRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ImportClientBrandingRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ImportCustomWorkspaceImageRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ImportWorkspaceImageRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ListAccountLinksRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ListAvailableManagementCidrRangesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.MigrateWorkspaceRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyAccountRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyCertificateBasedAuthPropertiesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyClientPropertiesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyEndpointEncryptionModeRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifySamlPropertiesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifySelfservicePermissionsRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyStreamingPropertiesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyWorkspaceAccessPropertiesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyWorkspaceCreationPropertiesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyWorkspacePropertiesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.ModifyWorkspaceStateRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.RebootWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.RebuildWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.RegisterWorkspaceDirectoryRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.RejectAccountLinkInvitationRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.RestoreWorkspaceRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.RevokeIpRulesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.StartWorkspacesPoolRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.StartWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.StopWorkspacesPoolRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.StopWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.TerminateWorkspacesPoolRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.TerminateWorkspacesPoolSessionRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.TerminateWorkspacesRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.UpdateConnectClientAddInRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.UpdateConnectionAliasPermissionRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.UpdateRulesOfIpGroupRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.UpdateWorkspaceBundleRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.UpdateWorkspaceImagePermissionRequestMarshaller;
import software.amazon.awssdk.services.workspaces.transform.UpdateWorkspacesPoolRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link WorkSpacesClient}.
 *
 * @see WorkSpacesClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultWorkSpacesClient implements WorkSpacesClient {
    private static final Logger log = Logger.loggerFor(DefaultWorkSpacesClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultWorkSpacesClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "WorkSpaces" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Accepts the account link invitation.
     * </p>
     * <important>
     * <p>
     * There's currently no unlinking capability after you accept the account linking invitation.
     * </p>
     * </important>
     *
     * @param acceptAccountLinkInvitationRequest
     * @return Result of the AcceptAccountLinkInvitation operation returned by the service.
     * @throws ValidationException
     *         You either haven't provided a <code>TargetAccountId</code> or are using the same value for
     *         <code>TargetAccountId</code> and <code>SourceAccountId</code>.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ConflictException
     *         The <code>TargetAccountId</code> is already linked or invited.
     * @throws InternalServerException
     *         Unexpected server error occured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.AcceptAccountLinkInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AcceptAccountLinkInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AcceptAccountLinkInvitationResponse acceptAccountLinkInvitation(
            AcceptAccountLinkInvitationRequest acceptAccountLinkInvitationRequest) throws ValidationException,
            ResourceNotFoundException, AccessDeniedException, ConflictException, InternalServerException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AcceptAccountLinkInvitationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AcceptAccountLinkInvitationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptAccountLinkInvitationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, acceptAccountLinkInvitationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptAccountLinkInvitation");

            return clientHandler
                    .execute(new ClientExecutionParams<AcceptAccountLinkInvitationRequest, AcceptAccountLinkInvitationResponse>()
                            .withOperationName("AcceptAccountLinkInvitation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(acceptAccountLinkInvitationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AcceptAccountLinkInvitationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates the specified connection alias with the specified directory to enable cross-Region redirection. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     * <note>
     * <p>
     * Before performing this operation, call <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html">
     * DescribeConnectionAliases</a> to make sure that the current state of the connection alias is <code>CREATED</code>
     * .
     * </p>
     * </note>
     *
     * @param associateConnectionAliasRequest
     * @return Result of the AssociateConnectionAlias operation returned by the service.
     * @throws ResourceAssociatedException
     *         The resource is associated with a directory.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.AssociateConnectionAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateConnectionAlias"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateConnectionAliasResponse associateConnectionAlias(
            AssociateConnectionAliasRequest associateConnectionAliasRequest) throws ResourceAssociatedException,
            AccessDeniedException, ResourceNotFoundException, InvalidParameterValuesException, InvalidResourceStateException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateConnectionAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateConnectionAliasResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateConnectionAliasRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateConnectionAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateConnectionAlias");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateConnectionAliasRequest, AssociateConnectionAliasResponse>()
                            .withOperationName("AssociateConnectionAlias").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateConnectionAliasRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateConnectionAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates the specified IP access control group with the specified directory.
     * </p>
     *
     * @param associateIpGroupsRequest
     * @return Result of the AssociateIpGroups operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.AssociateIpGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateIpGroups" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AssociateIpGroupsResponse associateIpGroups(AssociateIpGroupsRequest associateIpGroupsRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, ResourceLimitExceededException,
            InvalidResourceStateException, AccessDeniedException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateIpGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AssociateIpGroupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateIpGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateIpGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateIpGroups");

            return clientHandler.execute(new ClientExecutionParams<AssociateIpGroupsRequest, AssociateIpGroupsResponse>()
                    .withOperationName("AssociateIpGroups").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(associateIpGroupsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateIpGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates the specified application to the specified WorkSpace.
     * </p>
     *
     * @param associateWorkspaceApplicationRequest
     * @return Result of the AssociateWorkspaceApplication operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceInUseException
     *         The specified resource is currently in use.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ComputeNotCompatibleException
     *         The compute type of the WorkSpace is not compatible with the application.
     * @throws OperatingSystemNotCompatibleException
     *         The operating system of the WorkSpace is not compatible with the application.
     * @throws ApplicationNotSupportedException
     *         The specified application is not supported.
     * @throws IncompatibleApplicationsException
     *         The specified application is not compatible with the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.AssociateWorkspaceApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateWorkspaceApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateWorkspaceApplicationResponse associateWorkspaceApplication(
            AssociateWorkspaceApplicationRequest associateWorkspaceApplicationRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, ResourceAlreadyExistsException,
            ResourceInUseException, ResourceNotFoundException, ComputeNotCompatibleException,
            OperatingSystemNotCompatibleException, ApplicationNotSupportedException, IncompatibleApplicationsException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateWorkspaceApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateWorkspaceApplicationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateWorkspaceApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateWorkspaceApplicationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateWorkspaceApplication");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateWorkspaceApplicationRequest, AssociateWorkspaceApplicationResponse>()
                            .withOperationName("AssociateWorkspaceApplication").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateWorkspaceApplicationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateWorkspaceApplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds one or more rules to the specified IP access control group.
     * </p>
     * <p>
     * This action gives users permission to access their WorkSpaces from the CIDR address ranges specified in the
     * rules.
     * </p>
     *
     * @param authorizeIpRulesRequest
     * @return Result of the AuthorizeIpRules operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.AuthorizeIpRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AuthorizeIpRules" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AuthorizeIpRulesResponse authorizeIpRules(AuthorizeIpRulesRequest authorizeIpRulesRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, ResourceLimitExceededException,
            InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AuthorizeIpRulesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AuthorizeIpRulesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(authorizeIpRulesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, authorizeIpRulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AuthorizeIpRules");

            return clientHandler.execute(new ClientExecutionParams<AuthorizeIpRulesRequest, AuthorizeIpRulesResponse>()
                    .withOperationName("AuthorizeIpRules").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(authorizeIpRulesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AuthorizeIpRulesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Copies the specified image from the specified Region to the current Region. For more information about copying
     * images, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/copy-custom-image.html"> Copy a
     * Custom WorkSpaces Image</a>.
     * </p>
     * <p>
     * In the China (Ningxia) Region, you can copy images only within the same Region.
     * </p>
     * <p>
     * In Amazon Web Services GovCloud (US), to copy images to and from other Regions, contact Amazon Web
     * ServicesSupport.
     * </p>
     * <important>
     * <p>
     * Before copying a shared image, be sure to verify that it has been shared from the correct Amazon Web Services
     * account. To determine if an image has been shared and to see the ID of the Amazon Web Services account that owns
     * an image, use the <a href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImages.html">
     * DescribeWorkSpaceImages</a> and <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImagePermissions.html"
     * >DescribeWorkspaceImagePermissions</a> API operations.
     * </p>
     * </important>
     *
     * @param copyWorkspaceImageRequest
     * @return Result of the CopyWorkspaceImage operation returned by the service.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CopyWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CopyWorkspaceImage" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CopyWorkspaceImageResponse copyWorkspaceImage(CopyWorkspaceImageRequest copyWorkspaceImageRequest)
            throws ResourceLimitExceededException, ResourceAlreadyExistsException, ResourceNotFoundException,
            ResourceUnavailableException, OperationNotSupportedException, AccessDeniedException, InvalidParameterValuesException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CopyWorkspaceImageResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CopyWorkspaceImageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(copyWorkspaceImageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copyWorkspaceImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopyWorkspaceImage");

            return clientHandler.execute(new ClientExecutionParams<CopyWorkspaceImageRequest, CopyWorkspaceImageResponse>()
                    .withOperationName("CopyWorkspaceImage").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(copyWorkspaceImageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CopyWorkspaceImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates the account link invitation.
     * </p>
     *
     * @param createAccountLinkInvitationRequest
     * @return Result of the CreateAccountLinkInvitation operation returned by the service.
     * @throws ValidationException
     *         You either haven't provided a <code>TargetAccountId</code> or are using the same value for
     *         <code>TargetAccountId</code> and <code>SourceAccountId</code>.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ConflictException
     *         The <code>TargetAccountId</code> is already linked or invited.
     * @throws InternalServerException
     *         Unexpected server error occured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateAccountLinkInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateAccountLinkInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateAccountLinkInvitationResponse createAccountLinkInvitation(
            CreateAccountLinkInvitationRequest createAccountLinkInvitationRequest) throws ValidationException,
            AccessDeniedException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAccountLinkInvitationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAccountLinkInvitationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAccountLinkInvitationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAccountLinkInvitationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAccountLinkInvitation");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateAccountLinkInvitationRequest, CreateAccountLinkInvitationResponse>()
                            .withOperationName("CreateAccountLinkInvitation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createAccountLinkInvitationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateAccountLinkInvitationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a client-add-in for Amazon Connect within a directory. You can create only one Amazon Connect client
     * add-in within a directory.
     * </p>
     * <p>
     * This client add-in allows WorkSpaces users to seamlessly connect to Amazon Connect.
     * </p>
     *
     * @param createConnectClientAddInRequest
     * @return Result of the CreateConnectClientAddIn operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceCreationFailedException
     *         The resource could not be created.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateConnectClientAddIn
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateConnectClientAddIn"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateConnectClientAddInResponse createConnectClientAddIn(
            CreateConnectClientAddInRequest createConnectClientAddInRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, ResourceCreationFailedException, ResourceAlreadyExistsException, AccessDeniedException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateConnectClientAddInResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateConnectClientAddInResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createConnectClientAddInRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createConnectClientAddInRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateConnectClientAddIn");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateConnectClientAddInRequest, CreateConnectClientAddInResponse>()
                            .withOperationName("CreateConnectClientAddIn").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createConnectClientAddInRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateConnectClientAddInRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates the specified connection alias for use with cross-Region redirection. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     *
     * @param createConnectionAliasRequest
     * @return Result of the CreateConnectionAlias operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateConnectionAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateConnectionAlias"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateConnectionAliasResponse createConnectionAlias(CreateConnectionAliasRequest createConnectionAliasRequest)
            throws ResourceAlreadyExistsException, AccessDeniedException, InvalidParameterValuesException,
            ResourceLimitExceededException, InvalidResourceStateException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateConnectionAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateConnectionAliasResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createConnectionAliasRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createConnectionAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateConnectionAlias");

            return clientHandler.execute(new ClientExecutionParams<CreateConnectionAliasRequest, CreateConnectionAliasResponse>()
                    .withOperationName("CreateConnectionAlias").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createConnectionAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateConnectionAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an IP access control group.
     * </p>
     * <p>
     * An IP access control group provides you with the ability to control the IP addresses from which users are allowed
     * to access their WorkSpaces. To specify the CIDR address ranges, add rules to your IP access control group and
     * then associate the group with your directory. You can add rules when you create the group or at any time using
     * <a>AuthorizeIpRules</a>.
     * </p>
     * <p>
     * There is a default IP access control group associated with your directory. If you don't associate an IP access
     * control group with your directory, the default group is used. The default group includes a default rule that
     * allows users to access their WorkSpaces from anywhere. You cannot modify the default IP access control group for
     * your directory.
     * </p>
     *
     * @param createIpGroupRequest
     * @return Result of the CreateIpGroup operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceCreationFailedException
     *         The resource could not be created.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateIpGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateIpGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateIpGroupResponse createIpGroup(CreateIpGroupRequest createIpGroupRequest) throws InvalidParameterValuesException,
            ResourceLimitExceededException, ResourceAlreadyExistsException, ResourceCreationFailedException,
            AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateIpGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateIpGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIpGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIpGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIpGroup");

            return clientHandler.execute(new ClientExecutionParams<CreateIpGroupRequest, CreateIpGroupResponse>()
                    .withOperationName("CreateIpGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createIpGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateIpGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a standby WorkSpace in a secondary Region.
     * </p>
     *
     * @param createStandbyWorkspacesRequest
     * @return Result of the CreateStandbyWorkspaces operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateStandbyWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateStandbyWorkspaces"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateStandbyWorkspacesResponse createStandbyWorkspaces(CreateStandbyWorkspacesRequest createStandbyWorkspacesRequest)
            throws AccessDeniedException, InvalidParameterValuesException, OperationNotSupportedException,
            ResourceNotFoundException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateStandbyWorkspacesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateStandbyWorkspacesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createStandbyWorkspacesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStandbyWorkspacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStandbyWorkspaces");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateStandbyWorkspacesRequest, CreateStandbyWorkspacesResponse>()
                            .withOperationName("CreateStandbyWorkspaces").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createStandbyWorkspacesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateStandbyWorkspacesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates the specified tags for the specified WorkSpaces resource.
     * </p>
     *
     * @param createTagsRequest
     * @return Result of the CreateTags operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateTagsResponse createTags(CreateTagsRequest createTagsRequest) throws ResourceNotFoundException,
            InvalidParameterValuesException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateTagsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTags");

            return clientHandler.execute(new ClientExecutionParams<CreateTagsRequest, CreateTagsResponse>()
                    .withOperationName("CreateTags").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createTagsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTagsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new updated WorkSpace image based on the specified source image. The new updated WorkSpace image has
     * the latest drivers and other updates required by the Amazon WorkSpaces components.
     * </p>
     * <p>
     * To determine which WorkSpace images need to be updated with the latest Amazon WorkSpaces requirements, use <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImages.html">
     * DescribeWorkspaceImages</a>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * Only Windows 10, Windows Server 2016, and Windows Server 2019 WorkSpace images can be programmatically updated at
     * this time.
     * </p>
     * </li>
     * <li>
     * <p>
     * Microsoft Windows updates and other application updates are not included in the update process.
     * </p>
     * </li>
     * <li>
     * <p>
     * The source WorkSpace image is not deleted. You can delete the source image after you've verified your new updated
     * image and created a new bundle.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createUpdatedWorkspaceImageRequest
     * @return Result of the CreateUpdatedWorkspaceImage operation returned by the service.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateUpdatedWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateUpdatedWorkspaceImage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateUpdatedWorkspaceImageResponse createUpdatedWorkspaceImage(
            CreateUpdatedWorkspaceImageRequest createUpdatedWorkspaceImageRequest) throws ResourceLimitExceededException,
            ResourceAlreadyExistsException, ResourceNotFoundException, OperationNotSupportedException,
            InvalidResourceStateException, AccessDeniedException, InvalidParameterValuesException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUpdatedWorkspaceImageResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateUpdatedWorkspaceImageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUpdatedWorkspaceImageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUpdatedWorkspaceImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUpdatedWorkspaceImage");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateUpdatedWorkspaceImageRequest, CreateUpdatedWorkspaceImageResponse>()
                            .withOperationName("CreateUpdatedWorkspaceImage").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createUpdatedWorkspaceImageRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateUpdatedWorkspaceImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates the specified WorkSpace bundle. For more information about creating WorkSpace bundles, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/create-custom-bundle.html"> Create a Custom
     * WorkSpaces Image and Bundle</a>.
     * </p>
     *
     * @param createWorkspaceBundleRequest
     * @return Result of the CreateWorkspaceBundle operation returned by the service.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateWorkspaceBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaceBundle"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateWorkspaceBundleResponse createWorkspaceBundle(CreateWorkspaceBundleRequest createWorkspaceBundleRequest)
            throws ResourceUnavailableException, ResourceAlreadyExistsException, ResourceLimitExceededException,
            InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateWorkspaceBundleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateWorkspaceBundleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWorkspaceBundleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkspaceBundleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkspaceBundle");

            return clientHandler.execute(new ClientExecutionParams<CreateWorkspaceBundleRequest, CreateWorkspaceBundleResponse>()
                    .withOperationName("CreateWorkspaceBundle").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createWorkspaceBundleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateWorkspaceBundleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new WorkSpace image from an existing WorkSpace.
     * </p>
     *
     * @param createWorkspaceImageRequest
     * @return Result of the CreateWorkspaceImage operation returned by the service.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaceImage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateWorkspaceImageResponse createWorkspaceImage(CreateWorkspaceImageRequest createWorkspaceImageRequest)
            throws ResourceLimitExceededException, ResourceAlreadyExistsException, ResourceNotFoundException,
            OperationNotSupportedException, InvalidResourceStateException, AccessDeniedException,
            InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateWorkspaceImageResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateWorkspaceImageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWorkspaceImageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkspaceImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkspaceImage");

            return clientHandler.execute(new ClientExecutionParams<CreateWorkspaceImageRequest, CreateWorkspaceImageResponse>()
                    .withOperationName("CreateWorkspaceImage").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createWorkspaceImageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateWorkspaceImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates one or more WorkSpaces.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces are created.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The <code>MANUAL</code> running mode value is only supported by Amazon WorkSpaces Core. Contact your account team
     * to be allow-listed to use this value. For more information, see <a
     * href="http://aws.amazon.com/workspaces/core/">Amazon WorkSpaces Core</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * You don't need to specify the <code>PCOIP</code> protocol for Linux bundles because <code>DCV</code> (formerly
     * WSP) is the default protocol for those bundles.
     * </p>
     * </li>
     * <li>
     * <p>
     * User-decoupled WorkSpaces are only supported by Amazon WorkSpaces Core.
     * </p>
     * </li>
     * <li>
     * <p>
     * Review your running mode to ensure you are using one that is optimal for your needs and budget. For more
     * information on switching running modes, see <a href=
     * "http://aws.amazon.com/workspaces-family/workspaces/faqs/#:~:text=Can%20I%20switch%20between%20hourly%20and%20monthly%20billing%20on%20WorkSpaces%20Personal%3F"
     * > Can I switch between hourly and monthly billing?</a>
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param createWorkspacesRequest
     * @return Result of the CreateWorkspaces operation returned by the service.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateWorkspacesResponse createWorkspaces(CreateWorkspacesRequest createWorkspacesRequest)
            throws ResourceLimitExceededException, InvalidParameterValuesException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateWorkspacesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateWorkspacesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWorkspacesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkspacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkspaces");

            return clientHandler.execute(new ClientExecutionParams<CreateWorkspacesRequest, CreateWorkspacesResponse>()
                    .withOperationName("CreateWorkspaces").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createWorkspacesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateWorkspacesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a pool of WorkSpaces.
     * </p>
     *
     * @param createWorkspacesPoolRequest
     * @return Result of the CreateWorkspacesPool operation returned by the service.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.CreateWorkspacesPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspacesPool"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateWorkspacesPoolResponse createWorkspacesPool(CreateWorkspacesPoolRequest createWorkspacesPoolRequest)
            throws ResourceLimitExceededException, ResourceNotFoundException, InvalidParameterValuesException,
            ResourceAlreadyExistsException, OperationNotSupportedException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateWorkspacesPoolResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateWorkspacesPoolResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWorkspacesPoolRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkspacesPoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkspacesPool");

            return clientHandler.execute(new ClientExecutionParams<CreateWorkspacesPoolRequest, CreateWorkspacesPoolResponse>()
                    .withOperationName("CreateWorkspacesPool").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createWorkspacesPoolRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateWorkspacesPoolRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the account link invitation.
     * </p>
     *
     * @param deleteAccountLinkInvitationRequest
     * @return Result of the DeleteAccountLinkInvitation operation returned by the service.
     * @throws ValidationException
     *         You either haven't provided a <code>TargetAccountId</code> or are using the same value for
     *         <code>TargetAccountId</code> and <code>SourceAccountId</code>.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The <code>TargetAccountId</code> is already linked or invited.
     * @throws InternalServerException
     *         Unexpected server error occured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteAccountLinkInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteAccountLinkInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAccountLinkInvitationResponse deleteAccountLinkInvitation(
            DeleteAccountLinkInvitationRequest deleteAccountLinkInvitationRequest) throws ValidationException,
            AccessDeniedException, ResourceNotFoundException, ConflictException, InternalServerException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAccountLinkInvitationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAccountLinkInvitationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAccountLinkInvitationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAccountLinkInvitationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccountLinkInvitation");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteAccountLinkInvitationRequest, DeleteAccountLinkInvitationResponse>()
                            .withOperationName("DeleteAccountLinkInvitation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteAccountLinkInvitationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteAccountLinkInvitationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes customized client branding. Client branding allows you to customize your WorkSpace's client login portal.
     * You can tailor your login portal company logo, the support email address, support link, link to reset password,
     * and a custom message for users trying to sign in.
     * </p>
     * <p>
     * After you delete your customized client branding, your login portal reverts to the default client branding.
     * </p>
     *
     * @param deleteClientBrandingRequest
     * @return Result of the DeleteClientBranding operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteClientBranding
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteClientBranding"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteClientBrandingResponse deleteClientBranding(DeleteClientBrandingRequest deleteClientBrandingRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteClientBrandingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteClientBrandingResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteClientBrandingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteClientBrandingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteClientBranding");

            return clientHandler.execute(new ClientExecutionParams<DeleteClientBrandingRequest, DeleteClientBrandingResponse>()
                    .withOperationName("DeleteClientBranding").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteClientBrandingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteClientBrandingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a client-add-in for Amazon Connect that is configured within a directory.
     * </p>
     *
     * @param deleteConnectClientAddInRequest
     * @return Result of the DeleteConnectClientAddIn operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteConnectClientAddIn
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteConnectClientAddIn"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteConnectClientAddInResponse deleteConnectClientAddIn(
            DeleteConnectClientAddInRequest deleteConnectClientAddInRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteConnectClientAddInResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteConnectClientAddInResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteConnectClientAddInRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConnectClientAddInRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConnectClientAddIn");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteConnectClientAddInRequest, DeleteConnectClientAddInResponse>()
                            .withOperationName("DeleteConnectClientAddIn").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteConnectClientAddInRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteConnectClientAddInRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified connection alias. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     * <important>
     * <p>
     * <b>If you will no longer be using a fully qualified domain name (FQDN) as the registration code for your
     * WorkSpaces users, you must take certain precautions to prevent potential security issues.</b> For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html#cross-region-redirection-security-considerations"
     * > Security Considerations if You Stop Using Cross-Region Redirection</a>.
     * </p>
     * </important> <note>
     * <p>
     * To delete a connection alias that has been shared, the shared account must first disassociate the connection
     * alias from any directories it has been associated with. Then you must unshare the connection alias from the
     * account it has been shared with. You can delete a connection alias only after it is no longer shared with any
     * accounts or associated with any directories.
     * </p>
     * </note>
     *
     * @param deleteConnectionAliasRequest
     * @return Result of the DeleteConnectionAlias operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAssociatedException
     *         The resource is associated with a directory.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteConnectionAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteConnectionAlias"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteConnectionAliasResponse deleteConnectionAlias(DeleteConnectionAliasRequest deleteConnectionAliasRequest)
            throws ResourceNotFoundException, ResourceAssociatedException, AccessDeniedException,
            InvalidParameterValuesException, InvalidResourceStateException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteConnectionAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteConnectionAliasResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteConnectionAliasRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConnectionAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConnectionAlias");

            return clientHandler.execute(new ClientExecutionParams<DeleteConnectionAliasRequest, DeleteConnectionAliasResponse>()
                    .withOperationName("DeleteConnectionAlias").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteConnectionAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteConnectionAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified IP access control group.
     * </p>
     * <p>
     * You cannot delete an IP access control group that is associated with a directory.
     * </p>
     *
     * @param deleteIpGroupRequest
     * @return Result of the DeleteIpGroup operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAssociatedException
     *         The resource is associated with a directory.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteIpGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteIpGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteIpGroupResponse deleteIpGroup(DeleteIpGroupRequest deleteIpGroupRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, ResourceAssociatedException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteIpGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteIpGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIpGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIpGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIpGroup");

            return clientHandler.execute(new ClientExecutionParams<DeleteIpGroupRequest, DeleteIpGroupResponse>()
                    .withOperationName("DeleteIpGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteIpGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteIpGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified tags from the specified WorkSpaces resource.
     * </p>
     *
     * @param deleteTagsRequest
     * @return Result of the DeleteTags operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteTagsResponse deleteTags(DeleteTagsRequest deleteTagsRequest) throws ResourceNotFoundException,
            InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteTagsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTags");

            return clientHandler.execute(new ClientExecutionParams<DeleteTagsRequest, DeleteTagsResponse>()
                    .withOperationName("DeleteTags").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteTagsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteTagsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified WorkSpace bundle. For more information about deleting WorkSpace bundles, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/delete_bundle.html"> Delete a Custom WorkSpaces
     * Bundle or Image</a>.
     * </p>
     *
     * @param deleteWorkspaceBundleRequest
     * @return Result of the DeleteWorkspaceBundle operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAssociatedException
     *         The resource is associated with a directory.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteWorkspaceBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteWorkspaceBundle"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteWorkspaceBundleResponse deleteWorkspaceBundle(DeleteWorkspaceBundleRequest deleteWorkspaceBundleRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, ResourceAssociatedException,
            AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteWorkspaceBundleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteWorkspaceBundleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWorkspaceBundleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWorkspaceBundleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWorkspaceBundle");

            return clientHandler.execute(new ClientExecutionParams<DeleteWorkspaceBundleRequest, DeleteWorkspaceBundleResponse>()
                    .withOperationName("DeleteWorkspaceBundle").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteWorkspaceBundleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteWorkspaceBundleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified image from your account. To delete an image, you must first delete any bundles that are
     * associated with the image and unshare the image if it is shared with other accounts.
     * </p>
     *
     * @param deleteWorkspaceImageRequest
     * @return Result of the DeleteWorkspaceImage operation returned by the service.
     * @throws ResourceAssociatedException
     *         The resource is associated with a directory.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeleteWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteWorkspaceImage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteWorkspaceImageResponse deleteWorkspaceImage(DeleteWorkspaceImageRequest deleteWorkspaceImageRequest)
            throws ResourceAssociatedException, InvalidResourceStateException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteWorkspaceImageResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteWorkspaceImageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWorkspaceImageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWorkspaceImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWorkspaceImage");

            return clientHandler.execute(new ClientExecutionParams<DeleteWorkspaceImageRequest, DeleteWorkspaceImageResponse>()
                    .withOperationName("DeleteWorkspaceImage").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteWorkspaceImageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteWorkspaceImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deploys associated applications to the specified WorkSpace
     * </p>
     *
     * @param deployWorkspaceApplicationsRequest
     * @return Result of the DeployWorkspaceApplications operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceInUseException
     *         The specified resource is currently in use.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws IncompatibleApplicationsException
     *         The specified application is not compatible with the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeployWorkspaceApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeployWorkspaceApplications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeployWorkspaceApplicationsResponse deployWorkspaceApplications(
            DeployWorkspaceApplicationsRequest deployWorkspaceApplicationsRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, ResourceInUseException, ResourceNotFoundException,
            IncompatibleApplicationsException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeployWorkspaceApplicationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeployWorkspaceApplicationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deployWorkspaceApplicationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deployWorkspaceApplicationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeployWorkspaceApplications");

            return clientHandler
                    .execute(new ClientExecutionParams<DeployWorkspaceApplicationsRequest, DeployWorkspaceApplicationsResponse>()
                            .withOperationName("DeployWorkspaceApplications").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deployWorkspaceApplicationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeployWorkspaceApplicationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deregisters the specified directory. This operation is asynchronous and returns before the WorkSpace directory is
     * deregistered. If any WorkSpaces are registered to this directory, you must remove them before you can deregister
     * the directory.
     * </p>
     * <note>
     * <p>
     * Simple AD and AD Connector are made available to you free of charge to use with WorkSpaces. If there are no
     * WorkSpaces being used with your Simple AD or AD Connector directory for 30 consecutive days, this directory will
     * be automatically deregistered for use with Amazon WorkSpaces, and you will be charged for this directory as per
     * the <a href="http://aws.amazon.com/directoryservice/pricing/">Directory Service pricing terms</a>.
     * </p>
     * <p>
     * To delete empty directories, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/delete-workspaces-directory.html"> Delete the
     * Directory for Your WorkSpaces</a>. If you delete your Simple AD or AD Connector directory, you can always create
     * a new one when you want to start using WorkSpaces again.
     * </p>
     * </note>
     *
     * @param deregisterWorkspaceDirectoryRequest
     * @return Result of the DeregisterWorkspaceDirectory operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DeregisterWorkspaceDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeregisterWorkspaceDirectory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeregisterWorkspaceDirectoryResponse deregisterWorkspaceDirectory(
            DeregisterWorkspaceDirectoryRequest deregisterWorkspaceDirectoryRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, ResourceNotFoundException,
            InvalidResourceStateException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeregisterWorkspaceDirectoryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeregisterWorkspaceDirectoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deregisterWorkspaceDirectoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterWorkspaceDirectoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterWorkspaceDirectory");

            return clientHandler
                    .execute(new ClientExecutionParams<DeregisterWorkspaceDirectoryRequest, DeregisterWorkspaceDirectoryResponse>()
                            .withOperationName("DeregisterWorkspaceDirectory").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deregisterWorkspaceDirectoryRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeregisterWorkspaceDirectoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list that describes the configuration of Bring Your Own License (BYOL) for the specified account.
     * </p>
     *
     * @param describeAccountRequest
     * @return Result of the DescribeAccount operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeAccount" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeAccountResponse describeAccount(DescribeAccountRequest describeAccountRequest) throws AccessDeniedException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAccountResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeAccountResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAccountRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccount");

            return clientHandler.execute(new ClientExecutionParams<DescribeAccountRequest, DescribeAccountResponse>()
                    .withOperationName("DescribeAccount").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeAccountRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeAccountRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list that describes modifications to the configuration of Bring Your Own License (BYOL) for the
     * specified account.
     * </p>
     *
     * @param describeAccountModificationsRequest
     * @return Result of the DescribeAccountModifications operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeAccountModifications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeAccountModifications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAccountModificationsResponse describeAccountModifications(
            DescribeAccountModificationsRequest describeAccountModificationsRequest) throws AccessDeniedException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAccountModificationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAccountModificationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAccountModificationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountModificationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountModifications");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountModificationsRequest, DescribeAccountModificationsResponse>()
                            .withOperationName("DescribeAccountModifications").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeAccountModificationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAccountModificationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the associations between the application and the specified associated resources.
     * </p>
     *
     * @param describeApplicationAssociationsRequest
     * @return Result of the DescribeApplicationAssociations operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeApplicationAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeApplicationAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeApplicationAssociationsResponse describeApplicationAssociations(
            DescribeApplicationAssociationsRequest describeApplicationAssociationsRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeApplicationAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeApplicationAssociationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeApplicationAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeApplicationAssociationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeApplicationAssociations");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeApplicationAssociationsRequest, DescribeApplicationAssociationsResponse>()
                            .withOperationName("DescribeApplicationAssociations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeApplicationAssociationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeApplicationAssociationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the specified applications by filtering based on their compute types, license availability, operating
     * systems, and owners.
     * </p>
     *
     * @param describeApplicationsRequest
     * @return Result of the DescribeApplications operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeApplications"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeApplicationsResponse describeApplications(DescribeApplicationsRequest describeApplicationsRequest)
            throws AccessDeniedException, InvalidParameterValuesException, OperationNotSupportedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeApplicationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeApplicationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeApplicationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeApplicationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeApplications");

            return clientHandler.execute(new ClientExecutionParams<DescribeApplicationsRequest, DescribeApplicationsResponse>()
                    .withOperationName("DescribeApplications").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeApplicationsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeApplicationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the associations between the applications and the specified bundle.
     * </p>
     *
     * @param describeBundleAssociationsRequest
     * @return Result of the DescribeBundleAssociations operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeBundleAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeBundleAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeBundleAssociationsResponse describeBundleAssociations(
            DescribeBundleAssociationsRequest describeBundleAssociationsRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeBundleAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeBundleAssociationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeBundleAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBundleAssociationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBundleAssociations");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeBundleAssociationsRequest, DescribeBundleAssociationsResponse>()
                            .withOperationName("DescribeBundleAssociations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeBundleAssociationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeBundleAssociationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the specified client branding. Client branding allows you to customize the log in page of various
     * device types for your users. You can add your company logo, the support email address, support link, link to
     * reset password, and a custom message for users trying to sign in.
     * </p>
     * <note>
     * <p>
     * Only device types that have branding information configured will be shown in the response.
     * </p>
     * </note>
     *
     * @param describeClientBrandingRequest
     * @return Result of the DescribeClientBranding operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeClientBranding
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeClientBranding"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeClientBrandingResponse describeClientBranding(DescribeClientBrandingRequest describeClientBrandingRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeClientBrandingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeClientBrandingResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeClientBrandingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeClientBrandingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeClientBranding");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeClientBrandingRequest, DescribeClientBrandingResponse>()
                            .withOperationName("DescribeClientBranding").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeClientBrandingRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeClientBrandingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified Amazon WorkSpaces clients.
     * </p>
     *
     * @param describeClientPropertiesRequest
     * @return Result of the DescribeClientProperties operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeClientProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeClientProperties"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeClientPropertiesResponse describeClientProperties(
            DescribeClientPropertiesRequest describeClientPropertiesRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeClientPropertiesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeClientPropertiesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeClientPropertiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeClientPropertiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeClientProperties");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeClientPropertiesRequest, DescribeClientPropertiesResponse>()
                            .withOperationName("DescribeClientProperties").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeClientPropertiesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeClientPropertiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of Amazon Connect client add-ins that have been created.
     * </p>
     *
     * @param describeConnectClientAddInsRequest
     * @return Result of the DescribeConnectClientAddIns operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeConnectClientAddIns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeConnectClientAddIns"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeConnectClientAddInsResponse describeConnectClientAddIns(
            DescribeConnectClientAddInsRequest describeConnectClientAddInsRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeConnectClientAddInsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeConnectClientAddInsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeConnectClientAddInsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeConnectClientAddInsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConnectClientAddIns");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeConnectClientAddInsRequest, DescribeConnectClientAddInsResponse>()
                            .withOperationName("DescribeConnectClientAddIns").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeConnectClientAddInsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeConnectClientAddInsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the permissions that the owner of a connection alias has granted to another Amazon Web Services account
     * for the specified connection alias. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     *
     * @param describeConnectionAliasPermissionsRequest
     * @return Result of the DescribeConnectionAliasPermissions operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeConnectionAliasPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeConnectionAliasPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeConnectionAliasPermissionsResponse describeConnectionAliasPermissions(
            DescribeConnectionAliasPermissionsRequest describeConnectionAliasPermissionsRequest) throws AccessDeniedException,
            InvalidParameterValuesException, ResourceNotFoundException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeConnectionAliasPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeConnectionAliasPermissionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeConnectionAliasPermissionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeConnectionAliasPermissionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConnectionAliasPermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeConnectionAliasPermissionsRequest, DescribeConnectionAliasPermissionsResponse>()
                            .withOperationName("DescribeConnectionAliasPermissions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeConnectionAliasPermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeConnectionAliasPermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list that describes the connection aliases used for cross-Region redirection. For more information,
     * see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html">
     * Cross-Region Redirection for Amazon WorkSpaces</a>.
     * </p>
     *
     * @param describeConnectionAliasesRequest
     * @return Result of the DescribeConnectionAliases operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeConnectionAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeConnectionAliases"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeConnectionAliasesResponse describeConnectionAliases(
            DescribeConnectionAliasesRequest describeConnectionAliasesRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeConnectionAliasesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeConnectionAliasesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeConnectionAliasesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeConnectionAliasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConnectionAliases");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeConnectionAliasesRequest, DescribeConnectionAliasesResponse>()
                            .withOperationName("DescribeConnectionAliases").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeConnectionAliasesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeConnectionAliasesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a WorkSpace BYOL image being imported via ImportCustomWorkspaceImage.
     * </p>
     *
     * @param describeCustomWorkspaceImageImportRequest
     * @return Result of the DescribeCustomWorkspaceImageImport operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeCustomWorkspaceImageImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeCustomWorkspaceImageImport"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeCustomWorkspaceImageImportResponse describeCustomWorkspaceImageImport(
            DescribeCustomWorkspaceImageImportRequest describeCustomWorkspaceImageImportRequest) throws AccessDeniedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeCustomWorkspaceImageImportResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeCustomWorkspaceImageImportResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCustomWorkspaceImageImportRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeCustomWorkspaceImageImportRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCustomWorkspaceImageImport");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeCustomWorkspaceImageImportRequest, DescribeCustomWorkspaceImageImportResponse>()
                            .withOperationName("DescribeCustomWorkspaceImageImport").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeCustomWorkspaceImageImportRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeCustomWorkspaceImageImportRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the associations between the applications and the specified image.
     * </p>
     *
     * @param describeImageAssociationsRequest
     * @return Result of the DescribeImageAssociations operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeImageAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeImageAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeImageAssociationsResponse describeImageAssociations(
            DescribeImageAssociationsRequest describeImageAssociationsRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeImageAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeImageAssociationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeImageAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeImageAssociationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeImageAssociations");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeImageAssociationsRequest, DescribeImageAssociationsResponse>()
                            .withOperationName("DescribeImageAssociations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeImageAssociationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeImageAssociationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes one or more of your IP access control groups.
     * </p>
     *
     * @param describeIpGroupsRequest
     * @return Result of the DescribeIpGroups operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeIpGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeIpGroups" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeIpGroupsResponse describeIpGroups(DescribeIpGroupsRequest describeIpGroupsRequest)
            throws InvalidParameterValuesException, AccessDeniedException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeIpGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeIpGroupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeIpGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeIpGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeIpGroups");

            return clientHandler.execute(new ClientExecutionParams<DescribeIpGroupsRequest, DescribeIpGroupsResponse>()
                    .withOperationName("DescribeIpGroups").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeIpGroupsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeIpGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the specified tags for the specified WorkSpaces resource.
     * </p>
     *
     * @param describeTagsRequest
     * @return Result of the DescribeTags operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeTagsResponse describeTags(DescribeTagsRequest describeTagsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeTagsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeTagsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTags");

            return clientHandler.execute(new ClientExecutionParams<DescribeTagsRequest, DescribeTagsResponse>()
                    .withOperationName("DescribeTags").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeTagsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeTagsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the associations betweens applications and the specified WorkSpace.
     * </p>
     *
     * @param describeWorkspaceAssociationsRequest
     * @return Result of the DescribeWorkspaceAssociations operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeWorkspaceAssociationsResponse describeWorkspaceAssociations(
            DescribeWorkspaceAssociationsRequest describeWorkspaceAssociationsRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeWorkspaceAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeWorkspaceAssociationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeWorkspaceAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeWorkspaceAssociationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeWorkspaceAssociations");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeWorkspaceAssociationsRequest, DescribeWorkspaceAssociationsResponse>()
                            .withOperationName("DescribeWorkspaceAssociations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeWorkspaceAssociationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeWorkspaceAssociationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list that describes the available WorkSpace bundles.
     * </p>
     * <p>
     * You can filter the results using either bundle ID or owner, but not both.
     * </p>
     *
     * @param describeWorkspaceBundlesRequest
     * @return Result of the DescribeWorkspaceBundles operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceBundles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundles"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeWorkspaceBundlesResponse describeWorkspaceBundles(
            DescribeWorkspaceBundlesRequest describeWorkspaceBundlesRequest) throws InvalidParameterValuesException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeWorkspaceBundlesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeWorkspaceBundlesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeWorkspaceBundlesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeWorkspaceBundlesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeWorkspaceBundles");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeWorkspaceBundlesRequest, DescribeWorkspaceBundlesResponse>()
                            .withOperationName("DescribeWorkspaceBundles").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeWorkspaceBundlesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeWorkspaceBundlesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the available directories that are registered with Amazon WorkSpaces.
     * </p>
     *
     * @param describeWorkspaceDirectoriesRequest
     * @return Result of the DescribeWorkspaceDirectories operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeWorkspaceDirectoriesResponse describeWorkspaceDirectories(
            DescribeWorkspaceDirectoriesRequest describeWorkspaceDirectoriesRequest) throws InvalidParameterValuesException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeWorkspaceDirectoriesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeWorkspaceDirectoriesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeWorkspaceDirectoriesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeWorkspaceDirectoriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeWorkspaceDirectories");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeWorkspaceDirectoriesRequest, DescribeWorkspaceDirectoriesResponse>()
                            .withOperationName("DescribeWorkspaceDirectories").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeWorkspaceDirectoriesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeWorkspaceDirectoriesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the permissions that the owner of an image has granted to other Amazon Web Services accounts for an
     * image.
     * </p>
     *
     * @param describeWorkspaceImagePermissionsRequest
     * @return Result of the DescribeWorkspaceImagePermissions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceImagePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceImagePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeWorkspaceImagePermissionsResponse describeWorkspaceImagePermissions(
            DescribeWorkspaceImagePermissionsRequest describeWorkspaceImagePermissionsRequest) throws ResourceNotFoundException,
            AccessDeniedException, InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeWorkspaceImagePermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeWorkspaceImagePermissionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeWorkspaceImagePermissionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeWorkspaceImagePermissionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeWorkspaceImagePermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeWorkspaceImagePermissionsRequest, DescribeWorkspaceImagePermissionsResponse>()
                            .withOperationName("DescribeWorkspaceImagePermissions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeWorkspaceImagePermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeWorkspaceImagePermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified images, if the image identifiers are provided. Otherwise,
     * all images in the account are described.
     * </p>
     *
     * @param describeWorkspaceImagesRequest
     * @return Result of the DescribeWorkspaceImages operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceImages"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeWorkspaceImagesResponse describeWorkspaceImages(DescribeWorkspaceImagesRequest describeWorkspaceImagesRequest)
            throws AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeWorkspaceImagesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeWorkspaceImagesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeWorkspaceImagesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeWorkspaceImagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeWorkspaceImages");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeWorkspaceImagesRequest, DescribeWorkspaceImagesResponse>()
                            .withOperationName("DescribeWorkspaceImages").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeWorkspaceImagesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeWorkspaceImagesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the snapshots for the specified WorkSpace.
     * </p>
     *
     * @param describeWorkspaceSnapshotsRequest
     * @return Result of the DescribeWorkspaceSnapshots operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaceSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeWorkspaceSnapshotsResponse describeWorkspaceSnapshots(
            DescribeWorkspaceSnapshotsRequest describeWorkspaceSnapshotsRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeWorkspaceSnapshotsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeWorkspaceSnapshotsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeWorkspaceSnapshotsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeWorkspaceSnapshotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeWorkspaceSnapshots");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeWorkspaceSnapshotsRequest, DescribeWorkspaceSnapshotsResponse>()
                            .withOperationName("DescribeWorkspaceSnapshots").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeWorkspaceSnapshotsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeWorkspaceSnapshotsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the specified WorkSpaces.
     * </p>
     * <p>
     * You can filter the results by using the bundle identifier, directory identifier, or owner, but you can specify
     * only one filter at a time.
     * </p>
     *
     * @param describeWorkspacesRequest
     * @return Result of the DescribeWorkspaces operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeWorkspacesResponse describeWorkspaces(DescribeWorkspacesRequest describeWorkspacesRequest)
            throws InvalidParameterValuesException, ResourceUnavailableException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeWorkspacesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeWorkspacesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeWorkspacesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeWorkspacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeWorkspaces");

            return clientHandler.execute(new ClientExecutionParams<DescribeWorkspacesRequest, DescribeWorkspacesResponse>()
                    .withOperationName("DescribeWorkspaces").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeWorkspacesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeWorkspacesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the connection status of the specified WorkSpaces.
     * </p>
     *
     * @param describeWorkspacesConnectionStatusRequest
     * @return Result of the DescribeWorkspacesConnectionStatus operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspacesConnectionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesConnectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeWorkspacesConnectionStatusResponse describeWorkspacesConnectionStatus(
            DescribeWorkspacesConnectionStatusRequest describeWorkspacesConnectionStatusRequest)
            throws InvalidParameterValuesException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeWorkspacesConnectionStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeWorkspacesConnectionStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeWorkspacesConnectionStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeWorkspacesConnectionStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeWorkspacesConnectionStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeWorkspacesConnectionStatusRequest, DescribeWorkspacesConnectionStatusResponse>()
                            .withOperationName("DescribeWorkspacesConnectionStatus").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeWorkspacesConnectionStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeWorkspacesConnectionStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list that describes the streaming sessions for a specified pool.
     * </p>
     *
     * @param describeWorkspacesPoolSessionsRequest
     * @return Result of the DescribeWorkspacesPoolSessions operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspacesPoolSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesPoolSessions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeWorkspacesPoolSessionsResponse describeWorkspacesPoolSessions(
            DescribeWorkspacesPoolSessionsRequest describeWorkspacesPoolSessionsRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeWorkspacesPoolSessionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeWorkspacesPoolSessionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeWorkspacesPoolSessionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeWorkspacesPoolSessionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeWorkspacesPoolSessions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeWorkspacesPoolSessionsRequest, DescribeWorkspacesPoolSessionsResponse>()
                            .withOperationName("DescribeWorkspacesPoolSessions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeWorkspacesPoolSessionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeWorkspacesPoolSessionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the specified WorkSpaces Pools.
     * </p>
     *
     * @param describeWorkspacesPoolsRequest
     * @return Result of the DescribeWorkspacesPools operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DescribeWorkspacesPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesPools"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeWorkspacesPoolsResponse describeWorkspacesPools(DescribeWorkspacesPoolsRequest describeWorkspacesPoolsRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeWorkspacesPoolsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeWorkspacesPoolsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeWorkspacesPoolsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeWorkspacesPoolsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeWorkspacesPools");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeWorkspacesPoolsRequest, DescribeWorkspacesPoolsResponse>()
                            .withOperationName("DescribeWorkspacesPools").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeWorkspacesPoolsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeWorkspacesPoolsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates a connection alias from a directory. Disassociating a connection alias disables cross-Region
     * redirection between two directories in different Regions. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     * <note>
     * <p>
     * Before performing this operation, call <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html">
     * DescribeConnectionAliases</a> to make sure that the current state of the connection alias is <code>CREATED</code>
     * .
     * </p>
     * </note>
     *
     * @param disassociateConnectionAliasRequest
     * @return Result of the DisassociateConnectionAlias operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DisassociateConnectionAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateConnectionAlias"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateConnectionAliasResponse disassociateConnectionAlias(
            DisassociateConnectionAliasRequest disassociateConnectionAliasRequest) throws AccessDeniedException,
            ResourceNotFoundException, InvalidParameterValuesException, InvalidResourceStateException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateConnectionAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateConnectionAliasResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateConnectionAliasRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateConnectionAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateConnectionAlias");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateConnectionAliasRequest, DisassociateConnectionAliasResponse>()
                            .withOperationName("DisassociateConnectionAlias").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(disassociateConnectionAliasRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateConnectionAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates the specified IP access control group from the specified directory.
     * </p>
     *
     * @param disassociateIpGroupsRequest
     * @return Result of the DisassociateIpGroups operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DisassociateIpGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateIpGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateIpGroupsResponse disassociateIpGroups(DisassociateIpGroupsRequest disassociateIpGroupsRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, InvalidResourceStateException,
            AccessDeniedException, OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateIpGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateIpGroupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateIpGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateIpGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateIpGroups");

            return clientHandler.execute(new ClientExecutionParams<DisassociateIpGroupsRequest, DisassociateIpGroupsResponse>()
                    .withOperationName("DisassociateIpGroups").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(disassociateIpGroupsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DisassociateIpGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates the specified application from a WorkSpace.
     * </p>
     *
     * @param disassociateWorkspaceApplicationRequest
     * @return Result of the DisassociateWorkspaceApplication operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceInUseException
     *         The specified resource is currently in use.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.DisassociateWorkspaceApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateWorkspaceApplication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateWorkspaceApplicationResponse disassociateWorkspaceApplication(
            DisassociateWorkspaceApplicationRequest disassociateWorkspaceApplicationRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, ResourceInUseException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateWorkspaceApplicationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateWorkspaceApplicationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateWorkspaceApplicationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateWorkspaceApplicationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateWorkspaceApplication");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateWorkspaceApplicationRequest, DisassociateWorkspaceApplicationResponse>()
                            .withOperationName("DisassociateWorkspaceApplication").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(disassociateWorkspaceApplicationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateWorkspaceApplicationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves account link information.
     * </p>
     *
     * @param getAccountLinkRequest
     * @return Result of the GetAccountLink operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ValidationException
     *         You either haven't provided a <code>TargetAccountId</code> or are using the same value for
     *         <code>TargetAccountId</code> and <code>SourceAccountId</code>.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InternalServerException
     *         Unexpected server error occured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.GetAccountLink
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/GetAccountLink" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetAccountLinkResponse getAccountLink(GetAccountLinkRequest getAccountLinkRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAccountLinkResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetAccountLinkResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAccountLinkRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAccountLinkRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccountLink");

            return clientHandler.execute(new ClientExecutionParams<GetAccountLinkRequest, GetAccountLinkResponse>()
                    .withOperationName("GetAccountLink").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getAccountLinkRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetAccountLinkRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Imports client branding. Client branding allows you to customize your WorkSpace's client login portal. You can
     * tailor your login portal company logo, the support email address, support link, link to reset password, and a
     * custom message for users trying to sign in.
     * </p>
     * <p>
     * After you import client branding, the default branding experience for the specified platform type is replaced
     * with the imported experience
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * You must specify at least one platform type when importing client branding.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can import up to 6 MB of data with each request. If your request exceeds this limit, you can import client
     * branding for different platform types using separate requests.
     * </p>
     * </li>
     * <li>
     * <p>
     * In each platform type, the <code>SupportEmail</code> and <code>SupportLink</code> parameters are mutually
     * exclusive. You can specify only one parameter for each platform type, but not both.
     * </p>
     * </li>
     * <li>
     * <p>
     * Imported data can take up to a minute to appear in the WorkSpaces client.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param importClientBrandingRequest
     * @return Result of the ImportClientBranding operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ImportClientBranding
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ImportClientBranding"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ImportClientBrandingResponse importClientBranding(ImportClientBrandingRequest importClientBrandingRequest)
            throws InvalidParameterValuesException, ResourceLimitExceededException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ImportClientBrandingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ImportClientBrandingResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(importClientBrandingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importClientBrandingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportClientBranding");

            return clientHandler.execute(new ClientExecutionParams<ImportClientBrandingRequest, ImportClientBrandingResponse>()
                    .withOperationName("ImportClientBranding").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(importClientBrandingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ImportClientBrandingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Imports the specified Windows 10 or 11 Bring Your Own License (BYOL) image into Amazon WorkSpaces using EC2 Image
     * Builder. The image must be an already licensed image that is in your Amazon Web Services account, and you must
     * own the image. For more information about creating BYOL images, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html"> Bring Your Own Windows
     * Desktop Licenses</a>.
     * </p>
     *
     * @param importCustomWorkspaceImageRequest
     * @return Result of the ImportCustomWorkspaceImage operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ImportCustomWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ImportCustomWorkspaceImage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ImportCustomWorkspaceImageResponse importCustomWorkspaceImage(
            ImportCustomWorkspaceImageRequest importCustomWorkspaceImageRequest) throws AccessDeniedException,
            InvalidParameterValuesException, OperationNotSupportedException, ResourceNotFoundException,
            ResourceAlreadyExistsException, ResourceLimitExceededException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ImportCustomWorkspaceImageResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ImportCustomWorkspaceImageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(importCustomWorkspaceImageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importCustomWorkspaceImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportCustomWorkspaceImage");

            return clientHandler
                    .execute(new ClientExecutionParams<ImportCustomWorkspaceImageRequest, ImportCustomWorkspaceImageResponse>()
                            .withOperationName("ImportCustomWorkspaceImage").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(importCustomWorkspaceImageRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ImportCustomWorkspaceImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Imports the specified Windows 10 or 11 Bring Your Own License (BYOL) image into Amazon WorkSpaces. The image must
     * be an already licensed Amazon EC2 image that is in your Amazon Web Services account, and you must own the image.
     * For more information about creating BYOL images, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html"> Bring Your Own Windows
     * Desktop Licenses</a>.
     * </p>
     *
     * @param importWorkspaceImageRequest
     * @return Result of the ImportWorkspaceImage operation returned by the service.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ImportWorkspaceImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ImportWorkspaceImage"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ImportWorkspaceImageResponse importWorkspaceImage(ImportWorkspaceImageRequest importWorkspaceImageRequest)
            throws ResourceLimitExceededException, ResourceAlreadyExistsException, ResourceNotFoundException,
            OperationNotSupportedException, AccessDeniedException, InvalidParameterValuesException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ImportWorkspaceImageResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ImportWorkspaceImageResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(importWorkspaceImageRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, importWorkspaceImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ImportWorkspaceImage");

            return clientHandler.execute(new ClientExecutionParams<ImportWorkspaceImageRequest, ImportWorkspaceImageResponse>()
                    .withOperationName("ImportWorkspaceImage").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(importWorkspaceImageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ImportWorkspaceImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all account links.
     * </p>
     *
     * @param listAccountLinksRequest
     * @return Result of the ListAccountLinks operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ValidationException
     *         You either haven't provided a <code>TargetAccountId</code> or are using the same value for
     *         <code>TargetAccountId</code> and <code>SourceAccountId</code>.
     * @throws InternalServerException
     *         Unexpected server error occured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ListAccountLinks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ListAccountLinks" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListAccountLinksResponse listAccountLinks(ListAccountLinksRequest listAccountLinksRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAccountLinksResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAccountLinksResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAccountLinksRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAccountLinksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccountLinks");

            return clientHandler.execute(new ClientExecutionParams<ListAccountLinksRequest, ListAccountLinksResponse>()
                    .withOperationName("ListAccountLinks").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listAccountLinksRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAccountLinksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of IP address ranges, specified as IPv4 CIDR blocks, that you can use for the network management
     * interface when you enable Bring Your Own License (BYOL).
     * </p>
     * <p>
     * This operation can be run only by Amazon Web Services accounts that are enabled for BYOL. If your account isn't
     * enabled for BYOL, you'll receive an <code>AccessDeniedException</code> error.
     * </p>
     * <p>
     * The management network interface is connected to a secure Amazon WorkSpaces management network. It is used for
     * interactive streaming of the WorkSpace desktop to Amazon WorkSpaces clients, and to allow Amazon WorkSpaces to
     * manage the WorkSpace.
     * </p>
     *
     * @param listAvailableManagementCidrRangesRequest
     * @return Result of the ListAvailableManagementCidrRanges operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ListAvailableManagementCidrRanges
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ListAvailableManagementCidrRanges"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAvailableManagementCidrRangesResponse listAvailableManagementCidrRanges(
            ListAvailableManagementCidrRangesRequest listAvailableManagementCidrRangesRequest)
            throws InvalidParameterValuesException, AccessDeniedException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAvailableManagementCidrRangesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAvailableManagementCidrRangesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAvailableManagementCidrRangesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAvailableManagementCidrRangesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAvailableManagementCidrRanges");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAvailableManagementCidrRangesRequest, ListAvailableManagementCidrRangesResponse>()
                            .withOperationName("ListAvailableManagementCidrRanges").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listAvailableManagementCidrRangesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAvailableManagementCidrRangesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Migrates a WorkSpace from one operating system or bundle type to another, while retaining the data on the user
     * volume.
     * </p>
     * <p>
     * The migration process recreates the WorkSpace by using a new root volume from the target bundle image and the
     * user volume from the last available snapshot of the original WorkSpace. During migration, the original
     * <code>D:\Users\%USERNAME%</code> user profile folder is renamed to
     * <code>D:\Users\%USERNAME%MMddyyTHHmmss%.NotMigrated</code>. A new <code>D:\Users\%USERNAME%\</code> folder is
     * generated by the new OS. Certain files in the old user profile are moved to the new user profile.
     * </p>
     * <p>
     * For available migration scenarios, details about what happens during migration, and best practices, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/migrate-workspaces.html">Migrate a WorkSpace</a>.
     * </p>
     *
     * @param migrateWorkspaceRequest
     * @return Result of the MigrateWorkspace operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws OperationInProgressException
     *         The properties of this WorkSpace are currently being modified. Try again in a moment.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.MigrateWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/MigrateWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public MigrateWorkspaceResponse migrateWorkspace(MigrateWorkspaceRequest migrateWorkspaceRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException,
            OperationNotSupportedException, OperationInProgressException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<MigrateWorkspaceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                MigrateWorkspaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(migrateWorkspaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, migrateWorkspaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "MigrateWorkspace");

            return clientHandler.execute(new ClientExecutionParams<MigrateWorkspaceRequest, MigrateWorkspaceResponse>()
                    .withOperationName("MigrateWorkspace").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(migrateWorkspaceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new MigrateWorkspaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the configuration of Bring Your Own License (BYOL) for the specified account.
     * </p>
     *
     * @param modifyAccountRequest
     * @return Result of the ModifyAccount operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyAccount" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ModifyAccountResponse modifyAccount(ModifyAccountRequest modifyAccountRequest) throws InvalidParameterValuesException,
            AccessDeniedException, InvalidResourceStateException, ResourceUnavailableException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ModifyAccountResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ModifyAccountResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyAccountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyAccountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyAccount");

            return clientHandler.execute(new ClientExecutionParams<ModifyAccountRequest, ModifyAccountResponse>()
                    .withOperationName("ModifyAccount").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(modifyAccountRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyAccountRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the properties of the certificate-based authentication you want to use with your WorkSpaces.
     * </p>
     *
     * @param modifyCertificateBasedAuthPropertiesRequest
     * @return Result of the ModifyCertificateBasedAuthProperties operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyCertificateBasedAuthProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyCertificateBasedAuthProperties"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyCertificateBasedAuthPropertiesResponse modifyCertificateBasedAuthProperties(
            ModifyCertificateBasedAuthPropertiesRequest modifyCertificateBasedAuthPropertiesRequest)
            throws AccessDeniedException, InvalidParameterValuesException, OperationNotSupportedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ModifyCertificateBasedAuthPropertiesResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ModifyCertificateBasedAuthPropertiesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyCertificateBasedAuthPropertiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                modifyCertificateBasedAuthPropertiesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyCertificateBasedAuthProperties");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyCertificateBasedAuthPropertiesRequest, ModifyCertificateBasedAuthPropertiesResponse>()
                            .withOperationName("ModifyCertificateBasedAuthProperties").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(modifyCertificateBasedAuthPropertiesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyCertificateBasedAuthPropertiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the properties of the specified Amazon WorkSpaces clients.
     * </p>
     *
     * @param modifyClientPropertiesRequest
     * @return Result of the ModifyClientProperties operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyClientProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyClientProperties"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyClientPropertiesResponse modifyClientProperties(ModifyClientPropertiesRequest modifyClientPropertiesRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ModifyClientPropertiesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ModifyClientPropertiesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyClientPropertiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyClientPropertiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyClientProperties");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyClientPropertiesRequest, ModifyClientPropertiesResponse>()
                            .withOperationName("ModifyClientProperties").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(modifyClientPropertiesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyClientPropertiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the endpoint encryption mode that allows you to configure the specified directory between Standard TLS
     * and FIPS 140-2 validated mode.
     * </p>
     *
     * @param modifyEndpointEncryptionModeRequest
     * @return Result of the ModifyEndpointEncryptionMode operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyEndpointEncryptionMode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyEndpointEncryptionMode"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyEndpointEncryptionModeResponse modifyEndpointEncryptionMode(
            ModifyEndpointEncryptionModeRequest modifyEndpointEncryptionModeRequest) throws AccessDeniedException,
            ResourceNotFoundException, OperationNotSupportedException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ModifyEndpointEncryptionModeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ModifyEndpointEncryptionModeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyEndpointEncryptionModeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyEndpointEncryptionModeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyEndpointEncryptionMode");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyEndpointEncryptionModeRequest, ModifyEndpointEncryptionModeResponse>()
                            .withOperationName("ModifyEndpointEncryptionMode").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(modifyEndpointEncryptionModeRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyEndpointEncryptionModeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies multiple properties related to SAML 2.0 authentication, including the enablement status, user access
     * URL, and relay state parameter name that are used for configuring federation with an SAML 2.0 identity provider.
     * </p>
     *
     * @param modifySamlPropertiesRequest
     * @return Result of the ModifySamlProperties operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifySamlProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifySamlProperties"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifySamlPropertiesResponse modifySamlProperties(ModifySamlPropertiesRequest modifySamlPropertiesRequest)
            throws AccessDeniedException, InvalidParameterValuesException, OperationNotSupportedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ModifySamlPropertiesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ModifySamlPropertiesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifySamlPropertiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifySamlPropertiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifySamlProperties");

            return clientHandler.execute(new ClientExecutionParams<ModifySamlPropertiesRequest, ModifySamlPropertiesResponse>()
                    .withOperationName("ModifySamlProperties").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(modifySamlPropertiesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifySamlPropertiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the self-service WorkSpace management capabilities for your users. For more information, see <a href=
     * "https://docs.aws.amazon.com/workspaces/latest/adminguide/enable-user-self-service-workspace-management.html"
     * >Enable Self-Service WorkSpace Management Capabilities for Your Users</a>.
     * </p>
     *
     * @param modifySelfservicePermissionsRequest
     * @return Result of the ModifySelfservicePermissions operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifySelfservicePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifySelfservicePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifySelfservicePermissionsResponse modifySelfservicePermissions(
            ModifySelfservicePermissionsRequest modifySelfservicePermissionsRequest) throws AccessDeniedException,
            InvalidParameterValuesException, ResourceNotFoundException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ModifySelfservicePermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ModifySelfservicePermissionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifySelfservicePermissionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifySelfservicePermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifySelfservicePermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifySelfservicePermissionsRequest, ModifySelfservicePermissionsResponse>()
                            .withOperationName("ModifySelfservicePermissions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(modifySelfservicePermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifySelfservicePermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the specified streaming properties.
     * </p>
     *
     * @param modifyStreamingPropertiesRequest
     * @return Result of the ModifyStreamingProperties operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyStreamingProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyStreamingProperties"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyStreamingPropertiesResponse modifyStreamingProperties(
            ModifyStreamingPropertiesRequest modifyStreamingPropertiesRequest) throws AccessDeniedException,
            InvalidParameterValuesException, ResourceNotFoundException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ModifyStreamingPropertiesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ModifyStreamingPropertiesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyStreamingPropertiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyStreamingPropertiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyStreamingProperties");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyStreamingPropertiesRequest, ModifyStreamingPropertiesResponse>()
                            .withOperationName("ModifyStreamingProperties").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(modifyStreamingPropertiesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyStreamingPropertiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Specifies which devices and operating systems users can use to access their WorkSpaces. For more information, see
     * <a href=
     * "https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html#control-device-access">
     * Control Device Access</a>.
     * </p>
     *
     * @param modifyWorkspaceAccessPropertiesRequest
     * @return Result of the ModifyWorkspaceAccessProperties operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidParameterCombinationException
     *         Two or more of the selected parameter values cannot be used together.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyWorkspaceAccessProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceAccessProperties"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyWorkspaceAccessPropertiesResponse modifyWorkspaceAccessProperties(
            ModifyWorkspaceAccessPropertiesRequest modifyWorkspaceAccessPropertiesRequest) throws ResourceNotFoundException,
            AccessDeniedException, InvalidParameterValuesException, InvalidParameterCombinationException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ModifyWorkspaceAccessPropertiesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ModifyWorkspaceAccessPropertiesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyWorkspaceAccessPropertiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                modifyWorkspaceAccessPropertiesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyWorkspaceAccessProperties");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyWorkspaceAccessPropertiesRequest, ModifyWorkspaceAccessPropertiesResponse>()
                            .withOperationName("ModifyWorkspaceAccessProperties").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(modifyWorkspaceAccessPropertiesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyWorkspaceAccessPropertiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modify the default properties used to create WorkSpaces.
     * </p>
     *
     * @param modifyWorkspaceCreationPropertiesRequest
     * @return Result of the ModifyWorkspaceCreationProperties operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyWorkspaceCreationProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceCreationProperties"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyWorkspaceCreationPropertiesResponse modifyWorkspaceCreationProperties(
            ModifyWorkspaceCreationPropertiesRequest modifyWorkspaceCreationPropertiesRequest) throws AccessDeniedException,
            InvalidParameterValuesException, ResourceNotFoundException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ModifyWorkspaceCreationPropertiesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ModifyWorkspaceCreationPropertiesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyWorkspaceCreationPropertiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                modifyWorkspaceCreationPropertiesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyWorkspaceCreationProperties");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyWorkspaceCreationPropertiesRequest, ModifyWorkspaceCreationPropertiesResponse>()
                            .withOperationName("ModifyWorkspaceCreationProperties").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(modifyWorkspaceCreationPropertiesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyWorkspaceCreationPropertiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the specified WorkSpace properties. For important information about how to modify the size of the root
     * and user volumes, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html">
     * Modify a WorkSpace</a>.
     * </p>
     * <note>
     * <p>
     * The <code>MANUAL</code> running mode value is only supported by Amazon WorkSpaces Core. Contact your account team
     * to be allow-listed to use this value. For more information, see <a
     * href="http://aws.amazon.com/workspaces/core/">Amazon WorkSpaces Core</a>.
     * </p>
     * </note>
     *
     * @param modifyWorkspacePropertiesRequest
     * @return Result of the ModifyWorkspaceProperties operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws OperationInProgressException
     *         The properties of this WorkSpace are currently being modified. Try again in a moment.
     * @throws UnsupportedWorkspaceConfigurationException
     *         The configuration of this WorkSpace is not supported for this operation. For more information, see <a
     *         href="https://docs.aws.amazon.com/workspaces/latest/adminguide/required-service-components.html">Required
     *         Configuration and Service Components for WorkSpaces </a>.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyWorkspaceProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceProperties"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyWorkspacePropertiesResponse modifyWorkspaceProperties(
            ModifyWorkspacePropertiesRequest modifyWorkspacePropertiesRequest) throws InvalidParameterValuesException,
            InvalidResourceStateException, OperationInProgressException, UnsupportedWorkspaceConfigurationException,
            ResourceNotFoundException, AccessDeniedException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ModifyWorkspacePropertiesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ModifyWorkspacePropertiesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyWorkspacePropertiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyWorkspacePropertiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyWorkspaceProperties");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyWorkspacePropertiesRequest, ModifyWorkspacePropertiesResponse>()
                            .withOperationName("ModifyWorkspaceProperties").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(modifyWorkspacePropertiesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyWorkspacePropertiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets the state of the specified WorkSpace.
     * </p>
     * <p>
     * To maintain a WorkSpace without being interrupted, set the WorkSpace state to <code>ADMIN_MAINTENANCE</code>.
     * WorkSpaces in this state do not respond to requests to reboot, stop, start, rebuild, or restore. An AutoStop
     * WorkSpace in this state is not stopped. Users cannot log into a WorkSpace in the <code>ADMIN_MAINTENANCE</code>
     * state.
     * </p>
     *
     * @param modifyWorkspaceStateRequest
     * @return Result of the ModifyWorkspaceState operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.ModifyWorkspaceState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceState"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyWorkspaceStateResponse modifyWorkspaceState(ModifyWorkspaceStateRequest modifyWorkspaceStateRequest)
            throws InvalidParameterValuesException, InvalidResourceStateException, ResourceNotFoundException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ModifyWorkspaceStateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ModifyWorkspaceStateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyWorkspaceStateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyWorkspaceStateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyWorkspaceState");

            return clientHandler.execute(new ClientExecutionParams<ModifyWorkspaceStateRequest, ModifyWorkspaceStateResponse>()
                    .withOperationName("ModifyWorkspaceState").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(modifyWorkspaceStateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyWorkspaceStateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Reboots the specified WorkSpaces.
     * </p>
     * <p>
     * You cannot reboot a WorkSpace unless its state is <code>AVAILABLE</code>, <code>UNHEALTHY</code>, or
     * <code>REBOOTING</code>. Reboot a WorkSpace in the <code>REBOOTING</code> state only if your WorkSpace has been
     * stuck in the <code>REBOOTING</code> state for over 20 minutes.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces have rebooted.
     * </p>
     *
     * @param rebootWorkspacesRequest
     * @return Result of the RebootWorkspaces operation returned by the service.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RebootWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebootWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public RebootWorkspacesResponse rebootWorkspaces(RebootWorkspacesRequest rebootWorkspacesRequest)
            throws OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RebootWorkspacesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RebootWorkspacesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(rebootWorkspacesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rebootWorkspacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RebootWorkspaces");

            return clientHandler.execute(new ClientExecutionParams<RebootWorkspacesRequest, RebootWorkspacesResponse>()
                    .withOperationName("RebootWorkspaces").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(rebootWorkspacesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RebootWorkspacesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Rebuilds the specified WorkSpace.
     * </p>
     * <p>
     * You cannot rebuild a WorkSpace unless its state is <code>AVAILABLE</code>, <code>ERROR</code>,
     * <code>UNHEALTHY</code>, <code>STOPPED</code>, or <code>REBOOTING</code>.
     * </p>
     * <p>
     * Rebuilding a WorkSpace is a potentially destructive action that can result in the loss of data. For more
     * information, see <a href="https://docs.aws.amazon.com/workspaces/latest/adminguide/reset-workspace.html">Rebuild
     * a WorkSpace</a>.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces have been completely rebuilt.
     * </p>
     *
     * @param rebuildWorkspacesRequest
     * @return Result of the RebuildWorkspaces operation returned by the service.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RebuildWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebuildWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public RebuildWorkspacesResponse rebuildWorkspaces(RebuildWorkspacesRequest rebuildWorkspacesRequest)
            throws OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RebuildWorkspacesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RebuildWorkspacesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(rebuildWorkspacesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rebuildWorkspacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RebuildWorkspaces");

            return clientHandler.execute(new ClientExecutionParams<RebuildWorkspacesRequest, RebuildWorkspacesResponse>()
                    .withOperationName("RebuildWorkspaces").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(rebuildWorkspacesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RebuildWorkspacesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Registers the specified directory. This operation is asynchronous and returns before the WorkSpace directory is
     * registered. If this is the first time you are registering a directory, you will need to create the
     * workspaces_DefaultRole role before you can register a directory. For more information, see <a href=
     * "https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role">
     * Creating the workspaces_DefaultRole Role</a>.
     * </p>
     *
     * @param registerWorkspaceDirectoryRequest
     * @return Result of the RegisterWorkspaceDirectory operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws WorkspacesDefaultRoleNotFoundException
     *         The workspaces_DefaultRole role could not be found. If this is the first time you are registering a
     *         directory, you will need to create the workspaces_DefaultRole role before you can register a directory.
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role"
     *         >Creating the workspaces_DefaultRole Role</a>.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws UnsupportedNetworkConfigurationException
     *         The configuration of this network is not supported for this operation, or your network configuration
     *         conflicts with the Amazon WorkSpaces management network IP range. For more information, see <a
     *         href="https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-vpc.html"> Configure a
     *         VPC for Amazon WorkSpaces</a>.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RegisterWorkspaceDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RegisterWorkspaceDirectory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RegisterWorkspaceDirectoryResponse registerWorkspaceDirectory(
            RegisterWorkspaceDirectoryRequest registerWorkspaceDirectoryRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, ResourceLimitExceededException, AccessDeniedException,
            WorkspacesDefaultRoleNotFoundException, InvalidResourceStateException, UnsupportedNetworkConfigurationException,
            OperationNotSupportedException, ResourceAlreadyExistsException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RegisterWorkspaceDirectoryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RegisterWorkspaceDirectoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(registerWorkspaceDirectoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerWorkspaceDirectoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterWorkspaceDirectory");

            return clientHandler
                    .execute(new ClientExecutionParams<RegisterWorkspaceDirectoryRequest, RegisterWorkspaceDirectoryResponse>()
                            .withOperationName("RegisterWorkspaceDirectory").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(registerWorkspaceDirectoryRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RegisterWorkspaceDirectoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Rejects the account link invitation.
     * </p>
     *
     * @param rejectAccountLinkInvitationRequest
     * @return Result of the RejectAccountLinkInvitation operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws ValidationException
     *         You either haven't provided a <code>TargetAccountId</code> or are using the same value for
     *         <code>TargetAccountId</code> and <code>SourceAccountId</code>.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ConflictException
     *         The <code>TargetAccountId</code> is already linked or invited.
     * @throws InternalServerException
     *         Unexpected server error occured.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RejectAccountLinkInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RejectAccountLinkInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RejectAccountLinkInvitationResponse rejectAccountLinkInvitation(
            RejectAccountLinkInvitationRequest rejectAccountLinkInvitationRequest) throws AccessDeniedException,
            ValidationException, ResourceNotFoundException, ConflictException, InternalServerException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RejectAccountLinkInvitationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RejectAccountLinkInvitationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(rejectAccountLinkInvitationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rejectAccountLinkInvitationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RejectAccountLinkInvitation");

            return clientHandler
                    .execute(new ClientExecutionParams<RejectAccountLinkInvitationRequest, RejectAccountLinkInvitationResponse>()
                            .withOperationName("RejectAccountLinkInvitation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(rejectAccountLinkInvitationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RejectAccountLinkInvitationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Restores the specified WorkSpace to its last known healthy state.
     * </p>
     * <p>
     * You cannot restore a WorkSpace unless its state is <code> AVAILABLE</code>, <code>ERROR</code>,
     * <code>UNHEALTHY</code>, or <code>STOPPED</code>.
     * </p>
     * <p>
     * Restoring a WorkSpace is a potentially destructive action that can result in the loss of data. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/restore-workspace.html">Restore a WorkSpace</a>.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpace is completely restored.
     * </p>
     *
     * @param restoreWorkspaceRequest
     * @return Result of the RestoreWorkspace operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RestoreWorkspace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RestoreWorkspace" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public RestoreWorkspaceResponse restoreWorkspace(RestoreWorkspaceRequest restoreWorkspaceRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, AccessDeniedException,
            OperationNotSupportedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RestoreWorkspaceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RestoreWorkspaceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(restoreWorkspaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, restoreWorkspaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestoreWorkspace");

            return clientHandler.execute(new ClientExecutionParams<RestoreWorkspaceRequest, RestoreWorkspaceResponse>()
                    .withOperationName("RestoreWorkspace").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(restoreWorkspaceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RestoreWorkspaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes one or more rules from the specified IP access control group.
     * </p>
     *
     * @param revokeIpRulesRequest
     * @return Result of the RevokeIpRules operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.RevokeIpRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RevokeIpRules" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public RevokeIpRulesResponse revokeIpRules(RevokeIpRulesRequest revokeIpRulesRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, InvalidResourceStateException, AccessDeniedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RevokeIpRulesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RevokeIpRulesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(revokeIpRulesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, revokeIpRulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RevokeIpRules");

            return clientHandler.execute(new ClientExecutionParams<RevokeIpRulesRequest, RevokeIpRulesResponse>()
                    .withOperationName("RevokeIpRules").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(revokeIpRulesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RevokeIpRulesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts the specified WorkSpaces.
     * </p>
     * <p>
     * You cannot start a WorkSpace unless it has a running mode of <code>AutoStop</code> or <code>Manual</code> and a
     * state of <code>STOPPED</code>.
     * </p>
     *
     * @param startWorkspacesRequest
     * @return Result of the StartWorkspaces operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.StartWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StartWorkspaces" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StartWorkspacesResponse startWorkspaces(StartWorkspacesRequest startWorkspacesRequest) throws AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartWorkspacesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartWorkspacesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startWorkspacesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startWorkspacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartWorkspaces");

            return clientHandler.execute(new ClientExecutionParams<StartWorkspacesRequest, StartWorkspacesResponse>()
                    .withOperationName("StartWorkspaces").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startWorkspacesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartWorkspacesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts the specified pool.
     * </p>
     * <p>
     * You cannot start a pool unless it has a running mode of <code>AutoStop</code> and a state of <code>STOPPED</code>
     * .
     * </p>
     *
     * @param startWorkspacesPoolRequest
     * @return Result of the StartWorkspacesPool operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws OperationInProgressException
     *         The properties of this WorkSpace are currently being modified. Try again in a moment.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.StartWorkspacesPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StartWorkspacesPool"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartWorkspacesPoolResponse startWorkspacesPool(StartWorkspacesPoolRequest startWorkspacesPoolRequest)
            throws InvalidParameterValuesException, InvalidResourceStateException, ResourceLimitExceededException,
            ResourceNotFoundException, OperationNotSupportedException, OperationInProgressException, AccessDeniedException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartWorkspacesPoolResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartWorkspacesPoolResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startWorkspacesPoolRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startWorkspacesPoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartWorkspacesPool");

            return clientHandler.execute(new ClientExecutionParams<StartWorkspacesPoolRequest, StartWorkspacesPoolResponse>()
                    .withOperationName("StartWorkspacesPool").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startWorkspacesPoolRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartWorkspacesPoolRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops the specified WorkSpaces.
     * </p>
     * <p>
     * You cannot stop a WorkSpace unless it has a running mode of <code>AutoStop</code> or <code>Manual</code> and a
     * state of <code>AVAILABLE</code>, <code>IMPAIRED</code>, <code>UNHEALTHY</code>, or <code>ERROR</code>.
     * </p>
     *
     * @param stopWorkspacesRequest
     * @return Result of the StopWorkspaces operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.StopWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StopWorkspaces" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StopWorkspacesResponse stopWorkspaces(StopWorkspacesRequest stopWorkspacesRequest) throws AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopWorkspacesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StopWorkspacesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopWorkspacesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopWorkspacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopWorkspaces");

            return clientHandler.execute(new ClientExecutionParams<StopWorkspacesRequest, StopWorkspacesResponse>()
                    .withOperationName("StopWorkspaces").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(stopWorkspacesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StopWorkspacesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops the specified pool.
     * </p>
     * <p>
     * You cannot stop a WorkSpace pool unless it has a running mode of <code>AutoStop</code> and a state of
     * <code>AVAILABLE</code>, <code>IMPAIRED</code>, <code>UNHEALTHY</code>, or <code>ERROR</code>.
     * </p>
     *
     * @param stopWorkspacesPoolRequest
     * @return Result of the StopWorkspacesPool operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationInProgressException
     *         The properties of this WorkSpace are currently being modified. Try again in a moment.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.StopWorkspacesPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StopWorkspacesPool" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StopWorkspacesPoolResponse stopWorkspacesPool(StopWorkspacesPoolRequest stopWorkspacesPoolRequest)
            throws InvalidParameterValuesException, InvalidResourceStateException, ResourceNotFoundException,
            OperationInProgressException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopWorkspacesPoolResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StopWorkspacesPoolResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopWorkspacesPoolRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopWorkspacesPoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopWorkspacesPool");

            return clientHandler.execute(new ClientExecutionParams<StopWorkspacesPoolRequest, StopWorkspacesPoolResponse>()
                    .withOperationName("StopWorkspacesPool").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(stopWorkspacesPoolRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StopWorkspacesPoolRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Terminates the specified WorkSpaces.
     * </p>
     * <important>
     * <p>
     * Terminating a WorkSpace is a permanent action and cannot be undone. The user's data is destroyed. If you need to
     * archive any user data, contact Amazon Web ServicesSupport before terminating the WorkSpace.
     * </p>
     * </important>
     * <p>
     * You can terminate a WorkSpace that is in any state except <code>SUSPENDED</code>.
     * </p>
     * <p>
     * This operation is asynchronous and returns before the WorkSpaces have been completely terminated. After a
     * WorkSpace is terminated, the <code>TERMINATED</code> state is returned only briefly before the WorkSpace
     * directory metadata is cleaned up, so this state is rarely returned. To confirm that a WorkSpace is terminated,
     * check for the WorkSpace ID by using <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html"> DescribeWorkSpaces</a>. If
     * the WorkSpace ID isn't returned, then the WorkSpace has been successfully terminated.
     * </p>
     * <note>
     * <p>
     * Simple AD and AD Connector are made available to you free of charge to use with WorkSpaces. If there are no
     * WorkSpaces being used with your Simple AD or AD Connector directory for 30 consecutive days, this directory will
     * be automatically deregistered for use with Amazon WorkSpaces, and you will be charged for this directory as per
     * the <a href="http://aws.amazon.com/directoryservice/pricing/">Directory Service pricing terms</a>.
     * </p>
     * <p>
     * To delete empty directories, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/delete-workspaces-directory.html"> Delete the
     * Directory for Your WorkSpaces</a>. If you delete your Simple AD or AD Connector directory, you can always create
     * a new one when you want to start using WorkSpaces again.
     * </p>
     * </note>
     *
     * @param terminateWorkspacesRequest
     * @return Result of the TerminateWorkspaces operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.TerminateWorkspaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspaces"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public TerminateWorkspacesResponse terminateWorkspaces(TerminateWorkspacesRequest terminateWorkspacesRequest)
            throws AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TerminateWorkspacesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, TerminateWorkspacesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(terminateWorkspacesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, terminateWorkspacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TerminateWorkspaces");

            return clientHandler.execute(new ClientExecutionParams<TerminateWorkspacesRequest, TerminateWorkspacesResponse>()
                    .withOperationName("TerminateWorkspaces").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(terminateWorkspacesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TerminateWorkspacesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Terminates the specified pool.
     * </p>
     *
     * @param terminateWorkspacesPoolRequest
     * @return Result of the TerminateWorkspacesPool operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationInProgressException
     *         The properties of this WorkSpace are currently being modified. Try again in a moment.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.TerminateWorkspacesPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspacesPool"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public TerminateWorkspacesPoolResponse terminateWorkspacesPool(TerminateWorkspacesPoolRequest terminateWorkspacesPoolRequest)
            throws InvalidParameterValuesException, InvalidResourceStateException, ResourceNotFoundException,
            OperationInProgressException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TerminateWorkspacesPoolResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, TerminateWorkspacesPoolResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(terminateWorkspacesPoolRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, terminateWorkspacesPoolRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TerminateWorkspacesPool");

            return clientHandler
                    .execute(new ClientExecutionParams<TerminateWorkspacesPoolRequest, TerminateWorkspacesPoolResponse>()
                            .withOperationName("TerminateWorkspacesPool").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(terminateWorkspacesPoolRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new TerminateWorkspacesPoolRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Terminates the pool session.
     * </p>
     *
     * @param terminateWorkspacesPoolSessionRequest
     * @return Result of the TerminateWorkspacesPoolSession operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws OperationInProgressException
     *         The properties of this WorkSpace are currently being modified. Try again in a moment.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.TerminateWorkspacesPoolSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspacesPoolSession"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public TerminateWorkspacesPoolSessionResponse terminateWorkspacesPoolSession(
            TerminateWorkspacesPoolSessionRequest terminateWorkspacesPoolSessionRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, OperationNotSupportedException, OperationInProgressException, AccessDeniedException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TerminateWorkspacesPoolSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, TerminateWorkspacesPoolSessionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(terminateWorkspacesPoolSessionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                terminateWorkspacesPoolSessionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TerminateWorkspacesPoolSession");

            return clientHandler
                    .execute(new ClientExecutionParams<TerminateWorkspacesPoolSessionRequest, TerminateWorkspacesPoolSessionResponse>()
                            .withOperationName("TerminateWorkspacesPoolSession").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(terminateWorkspacesPoolSessionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new TerminateWorkspacesPoolSessionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a Amazon Connect client add-in. Use this action to update the name and endpoint URL of a Amazon Connect
     * client add-in.
     * </p>
     *
     * @param updateConnectClientAddInRequest
     * @return Result of the UpdateConnectClientAddIn operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.UpdateConnectClientAddIn
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateConnectClientAddIn"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateConnectClientAddInResponse updateConnectClientAddIn(
            UpdateConnectClientAddInRequest updateConnectClientAddInRequest) throws InvalidParameterValuesException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateConnectClientAddInResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateConnectClientAddInResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateConnectClientAddInRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateConnectClientAddInRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateConnectClientAddIn");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateConnectClientAddInRequest, UpdateConnectClientAddInResponse>()
                            .withOperationName("UpdateConnectClientAddIn").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateConnectClientAddInRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateConnectClientAddInRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Shares or unshares a connection alias with one account by specifying whether that account has permission to
     * associate the connection alias with a directory. If the association permission is granted, the connection alias
     * is shared with that account. If the association permission is revoked, the connection alias is unshared with the
     * account. For more information, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html"> Cross-Region
     * Redirection for Amazon WorkSpaces</a>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * Before performing this operation, call <a
     * href="https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html">
     * DescribeConnectionAliases</a> to make sure that the current state of the connection alias is <code>CREATED</code>
     * .
     * </p>
     * </li>
     * <li>
     * <p>
     * To delete a connection alias that has been shared, the shared account must first disassociate the connection
     * alias from any directories it has been associated with. Then you must unshare the connection alias from the
     * account it has been shared with. You can delete a connection alias only after it is no longer shared with any
     * accounts or associated with any directories.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param updateConnectionAliasPermissionRequest
     * @return Result of the UpdateConnectionAliasPermission operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceAssociatedException
     *         The resource is associated with a directory.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.UpdateConnectionAliasPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateConnectionAliasPermission"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateConnectionAliasPermissionResponse updateConnectionAliasPermission(
            UpdateConnectionAliasPermissionRequest updateConnectionAliasPermissionRequest) throws AccessDeniedException,
            InvalidParameterValuesException, ResourceLimitExceededException, ResourceNotFoundException,
            ResourceAssociatedException, InvalidResourceStateException, OperationNotSupportedException, AwsServiceException,
            SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateConnectionAliasPermissionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateConnectionAliasPermissionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateConnectionAliasPermissionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateConnectionAliasPermissionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateConnectionAliasPermission");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateConnectionAliasPermissionRequest, UpdateConnectionAliasPermissionResponse>()
                            .withOperationName("UpdateConnectionAliasPermission").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateConnectionAliasPermissionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateConnectionAliasPermissionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Replaces the current rules of the specified IP access control group with the specified rules.
     * </p>
     *
     * @param updateRulesOfIpGroupRequest
     * @return Result of the UpdateRulesOfIpGroup operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.UpdateRulesOfIpGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateRulesOfIpGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateRulesOfIpGroupResponse updateRulesOfIpGroup(UpdateRulesOfIpGroupRequest updateRulesOfIpGroupRequest)
            throws InvalidParameterValuesException, ResourceNotFoundException, ResourceLimitExceededException,
            InvalidResourceStateException, AccessDeniedException, AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateRulesOfIpGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateRulesOfIpGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRulesOfIpGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRulesOfIpGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRulesOfIpGroup");

            return clientHandler.execute(new ClientExecutionParams<UpdateRulesOfIpGroupRequest, UpdateRulesOfIpGroupResponse>()
                    .withOperationName("UpdateRulesOfIpGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateRulesOfIpGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateRulesOfIpGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a WorkSpace bundle with a new image. For more information about updating WorkSpace bundles, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/update-custom-bundle.html"> Update a Custom
     * WorkSpaces Bundle</a>.
     * </p>
     * <important>
     * <p>
     * Existing WorkSpaces aren't automatically updated when you update the bundle that they're based on. To update
     * existing WorkSpaces that are based on a bundle that you've updated, you must either rebuild the WorkSpaces or
     * delete and recreate them.
     * </p>
     * </important>
     *
     * @param updateWorkspaceBundleRequest
     * @return Result of the UpdateWorkspaceBundle operation returned by the service.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.UpdateWorkspaceBundle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateWorkspaceBundle"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateWorkspaceBundleResponse updateWorkspaceBundle(UpdateWorkspaceBundleRequest updateWorkspaceBundleRequest)
            throws AccessDeniedException, InvalidParameterValuesException, ResourceNotFoundException,
            ResourceUnavailableException, OperationNotSupportedException, AwsServiceException, SdkClientException,
            WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateWorkspaceBundleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateWorkspaceBundleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateWorkspaceBundleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWorkspaceBundleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWorkspaceBundle");

            return clientHandler.execute(new ClientExecutionParams<UpdateWorkspaceBundleRequest, UpdateWorkspaceBundleResponse>()
                    .withOperationName("UpdateWorkspaceBundle").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateWorkspaceBundleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateWorkspaceBundleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Shares or unshares an image with one account in the same Amazon Web Services Region by specifying whether that
     * account has permission to copy the image. If the copy image permission is granted, the image is shared with that
     * account. If the copy image permission is revoked, the image is unshared with the account.
     * </p>
     * <p>
     * After an image has been shared, the recipient account can copy the image to other Regions as needed.
     * </p>
     * <p>
     * In the China (Ningxia) Region, you can copy images only within the same Region.
     * </p>
     * <p>
     * In Amazon Web Services GovCloud (US), to copy images to and from other Regions, contact Amazon Web
     * ServicesSupport.
     * </p>
     * <p>
     * For more information about sharing images, see <a
     * href="https://docs.aws.amazon.com/workspaces/latest/adminguide/share-custom-image.html"> Share or Unshare a
     * Custom WorkSpaces Image</a>.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * To delete an image that has been shared, you must unshare the image before you delete it.
     * </p>
     * </li>
     * <li>
     * <p>
     * Sharing Bring Your Own License (BYOL) images across Amazon Web Services accounts isn't supported at this time in
     * Amazon Web Services GovCloud (US). To share BYOL images across accounts in Amazon Web Services GovCloud (US),
     * contact Amazon Web ServicesSupport.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param updateWorkspaceImagePermissionRequest
     * @return Result of the UpdateWorkspaceImagePermission operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceUnavailableException
     *         The specified resource is not available.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.UpdateWorkspaceImagePermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateWorkspaceImagePermission"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateWorkspaceImagePermissionResponse updateWorkspaceImagePermission(
            UpdateWorkspaceImagePermissionRequest updateWorkspaceImagePermissionRequest) throws ResourceNotFoundException,
            ResourceUnavailableException, AccessDeniedException, InvalidParameterValuesException, OperationNotSupportedException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateWorkspaceImagePermissionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateWorkspaceImagePermissionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "InvalidParameterValuesException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterValuesException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterValuesException::builder).build());
            case "OperationInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationInProgressException::builder).build());
            case "ResourceUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceUnavailableException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "ResourceAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
            case "ResourceCreationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceCreationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceCreationFailedException::builder).build());
            case "ResourceLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build());
            case "OperatingSystemNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperatingSystemNotCompatibleException")
                        .httpStatusCode(400).exceptionBuilderSupplier(OperatingSystemNotCompatibleException::builder).build());
            case "UnsupportedWorkspaceConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedWorkspaceConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedWorkspaceConfigurationException::builder)
                        .build());
            case "IncompatibleApplicationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleApplicationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleApplicationsException::builder).build());
            case "UnsupportedNetworkConfigurationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedNetworkConfigurationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(UnsupportedNetworkConfigurationException::builder).build());
            case "ResourceInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceInUseException::builder).build());
            case "WorkspacesDefaultRoleNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("WorkspacesDefaultRoleNotFoundException")
                        .httpStatusCode(400).exceptionBuilderSupplier(WorkspacesDefaultRoleNotFoundException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "InvalidResourceStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidResourceStateException::builder).build());
            case "InvalidParameterCombinationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException")
                        .httpStatusCode(400).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateWorkspaceImagePermissionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateWorkspaceImagePermissionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWorkspaceImagePermission");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateWorkspaceImagePermissionRequest, UpdateWorkspaceImagePermissionResponse>()
                            .withOperationName("UpdateWorkspaceImagePermission").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateWorkspaceImagePermissionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateWorkspaceImagePermissionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the specified pool.
     * </p>
     *
     * @param updateWorkspacesPoolRequest
     * @return Result of the UpdateWorkspacesPool operation returned by the service.
     * @throws InvalidParameterValuesException
     *         One or more parameter values are not valid.
     * @throws InvalidResourceStateException
     *         The state of the resource is not valid for this operation.
     * @throws ResourceNotFoundException
     *         The resource could not be found.
     * @throws ResourceLimitExceededException
     *         Your resource limits have been exceeded.
     * @throws OperationNotSupportedException
     *         This operation is not supported.
     * @throws OperationInProgressException
     *         The properties of this WorkSpace are currently being modified. Try again in a moment.
     * @throws AccessDeniedException
     *         The user is not authorized to access a resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesClient.UpdateWorkspacesPool
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateWorkspacesPool"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateWorkspacesPoolResponse updateWorkspacesPool(UpdateWorkspacesPoolRequest updateWorkspacesPoolRequest)
            throws InvalidParameterValuesException, InvalidResourceStateException, ResourceNotFoundException,
            ResourceLimitExceededException, OperationNotSupportedException, OperationInProgressException, AccessDeniedException,
            AwsServiceException, SdkClientException, WorkSpacesException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateWorkspacesPoolResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateWorkspacesPoolResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "OperationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OperationNotSupportedException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ComputeNotCompatibleException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ComputeNotCompatibleException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ComputeNotCompatibleException::builder).build());
            case "ApplicationNotSupportedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ApplicationNotSupportedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ApplicationNotSupportedException::builder).build());
            case "ResourceAssociatedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceAssociatedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceAssociatedException::builder).build());
            case "ResourceNotFoundException":
                return O