/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspaces.model.CertificateBasedAuthProperties;
import software.amazon.awssdk.services.workspaces.model.DeletableCertificateBasedAuthPropertiesListCopier;
import software.amazon.awssdk.services.workspaces.model.DeletableCertificateBasedAuthProperty;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyCertificateBasedAuthPropertiesRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, ModifyCertificateBasedAuthPropertiesRequest> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(ModifyCertificateBasedAuthPropertiesRequest.getter(ModifyCertificateBasedAuthPropertiesRequest::resourceId)).setter(ModifyCertificateBasedAuthPropertiesRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final SdkField<CertificateBasedAuthProperties> CERTIFICATE_BASED_AUTH_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CertificateBasedAuthProperties").getter(ModifyCertificateBasedAuthPropertiesRequest.getter(ModifyCertificateBasedAuthPropertiesRequest::certificateBasedAuthProperties)).setter(ModifyCertificateBasedAuthPropertiesRequest.setter(Builder::certificateBasedAuthProperties)).constructor(CertificateBasedAuthProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateBasedAuthProperties").build()}).build();
    private static final SdkField<List<String>> PROPERTIES_TO_DELETE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PropertiesToDelete").getter(ModifyCertificateBasedAuthPropertiesRequest.getter(ModifyCertificateBasedAuthPropertiesRequest::propertiesToDeleteAsStrings)).setter(ModifyCertificateBasedAuthPropertiesRequest.setter(Builder::propertiesToDeleteWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertiesToDelete").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD, CERTIFICATE_BASED_AUTH_PROPERTIES_FIELD, PROPERTIES_TO_DELETE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyCertificateBasedAuthPropertiesRequest.memberNameToFieldInitializer();
    private final String resourceId;
    private final CertificateBasedAuthProperties certificateBasedAuthProperties;
    private final List<String> propertiesToDelete;

    private ModifyCertificateBasedAuthPropertiesRequest(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.certificateBasedAuthProperties = builder.certificateBasedAuthProperties;
        this.propertiesToDelete = builder.propertiesToDelete;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final CertificateBasedAuthProperties certificateBasedAuthProperties() {
        return this.certificateBasedAuthProperties;
    }

    public final List<DeletableCertificateBasedAuthProperty> propertiesToDelete() {
        return DeletableCertificateBasedAuthPropertiesListCopier.copyStringToEnum(this.propertiesToDelete);
    }

    public final boolean hasPropertiesToDelete() {
        return this.propertiesToDelete != null && !(this.propertiesToDelete instanceof SdkAutoConstructList);
    }

    public final List<String> propertiesToDeleteAsStrings() {
        return this.propertiesToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateBasedAuthProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropertiesToDelete() ? this.propertiesToDeleteAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCertificateBasedAuthPropertiesRequest)) {
            return false;
        }
        ModifyCertificateBasedAuthPropertiesRequest other = (ModifyCertificateBasedAuthPropertiesRequest)((Object)obj);
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.certificateBasedAuthProperties(), other.certificateBasedAuthProperties()) && this.hasPropertiesToDelete() == other.hasPropertiesToDelete() && Objects.equals(this.propertiesToDeleteAsStrings(), other.propertiesToDeleteAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyCertificateBasedAuthPropertiesRequest").add("ResourceId", (Object)this.resourceId()).add("CertificateBasedAuthProperties", (Object)this.certificateBasedAuthProperties()).add("PropertiesToDelete", this.hasPropertiesToDelete() ? this.propertiesToDeleteAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "CertificateBasedAuthProperties": {
                return Optional.ofNullable(clazz.cast(this.certificateBasedAuthProperties()));
            }
            case "PropertiesToDelete": {
                return Optional.ofNullable(clazz.cast(this.propertiesToDeleteAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("CertificateBasedAuthProperties", CERTIFICATE_BASED_AUTH_PROPERTIES_FIELD);
        map.put("PropertiesToDelete", PROPERTIES_TO_DELETE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyCertificateBasedAuthPropertiesRequest, T> g) {
        return obj -> g.apply((ModifyCertificateBasedAuthPropertiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private String resourceId;
        private CertificateBasedAuthProperties certificateBasedAuthProperties;
        private List<String> propertiesToDelete = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyCertificateBasedAuthPropertiesRequest model) {
            super(model);
            this.resourceId(model.resourceId);
            this.certificateBasedAuthProperties(model.certificateBasedAuthProperties);
            this.propertiesToDeleteWithStrings(model.propertiesToDelete);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final CertificateBasedAuthProperties.Builder getCertificateBasedAuthProperties() {
            return this.certificateBasedAuthProperties != null ? this.certificateBasedAuthProperties.toBuilder() : null;
        }

        public final void setCertificateBasedAuthProperties(CertificateBasedAuthProperties.BuilderImpl certificateBasedAuthProperties) {
            this.certificateBasedAuthProperties = certificateBasedAuthProperties != null ? certificateBasedAuthProperties.build() : null;
        }

        @Override
        public final Builder certificateBasedAuthProperties(CertificateBasedAuthProperties certificateBasedAuthProperties) {
            this.certificateBasedAuthProperties = certificateBasedAuthProperties;
            return this;
        }

        public final Collection<String> getPropertiesToDelete() {
            if (this.propertiesToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return this.propertiesToDelete;
        }

        public final void setPropertiesToDelete(Collection<String> propertiesToDelete) {
            this.propertiesToDelete = DeletableCertificateBasedAuthPropertiesListCopier.copy(propertiesToDelete);
        }

        @Override
        public final Builder propertiesToDeleteWithStrings(Collection<String> propertiesToDelete) {
            this.propertiesToDelete = DeletableCertificateBasedAuthPropertiesListCopier.copy(propertiesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertiesToDeleteWithStrings(String ... propertiesToDelete) {
            this.propertiesToDeleteWithStrings(Arrays.asList(propertiesToDelete));
            return this;
        }

        @Override
        public final Builder propertiesToDelete(Collection<DeletableCertificateBasedAuthProperty> propertiesToDelete) {
            this.propertiesToDelete = DeletableCertificateBasedAuthPropertiesListCopier.copyEnumToString(propertiesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertiesToDelete(DeletableCertificateBasedAuthProperty ... propertiesToDelete) {
            this.propertiesToDelete(Arrays.asList(propertiesToDelete));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyCertificateBasedAuthPropertiesRequest build() {
            return new ModifyCertificateBasedAuthPropertiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyCertificateBasedAuthPropertiesRequest> {
        public Builder resourceId(String var1);

        public Builder certificateBasedAuthProperties(CertificateBasedAuthProperties var1);

        default public Builder certificateBasedAuthProperties(Consumer<CertificateBasedAuthProperties.Builder> certificateBasedAuthProperties) {
            return this.certificateBasedAuthProperties((CertificateBasedAuthProperties)((CertificateBasedAuthProperties.Builder)CertificateBasedAuthProperties.builder().applyMutation(certificateBasedAuthProperties)).build());
        }

        public Builder propertiesToDeleteWithStrings(Collection<String> var1);

        public Builder propertiesToDeleteWithStrings(String ... var1);

        public Builder propertiesToDelete(Collection<DeletableCertificateBasedAuthProperty> var1);

        public Builder propertiesToDelete(DeletableCertificateBasedAuthProperty ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

