/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WorkspacesPoolState {
    CREATING("CREATING"),
    DELETING("DELETING"),
    RUNNING("RUNNING"),
    STARTING("STARTING"),
    STOPPED("STOPPED"),
    STOPPING("STOPPING"),
    UPDATING("UPDATING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WorkspacesPoolState> VALUE_MAP;
    private final String value;

    private WorkspacesPoolState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WorkspacesPoolState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WorkspacesPoolState> knownValues() {
        EnumSet<WorkspacesPoolState> knownValues = EnumSet.allOf(WorkspacesPoolState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WorkspacesPoolState.class, WorkspacesPoolState::toString);
    }
}

