/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspaces.model.WorkSpacesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeWorkspacesPoolSessionsRequest
extends WorkSpacesRequest
implements ToCopyableBuilder<Builder, DescribeWorkspacesPoolSessionsRequest> {
    private static final SdkField<String> POOL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PoolId").getter(DescribeWorkspacesPoolSessionsRequest.getter(DescribeWorkspacesPoolSessionsRequest::poolId)).setter(DescribeWorkspacesPoolSessionsRequest.setter(Builder::poolId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PoolId").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(DescribeWorkspacesPoolSessionsRequest.getter(DescribeWorkspacesPoolSessionsRequest::userId)).setter(DescribeWorkspacesPoolSessionsRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Limit").getter(DescribeWorkspacesPoolSessionsRequest.getter(DescribeWorkspacesPoolSessionsRequest::limit)).setter(DescribeWorkspacesPoolSessionsRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeWorkspacesPoolSessionsRequest.getter(DescribeWorkspacesPoolSessionsRequest::nextToken)).setter(DescribeWorkspacesPoolSessionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POOL_ID_FIELD, USER_ID_FIELD, LIMIT_FIELD, NEXT_TOKEN_FIELD));
    private final String poolId;
    private final String userId;
    private final Integer limit;
    private final String nextToken;

    private DescribeWorkspacesPoolSessionsRequest(BuilderImpl builder) {
        super(builder);
        this.poolId = builder.poolId;
        this.userId = builder.userId;
        this.limit = builder.limit;
        this.nextToken = builder.nextToken;
    }

    public final String poolId() {
        return this.poolId;
    }

    public final String userId() {
        return this.userId;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.poolId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWorkspacesPoolSessionsRequest)) {
            return false;
        }
        DescribeWorkspacesPoolSessionsRequest other = (DescribeWorkspacesPoolSessionsRequest)((Object)obj);
        return Objects.equals(this.poolId(), other.poolId()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.limit(), other.limit()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeWorkspacesPoolSessionsRequest").add("PoolId", (Object)this.poolId()).add("UserId", (Object)this.userId()).add("Limit", (Object)this.limit()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PoolId": {
                return Optional.ofNullable(clazz.cast(this.poolId()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeWorkspacesPoolSessionsRequest, T> g) {
        return obj -> g.apply((DescribeWorkspacesPoolSessionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesRequest.BuilderImpl
    implements Builder {
        private String poolId;
        private String userId;
        private Integer limit;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWorkspacesPoolSessionsRequest model) {
            super(model);
            this.poolId(model.poolId);
            this.userId(model.userId);
            this.limit(model.limit);
            this.nextToken(model.nextToken);
        }

        public final String getPoolId() {
            return this.poolId;
        }

        public final void setPoolId(String poolId) {
            this.poolId = poolId;
        }

        @Override
        public final Builder poolId(String poolId) {
            this.poolId = poolId;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeWorkspacesPoolSessionsRequest build() {
            return new DescribeWorkspacesPoolSessionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkSpacesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeWorkspacesPoolSessionsRequest> {
        public Builder poolId(String var1);

        public Builder userId(String var1);

        public Builder limit(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

