/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OperatingSystemType {
    WINDOWS("WINDOWS"),
    LINUX("LINUX"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OperatingSystemType> VALUE_MAP;
    private final String value;

    private OperatingSystemType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OperatingSystemType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OperatingSystemType> knownValues() {
        EnumSet<OperatingSystemType> knownValues = EnumSet.allOf(OperatingSystemType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OperatingSystemType.class, OperatingSystemType::toString);
    }
}

