/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workmail.model.JobsCopier;
import software.amazon.awssdk.services.workmail.model.MailboxExportJob;
import software.amazon.awssdk.services.workmail.model.WorkMailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMailboxExportJobsResponse
extends WorkMailResponse
implements ToCopyableBuilder<Builder, ListMailboxExportJobsResponse> {
    private static final SdkField<List<MailboxExportJob>> JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Jobs").getter(ListMailboxExportJobsResponse.getter(ListMailboxExportJobsResponse::jobs)).setter(ListMailboxExportJobsResponse.setter(Builder::jobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Jobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MailboxExportJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMailboxExportJobsResponse.getter(ListMailboxExportJobsResponse::nextToken)).setter(ListMailboxExportJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOBS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Jobs", JOBS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<MailboxExportJob> jobs;
    private final String nextToken;

    private ListMailboxExportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.jobs = builder.jobs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasJobs() {
        return this.jobs != null && !(this.jobs instanceof SdkAutoConstructList);
    }

    public final List<MailboxExportJob> jobs() {
        return this.jobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasJobs() ? this.jobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMailboxExportJobsResponse)) {
            return false;
        }
        ListMailboxExportJobsResponse other = (ListMailboxExportJobsResponse)((Object)obj);
        return this.hasJobs() == other.hasJobs() && Objects.equals(this.jobs(), other.jobs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListMailboxExportJobsResponse").add("Jobs", this.hasJobs() ? this.jobs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Jobs": {
                return Optional.ofNullable(clazz.cast(this.jobs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListMailboxExportJobsResponse, T> g) {
        return obj -> g.apply((ListMailboxExportJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailResponse.BuilderImpl
    implements Builder {
        private List<MailboxExportJob> jobs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMailboxExportJobsResponse model) {
            super(model);
            this.jobs(model.jobs);
            this.nextToken(model.nextToken);
        }

        public final List<MailboxExportJob.Builder> getJobs() {
            List<MailboxExportJob.Builder> result = JobsCopier.copyToBuilder(this.jobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setJobs(Collection<MailboxExportJob.BuilderImpl> jobs) {
            this.jobs = JobsCopier.copyFromBuilder(jobs);
        }

        @Override
        public final Builder jobs(Collection<MailboxExportJob> jobs) {
            this.jobs = JobsCopier.copy(jobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(MailboxExportJob ... jobs) {
            this.jobs(Arrays.asList(jobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(Consumer<MailboxExportJob.Builder> ... jobs) {
            this.jobs(Stream.of(jobs).map(c -> (MailboxExportJob)((MailboxExportJob.Builder)MailboxExportJob.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMailboxExportJobsResponse build() {
            return new ListMailboxExportJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends WorkMailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMailboxExportJobsResponse> {
        public Builder jobs(Collection<MailboxExportJob> var1);

        public Builder jobs(MailboxExportJob ... var1);

        public Builder jobs(Consumer<MailboxExportJob.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

