/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workmail.model.ResourceType;
import software.amazon.awssdk.services.workmail.model.WorkMailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateResourceRequest
extends WorkMailRequest
implements ToCopyableBuilder<Builder, CreateResourceRequest> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrganizationId").getter(CreateResourceRequest.getter(CreateResourceRequest::organizationId)).setter(CreateResourceRequest.setter(Builder::organizationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateResourceRequest.getter(CreateResourceRequest::name)).setter(CreateResourceRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CreateResourceRequest.getter(CreateResourceRequest::typeAsString)).setter(CreateResourceRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateResourceRequest.getter(CreateResourceRequest::description)).setter(CreateResourceRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Boolean> HIDDEN_FROM_GLOBAL_ADDRESS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HiddenFromGlobalAddressList").getter(CreateResourceRequest.getter(CreateResourceRequest::hiddenFromGlobalAddressList)).setter(CreateResourceRequest.setter(Builder::hiddenFromGlobalAddressList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HiddenFromGlobalAddressList").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD, NAME_FIELD, TYPE_FIELD, DESCRIPTION_FIELD, HIDDEN_FROM_GLOBAL_ADDRESS_LIST_FIELD));
    private final String organizationId;
    private final String name;
    private final String type;
    private final String description;
    private final Boolean hiddenFromGlobalAddressList;

    private CreateResourceRequest(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.name = builder.name;
        this.type = builder.type;
        this.description = builder.description;
        this.hiddenFromGlobalAddressList = builder.hiddenFromGlobalAddressList;
    }

    public final String organizationId() {
        return this.organizationId;
    }

    public final String name() {
        return this.name;
    }

    public final ResourceType type() {
        return ResourceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean hiddenFromGlobalAddressList() {
        return this.hiddenFromGlobalAddressList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hiddenFromGlobalAddressList());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateResourceRequest)) {
            return false;
        }
        CreateResourceRequest other = (CreateResourceRequest)((Object)obj);
        return Objects.equals(this.organizationId(), other.organizationId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.hiddenFromGlobalAddressList(), other.hiddenFromGlobalAddressList());
    }

    public final String toString() {
        return ToString.builder((String)"CreateResourceRequest").add("OrganizationId", (Object)this.organizationId()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("HiddenFromGlobalAddressList", (Object)this.hiddenFromGlobalAddressList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationId": {
                return Optional.ofNullable(clazz.cast(this.organizationId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "HiddenFromGlobalAddressList": {
                return Optional.ofNullable(clazz.cast(this.hiddenFromGlobalAddressList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateResourceRequest, T> g) {
        return obj -> g.apply((CreateResourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailRequest.BuilderImpl
    implements Builder {
        private String organizationId;
        private String name;
        private String type;
        private String description;
        private Boolean hiddenFromGlobalAddressList;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateResourceRequest model) {
            super(model);
            this.organizationId(model.organizationId);
            this.name(model.name);
            this.type(model.type);
            this.description(model.description);
            this.hiddenFromGlobalAddressList(model.hiddenFromGlobalAddressList);
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ResourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getHiddenFromGlobalAddressList() {
            return this.hiddenFromGlobalAddressList;
        }

        public final void setHiddenFromGlobalAddressList(Boolean hiddenFromGlobalAddressList) {
            this.hiddenFromGlobalAddressList = hiddenFromGlobalAddressList;
        }

        @Override
        public final Builder hiddenFromGlobalAddressList(Boolean hiddenFromGlobalAddressList) {
            this.hiddenFromGlobalAddressList = hiddenFromGlobalAddressList;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateResourceRequest build() {
            return new CreateResourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkMailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateResourceRequest> {
        public Builder organizationId(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(ResourceType var1);

        public Builder description(String var1);

        public Builder hiddenFromGlobalAddressList(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

