/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workmail.WorkMailClient;
import software.amazon.awssdk.services.workmail.internal.UserAgentUtils;
import software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsRequest;
import software.amazon.awssdk.services.workmail.model.ListMailboxExportJobsResponse;

public class ListMailboxExportJobsIterable
implements SdkIterable<ListMailboxExportJobsResponse> {
    private final WorkMailClient client;
    private final ListMailboxExportJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMailboxExportJobsIterable(WorkMailClient client, ListMailboxExportJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMailboxExportJobsResponseFetcher();
    }

    public Iterator<ListMailboxExportJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListMailboxExportJobsResponseFetcher
    implements SyncPageFetcher<ListMailboxExportJobsResponse> {
        private ListMailboxExportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListMailboxExportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMailboxExportJobsResponse nextPage(ListMailboxExportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListMailboxExportJobsIterable.this.client.listMailboxExportJobs(ListMailboxExportJobsIterable.this.firstRequest);
            }
            return ListMailboxExportJobsIterable.this.client.listMailboxExportJobs((ListMailboxExportJobsRequest)((Object)ListMailboxExportJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

