/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AvailabilityProviderType {
    EWS("EWS"),
    LAMBDA("LAMBDA"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AvailabilityProviderType> VALUE_MAP;
    private final String value;

    private AvailabilityProviderType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AvailabilityProviderType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AvailabilityProviderType> knownValues() {
        EnumSet<AvailabilityProviderType> knownValues = EnumSet.allOf(AvailabilityProviderType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AvailabilityProviderType.class, AvailabilityProviderType::toString);
    }
}

