/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workmail.WorkMailClient;
import software.amazon.awssdk.services.workmail.model.ListAliasesRequest;
import software.amazon.awssdk.services.workmail.model.ListAliasesResponse;

public class ListAliasesIterable
implements SdkIterable<ListAliasesResponse> {
    private final WorkMailClient client;
    private final ListAliasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAliasesIterable(WorkMailClient client, ListAliasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAliasesResponseFetcher();
    }

    public Iterator<ListAliasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListAliasesResponseFetcher
    implements SyncPageFetcher<ListAliasesResponse> {
        private ListAliasesResponseFetcher() {
        }

        public boolean hasNextPage(ListAliasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAliasesResponse nextPage(ListAliasesResponse previousPage) {
            if (previousPage == null) {
                return ListAliasesIterable.this.client.listAliases(ListAliasesIterable.this.firstRequest);
            }
            return ListAliasesIterable.this.client.listAliases((ListAliasesRequest)((Object)ListAliasesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

