/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OrganizationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OrganizationSummary> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OrganizationSummary.getter(OrganizationSummary::organizationId)).setter(OrganizationSummary.setter(Builder::organizationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()}).build();
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OrganizationSummary.getter(OrganizationSummary::alias)).setter(OrganizationSummary.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alias").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OrganizationSummary.getter(OrganizationSummary::errorMessage)).setter(OrganizationSummary.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OrganizationSummary.getter(OrganizationSummary::state)).setter(OrganizationSummary.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD, ALIAS_FIELD, ERROR_MESSAGE_FIELD, STATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String organizationId;
    private final String alias;
    private final String errorMessage;
    private final String state;

    private OrganizationSummary(BuilderImpl builder) {
        this.organizationId = builder.organizationId;
        this.alias = builder.alias;
        this.errorMessage = builder.errorMessage;
        this.state = builder.state;
    }

    public String organizationId() {
        return this.organizationId;
    }

    public String alias() {
        return this.alias;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public String state() {
        return this.state;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrganizationSummary)) {
            return false;
        }
        OrganizationSummary other = (OrganizationSummary)obj;
        return Objects.equals(this.organizationId(), other.organizationId()) && Objects.equals(this.alias(), other.alias()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.state(), other.state());
    }

    public String toString() {
        return ToString.builder((String)"OrganizationSummary").add("OrganizationId", (Object)this.organizationId()).add("Alias", (Object)this.alias()).add("ErrorMessage", (Object)this.errorMessage()).add("State", (Object)this.state()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrganizationId": {
                return Optional.ofNullable(clazz.cast(this.organizationId()));
            }
            case "Alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OrganizationSummary, T> g) {
        return obj -> g.apply((OrganizationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String organizationId;
        private String alias;
        private String errorMessage;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(OrganizationSummary model) {
            this.organizationId(model.organizationId);
            this.alias(model.alias);
            this.errorMessage(model.errorMessage);
            this.state(model.state);
        }

        public final String getOrganizationId() {
            return this.organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public final String getAlias() {
            return this.alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public OrganizationSummary build() {
            return new OrganizationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OrganizationSummary> {
        public Builder organizationId(String var1);

        public Builder alias(String var1);

        public Builder errorMessage(String var1);

        public Builder state(String var1);
    }
}

