/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workmail.model.EntityState;
import software.amazon.awssdk.services.workmail.model.UserRole;
import software.amazon.awssdk.services.workmail.model.WorkMailResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeUserResponse
extends WorkMailResponse
implements ToCopyableBuilder<Builder, DescribeUserResponse> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeUserResponse.getter(DescribeUserResponse::userId)).setter(DescribeUserResponse.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeUserResponse.getter(DescribeUserResponse::name)).setter(DescribeUserResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeUserResponse.getter(DescribeUserResponse::email)).setter(DescribeUserResponse.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeUserResponse.getter(DescribeUserResponse::displayName)).setter(DescribeUserResponse.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeUserResponse.getter(DescribeUserResponse::stateAsString)).setter(DescribeUserResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> USER_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeUserResponse.getter(DescribeUserResponse::userRoleAsString)).setter(DescribeUserResponse.setter(Builder::userRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserRole").build()}).build();
    private static final SdkField<Instant> ENABLED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeUserResponse.getter(DescribeUserResponse::enabledDate)).setter(DescribeUserResponse.setter(Builder::enabledDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledDate").build()}).build();
    private static final SdkField<Instant> DISABLED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeUserResponse.getter(DescribeUserResponse::disabledDate)).setter(DescribeUserResponse.setter(Builder::disabledDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisabledDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD, NAME_FIELD, EMAIL_FIELD, DISPLAY_NAME_FIELD, STATE_FIELD, USER_ROLE_FIELD, ENABLED_DATE_FIELD, DISABLED_DATE_FIELD));
    private final String userId;
    private final String name;
    private final String email;
    private final String displayName;
    private final String state;
    private final String userRole;
    private final Instant enabledDate;
    private final Instant disabledDate;

    private DescribeUserResponse(BuilderImpl builder) {
        super(builder);
        this.userId = builder.userId;
        this.name = builder.name;
        this.email = builder.email;
        this.displayName = builder.displayName;
        this.state = builder.state;
        this.userRole = builder.userRole;
        this.enabledDate = builder.enabledDate;
        this.disabledDate = builder.disabledDate;
    }

    public String userId() {
        return this.userId;
    }

    public String name() {
        return this.name;
    }

    public String email() {
        return this.email;
    }

    public String displayName() {
        return this.displayName;
    }

    public EntityState state() {
        return EntityState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public UserRole userRole() {
        return UserRole.fromValue(this.userRole);
    }

    public String userRoleAsString() {
        return this.userRole;
    }

    public Instant enabledDate() {
        return this.enabledDate;
    }

    public Instant disabledDate() {
        return this.disabledDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabledDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.disabledDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserResponse)) {
            return false;
        }
        DescribeUserResponse other = (DescribeUserResponse)((Object)obj);
        return Objects.equals(this.userId(), other.userId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.email(), other.email()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.userRoleAsString(), other.userRoleAsString()) && Objects.equals(this.enabledDate(), other.enabledDate()) && Objects.equals(this.disabledDate(), other.disabledDate());
    }

    public String toString() {
        return ToString.builder((String)"DescribeUserResponse").add("UserId", (Object)this.userId()).add("Name", (Object)this.name()).add("Email", (Object)this.email()).add("DisplayName", (Object)this.displayName()).add("State", (Object)this.stateAsString()).add("UserRole", (Object)this.userRoleAsString()).add("EnabledDate", (Object)this.enabledDate()).add("DisabledDate", (Object)this.disabledDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "UserRole": {
                return Optional.ofNullable(clazz.cast(this.userRoleAsString()));
            }
            case "EnabledDate": {
                return Optional.ofNullable(clazz.cast(this.enabledDate()));
            }
            case "DisabledDate": {
                return Optional.ofNullable(clazz.cast(this.disabledDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUserResponse, T> g) {
        return obj -> g.apply((DescribeUserResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkMailResponse.BuilderImpl
    implements Builder {
        private String userId;
        private String name;
        private String email;
        private String displayName;
        private String state;
        private String userRole;
        private Instant enabledDate;
        private Instant disabledDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserResponse model) {
            super(model);
            this.userId(model.userId);
            this.name(model.name);
            this.email(model.email);
            this.displayName(model.displayName);
            this.state(model.state);
            this.userRole(model.userRole);
            this.enabledDate(model.enabledDate);
            this.disabledDate(model.disabledDate);
        }

        public final String getUserId() {
            return this.userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getEmail() {
            return this.email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(EntityState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getUserRole() {
            return this.userRole;
        }

        @Override
        public final Builder userRole(String userRole) {
            this.userRole = userRole;
            return this;
        }

        @Override
        public final Builder userRole(UserRole userRole) {
            this.userRole(userRole == null ? null : userRole.toString());
            return this;
        }

        public final void setUserRole(String userRole) {
            this.userRole = userRole;
        }

        public final Instant getEnabledDate() {
            return this.enabledDate;
        }

        @Override
        public final Builder enabledDate(Instant enabledDate) {
            this.enabledDate = enabledDate;
            return this;
        }

        public final void setEnabledDate(Instant enabledDate) {
            this.enabledDate = enabledDate;
        }

        public final Instant getDisabledDate() {
            return this.disabledDate;
        }

        @Override
        public final Builder disabledDate(Instant disabledDate) {
            this.disabledDate = disabledDate;
            return this;
        }

        public final void setDisabledDate(Instant disabledDate) {
            this.disabledDate = disabledDate;
        }

        @Override
        public DescribeUserResponse build() {
            return new DescribeUserResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends WorkMailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeUserResponse> {
        public Builder userId(String var1);

        public Builder name(String var1);

        public Builder email(String var1);

        public Builder displayName(String var1);

        public Builder state(String var1);

        public Builder state(EntityState var1);

        public Builder userRole(String var1);

        public Builder userRole(UserRole var1);

        public Builder enabledDate(Instant var1);

        public Builder disabledDate(Instant var1);
    }
}

