/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutMailboxPermissionsRequest extends WorkMailRequest implements
        ToCopyableBuilder<PutMailboxPermissionsRequest.Builder, PutMailboxPermissionsRequest> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutMailboxPermissionsRequest::organizationId)).setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()).build();

    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutMailboxPermissionsRequest::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()).build();

    private static final SdkField<String> GRANTEE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutMailboxPermissionsRequest::granteeId)).setter(setter(Builder::granteeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GranteeId").build()).build();

    private static final SdkField<List<String>> PERMISSION_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(PutMailboxPermissionsRequest::permissionValuesAsStrings))
            .setter(setter(Builder::permissionValuesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD,
            ENTITY_ID_FIELD, GRANTEE_ID_FIELD, PERMISSION_VALUES_FIELD));

    private final String organizationId;

    private final String entityId;

    private final String granteeId;

    private final List<String> permissionValues;

    private PutMailboxPermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.entityId = builder.entityId;
        this.granteeId = builder.granteeId;
        this.permissionValues = builder.permissionValues;
    }

    /**
     * <p>
     * The identifier of the organization under which the user, group, or resource exists.
     * </p>
     * 
     * @return The identifier of the organization under which the user, group, or resource exists.
     */
    public String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * The identifier of the user, group, or resource for which to update mailbox permissions.
     * </p>
     * 
     * @return The identifier of the user, group, or resource for which to update mailbox permissions.
     */
    public String entityId() {
        return entityId;
    }

    /**
     * <p>
     * The identifier of the user, group, or resource to which to grant the permissions.
     * </p>
     * 
     * @return The identifier of the user, group, or resource to which to grant the permissions.
     */
    public String granteeId() {
        return granteeId;
    }

    /**
     * <p>
     * The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox (the
     * grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of the owner
     * of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS allows the
     * grantee full access to the mailbox, irrespective of other folder-level permissions set on the mailbox.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPermissionValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the
     *         mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email
     *         on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of these
     *         emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other folder-level
     *         permissions set on the mailbox.
     */
    public List<PermissionType> permissionValues() {
        return PermissionValuesCopier.copyStringToEnum(permissionValues);
    }

    /**
     * Returns true if the PermissionValues property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasPermissionValues() {
        return permissionValues != null && !(permissionValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox (the
     * grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of the owner
     * of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS allows the
     * grantee full access to the mailbox, irrespective of other folder-level permissions set on the mailbox.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPermissionValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the
     *         mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email
     *         on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of these
     *         emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other folder-level
     *         permissions set on the mailbox.
     */
    public List<String> permissionValuesAsStrings() {
        return permissionValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(granteeId());
        hashCode = 31 * hashCode + Objects.hashCode(permissionValuesAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMailboxPermissionsRequest)) {
            return false;
        }
        PutMailboxPermissionsRequest other = (PutMailboxPermissionsRequest) obj;
        return Objects.equals(organizationId(), other.organizationId()) && Objects.equals(entityId(), other.entityId())
                && Objects.equals(granteeId(), other.granteeId())
                && Objects.equals(permissionValuesAsStrings(), other.permissionValuesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutMailboxPermissionsRequest").add("OrganizationId", organizationId())
                .add("EntityId", entityId()).add("GranteeId", granteeId()).add("PermissionValues", permissionValuesAsStrings())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "EntityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "GranteeId":
            return Optional.ofNullable(clazz.cast(granteeId()));
        case "PermissionValues":
            return Optional.ofNullable(clazz.cast(permissionValuesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutMailboxPermissionsRequest, T> g) {
        return obj -> g.apply((PutMailboxPermissionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutMailboxPermissionsRequest> {
        /**
         * <p>
         * The identifier of the organization under which the user, group, or resource exists.
         * </p>
         * 
         * @param organizationId
         *        The identifier of the organization under which the user, group, or resource exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * The identifier of the user, group, or resource for which to update mailbox permissions.
         * </p>
         * 
         * @param entityId
         *        The identifier of the user, group, or resource for which to update mailbox permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * The identifier of the user, group, or resource to which to grant the permissions.
         * </p>
         * 
         * @param granteeId
         *        The identifier of the user, group, or resource to which to grant the permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder granteeId(String granteeId);

        /**
         * <p>
         * The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox
         * (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of
         * the owner of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS
         * allows the grantee full access to the mailbox, irrespective of other folder-level permissions set on the
         * mailbox.
         * </p>
         * 
         * @param permissionValues
         *        The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the
         *        mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send
         *        email on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of
         *        these emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other
         *        folder-level permissions set on the mailbox.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionValuesWithStrings(Collection<String> permissionValues);

        /**
         * <p>
         * The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox
         * (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of
         * the owner of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS
         * allows the grantee full access to the mailbox, irrespective of other folder-level permissions set on the
         * mailbox.
         * </p>
         * 
         * @param permissionValues
         *        The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the
         *        mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send
         *        email on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of
         *        these emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other
         *        folder-level permissions set on the mailbox.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionValuesWithStrings(String... permissionValues);

        /**
         * <p>
         * The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox
         * (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of
         * the owner of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS
         * allows the grantee full access to the mailbox, irrespective of other folder-level permissions set on the
         * mailbox.
         * </p>
         * 
         * @param permissionValues
         *        The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the
         *        mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send
         *        email on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of
         *        these emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other
         *        folder-level permissions set on the mailbox.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionValues(Collection<PermissionType> permissionValues);

        /**
         * <p>
         * The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox
         * (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of
         * the owner of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS
         * allows the grantee full access to the mailbox, irrespective of other folder-level permissions set on the
         * mailbox.
         * </p>
         * 
         * @param permissionValues
         *        The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the
         *        mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send
         *        email on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of
         *        these emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other
         *        folder-level permissions set on the mailbox.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionValues(PermissionType... permissionValues);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkMailRequest.BuilderImpl implements Builder {
        private String organizationId;

        private String entityId;

        private String granteeId;

        private List<String> permissionValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutMailboxPermissionsRequest model) {
            super(model);
            organizationId(model.organizationId);
            entityId(model.entityId);
            granteeId(model.granteeId);
            permissionValuesWithStrings(model.permissionValues);
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        public final String getEntityId() {
            return entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public final String getGranteeId() {
            return granteeId;
        }

        @Override
        public final Builder granteeId(String granteeId) {
            this.granteeId = granteeId;
            return this;
        }

        public final void setGranteeId(String granteeId) {
            this.granteeId = granteeId;
        }

        public final Collection<String> getPermissionValuesAsStrings() {
            return permissionValues;
        }

        @Override
        public final Builder permissionValuesWithStrings(Collection<String> permissionValues) {
            this.permissionValues = PermissionValuesCopier.copy(permissionValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionValuesWithStrings(String... permissionValues) {
            permissionValuesWithStrings(Arrays.asList(permissionValues));
            return this;
        }

        @Override
        public final Builder permissionValues(Collection<PermissionType> permissionValues) {
            this.permissionValues = PermissionValuesCopier.copyEnumToString(permissionValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionValues(PermissionType... permissionValues) {
            permissionValues(Arrays.asList(permissionValues));
            return this;
        }

        public final void setPermissionValuesWithStrings(Collection<String> permissionValues) {
            this.permissionValues = PermissionValuesCopier.copy(permissionValues);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutMailboxPermissionsRequest build() {
            return new PutMailboxPermissionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
