/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.workmail.model.AssociateDelegateToResourceRequest;
import software.amazon.awssdk.services.workmail.model.AssociateDelegateToResourceResponse;
import software.amazon.awssdk.services.workmail.model.AssociateMemberToGroupRequest;
import software.amazon.awssdk.services.workmail.model.AssociateMemberToGroupResponse;
import software.amazon.awssdk.services.workmail.model.CreateAliasRequest;
import software.amazon.awssdk.services.workmail.model.CreateAliasResponse;
import software.amazon.awssdk.services.workmail.model.CreateGroupRequest;
import software.amazon.awssdk.services.workmail.model.CreateGroupResponse;
import software.amazon.awssdk.services.workmail.model.CreateResourceRequest;
import software.amazon.awssdk.services.workmail.model.CreateResourceResponse;
import software.amazon.awssdk.services.workmail.model.CreateUserRequest;
import software.amazon.awssdk.services.workmail.model.CreateUserResponse;
import software.amazon.awssdk.services.workmail.model.DeleteAliasRequest;
import software.amazon.awssdk.services.workmail.model.DeleteAliasResponse;
import software.amazon.awssdk.services.workmail.model.DeleteGroupRequest;
import software.amazon.awssdk.services.workmail.model.DeleteGroupResponse;
import software.amazon.awssdk.services.workmail.model.DeleteMailboxPermissionsRequest;
import software.amazon.awssdk.services.workmail.model.DeleteMailboxPermissionsResponse;
import software.amazon.awssdk.services.workmail.model.DeleteResourceRequest;
import software.amazon.awssdk.services.workmail.model.DeleteResourceResponse;
import software.amazon.awssdk.services.workmail.model.DeleteUserRequest;
import software.amazon.awssdk.services.workmail.model.DeleteUserResponse;
import software.amazon.awssdk.services.workmail.model.DeregisterFromWorkMailRequest;
import software.amazon.awssdk.services.workmail.model.DeregisterFromWorkMailResponse;
import software.amazon.awssdk.services.workmail.model.DescribeGroupRequest;
import software.amazon.awssdk.services.workmail.model.DescribeGroupResponse;
import software.amazon.awssdk.services.workmail.model.DescribeOrganizationRequest;
import software.amazon.awssdk.services.workmail.model.DescribeOrganizationResponse;
import software.amazon.awssdk.services.workmail.model.DescribeResourceRequest;
import software.amazon.awssdk.services.workmail.model.DescribeResourceResponse;
import software.amazon.awssdk.services.workmail.model.DescribeUserRequest;
import software.amazon.awssdk.services.workmail.model.DescribeUserResponse;
import software.amazon.awssdk.services.workmail.model.DirectoryServiceAuthenticationFailedException;
import software.amazon.awssdk.services.workmail.model.DirectoryUnavailableException;
import software.amazon.awssdk.services.workmail.model.DisassociateDelegateFromResourceRequest;
import software.amazon.awssdk.services.workmail.model.DisassociateDelegateFromResourceResponse;
import software.amazon.awssdk.services.workmail.model.DisassociateMemberFromGroupRequest;
import software.amazon.awssdk.services.workmail.model.DisassociateMemberFromGroupResponse;
import software.amazon.awssdk.services.workmail.model.EmailAddressInUseException;
import software.amazon.awssdk.services.workmail.model.EntityAlreadyRegisteredException;
import software.amazon.awssdk.services.workmail.model.EntityNotFoundException;
import software.amazon.awssdk.services.workmail.model.EntityStateException;
import software.amazon.awssdk.services.workmail.model.GetMailboxDetailsRequest;
import software.amazon.awssdk.services.workmail.model.GetMailboxDetailsResponse;
import software.amazon.awssdk.services.workmail.model.InvalidConfigurationException;
import software.amazon.awssdk.services.workmail.model.InvalidParameterException;
import software.amazon.awssdk.services.workmail.model.InvalidPasswordException;
import software.amazon.awssdk.services.workmail.model.ListAliasesRequest;
import software.amazon.awssdk.services.workmail.model.ListAliasesResponse;
import software.amazon.awssdk.services.workmail.model.ListGroupMembersRequest;
import software.amazon.awssdk.services.workmail.model.ListGroupMembersResponse;
import software.amazon.awssdk.services.workmail.model.ListGroupsRequest;
import software.amazon.awssdk.services.workmail.model.ListGroupsResponse;
import software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsRequest;
import software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsResponse;
import software.amazon.awssdk.services.workmail.model.ListOrganizationsRequest;
import software.amazon.awssdk.services.workmail.model.ListOrganizationsResponse;
import software.amazon.awssdk.services.workmail.model.ListResourceDelegatesRequest;
import software.amazon.awssdk.services.workmail.model.ListResourceDelegatesResponse;
import software.amazon.awssdk.services.workmail.model.ListResourcesRequest;
import software.amazon.awssdk.services.workmail.model.ListResourcesResponse;
import software.amazon.awssdk.services.workmail.model.ListUsersRequest;
import software.amazon.awssdk.services.workmail.model.ListUsersResponse;
import software.amazon.awssdk.services.workmail.model.MailDomainNotFoundException;
import software.amazon.awssdk.services.workmail.model.MailDomainStateException;
import software.amazon.awssdk.services.workmail.model.NameAvailabilityException;
import software.amazon.awssdk.services.workmail.model.OrganizationNotFoundException;
import software.amazon.awssdk.services.workmail.model.OrganizationStateException;
import software.amazon.awssdk.services.workmail.model.PutMailboxPermissionsRequest;
import software.amazon.awssdk.services.workmail.model.PutMailboxPermissionsResponse;
import software.amazon.awssdk.services.workmail.model.RegisterToWorkMailRequest;
import software.amazon.awssdk.services.workmail.model.RegisterToWorkMailResponse;
import software.amazon.awssdk.services.workmail.model.ReservedNameException;
import software.amazon.awssdk.services.workmail.model.ResetPasswordRequest;
import software.amazon.awssdk.services.workmail.model.ResetPasswordResponse;
import software.amazon.awssdk.services.workmail.model.UnsupportedOperationException;
import software.amazon.awssdk.services.workmail.model.UpdateMailboxQuotaRequest;
import software.amazon.awssdk.services.workmail.model.UpdateMailboxQuotaResponse;
import software.amazon.awssdk.services.workmail.model.UpdatePrimaryEmailAddressRequest;
import software.amazon.awssdk.services.workmail.model.UpdatePrimaryEmailAddressResponse;
import software.amazon.awssdk.services.workmail.model.UpdateResourceRequest;
import software.amazon.awssdk.services.workmail.model.UpdateResourceResponse;
import software.amazon.awssdk.services.workmail.model.WorkMailException;
import software.amazon.awssdk.services.workmail.model.WorkMailRequest;
import software.amazon.awssdk.services.workmail.paginators.ListAliasesPublisher;
import software.amazon.awssdk.services.workmail.paginators.ListGroupMembersPublisher;
import software.amazon.awssdk.services.workmail.paginators.ListGroupsPublisher;
import software.amazon.awssdk.services.workmail.paginators.ListMailboxPermissionsPublisher;
import software.amazon.awssdk.services.workmail.paginators.ListOrganizationsPublisher;
import software.amazon.awssdk.services.workmail.paginators.ListResourceDelegatesPublisher;
import software.amazon.awssdk.services.workmail.paginators.ListResourcesPublisher;
import software.amazon.awssdk.services.workmail.paginators.ListUsersPublisher;
import software.amazon.awssdk.services.workmail.transform.AssociateDelegateToResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.AssociateMemberToGroupRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.CreateAliasRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.CreateGroupRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.CreateResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteAliasRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteGroupRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteMailboxPermissionsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DeregisterFromWorkMailRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DescribeGroupRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DescribeOrganizationRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DescribeResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DescribeUserRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DisassociateDelegateFromResourceRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.DisassociateMemberFromGroupRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.GetMailboxDetailsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListAliasesRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListGroupMembersRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListGroupsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListMailboxPermissionsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListOrganizationsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListResourceDelegatesRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListResourcesRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ListUsersRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.PutMailboxPermissionsRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.RegisterToWorkMailRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.ResetPasswordRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.UpdateMailboxQuotaRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.UpdatePrimaryEmailAddressRequestMarshaller;
import software.amazon.awssdk.services.workmail.transform.UpdateResourceRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link WorkMailAsyncClient}.
 *
 * @see WorkMailAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultWorkMailAsyncClient implements WorkMailAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkMailAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultWorkMailAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Adds a member (user or group) to the resource's set of delegates.
     * </p>
     *
     * @param associateDelegateToResourceRequest
     * @return A Java Future containing the result of the AssociateDelegateToResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.AssociateDelegateToResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/AssociateDelegateToResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateDelegateToResourceResponse> associateDelegateToResource(
            AssociateDelegateToResourceRequest associateDelegateToResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateDelegateToResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateDelegateToResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateDelegateToResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateDelegateToResourceRequest, AssociateDelegateToResourceResponse>()
                            .withOperationName("AssociateDelegateToResource")
                            .withMarshaller(new AssociateDelegateToResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(associateDelegateToResourceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds a member (user or group) to the group's set.
     * </p>
     *
     * @param associateMemberToGroupRequest
     * @return A Java Future containing the result of the AssociateMemberToGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory on which you are trying to perform operations isn't
     *         available.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.AssociateMemberToGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/AssociateMemberToGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateMemberToGroupResponse> associateMemberToGroup(
            AssociateMemberToGroupRequest associateMemberToGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateMemberToGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateMemberToGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateMemberToGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateMemberToGroupRequest, AssociateMemberToGroupResponse>()
                            .withOperationName("AssociateMemberToGroup")
                            .withMarshaller(new AssociateMemberToGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(associateMemberToGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds an alias to the set of a given member (user or group) of Amazon WorkMail.
     * </p>
     *
     * @param createAliasRequest
     * @return A Java Future containing the result of the CreateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EmailAddressInUseException The email address that you're trying to assign is already created for a
     *         different user, group, or resource.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>MailDomainNotFoundException For an email or alias to be created in Amazon WorkMail, the included
     *         domain must be defined in the organization.</li>
     *         <li>MailDomainStateException After a domain has been added to the organization, it must be verified. The
     *         domain is not yet verified.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAliasResponse> createAlias(CreateAliasRequest createAliasRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateAliasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAliasRequest, CreateAliasResponse>()
                            .withOperationName("CreateAlias").withMarshaller(new CreateAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createAliasRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a group that can be used in Amazon WorkMail by calling the <a>RegisterToWorkMail</a> operation.
     * </p>
     *
     * @param createGroupRequest
     * @return A Java Future containing the result of the CreateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory on which you are trying to perform operations isn't
     *         available.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>NameAvailabilityException The user, group, or resource name isn't unique in Amazon WorkMail.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>ReservedNameException This user, group, or resource name is not allowed in Amazon WorkMail.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateGroupResponse> createGroup(CreateGroupRequest createGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateGroupRequest, CreateGroupResponse>()
                            .withOperationName("CreateGroup").withMarshaller(new CreateGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new Amazon WorkMail resource.
     * </p>
     *
     * @param createResourceRequest
     * @return A Java Future containing the result of the CreateResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory on which you are trying to perform operations isn't
     *         available.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>NameAvailabilityException The user, group, or resource name isn't unique in Amazon WorkMail.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>ReservedNameException This user, group, or resource name is not allowed in Amazon WorkMail.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateResourceResponse> createResource(CreateResourceRequest createResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateResourceRequest, CreateResourceResponse>()
                            .withOperationName("CreateResource")
                            .withMarshaller(new CreateResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createResourceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a user who can be used in Amazon WorkMail by calling the <a>RegisterToWorkMail</a> operation.
     * </p>
     *
     * @param createUserRequest
     * @return A Java Future containing the result of the CreateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory on which you are trying to perform operations isn't
     *         available.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>InvalidPasswordException The supplied password doesn't match the minimum security constraints, such
     *         as length or use of special characters.</li>
     *         <li>NameAvailabilityException The user, group, or resource name isn't unique in Amazon WorkMail.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>ReservedNameException This user, group, or resource name is not allowed in Amazon WorkMail.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.CreateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateUserResponse> createUser(CreateUserRequest createUserRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateUserRequest, CreateUserResponse>().withOperationName("CreateUser")
                            .withMarshaller(new CreateUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createUserRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Remove one or more specified aliases from a set of aliases for a given user.
     * </p>
     *
     * @param deleteAliasRequest
     * @return A Java Future containing the result of the DeleteAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAliasResponse> deleteAlias(DeleteAliasRequest deleteAliasRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteAliasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAliasRequest, DeleteAliasResponse>()
                            .withOperationName("DeleteAlias").withMarshaller(new DeleteAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteAliasRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a group from Amazon WorkMail.
     * </p>
     *
     * @param deleteGroupRequest
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory on which you are trying to perform operations isn't
     *         available.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteGroupResponse> deleteGroup(DeleteGroupRequest deleteGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteGroupRequest, DeleteGroupResponse>()
                            .withOperationName("DeleteGroup").withMarshaller(new DeleteGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes permissions granted to a member (user or group).
     * </p>
     *
     * @param deleteMailboxPermissionsRequest
     * @return A Java Future containing the result of the DeleteMailboxPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteMailboxPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteMailboxPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMailboxPermissionsResponse> deleteMailboxPermissions(
            DeleteMailboxPermissionsRequest deleteMailboxPermissionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteMailboxPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteMailboxPermissionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteMailboxPermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMailboxPermissionsRequest, DeleteMailboxPermissionsResponse>()
                            .withOperationName("DeleteMailboxPermissions")
                            .withMarshaller(new DeleteMailboxPermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteMailboxPermissionsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified resource.
     * </p>
     *
     * @param deleteResourceRequest
     * @return A Java Future containing the result of the DeleteResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteResourceResponse> deleteResource(DeleteResourceRequest deleteResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteResourceRequest, DeleteResourceResponse>()
                            .withOperationName("DeleteResource")
                            .withMarshaller(new DeleteResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteResourceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a user from Amazon WorkMail and all subsequent systems. Before you can delete a user, the user state must
     * be <code>DISABLED</code>. Use the <a>DescribeUser</a> action to confirm the user state.
     * </p>
     * <p>
     * Deleting a user is permanent and cannot be undone. WorkMail archives user mailboxes for 30 days before they are
     * permanently removed.
     * </p>
     *
     * @param deleteUserRequest
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory on which you are trying to perform operations isn't
     *         available.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeleteUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserRequest, DeleteUserResponse>().withOperationName("DeleteUser")
                            .withMarshaller(new DeleteUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteUserRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Mark a user, group, or resource as no longer used in Amazon WorkMail. This action disassociates the mailbox and
     * schedules it for clean-up. WorkMail keeps mailboxes for 30 days before they are permanently removed. The
     * functionality in the console is <i>Disable</i>.
     * </p>
     *
     * @param deregisterFromWorkMailRequest
     * @return A Java Future containing the result of the DeregisterFromWorkMail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DeregisterFromWorkMail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DeregisterFromWorkMail"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeregisterFromWorkMailResponse> deregisterFromWorkMail(
            DeregisterFromWorkMailRequest deregisterFromWorkMailRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeregisterFromWorkMailResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeregisterFromWorkMailResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeregisterFromWorkMailResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeregisterFromWorkMailRequest, DeregisterFromWorkMailResponse>()
                            .withOperationName("DeregisterFromWorkMail")
                            .withMarshaller(new DeregisterFromWorkMailRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deregisterFromWorkMailRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the data available for the group.
     * </p>
     *
     * @param describeGroupRequest
     * @return A Java Future containing the result of the DescribeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeGroupResponse> describeGroup(DescribeGroupRequest describeGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeGroupRequest, DescribeGroupResponse>()
                            .withOperationName("DescribeGroup")
                            .withMarshaller(new DescribeGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides more information regarding a given organization based on its identifier.
     * </p>
     *
     * @param describeOrganizationRequest
     * @return A Java Future containing the result of the DescribeOrganization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeOrganization
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeOrganization" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeOrganizationResponse> describeOrganization(
            DescribeOrganizationRequest describeOrganizationRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeOrganizationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeOrganizationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeOrganizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeOrganizationRequest, DescribeOrganizationResponse>()
                            .withOperationName("DescribeOrganization")
                            .withMarshaller(new DescribeOrganizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeOrganizationRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns the data available for the resource.
     * </p>
     *
     * @param describeResourceRequest
     * @return A Java Future containing the result of the DescribeResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeResourceResponse> describeResource(DescribeResourceRequest describeResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeResourceRequest, DescribeResourceResponse>()
                            .withOperationName("DescribeResource")
                            .withMarshaller(new DescribeResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeResourceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides information regarding the user.
     * </p>
     *
     * @param describeUserRequest
     * @return A Java Future containing the result of the DescribeUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DescribeUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeUserResponse> describeUser(DescribeUserRequest describeUserRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeUserRequest, DescribeUserResponse>()
                            .withOperationName("DescribeUser").withMarshaller(new DescribeUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeUserRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a member from the resource's set of delegates.
     * </p>
     *
     * @param disassociateDelegateFromResourceRequest
     * @return A Java Future containing the result of the DisassociateDelegateFromResource operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DisassociateDelegateFromResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DisassociateDelegateFromResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateDelegateFromResourceResponse> disassociateDelegateFromResource(
            DisassociateDelegateFromResourceRequest disassociateDelegateFromResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateDelegateFromResourceResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociateDelegateFromResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateDelegateFromResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateDelegateFromResourceRequest, DisassociateDelegateFromResourceResponse>()
                            .withOperationName("DisassociateDelegateFromResource")
                            .withMarshaller(new DisassociateDelegateFromResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(disassociateDelegateFromResourceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a member from a group.
     * </p>
     *
     * @param disassociateMemberFromGroupRequest
     * @return A Java Future containing the result of the DisassociateMemberFromGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory on which you are trying to perform operations isn't
     *         available.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.DisassociateMemberFromGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/DisassociateMemberFromGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateMemberFromGroupResponse> disassociateMemberFromGroup(
            DisassociateMemberFromGroupRequest disassociateMemberFromGroupRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateMemberFromGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateMemberFromGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateMemberFromGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateMemberFromGroupRequest, DisassociateMemberFromGroupResponse>()
                            .withOperationName("DisassociateMemberFromGroup")
                            .withMarshaller(new DisassociateMemberFromGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(disassociateMemberFromGroupRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Requests a user's mailbox details for a specified organization and user.
     * </p>
     *
     * @param getMailboxDetailsRequest
     * @return A Java Future containing the result of the GetMailboxDetails operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.GetMailboxDetails
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/GetMailboxDetails" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetMailboxDetailsResponse> getMailboxDetails(GetMailboxDetailsRequest getMailboxDetailsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMailboxDetailsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetMailboxDetailsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMailboxDetailsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMailboxDetailsRequest, GetMailboxDetailsResponse>()
                            .withOperationName("GetMailboxDetails")
                            .withMarshaller(new GetMailboxDetailsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getMailboxDetailsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a paginated call to list the aliases associated with a given entity.
     * </p>
     *
     * @param listAliasesRequest
     * @return A Java Future containing the result of the ListAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListAliases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListAliasesResponse> listAliases(ListAliasesRequest listAliasesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAliasesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListAliasesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAliasesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAliasesRequest, ListAliasesResponse>()
                            .withOperationName("ListAliases").withMarshaller(new ListAliasesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listAliasesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a paginated call to list the aliases associated with a given entity.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAliases(software.amazon.awssdk.services.workmail.model.ListAliasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListAliasesPublisher publisher = client.listAliasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListAliasesPublisher publisher = client.listAliasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListAliasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListAliasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAliases(software.amazon.awssdk.services.workmail.model.ListAliasesRequest)} operation.</b>
     * </p>
     *
     * @param listAliasesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListAliases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListAliases" target="_top">AWS API
     *      Documentation</a>
     */
    public ListAliasesPublisher listAliasesPaginator(ListAliasesRequest listAliasesRequest) {
        return new ListAliasesPublisher(this, applyPaginatorUserAgent(listAliasesRequest));
    }

    /**
     * <p>
     * Returns an overview of the members of a group. Users and groups can be members of a group.
     * </p>
     *
     * @param listGroupMembersRequest
     * @return A Java Future containing the result of the ListGroupMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListGroupMembers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroupMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListGroupMembersResponse> listGroupMembers(ListGroupMembersRequest listGroupMembersRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGroupMembersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListGroupMembersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListGroupMembersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGroupMembersRequest, ListGroupMembersResponse>()
                            .withOperationName("ListGroupMembers")
                            .withMarshaller(new ListGroupMembersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listGroupMembersRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns an overview of the members of a group. Users and groups can be members of a group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGroupMembers(software.amazon.awssdk.services.workmail.model.ListGroupMembersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupMembersPublisher publisher = client.listGroupMembersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupMembersPublisher publisher = client.listGroupMembersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListGroupMembersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListGroupMembersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroupMembers(software.amazon.awssdk.services.workmail.model.ListGroupMembersRequest)} operation.</b>
     * </p>
     *
     * @param listGroupMembersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListGroupMembers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroupMembers" target="_top">AWS API
     *      Documentation</a>
     */
    public ListGroupMembersPublisher listGroupMembersPaginator(ListGroupMembersRequest listGroupMembersRequest) {
        return new ListGroupMembersPublisher(this, applyPaginatorUserAgent(listGroupMembersRequest));
    }

    /**
     * <p>
     * Returns summaries of the organization's groups.
     * </p>
     *
     * @param listGroupsRequest
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListGroupsResponse> listGroups(ListGroupsRequest listGroupsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGroupsRequest, ListGroupsResponse>().withOperationName("ListGroups")
                            .withMarshaller(new ListGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listGroupsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns summaries of the organization's groups.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listGroups(software.amazon.awssdk.services.workmail.model.ListGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListGroupsPublisher publisher = client.listGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroups(software.amazon.awssdk.services.workmail.model.ListGroupsRequest)} operation.</b>
     * </p>
     *
     * @param listGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    public ListGroupsPublisher listGroupsPaginator(ListGroupsRequest listGroupsRequest) {
        return new ListGroupsPublisher(this, applyPaginatorUserAgent(listGroupsRequest));
    }

    /**
     * <p>
     * Lists the mailbox permissions associated with a user, group, or resource mailbox.
     * </p>
     *
     * @param listMailboxPermissionsRequest
     * @return A Java Future containing the result of the ListMailboxPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMailboxPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMailboxPermissionsResponse> listMailboxPermissions(
            ListMailboxPermissionsRequest listMailboxPermissionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMailboxPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMailboxPermissionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMailboxPermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMailboxPermissionsRequest, ListMailboxPermissionsResponse>()
                            .withOperationName("ListMailboxPermissions")
                            .withMarshaller(new ListMailboxPermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listMailboxPermissionsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the mailbox permissions associated with a user, group, or resource mailbox.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listMailboxPermissions(software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailboxPermissionsPublisher publisher = client.listMailboxPermissionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListMailboxPermissionsPublisher publisher = client.listMailboxPermissionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMailboxPermissions(software.amazon.awssdk.services.workmail.model.ListMailboxPermissionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMailboxPermissionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListMailboxPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListMailboxPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    public ListMailboxPermissionsPublisher listMailboxPermissionsPaginator(
            ListMailboxPermissionsRequest listMailboxPermissionsRequest) {
        return new ListMailboxPermissionsPublisher(this, applyPaginatorUserAgent(listMailboxPermissionsRequest));
    }

    /**
     * <p>
     * Returns summaries of the customer's non-deleted organizations.
     * </p>
     *
     * @param listOrganizationsRequest
     * @return A Java Future containing the result of the ListOrganizations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListOrganizations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListOrganizations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListOrganizationsResponse> listOrganizations(ListOrganizationsRequest listOrganizationsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListOrganizationsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListOrganizationsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListOrganizationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListOrganizationsRequest, ListOrganizationsResponse>()
                            .withOperationName("ListOrganizations")
                            .withMarshaller(new ListOrganizationsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listOrganizationsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns summaries of the customer's non-deleted organizations.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOrganizations(software.amazon.awssdk.services.workmail.model.ListOrganizationsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListOrganizationsPublisher publisher = client.listOrganizationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListOrganizationsPublisher publisher = client.listOrganizationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListOrganizationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListOrganizationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizations(software.amazon.awssdk.services.workmail.model.ListOrganizationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOrganizationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListOrganizations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListOrganizations" target="_top">AWS API
     *      Documentation</a>
     */
    public ListOrganizationsPublisher listOrganizationsPaginator(ListOrganizationsRequest listOrganizationsRequest) {
        return new ListOrganizationsPublisher(this, applyPaginatorUserAgent(listOrganizationsRequest));
    }

    /**
     * <p>
     * Lists the delegates associated with a resource. Users and groups can be resource delegates and answer requests on
     * behalf of the resource.
     * </p>
     *
     * @param listResourceDelegatesRequest
     * @return A Java Future containing the result of the ListResourceDelegates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListResourceDelegates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResourceDelegates" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResourceDelegatesResponse> listResourceDelegates(
            ListResourceDelegatesRequest listResourceDelegatesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResourceDelegatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListResourceDelegatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListResourceDelegatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResourceDelegatesRequest, ListResourceDelegatesResponse>()
                            .withOperationName("ListResourceDelegates")
                            .withMarshaller(new ListResourceDelegatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listResourceDelegatesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the delegates associated with a resource. Users and groups can be resource delegates and answer requests on
     * behalf of the resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceDelegates(software.amazon.awssdk.services.workmail.model.ListResourceDelegatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListResourceDelegatesPublisher publisher = client.listResourceDelegatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListResourceDelegatesPublisher publisher = client.listResourceDelegatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListResourceDelegatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListResourceDelegatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceDelegates(software.amazon.awssdk.services.workmail.model.ListResourceDelegatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceDelegatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListResourceDelegates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResourceDelegates" target="_top">AWS
     *      API Documentation</a>
     */
    public ListResourceDelegatesPublisher listResourceDelegatesPaginator(ListResourceDelegatesRequest listResourceDelegatesRequest) {
        return new ListResourceDelegatesPublisher(this, applyPaginatorUserAgent(listResourceDelegatesRequest));
    }

    /**
     * <p>
     * Returns summaries of the organization's resources.
     * </p>
     *
     * @param listResourcesRequest
     * @return A Java Future containing the result of the ListResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResources" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListResourcesResponse> listResources(ListResourcesRequest listResourcesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResourcesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListResourcesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListResourcesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResourcesRequest, ListResourcesResponse>()
                            .withOperationName("ListResources")
                            .withMarshaller(new ListResourcesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listResourcesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns summaries of the organization's resources.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listResources(software.amazon.awssdk.services.workmail.model.ListResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListResourcesPublisher publisher = client.listResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListResourcesPublisher publisher = client.listResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResources(software.amazon.awssdk.services.workmail.model.ListResourcesRequest)} operation.</b>
     * </p>
     *
     * @param listResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListResources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListResources" target="_top">AWS API
     *      Documentation</a>
     */
    public ListResourcesPublisher listResourcesPaginator(ListResourcesRequest listResourcesRequest) {
        return new ListResourcesPublisher(this, applyPaginatorUserAgent(listResourcesRequest));
    }

    /**
     * <p>
     * Returns summaries of the organization's users.
     * </p>
     *
     * @param listUsersRequest
     * @return A Java Future containing the result of the ListUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListUsersResponse> listUsers(ListUsersRequest listUsersRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListUsersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListUsersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListUsersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListUsersRequest, ListUsersResponse>().withOperationName("ListUsers")
                            .withMarshaller(new ListUsersRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listUsersRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns summaries of the organization's users.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listUsers(software.amazon.awssdk.services.workmail.model.ListUsersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListUsersPublisher publisher = client.listUsersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workmail.paginators.ListUsersPublisher publisher = client.listUsersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workmail.model.ListUsersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workmail.model.ListUsersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsers(software.amazon.awssdk.services.workmail.model.ListUsersRequest)} operation.</b>
     * </p>
     *
     * @param listUsersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ListUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    public ListUsersPublisher listUsersPaginator(ListUsersRequest listUsersRequest) {
        return new ListUsersPublisher(this, applyPaginatorUserAgent(listUsersRequest));
    }

    /**
     * <p>
     * Sets permissions for a user, group, or resource. This replaces any pre-existing permissions.
     * </p>
     *
     * @param putMailboxPermissionsRequest
     * @return A Java Future containing the result of the PutMailboxPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.PutMailboxPermissions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/PutMailboxPermissions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PutMailboxPermissionsResponse> putMailboxPermissions(
            PutMailboxPermissionsRequest putMailboxPermissionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutMailboxPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutMailboxPermissionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<PutMailboxPermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutMailboxPermissionsRequest, PutMailboxPermissionsResponse>()
                            .withOperationName("PutMailboxPermissions")
                            .withMarshaller(new PutMailboxPermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(putMailboxPermissionsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Registers an existing and disabled user, group, or resource for Amazon WorkMail use by associating a mailbox and
     * calendaring capabilities. It performs no change if the user, group, or resource is enabled and fails if the user,
     * group, or resource is deleted. This operation results in the accumulation of costs. For more information, see <a
     * href="https://aws.amazon.com//workmail/pricing">Pricing</a>. The equivalent console functionality for this
     * operation is <i>Enable</i>.
     * </p>
     * <p>
     * Users can either be created by calling the <a>CreateUser</a> API operation or they can be synchronized from your
     * directory. For more information, see <a>DeregisterFromWorkMail</a>.
     * </p>
     *
     * @param registerToWorkMailRequest
     * @return A Java Future containing the result of the RegisterToWorkMail operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory on which you are trying to perform operations isn't
     *         available.</li>
     *         <li>EmailAddressInUseException The email address that you're trying to assign is already created for a
     *         different user, group, or resource.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>EntityAlreadyRegisteredException The user, group, or resource that you're trying to register is
     *         already registered.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>MailDomainNotFoundException For an email or alias to be created in Amazon WorkMail, the included
     *         domain must be defined in the organization.</li>
     *         <li>MailDomainStateException After a domain has been added to the organization, it must be verified. The
     *         domain is not yet verified.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.RegisterToWorkMail
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/RegisterToWorkMail" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterToWorkMailResponse> registerToWorkMail(RegisterToWorkMailRequest registerToWorkMailRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RegisterToWorkMailResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RegisterToWorkMailResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RegisterToWorkMailResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RegisterToWorkMailRequest, RegisterToWorkMailResponse>()
                            .withOperationName("RegisterToWorkMail")
                            .withMarshaller(new RegisterToWorkMailRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(registerToWorkMailRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Allows the administrator to reset the password for a user.
     * </p>
     *
     * @param resetPasswordRequest
     * @return A Java Future containing the result of the ResetPassword operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory on which you are trying to perform operations isn't
     *         available.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>InvalidPasswordException The supplied password doesn't match the minimum security constraints, such
     *         as length or use of special characters.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.ResetPassword
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/ResetPassword" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ResetPasswordResponse> resetPassword(ResetPasswordRequest resetPasswordRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ResetPasswordResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ResetPasswordResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ResetPasswordResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ResetPasswordRequest, ResetPasswordResponse>()
                            .withOperationName("ResetPassword")
                            .withMarshaller(new ResetPasswordRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(resetPasswordRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a user's current mailbox quota for a specified organization and user.
     * </p>
     *
     * @param updateMailboxQuotaRequest
     * @return A Java Future containing the result of the UpdateMailboxQuota operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UpdateMailboxQuota
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateMailboxQuota" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateMailboxQuotaResponse> updateMailboxQuota(UpdateMailboxQuotaRequest updateMailboxQuotaRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateMailboxQuotaResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateMailboxQuotaResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateMailboxQuotaResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateMailboxQuotaRequest, UpdateMailboxQuotaResponse>()
                            .withOperationName("UpdateMailboxQuota")
                            .withMarshaller(new UpdateMailboxQuotaRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateMailboxQuotaRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the primary email for a user, group, or resource. The current email is moved into the list of aliases (or
     * swapped between an existing alias and the current primary email), and the email provided in the input is promoted
     * as the primary.
     * </p>
     *
     * @param updatePrimaryEmailAddressRequest
     * @return A Java Future containing the result of the UpdatePrimaryEmailAddress operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryServiceAuthenticationFailedException The directory service doesn't recognize the credentials
     *         supplied by WorkMail.</li>
     *         <li>DirectoryUnavailableException The directory on which you are trying to perform operations isn't
     *         available.</li>
     *         <li>EmailAddressInUseException The email address that you're trying to assign is already created for a
     *         different user, group, or resource.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>MailDomainNotFoundException For an email or alias to be created in Amazon WorkMail, the included
     *         domain must be defined in the organization.</li>
     *         <li>MailDomainStateException After a domain has been added to the organization, it must be verified. The
     *         domain is not yet verified.</li>
     *         <li>InvalidParameterException One or more of the input parameters don't match the service's restrictions.
     *         </li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>UnsupportedOperationException You can't perform a write operation against a read-only directory.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UpdatePrimaryEmailAddress
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdatePrimaryEmailAddress"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdatePrimaryEmailAddressResponse> updatePrimaryEmailAddress(
            UpdatePrimaryEmailAddressRequest updatePrimaryEmailAddressRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdatePrimaryEmailAddressResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdatePrimaryEmailAddressResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdatePrimaryEmailAddressResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePrimaryEmailAddressRequest, UpdatePrimaryEmailAddressResponse>()
                            .withOperationName("UpdatePrimaryEmailAddress")
                            .withMarshaller(new UpdatePrimaryEmailAddressRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updatePrimaryEmailAddressRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates data for the resource. To have the latest information, it must be preceded by a <a>DescribeResource</a>
     * call. The dataset in the request should be the one expected when performing another <code>DescribeResource</code>
     * call.
     * </p>
     *
     * @param updateResourceRequest
     * @return A Java Future containing the result of the UpdateResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DirectoryUnavailableException The directory on which you are trying to perform operations isn't
     *         available.</li>
     *         <li>EntityNotFoundException The identifier supplied for the user, group, or resource does not exist in
     *         your organization.</li>
     *         <li>EntityStateException You are performing an operation on a user, group, or resource that isn't in the
     *         expected state, such as trying to delete an active user.</li>
     *         <li>InvalidConfigurationException The configuration for a resource isn't valid. A resource must either be
     *         able to auto-respond to requests or have at least one delegate associated that can do so on its behalf.</li>
     *         <li>EmailAddressInUseException The email address that you're trying to assign is already created for a
     *         different user, group, or resource.</li>
     *         <li>MailDomainNotFoundException For an email or alias to be created in Amazon WorkMail, the included
     *         domain must be defined in the organization.</li>
     *         <li>MailDomainStateException After a domain has been added to the organization, it must be verified. The
     *         domain is not yet verified.</li>
     *         <li>NameAvailabilityException The user, group, or resource name isn't unique in Amazon WorkMail.</li>
     *         <li>OrganizationNotFoundException An operation received a valid organization identifier that either
     *         doesn't belong or exist in the system.</li>
     *         <li>OrganizationStateException The organization must have a valid state (Active or Synchronizing) to
     *         perform certain operations on the organization or its members.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkMailException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkMailAsyncClient.UpdateResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/workmail-2017-10-01/UpdateResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateResourceResponse> updateResource(UpdateResourceRequest updateResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateResourceRequest, UpdateResourceResponse>()
                            .withOperationName("UpdateResource")
                            .withMarshaller(new UpdateResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateResourceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(WorkMailException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DirectoryUnavailableException")
                                .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidConfigurationException")
                                .exceptionBuilderSupplier(InvalidConfigurationException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterException")
                                .exceptionBuilderSupplier(InvalidParameterException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MailDomainStateException")
                                .exceptionBuilderSupplier(MailDomainStateException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPasswordException")
                                .exceptionBuilderSupplier(InvalidPasswordException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedOperationException")
                                .exceptionBuilderSupplier(UnsupportedOperationException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EntityNotFoundException")
                                .exceptionBuilderSupplier(EntityNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReservedNameException")
                                .exceptionBuilderSupplier(ReservedNameException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MailDomainNotFoundException")
                                .exceptionBuilderSupplier(MailDomainNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OrganizationStateException")
                                .exceptionBuilderSupplier(OrganizationStateException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DirectoryServiceAuthenticationFailedException")
                                .exceptionBuilderSupplier(DirectoryServiceAuthenticationFailedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OrganizationNotFoundException")
                                .exceptionBuilderSupplier(OrganizationNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NameAvailabilityException")
                                .exceptionBuilderSupplier(NameAvailabilityException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EmailAddressInUseException")
                                .exceptionBuilderSupplier(EmailAddressInUseException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EntityStateException")
                                .exceptionBuilderSupplier(EntityStateException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EntityAlreadyRegisteredException")
                                .exceptionBuilderSupplier(EntityAlreadyRegisteredException::builder).build());
    }

    private <T extends WorkMailRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}
