/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workdocs.model.SubscriptionProtocolType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Subscription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Subscription> {
    private static final SdkField<String> SUBSCRIPTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Subscription.getter(Subscription::subscriptionId)).setter(Subscription.setter(Builder::subscriptionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionId").build()}).build();
    private static final SdkField<String> END_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Subscription.getter(Subscription::endPoint)).setter(Subscription.setter(Builder::endPoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndPoint").build()}).build();
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Subscription.getter(Subscription::protocolAsString)).setter(Subscription.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTION_ID_FIELD, END_POINT_FIELD, PROTOCOL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String subscriptionId;
    private final String endPoint;
    private final String protocol;

    private Subscription(BuilderImpl builder) {
        this.subscriptionId = builder.subscriptionId;
        this.endPoint = builder.endPoint;
        this.protocol = builder.protocol;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public String endPoint() {
        return this.endPoint;
    }

    public SubscriptionProtocolType protocol() {
        return SubscriptionProtocolType.fromValue(this.protocol);
    }

    public String protocolAsString() {
        return this.protocol;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endPoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription)obj;
        return Objects.equals(this.subscriptionId(), other.subscriptionId()) && Objects.equals(this.endPoint(), other.endPoint()) && Objects.equals(this.protocolAsString(), other.protocolAsString());
    }

    public String toString() {
        return ToString.builder((String)"Subscription").add("SubscriptionId", (Object)this.subscriptionId()).add("EndPoint", (Object)this.endPoint()).add("Protocol", (Object)this.protocolAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubscriptionId": {
                return Optional.ofNullable(clazz.cast(this.subscriptionId()));
            }
            case "EndPoint": {
                return Optional.ofNullable(clazz.cast(this.endPoint()));
            }
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Subscription, T> g) {
        return obj -> g.apply((Subscription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String subscriptionId;
        private String endPoint;
        private String protocol;

        private BuilderImpl() {
        }

        private BuilderImpl(Subscription model) {
            this.subscriptionId(model.subscriptionId);
            this.endPoint(model.endPoint);
            this.protocol(model.protocol);
        }

        public final String getSubscriptionId() {
            return this.subscriptionId;
        }

        @Override
        public final Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public final void setSubscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
        }

        public final String getEndPoint() {
            return this.endPoint;
        }

        @Override
        public final Builder endPoint(String endPoint) {
            this.endPoint = endPoint;
            return this;
        }

        public final void setEndPoint(String endPoint) {
            this.endPoint = endPoint;
        }

        public final String getProtocolAsString() {
            return this.protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(SubscriptionProtocolType protocol) {
            this.protocol(protocol.toString());
            return this;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public Subscription build() {
            return new Subscription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Subscription> {
        public Builder subscriptionId(String var1);

        public Builder endPoint(String var1);

        public Builder protocol(String var1);

        public Builder protocol(SubscriptionProtocolType var1);
    }
}

